/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class RHPartnership
extends RowHandler {
    public static final String OBJECT_TYPE = "PARTNERSHIP";
    List lines = new ArrayList();
    private Map arcMap = new TreeMap();
    private Map relMap = new TreeMap();

    public RHPartnership(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            if (!this.lines.contains(varFileLine)) {
                this.lines.add(varFileLine);
            }
            this.createRelation(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createRelation(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "partnership_source");
        String string2 = this.getField(varFileLine, "partnership_target");
        VarFileLine varFileLine2 = this.getVarFileLine(string);
        VarFileLine varFileLine3 = this.getVarFileLine(string2);
        if (varFileLine2 == null || varFileLine3 == null) {
            return;
        }
        Entity entity = this.getEntityFromLine(varFileLine2);
        Entity entity2 = this.getEntityFromLine(varFileLine3);
        Relation relation = (Relation)this.relMap.get(string);
        Relation relation2 = (Relation)this.relMap.get(string2);
        if (relation != null && relation2 != null && entity == entity2) {
            Integer n = new Integer(12);
            String string3 = this.getField(varFileLine2.getLine(), n);
            String string4 = this.getField(varFileLine3.getLine(), n);
            if ("X".equalsIgnoreCase(string4) && "X".equalsIgnoreCase(string3)) {
                ArcHolder arcHolder = new ArcHolder();
                arcHolder.entity = entity;
                arcHolder.rel1 = relation;
                arcHolder.rel2 = relation2;
                ArrayList<ArcHolder> arrayList = (ArrayList<ArcHolder>)this.arcMap.get(entity.getObjectID());
                if (arrayList == null) {
                    arrayList = new ArrayList<ArcHolder>();
                }
                arrayList.add(arcHolder);
                this.arcMap.put(entity.getObjectID(), arrayList);
                this.removeSelectedLine(varFileLine);
                return;
            }
            return;
        }
        if (entity != null && entity2 != null) {
            Relation relation3 = this.getLogicalDesign().getRelationSet().createRelation(null);
            this.setCreatorChanger(relation3, varFileLine);
            String string5 = this.getField(varFileLine, "partnership_optional_source");
            String string6 = this.getField(varFileLine, "partnership_optional_target");
            relation3.setFireCardinalityChange(false);
            if (string5.equalsIgnoreCase("0")) {
                relation3.setOptionalSource(true);
            } else {
                relation3.setOptionalSource(false);
            }
            if (string6.equalsIgnoreCase("0")) {
                relation3.setOptionalTarget(true);
            } else {
                relation3.setOptionalTarget(false);
            }
            String string7 = this.getField(varFileLine, "partnership_cardinality_source");
            String string8 = this.getField(varFileLine, "partnership_cardinality_target");
            int n = new Integer(string7);
            if (n > 0) {
                relation3.setSourceCardinality(this.findCardinality(n));
            }
            String string9 = this.getPartnershipSetName(varFileLine2);
            String string10 = this.getPartnershipSetName(varFileLine3);
            relation3.setSourceEntity(entity);
            relation3.setNameOnSource(string9);
            relation3.setTargetEntity(entity2);
            relation3.setNameOnTarget(string10);
            boolean bl = this.belongsToPK(string);
            relation3.setBelongsToSourcePK(bl);
            bl = this.belongsToPK(string2);
            relation3.setBelongsToTargetPK(bl);
            relation3.setIdentifying(relation3.belongsToSourcePK() || relation3.belongsToTargetPK());
            int n2 = new Integer(string8);
            if (n2 > 0) {
                relation3.setTargetCardinality(this.findCardinality(n2));
            }
            if (((Relation.Cardinality)relation3.getSourceCardinality()).getValue() == 1 && ((Relation.Cardinality)relation3.getTargetCardinality()).getValue() == 1) {
                if (relation3.belongsToTargetPK()) {
                    relation3.setDominantRole(relation3.getSourceEntity());
                } else if (relation3.belongsToSourcePK()) {
                    relation3.setDominantRole(relation3.getTargetEntity());
                } else if (relation3.isOptionalSource() != relation3.isOptionalTarget()) {
                    if (relation3.isOptionalSource()) {
                        relation3.setDominantRole(relation3.getSourceEntity());
                    } else {
                        relation3.setDominantRole(relation3.getTargetEntity());
                    }
                }
            }
            relation3.setFireCardinalityChange(true);
            relation3.setTargetCardinality(relation3.getTargetCardinality());
            ((TVRelation)relation3.getTopView()).addConnection();
            relation3.setComment(this.getComment(string, string2));
            relation3.setNotes(this.getNotes(string, string2));
            this.relMap.put(string, relation3);
            this.relMap.put(string2, relation3);
            this.addCreatedObject(this.getField(varFileLine, "general_id"), relation3);
            this.addCreatedObject(string, relation3);
            this.addCreatedObject(string2, relation3);
            this.removeSelectedLine(varFileLine);
        }
    }

    private VarFileLine getVarFileLine(String string) {
        for (VarFileLine varFileLine : this.getAllSelectedLines()) {
            if (!varFileLine.getType().equalsIgnoreCase("PARTNERSHIP_SET") || !this.getField(varFileLine, "general_id").equalsIgnoreCase(string)) continue;
            return varFileLine;
        }
        return null;
    }

    private Entity getEntityFromLine(VarFileLine varFileLine) {
        return (Entity)this.getCreatedObject(this.getField(varFileLine, "partnership_source"));
    }

    private String getPartnershipSetName(VarFileLine varFileLine) {
        return this.getField(varFileLine, "partnership_set_name");
    }

    private Object findCardinality(int n) {
        Relation.Cardinality[] cardinalityArray = Relation.getCardinalityChoices();
        switch (n) {
            case 1: {
                return cardinalityArray[n];
            }
        }
        return cardinalityArray[0];
    }

    private String getNotes(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (VarFileLine varFileLine : this.getCommentLines()) {
            VarFileLine varFileLine2;
            String string3;
            String string4;
            if (!varFileLine.getType().equalsIgnoreCase("NOTES") || !string.equalsIgnoreCase(string4 = this.getField(varFileLine, "note_relation_id")) && !string2.equalsIgnoreCase(string4) || "0".equalsIgnoreCase(string3 = this.getField(varFileLine, "note_text_id")) || (varFileLine2 = this.getCommentLine(string3, "ANLTEXT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getField(varFileLine2, "TEXT_COMMENT_2"));
        }
        return stringBuffer.toString();
    }

    private String getComment(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (VarFileLine varFileLine : this.getCommentLines()) {
            VarFileLine varFileLine2;
            String string3;
            String string4;
            if (!varFileLine.getType().equalsIgnoreCase("PARTNERSHIP_SET") || !string.equalsIgnoreCase(string4 = this.getField(varFileLine, "general_id")) && !string2.equalsIgnoreCase(string4) || "0".equalsIgnoreCase(string3 = this.getField(varFileLine, "PARTNERSHIP_TEXT_ID")) || (varFileLine2 = this.getCommentLine(string3, "ANLTEXT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getField(varFileLine2, "TEXT_COMMENT_2"));
        }
        return stringBuffer.toString();
    }

    private boolean belongsToPK(String string) {
        boolean bl = false;
        if (string != null) {
            for (VarFileLine varFileLine : this.getAllSelectedLines()) {
                String string2;
                if (!varFileLine.getType().equalsIgnoreCase("PARTNERSHIP_SETENT") || !string.equalsIgnoreCase(string2 = this.getField(varFileLine, "general_id"))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void createArcs() {
        for (String string : this.arcMap.keySet()) {
            List list = (List)this.arcMap.get(string);
            if (list.size() <= 0) continue;
            Entity entity = ((ArcHolder)list.get((int)0)).entity;
            while (list.size() > 0) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(list);
                ArrayList<DesignObject> arrayList2 = new ArrayList<DesignObject>();
                arrayList2.add(entity);
                ArcHolder arcHolder = (ArcHolder)arrayList.get(0);
                arrayList2.add(arcHolder.rel1);
                arrayList2.add(arcHolder.rel2);
                list.remove(arcHolder);
                for (int i = 1; i < arrayList.size(); ++i) {
                    ArcHolder arcHolder2 = (ArcHolder)arrayList.get(i);
                    if (arcHolder.rel1 != arcHolder2.rel1 && arcHolder.rel1 != arcHolder2.rel2 && arcHolder.rel2 != arcHolder2.rel1 && arcHolder.rel2 != arcHolder2.rel2) continue;
                    if (!arrayList2.contains(arcHolder2.rel1)) {
                        arrayList2.add(arcHolder2.rel1);
                    }
                    if (!arrayList2.contains(arcHolder2.rel2)) {
                        arrayList2.add(arcHolder2.rel2);
                    }
                    list.remove(arcHolder2);
                }
                ((LogicalDesign)entity.getDesignPart()).createArc(arrayList2.toArray());
            }
        }
    }

    private class ArcHolder {
        public Relation rel1;
        public Relation rel2;
        public Entity entity;

        private ArcHolder() {
        }
    }
}

