/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class RHDiagram
extends RowHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    public static final String DIAGRAM_DEFAULT_PHYSICAL = "default_physical";
    public static final String DIAGRAM_DEFAULT_LOGICAL = "default_logical";
    public static final String DIAGRAM_PHYSICAL_TERRAIN = "default_physical_terrain";
    private Fields constants;
    List lines = new ArrayList();
    private static final Integer DIAGRAM_TYPE_POSITION = new Integer(3);
    private static final Integer DIAGRAM_NAME_POSITION = new Integer(2);
    private static final String PHYSICAL_DIAGRAM_TYPE = "1";
    Map diagramMap = new TreeMap();

    public RHDiagram(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
        this.constants = fields;
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    private void collectLines(VarFileLine varFileLine) {
        String string = this.getField(varFileLine.getLine(), DIAGRAM_TYPE_POSITION);
        String string2 = this.getField(varFileLine.getLine(), DIAGRAM_NAME_POSITION);
        if (string.equalsIgnoreCase(PHYSICAL_DIAGRAM_TYPE) && !string2.equalsIgnoreCase(DIAGRAM_PHYSICAL_TERRAIN) && !this.lines.contains(varFileLine)) {
            if (!this.lines.contains(varFileLine)) {
                DesignPartView designPartView;
                this.lines.add(varFileLine);
                if (string2.equalsIgnoreCase(DIAGRAM_DEFAULT_PHYSICAL)) {
                    this.setPhysicalDesignID(varFileLine);
                    designPartView = this.getDesign().getRelationalDesign().getMainView();
                } else {
                    designPartView = this.getDesign().getRelationalDesign().createDesignPartSubView();
                    designPartView.setName(string2);
                    ((DesignPartViewPlaceHolder)((DPVRelationalSubView)designPartView).getPlaceHolder()).setVisible(false);
                }
                this.diagramMap.put(this.getField(varFileLine, "general_id"), designPartView);
            }
            this.removeSelectedLine(varFileLine);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.collectLines(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void setPhysicalDesignID(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "general_id");
        this.constants.setPhysicalDesignID(string);
    }

    public Map getDiagramsMap() {
        return this.diagramMap;
    }
}

