/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHDataBase
extends RowHandler {
    public static final String OBJECT_TYPE = "DATABASES";
    public static final String OBJECT_TYPE_COOL = "DATABASE";

    public RHDataBase(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createDataBase(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createDataBase(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "DATABASE_STORAGE_GROUPS");
        StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)this.getCreatedObject(string);
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        String string2 = this.getField(varFileLine, "DATABASE_NAME");
        if (!string2.equalsIgnoreCase("DSNDB04") && !this.getField(varFileLine, "DATABASE_NAME").equalsIgnoreCase("DSNDB07")) {
            DataBaseDB2 dataBaseDB2 = storageDesignDB2v70.getDataBaseSet().createDataBase();
            dataBaseDB2.setName(this.getField(varFileLine, "DATABASE_NAME"));
            dataBaseDB2.setComment(this.getComment(varFileLine));
            dataBaseDB2.setStorageGroup(storageGroupDB2);
            this.fillCommontOn(varFileLine, dataBaseDB2);
            String string3 = this.getField(varFileLine, "DATABASE_BUFFERPOOL");
            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)this.getCreatedObject(string3);
            if (bufferPoolDB2 != null) {
                dataBaseDB2.setBufferPool(bufferPoolDB2);
            }
            this.addCreatedObject(this.getField(varFileLine, "general_id"), dataBaseDB2);
            this.removeSelectedLine(varFileLine);
        } else {
            DataBaseSetDB2 dataBaseSetDB2 = storageDesignDB2v70.getDataBaseSet();
            Iterator iterator = dataBaseSetDB2.iterator();
            while (iterator.hasNext()) {
                DataBaseDB2 dataBaseDB2 = (DataBaseDB2)iterator.next();
                if (!dataBaseDB2.getName().equalsIgnoreCase(string2)) continue;
                this.addCreatedObject(this.getField(varFileLine, "general_id"), dataBaseDB2);
                this.removeSelectedLine(varFileLine);
            }
        }
    }

    private void fillCommontOn(VarFileLine varFileLine, DataBaseDB2 dataBaseDB2) {
        String string = this.getField(varFileLine, "DATABASE_TEXT");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            dataBaseDB2.setCommentInRDBMS(string2);
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "DATABASE_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "DATABASE_TEXT_ID"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }
}

