/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingBachmannPhysicalDatatype;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandlerDomain;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHColumn
extends RowHandlerDomain
implements SectionConstants {
    public static final String OBJECT_TYPE = "TABLE_COLUMNS";
    public static final String OBJECT_TYPE_COOL = "COLUMN";
    private static final Logger LOGGER = new Logger(RHColumn.class);
    private Map coljct5ToFKMap;
    private Map colToFKMap;

    public RHColumn(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
            this.addColumnLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createColumn(varFileLine, bl);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createColumn(VarFileLine varFileLine, boolean bl) {
        String string = this.getField(varFileLine, "column_table_id");
        Table table = (Table)this.getCreatedObject(string);
        if (table != null) {
            if (!bl) {
                boolean bl2 = this.isFkColumn(this.getField(varFileLine, "general_id"), string);
                if (bl2) {
                    VarColumnFK varColumnFK = new VarColumnFK();
                    varColumnFK.constructColumn(varFileLine, table);
                } else {
                    VarColumn varColumn = new VarColumn();
                    varColumn.constructColumn(varFileLine, table);
                }
            } else {
                String string2 = this.getField(varFileLine, "general_id");
                Column column = (Column)this.getAllCreatedObjects().get(string2);
                if (column != null) {
                    if (column.getContainer() != null) {
                        column.setName(this.getField(varFileLine, "column_name"));
                        column.setComment(this.getComment(varFileLine));
                        this.fillElements(column, varFileLine, table);
                        this.removeSelectedLine(varFileLine);
                    } else {
                        boolean bl3 = this.isFkColumn(this.getField(varFileLine, "general_id"), string);
                        if (bl3) {
                            VarColumnFK varColumnFK = new VarColumnFK();
                            varColumnFK.constructColumn(varFileLine, table);
                        } else {
                            VarColumn varColumn = new VarColumn();
                            varColumn.constructColumn(varFileLine, table);
                        }
                    }
                } else {
                    boolean bl4 = this.isFkColumn(this.getField(varFileLine, "general_id"), string);
                    if (bl4) {
                        VarColumnFK varColumnFK = new VarColumnFK();
                        varColumnFK.constructColumn(varFileLine, table);
                    } else {
                        VarColumn varColumn = new VarColumn();
                        varColumn.constructColumn(varFileLine, table);
                    }
                }
            }
        }
    }

    private void fillNulls(VarFileLine varFileLine, Column column) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "column_nulls_allowed"));
            if (!Fields.typeVar.equalsIgnoreCase("Sterling COOL:DBA V2.1")) {
                if (n == 1) {
                    column.setNullsAllowed(true);
                } else if (n == 2 || n == 3) {
                    column.setNullsAllowed(false);
                }
            } else if (n == 1) {
                column.setNullsAllowed(true);
            } else if (n == 0) {
                column.setNullsAllowed(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillNulls: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL NULLS format near " + varFileLine);
        }
    }

    private void fillType(VarFileLine varFileLine, Column column) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "COLUMN_TYPE"));
            String string = MappingBachmannPhysicalDatatype.getNamePhysicalDatatype(n);
            String string2 = StandardDatatypeNames.getUsedDatatypeName(string);
            LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, string2);
            String[] stringArray = new String[3];
            String string3 = this.getField(varFileLine, "COLUMN_SCALE");
            if (string3.equalsIgnoreCase("0")) {
                if (string2.equals("real") || string2.equals("NUMERIC") || string2.equals("DECIMAL")) {
                    stringArray[2] = string3;
                    stringArray[1] = string3;
                    stringArray[0] = this.getField(varFileLine, "COLUMN_LENGTH");
                } else {
                    stringArray[2] = this.getField(varFileLine, "COLUMN_LENGTH");
                    stringArray[1] = string3;
                    stringArray[0] = string3;
                }
            } else {
                stringArray[2] = "0";
                stringArray[1] = string3;
                stringArray[0] = this.getField(varFileLine, "COLUMN_LENGTH");
            }
            String string4 = DomainFactory.createDomainName(logicalDatatype, stringArray);
            Domain domain = this.getCorrespondingDomain(string4);
            if (domain != null) {
                column.setDomain(domain);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillType: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL TYPE format near " + varFileLine);
        }
    }

    private void fillForbitdata(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "COLUMN_FORBITDATA"));
            String[] stringArray = ColumnProxyDB2.getBitDataChoices();
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    columnProxyDB2.setBitData(stringArray[n]);
                    break;
                }
                default: {
                    columnProxyDB2.setBitData(stringArray[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillForbitdata: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL FORBIT DATA format near " + varFileLine);
        }
    }

    private void fillValue(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            long l = Long.parseLong(this.getField(varFileLine, "COLUMN_VALUE"));
            columnProxyDB2.setInitial(l);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillValue: ");
            stringBuffer.append(this.getField(varFileLine, "COLUMN_VALUE")).append(' ');
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL VALUE format near " + varFileLine);
        }
    }

    private void fillAvglen(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "COLUMN_AVGLEN"));
            columnProxyDB2.setAverageLength(f);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillAvglen: ");
            stringBuffer.append(this.getField(varFileLine, "COLUMN_AVGLEN")).append(' ');
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL AVG LEN format near " + varFileLine);
        }
    }

    private void fillFrequentPct(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "COLUMN_FREQUENT_PCT"));
            columnProxyDB2.setFrequencyPercent(f *= 100.0f);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillFrequentPct: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL FREQUENT PCT format near " + varFileLine);
        }
    }

    private void fillFrequentCount(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            long l = Long.parseLong(this.getField(varFileLine, "COLUMN_FREQUENT_COUNT"));
            columnProxyDB2.setFrequencyCount(l);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillFrequentCount : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL FREQUENT COUNT format near " + varFileLine);
        }
    }

    private void fillUpdateRate(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "COLUMN_UPDATE_RATE"));
            columnProxyDB2.setUpdateRatePercent(f *= 100.0f);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillUpdateRate : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL UPDATE RATE format near " + varFileLine);
        }
    }

    private void fillGrowthPct(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "COLUMN_GROWTH_PCT"));
            columnProxyDB2.setGrowthPercent(f *= 100.0f);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHColumn.fillGrowthPct : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL GROWTH PCT format near " + varFileLine);
        }
    }

    private void fillLabelOn(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        String string = this.getField(varFileLine, "COLUMN_LABEL_ON");
        columnProxyDB2.setLabel(string);
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.getDesign().getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private void fillCommontOn(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        String string = this.getField(varFileLine, "COLUMN_DESCRIPTION");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            columnProxyDB2.setCommentInRDBMS(string2);
        }
    }

    private void fillProgram(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        String string = this.getField(varFileLine, "COLUMN_FIELDPROC2");
        if (!"".equalsIgnoreCase(string) && !"0".equalsIgnoreCase(string)) {
            columnProxyDB2.setProgram(string);
        }
    }

    private void fillConstant(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        String string = this.getField(varFileLine, "COLUMN_FPCONSTANT");
        if (!"".equalsIgnoreCase(string) && !"0".equalsIgnoreCase(string)) {
            columnProxyDB2.setConstant(string);
        }
    }

    private void fillDefault(VarFileLine varFileLine, ColumnProxyDB2 columnProxyDB2) {
        String string = this.getField(varFileLine, "COLUMN_DEFAULT_KEY").trim();
        if (string != null && string.equalsIgnoreCase("1")) {
            String string2 = this.getDefaultValue(string);
            String[] stringArray = ColumnProxyDB2.getDefaultValueChoices();
            columnProxyDB2.setDefault(true);
            columnProxyDB2.setDefaultValue(stringArray[1]);
            columnProxyDB2.setDefaultValueConstant(string2);
            columnProxyDB2.getColumn().setUsesDefaultValue(true);
        }
    }

    private String getDefaultValue(String string) {
        String string2 = "";
        List list = this.getAllSelectedLines();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase("COL_DEFAULT") || !string.equalsIgnoreCase(this.getField(varFileLine, "general_id"))) continue;
            string2 = this.getField(varFileLine, "col_default_value");
        }
        return string2;
    }

    private boolean isFkColumn(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            int n = (Integer)this.getFieldConstants().get("IS_COOL");
            if (n == 1000) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List list = this.getAllSelectedLines();
                for (Object object : list) {
                    if (!((VarFileLine)object).getType().equalsIgnoreCase("COLUMN_SETTABLE_CO") || !string.equalsIgnoreCase(this.getField((VarFileLine)object, "COLUMNSETTABLE_TABLECOLUMN"))) continue;
                    arrayList.add(this.getField((VarFileLine)object, "COLUMNSETTABLE_COLUMNSET"));
                }
                if (arrayList.size() > 0) {
                    Object object;
                    object = this.getAllForeignKeyLines();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string3;
                            VarFileLine varFileLine = (VarFileLine)iterator.next();
                            if (!varFileLine.getType().equalsIgnoreCase("FOREIGN_KEY") || !(string3 = (String)arrayList.get(i)).equalsIgnoreCase(this.getField(varFileLine, "FOREIGNKEY_COLUMNSET")) || !string2.equalsIgnoreCase(this.getField(varFileLine, "foreignkey_table_id"))) continue;
                            bl = true;
                        }
                    }
                }
            } else {
                return this.getColToFKMap().get(string) != null;
            }
        }
        return bl;
    }

    private void makeFKMap(List list) {
        this.coljct5ToFKMap = new TreeMap();
        for (VarFileLine varFileLine : list) {
            String string = this.getField(varFileLine, "FOREIGNKEY_COLJCT5");
            this.coljct5ToFKMap.put(string, string);
        }
    }

    private Map getFKMap() {
        if (this.coljct5ToFKMap == null) {
            this.makeFKMap(this.getAllForeignKeyLines());
        }
        return this.coljct5ToFKMap;
    }

    private void makeColToFKMap() {
        this.colToFKMap = new TreeMap();
        for (VarFileLine varFileLine : this.getAllSelectedLines()) {
            String string;
            if (!varFileLine.getType().equalsIgnoreCase("COLJCT") || (string = this.getField(varFileLine, "COLJCT_5_KEY")).equals("") || this.getFKMap().get(string) == null) continue;
            String string2 = this.getField(varFileLine, "COLJCT_COLUMN_KEY");
            this.colToFKMap.put(string2, string2);
        }
    }

    private Map getColToFKMap() {
        if (this.colToFKMap == null) {
            this.makeColToFKMap();
        }
        return this.colToFKMap;
    }

    protected void fillElements(Column column, VarFileLine varFileLine, Table table) {
        column.getParent();
        this.setCreatorChanger(column, varFileLine);
        this.fillNulls(varFileLine, column);
        this.fillType(varFileLine, column);
        Design design = column.getDesign();
        RDBMSSite rDBMSSite = design.getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)design.getStorageDesign(rDBMSSite);
        ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)storageDesignDB2v70.getColumnProxySet().getProxy(column.getObjectID());
        if (columnProxyDB2 != null) {
            this.fillCommontOn(varFileLine, columnProxyDB2);
            this.fillForbitdata(varFileLine, columnProxyDB2);
            this.fillValue(varFileLine, columnProxyDB2);
            this.fillAvglen(varFileLine, columnProxyDB2);
            this.fillFrequentPct(varFileLine, columnProxyDB2);
            this.fillFrequentCount(varFileLine, columnProxyDB2);
            this.fillUpdateRate(varFileLine, columnProxyDB2);
            this.fillGrowthPct(varFileLine, columnProxyDB2);
            this.fillLabelOn(varFileLine, columnProxyDB2);
            this.fillProgram(varFileLine, columnProxyDB2);
            this.fillConstant(varFileLine, columnProxyDB2);
            this.fillDefault(varFileLine, columnProxyDB2);
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "COLUMN_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "COLUMN_TEXT_ID"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }

    class VarColumnFK
    extends VarColumn {
        VarColumnFK() {
        }

        @Override
        public void constructColumn(VarFileLine varFileLine, Table table) {
            Column column = table.createColumn();
            column.setName(RHColumn.this.getField(varFileLine, "column_name"));
            column.setComment(RHColumn.this.getComment(varFileLine));
            column.setNameFixed(true);
            RHColumn.this.fillElements(column, varFileLine, table);
            this.handleLine(column, varFileLine, table);
        }

        @Override
        protected void handleLine(Column column, VarFileLine varFileLine, Table table) {
            RHColumn.this.addCreatedObject(RHColumn.this.getField(varFileLine, "general_id"), column);
            RHColumn.this.removeSelectedLine(varFileLine);
        }
    }

    class VarColumn {
        VarColumn() {
        }

        public void constructColumn(VarFileLine varFileLine, Table table) {
            Column column = table.createColumn(RHColumn.this.getField(varFileLine, "column_name"));
            column.setComment(RHColumn.this.getComment(varFileLine));
            RHColumn.this.fillElements(column, varFileLine, table);
            this.handleLine(column, varFileLine, table);
        }

        protected void handleLine(Column column, VarFileLine varFileLine, Table table) {
            RHColumn.this.addCreatedObject(RHColumn.this.getField(varFileLine, "general_id"), column);
            RHColumn.this.removeSelectedLine(varFileLine);
        }
    }
}

