/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;

public class RHCheckConstraint
extends RowHandler
implements StatementsConstants {
    public static final String OBJECT_TYPE = "CHECK_CONSTRAINT";

    public RHCheckConstraint(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAlias(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createAlias(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "CHECK_CONSTRAINT_TABLE_ID");
        if (!"0".equalsIgnoreCase(string)) {
            Table table = (Table)this.getCreatedObject(string);
            if (table != null) {
                String string2 = this.getField(varFileLine, "CHECK_CONSTRAINT_NAME");
                String string3 = "";
                VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "CHECK_CONSTRAINT_TEXT"), "TEXT");
                if (varFileLine2 != null) {
                    string3 = this.getField(varFileLine2, "text_comment");
                }
                if (!"".equalsIgnoreCase(string3)) {
                    TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(string2, string3);
                    table.addCheckConstraint(tableLevelConstraint);
                }
            }
        } else {
            Column column;
            String string4 = this.getField(varFileLine, "CHECK_CONSTRAINT_COLUMN_ID");
            if (!"0".equalsIgnoreCase(string4) && (column = (Column)this.getCreatedObject(string4)) != null) {
                String string5 = this.getField(varFileLine, "CHECK_CONSTRAINT_NAME");
                String string6 = "";
                VarFileLine varFileLine3 = this.getCommentLine(this.getField(varFileLine, "CHECK_CONSTRAINT_TEXT"), "TEXT");
                if (varFileLine3 != null) {
                    string6 = this.getField(varFileLine3, "text_comment");
                }
                if (!"".equalsIgnoreCase(string6)) {
                    this.initCheckConstraint(string6, string5, column);
                }
            }
        }
        this.removeSelectedLine(varFileLine);
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        boolean bl = Token.hasToken(string, "LIKE");
        boolean bl2 = Token.hasToken(string, "IN");
        boolean bl3 = Token.hasToken(string, "BETWEEN");
        if (bl) {
            String string3 = Token.getTokenAfter(string, "LIKE");
            string3 = string3.substring(1, string3.length() - 1);
            ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
            constraintEnumeration.add(string3);
            constraintEnumeration.setName(string2);
            column.setUseDomainConstraints(false);
            column.setValueList(constraintEnumeration);
        } else if (bl2) {
            String string4 = Token.getValBetweenBrackets(string).trim();
            ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                string5 = string5.substring(1, string5.length() - 1);
                constraintEnumeration.add(string5);
            }
            constraintEnumeration.setName(string2);
            column.setUseDomainConstraints(false);
            column.setValueList(constraintEnumeration);
        } else if (bl3) {
            String string6 = Token.getTokenAfter(string, "BETWEEN");
            String string7 = Token.getTokenAfter(string, "AND");
            AVT aVT = new AVT(string6, string7, "");
            column.addAVT(aVT);
            column.setUseDomainConstraints(false);
        } else {
            CheckConstraint checkConstraint = new CheckConstraint();
            RDBMSTypeSet rDBMSTypeSet = this.getDesign().getRDBMSTypeSet();
            Iterator iterator = rDBMSTypeSet.iterator();
            while (iterator.hasNext()) {
                RDBMSType rDBMSType = (RDBMSType)iterator.next();
                if (!rDBMSType.getName().equalsIgnoreCase("IBM DB2 (7.0)")) continue;
                checkConstraint.add(rDBMSType, string);
            }
            checkConstraint.setName(string2);
            column.setUseDomainConstraints(false);
            column.setCheck(checkConstraint);
        }
    }
}

