/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHBufferpool
extends RowHandler {
    public static final String OBJECT_TYPE = "BUFFER_POOLS";
    private static final Logger LOGGER = new Logger(RHBufferpool.class);

    public RHBufferpool(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createBufferPool(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createBufferPool(VarFileLine varFileLine) {
        try {
            String string = this.getField(varFileLine, "BUFFER_POOLS_NAME");
            StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(this.getDesign().getSelectedRDBMSSite());
            BufferPoolSetDB2 bufferPoolSetDB2 = storageDesignDB2v70.getBufferPoolSet();
            Iterator iterator = bufferPoolSetDB2.iterator();
            while (iterator.hasNext()) {
                BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
                if (!bufferPoolDB2.getName().equalsIgnoreCase(string)) continue;
                this.fillElements(varFileLine, bufferPoolDB2);
                this.addCreatedObject(this.getField(varFileLine, "general_id"), bufferPoolDB2);
                this.removeSelectedLine(varFileLine);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillElements(VarFileLine varFileLine, BufferPoolDB2 bufferPoolDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "BUFFER_POOLS_MIN_BUFFERS"));
            int n2 = Integer.parseInt(this.getField(varFileLine, "BUFFER_POOLS_MAX_BUFFERS"));
            bufferPoolDB2.setMinBuffers(n);
            bufferPoolDB2.setMaxBuffers(n2);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHBufferpool.fillElements : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong MIN or MAX BUFFER format in " + varFileLine);
        }
    }
}

