/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHAlias
extends RowHandler {
    public static final String OBJECT_TYPE = "ALIASES";

    public RHAlias(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAlias(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    private void createAlias(VarFileLine varFileLine) {
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        if (storageDesignDB2v70 != null) {
            int n = (Integer)this.getFieldConstants().get("IS_COOL");
            if (n == 1000) {
                String string = this.getField(varFileLine, "ALIAS_REF_NAME");
                ModelObject modelObject = this.searchObjectForAlias(string);
                if (modelObject != null) {
                    if (modelObject instanceof Table) {
                        Table table = (Table)modelObject;
                        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)storageDesignDB2v70.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxyDB2 != null) {
                            AliasDB2 aliasDB2 = this.fillElements(varFileLine, storageDesignDB2v70);
                            aliasDB2.setTable(tableProxyDB2);
                            this.cleanUp(varFileLine, aliasDB2);
                        }
                    } else if (modelObject instanceof AliasDB2) {
                        AliasDB2 aliasDB2 = this.fillElements(varFileLine, storageDesignDB2v70);
                        AliasDB2 aliasDB22 = (AliasDB2)modelObject;
                        aliasDB2.setAnotherAlias(aliasDB22);
                        this.cleanUp(varFileLine, aliasDB2);
                    } else if (modelObject instanceof TableView) {
                        TableView tableView = (TableView)modelObject;
                        TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)storageDesignDB2v70.getTableViewProxySet().getProxy(tableView.getObjectID());
                        if (tableViewProxyDB2 != null) {
                            AliasDB2 aliasDB2 = this.fillElements(varFileLine, storageDesignDB2v70);
                            aliasDB2.setView(tableViewProxyDB2);
                            this.cleanUp(varFileLine, aliasDB2);
                        }
                    }
                }
            } else {
                AliasDB2 aliasDB2 = this.fillElements(varFileLine, storageDesignDB2v70);
                String string = this.getField(varFileLine, "ALIAS_TABLE_ID");
                if (!string.equalsIgnoreCase("0")) {
                    TableProxyDB2 tableProxyDB2;
                    Table table = (Table)this.getCreatedObject(string);
                    if (table != null && (tableProxyDB2 = (TableProxyDB2)storageDesignDB2v70.getTableProxySet().getProxy(table.getObjectID())) != null) {
                        aliasDB2.setTable(tableProxyDB2);
                    }
                } else {
                    TableViewProxyDB2 tableViewProxyDB2;
                    TableView tableView;
                    String string2 = this.getField(varFileLine, "ALIAS_VIEW_ID");
                    if (!string2.equalsIgnoreCase("0") && (tableView = (TableView)this.getCreatedObject(string2)) != null && (tableViewProxyDB2 = (TableViewProxyDB2)storageDesignDB2v70.getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                        aliasDB2.setView(tableViewProxyDB2);
                    }
                }
                this.cleanUp(varFileLine, aliasDB2);
            }
        }
    }

    private ModelObject searchObjectForAlias(String string) {
        ModelObject modelObject = null;
        Map map = this.getAllCreatedObjects();
        Collection collection = map.values();
        for (ModelObject modelObject2 : collection) {
            if (!(modelObject2 instanceof Table) && !(modelObject2 instanceof TableView) && !(modelObject2 instanceof SynonymDB2) || !modelObject2.getName().equalsIgnoreCase(string)) continue;
            modelObject = modelObject2;
        }
        return modelObject;
    }

    private AliasDB2 fillElements(VarFileLine varFileLine, StorageDesignDB2v70 storageDesignDB2v70) {
        AliasDB2 aliasDB2 = storageDesignDB2v70.getAliasSet().createAlias();
        aliasDB2.setName(this.getField(varFileLine, "ALIAS_NAME"));
        this.fillCommontOn(varFileLine, aliasDB2);
        this.fillOwner(varFileLine, aliasDB2);
        return aliasDB2;
    }

    private void cleanUp(VarFileLine varFileLine, AliasDB2 aliasDB2) {
        this.addCreatedObject(this.getField(varFileLine, "general_id"), aliasDB2);
        this.removeSelectedLine(varFileLine);
    }

    private void fillCommontOn(VarFileLine varFileLine, AliasDB2 aliasDB2) {
        String string = this.getField(varFileLine, "ALIAS_COMMENT");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            aliasDB2.setCommentInRDBMS(string2);
            aliasDB2.setComment(string2);
        }
    }

    private void fillOwner(VarFileLine varFileLine, AliasDB2 aliasDB2) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "ALIAS_OWNER");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)aliasDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.addCreatedObject(string, owner);
            }
            aliasDB2.setOwner(owner);
        } else {
            String string = this.getField(varFileLine, "ALIAS_OWNER");
            Owner owner = (Owner)this.getCreatedObject(string);
            aliasDB2.setOwner(owner);
        }
    }
}

