/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class MappedVarsCollector
extends CustomDialog {
    private File logicalFile = null;
    private JTextField text;
    private JList list;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private URLChooser fileChooser;

    public MappedVarsCollector(ApplicationView applicationView) {
        super(applicationView);
        Serializable serializable;
        this.setLayout(new BorderLayout());
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".var") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("MappedVarsCollector.VARFiles");
            }
        };
        this.fileChooser = DialogUtil.newURLChooser();
        this.fileChooser.clearChooseableURLFilters();
        this.fileChooser.setSelectionScope(0);
        this.fileChooser.setSelectionMode(0);
        this.fileChooser.setShowJarsAsDirs(false);
        this.fileChooser.setURLFilter(uRLFilter);
        String string = this.getApplicationView().getSettings().getDefaultImportPath();
        if (string != null) {
            this.fileChooser.setSelectedURL(URLFactory.newDirURL((String)string));
        } else {
            serializable = this.getApplicationView().getUserHomeDirectory();
            if (serializable != null) {
                this.fileChooser.setSelectedURL((URL)serializable);
            }
        }
        serializable = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("MappedVarsCollector.Logical"));
        jPanel.setBorder(titledBorder);
        this.text = new JTextField();
        this.text.setEditable(false);
        this.text.setPreferredSize(new Dimension(260, 20));
        jPanel.add(this.text);
        JButton jButton = new JButton(Messages.getString("MappedVarsCollector.Select"));
        jButton.setMnemonic(83);
        jButton.addActionListener(new SelListener());
        jPanel.add(jButton);
        ((Container)serializable).add(jPanel, "North");
        JPanel jPanel2 = new JPanel();
        titledBorder = BorderFactory.createTitledBorder(Messages.getString("MappedVarsCollector.Relationals"));
        jPanel2.setBorder(titledBorder);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        jPanel2.add(new JScrollPane(this.list));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JButton jButton2 = new JButton(Messages.getString("MappedVarsCollector.Add"));
        jButton2.setMnemonic(65);
        jButton2.addActionListener(new AddListener());
        jPanel3.add((Component)jButton2, "North");
        JButton jButton3 = new JButton(Messages.getString("MappedVarsCollector.Remove"));
        jButton3.setMnemonic(82);
        jButton3.addActionListener(new RemoveListener());
        jPanel3.add((Component)new JPanel(), "Center");
        jPanel3.add((Component)jButton3, "South");
        jPanel2.add(jPanel3);
        ((Container)serializable).add(jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton4 = new JButton(Messages.getString("MappedVarsCollector.OK"));
        jButton4.setMnemonic(79);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MappedVarsCollector.this.result = MappedVarsCollector.this.checkFiles();
                if (MappedVarsCollector.this.result) {
                    MappedVarsCollector.this.close();
                }
            }
        });
        jPanel4.add(jButton4);
        JButton jButton5 = new JButton(Messages.getString("MappedVarsCollector.Cancel"));
        jButton5.setMnemonic(67);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MappedVarsCollector.this.result = false;
                MappedVarsCollector.this.close();
            }
        });
        jPanel4.add(jButton5);
        JButton jButton6 = new JButton(this.getHelpAction());
        jButton6.setMnemonic(72);
        jPanel4.add(jButton6);
        jButton4.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton5.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton6.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        ((Container)serializable).add(jPanel4, "South");
        this.add((Component)serializable);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("MappedVarsCollector.SelectMappedVarFiles"));
            this.dialog.setModal(true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_MAPPED_VAR_FILES_DIALOG";
    }

    public boolean showDialog(ApplicationView applicationView) {
        this.result = false;
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private boolean checkFiles() {
        if (this.logicalFile == null) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.YouMustSelectLogicalVARFile"), Messages.getString("MappedVarsCollector.Warning"), 2);
            return false;
        }
        if (this.getRelationalFiles().length == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.YouMustSelect1RelationalVARFile"), Messages.getString("MappedVarsCollector.Warning"), 2);
            return false;
        }
        return true;
    }

    private class SelListener
    implements ActionListener {
        private SelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            int n = MappedVarsCollector.this.fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.SelectLogicalFile"));
            MappedVarsCollector.this.fileChooser.setFileNameURL("");
            if (n == 0 && (file = new File(MappedVarsCollector.this.fileChooser.getSelectedURL().getPath())) != null) {
                MappedVarsCollector.this.logicalFile = file;
                MappedVarsCollector.this.text.setText(MappedVarsCollector.this.logicalFile.getAbsolutePath());
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = MappedVarsCollector.this.list.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                MappedVarsCollector.this.listModel.removeElement(objectArray[i]);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            int n = MappedVarsCollector.this.fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("MappedVarsCollector.SelectRelationalFile"));
            MappedVarsCollector.this.fileChooser.setFileNameURL("");
            if (n == 0 && (file = new File(MappedVarsCollector.this.fileChooser.getSelectedURL().getPath())) != null) {
                MappedVarsCollector.this.listModel.addElement(file);
            }
        }
    }
}

