/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.imports.parser.SQLCommand;
import oracle.dbtools.crest.imports.parser.SQLStatementTypes;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.util.IdeUtil;

public class ScriptParser {
    private static final Logger LOGGER = new Logger(ScriptParser.class);
    private static final String systemLineSeparator = System.getProperty("line.separator");
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private List<SQLCommand> m_sqlArray = new ArrayList<SQLCommand>();
    private BufferedReader m_reader = null;
    private int m_readerLineCnt = -1;
    private int m_readerLineStartCnt = 0;
    private int m_state = 0;
    private boolean m_firstLine = true;
    private String m_quoteString = "";
    private String m_leftOver = null;
    private boolean sqlServerDDL = false;
    private boolean db2orUDB = false;
    private String db2UDBTerminationString = ";";

    public ScriptParser(InputStream inputStream, int n) throws UnsupportedEncodingException {
        this(inputStream);
        if (n == 9 || n == 4) {
            this.sqlServerDDL = true;
        }
        if (n == 5 || n == 1 || n == 6 || n == 2) {
            this.db2orUDB = true;
            char c = AbstractSSBDB2.DB2_UDB_STATEMENT_TERMINATION_CHAR;
            this.db2UDBTerminationString = c == ' ' ? ";" : String.valueOf(AbstractSSBDB2.DB2_UDB_STATEMENT_TERMINATION_CHAR);
        }
    }

    public ScriptParser(InputStream inputStream) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, IdeUtil.getIdeEncoding()));
    }

    public ScriptParser(Reader reader) {
        this.scriptParserInit(reader);
    }

    private void scriptParserInit(Reader reader) {
        this.m_reader = new BufferedReader(reader);
    }

    public ScriptParser(String string) {
        this(new StringReader(string));
    }

    public void parse() {
        this.m_leftOver = null;
        this.m_readerLineCnt = -1;
        try {
            SQLCommand sQLCommand = this.next();
            while (sQLCommand != null) {
                this.m_sqlArray.add(sQLCommand);
                sQLCommand = this.next();
            }
        }
        catch (IOException iOException) {
            LOGGER.error(iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public SQLCommand next() throws IOException {
        String string = this.getTop(this.m_leftOver);
        this.m_leftOver = null;
        if (string == null) {
            return null;
        }
        SQLCommand sQLCommand = this.getPropertiesWhenNoSpaceRequired(string);
        if (sQLCommand == null) {
            sQLCommand = this.getPropertiesWhenTokensKnown(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.getPropertiesWhenMulitpleTokensKnown(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.getHalfRecognizedMultiToken(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.createUnknownStatementProperties();
        }
        sQLCommand = this.refineStmtRecognition(sQLCommand, string);
        sQLCommand = this.identifyEndOfStatement(string, this.m_reader, sQLCommand);
        return sQLCommand;
    }

    private SQLCommand getHalfRecognizedMultiToken(String string) {
        Set<String> set = SQLStatementTypes.halfRecognizedMultiToken.keySet();
        for (String string2 : set) {
            if (!string.toLowerCase().startsWith(string2)) continue;
            return SQLStatementTypes.halfRecognizedMultiToken.get(string2);
        }
        return null;
    }

    private void setError(SQLCommand sQLCommand) {
        sQLCommand.setProperty("prop_error_string", "SQLPLUS command failed - not enough arguments");
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLCommand refineStmtRecognition(SQLCommand sQLCommand, String string) {
        String string2 = null;
        String string3 = null;
        if (sQLCommand.isSqlPlusSetCmd() || sQLCommand.isCreateCmd() || sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME) {
            String[] stringArray = this.getTokens(string);
            if (stringArray.length <= 2) {
                this.setError(sQLCommand);
                return sQLCommand;
            }
            string3 = stringArray[2];
            string2 = stringArray[2].toLowerCase();
            if (string2.equals("replace")) {
                if (stringArray.length <= 4) {
                    this.setError(sQLCommand);
                    return sQLCommand;
                }
                string3 = stringArray[4];
                string2 = stringArray[4];
            }
        } else {
            if (sQLCommand.getStmtSubType() != SQLCommand.StmtSubType.G_S_SPOOL && sQLCommand.getStmtSubType() != SQLCommand.StmtSubType.G_S_DEFINE) {
                return sQLCommand;
            }
            String[] stringArray = this.getTokens(string);
            if (stringArray.length <= 1) {
                return sQLCommand;
            }
            string3 = stringArray[1];
            string2 = stringArray[1].toLowerCase();
        }
        if (string2.equals("on")) {
            sQLCommand.setProperty("prop_status_boolean", true);
        } else if (string2.equals("off")) {
            sQLCommand.setProperty("prop_status_boolean", false);
        }
        if (string3 != null && !string3.equals("")) {
            sQLCommand.setProperty("prop_file_string", string3);
        } else {
            sQLCommand.setProperty("prop_file_string", string2);
        }
        if (sQLCommand.getProperty("prop_status_boolean") == null) {
            sQLCommand.setProperty("prop_status_boolean", true);
        }
        return sQLCommand;
    }

    private String[] getTokens(String string) {
        string = string.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
        string = string.replace("  ", " ");
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.split(" ");
    }

    private SQLCommand getPropertiesWhenMulitpleTokensKnown(String string) {
        String string2 = this.stripLine(string);
        Set<String> set = this.db2orUDB ? SQLStatementTypes.getMultiTokenDB2UDB().keySet() : SQLStatementTypes.multiToken.keySet();
        for (String string3 : set) {
            if (!string2.startsWith(string3)) continue;
            return SQLStatementTypes.multiToken.get(string3);
        }
        return null;
    }

    private SQLCommand createUnknownStatementProperties() {
        return new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_UNKNOWN, SQLCommand.StmtResultType.G_R_UNKNOWN, true);
    }

    private SQLCommand getPropertiesWhenNoSpaceRequired(String string) {
        SQLCommand sQLCommand = null;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = null;
        if ((string = string.trim()).length() >= 2) {
            string2 = string.trim().substring(0, 2);
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
            } else {
                string2 = string.trim().substring(0, 1);
                if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                    sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
                }
            }
        } else {
            string2 = string;
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
            }
        }
        return sQLCommand;
    }

    private SQLCommand getPropertiesWhenTokensKnown(String string) {
        String[] stringArray = string.trim().split("[ \n\r\t]");
        if (stringArray[0] != null && stringArray[0].length() > 0 && stringArray[0].charAt(stringArray[0].length() - 1) == ';') {
            stringArray[0] = stringArray[0].replaceAll(";", "");
        }
        return SQLStatementTypes.spaceRequiredTokens.get(stringArray[0].toLowerCase(Locale.ENGLISH));
    }

    private StringBuffer findEndOfSQLAndPLSQL(String string, BufferedReader bufferedReader, SQLCommand sQLCommand, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        boolean bl3 = false;
        int n = 0;
        int n2 = 1;
        while (bl2) {
            Object[] objectArray;
            int n3;
            int n4 = -1;
            if (string == null) {
                n3 = 0;
            } else {
                objectArray = this.numberOfQuotes(string, true, true);
                n3 = objectArray[0];
                n = objectArray[1];
                n4 = objectArray[2];
            }
            if (n3 % 2 != 0) {
                boolean bl4 = bl3 = !bl3;
            }
            if (string != null && !bl3) {
                if (n4 != -1 && bl) {
                    this.m_leftOver = string.length() != n4 + 1 ? string.substring(n4 + 1) : null;
                    string = string.substring(0, n4);
                    bl2 = false;
                } else if (string.trim().endsWith(";") && n == 0 && bl) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf(";"));
                } else if (string.trim().endsWith("\n/") || string.trim().equals("/")) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf("/"));
                } else if (string.trim().equals(".")) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf("."));
                } else if (this.sqlServerDDL && string.endsWith("\nGO")) {
                    bl2 = false;
                    string = string.substring(0, string.length() - 3);
                } else if (this.db2orUDB && string.endsWith(this.db2UDBTerminationString)) {
                    bl2 = false;
                    string = string.substring(0, string.length() - 1);
                }
                stringBuffer.append(string + systemLineSeparator);
                if (bl2) {
                    string = bufferedReader.readLine();
                    ++n2;
                    ++this.m_readerLineCnt;
                    if (this.sqlServerDDL && string != null && string.trim().toUpperCase().startsWith("GO") && (objectArray = (Object[])this.getTokens(string)).length > 0 && objectArray[0].equalsIgnoreCase("GO")) {
                        bl2 = false;
                        string = "";
                    }
                }
            } else {
                stringBuffer.append(string + systemLineSeparator);
                string = bufferedReader.readLine();
                ++n2;
                ++this.m_readerLineCnt;
            }
            if (string != null) continue;
            bl2 = false;
        }
        sQLCommand.setStartLine(this.m_readerLineStartCnt);
        sQLCommand.setEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    private StringBuffer findEndOfSQLPLUS(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) throws IOException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 1;
        while (bl) {
            if (string.trim().endsWith("-")) {
                stringBuffer.append(string + systemLineSeparator);
                string = bufferedReader.readLine();
                ++n;
                ++this.m_readerLineCnt;
                if (string != null) continue;
                bl = false;
                continue;
            }
            if (this.sqlServerDDL && sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) {
                stringBuffer.append(string + systemLineSeparator);
                string = bufferedReader.readLine();
                ++n;
                ++this.m_readerLineCnt;
                if (string == null) {
                    bl = false;
                    continue;
                }
                stringArray = this.getTokens(string);
                if (stringArray.length <= 0 || !stringArray[0].equalsIgnoreCase("GO")) continue;
                bl = false;
                continue;
            }
            bl = false;
            stringBuffer.append(string + systemLineSeparator);
        }
        sQLCommand.setStartLine(this.m_readerLineStartCnt);
        sQLCommand.setEndLine(this.m_readerLineCnt);
        if (stringBuffer.toString().trim().endsWith(";") && stringBuffer.length() > 1) {
            stringArray = stringBuffer.substring(0, stringBuffer.lastIndexOf(";"));
            stringBuffer = new StringBuffer((String)stringArray);
        }
        return stringBuffer;
    }

    private StringBuffer findEndOfMultiLineComment(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 1;
        while (bl) {
            int n2 = string.indexOf("*/");
            if (n2 >= 0) {
                bl = false;
                if (n2 + 2 == string.length()) {
                    this.m_leftOver = "";
                } else {
                    this.m_leftOver = string.substring(n2 + 2);
                    string = string.substring(0, n2 + 2);
                }
                stringBuffer.append(string + systemLineSeparator);
                continue;
            }
            stringBuffer.append(string + systemLineSeparator);
            string = bufferedReader.readLine();
            ++n;
            ++this.m_readerLineCnt;
            if (string != null) continue;
            bl = false;
            stringBuffer.append("*/");
        }
        sQLCommand.setStartLine(this.m_readerLineStartCnt);
        sQLCommand.setEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    private SQLCommand identifyEndOfStatement(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            switch (sQLCommand.getStmtType()) {
                case G_C_SQL: {
                    stringBuffer = this.findEndOfSQLAndPLSQL(string, bufferedReader, sQLCommand, true);
                    break;
                }
                case G_C_PLSQL: {
                    stringBuffer = this.findEndOfSQLAndPLSQL(string, bufferedReader, sQLCommand, false);
                    break;
                }
                case G_C_SQLPLUS: {
                    stringBuffer = this.findEndOfSQLPLUS(string, bufferedReader, sQLCommand);
                    break;
                }
                case G_C_USERDEFINED: 
                case G_C_COMMENT: {
                    stringBuffer = this.findEndOfLine(string, sQLCommand);
                    break;
                }
                case G_C_UNKNOWN: {
                    LOGGER.error("Unsupported Command: " + string);
                }
                case G_C_MULTILINECOMMENT: {
                    stringBuffer = this.findEndOfMultiLineComment(string, bufferedReader, sQLCommand);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error(iOException.getLocalizedMessage());
        }
        this.m_state = 0;
        if (stringBuffer.length() > 0) {
            while (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        }
        sQLCommand.setSql(stringBuffer.toString());
        return sQLCommand;
    }

    private StringBuffer findEndOfLine(String string, SQLCommand sQLCommand) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + systemLineSeparator);
        sQLCommand.setStartLine(this.m_readerLineStartCnt);
        sQLCommand.setEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    public static String removeComments(String string) {
        string = ScriptParser.checkInLineComments(string);
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("/*", n);
        while (n3 > -1) {
            if (ScriptParser.amIInitial(string.substring(n2, n3))) {
                n2 = n3;
                int n4 = string.indexOf("*/", n3);
                if (n4 == -1) {
                    string = string.substring(0, n3);
                    n3 = -1;
                    continue;
                }
                string = string.substring(0, n3) + " " + string.substring(n4 + 2);
                n3 = string.indexOf("/*", n3);
                continue;
            }
            ++n3;
            n3 = string.indexOf("/*", n3);
        }
        return string;
    }

    private static String checkInLineComments(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("--", n);
        while (n3 > -1) {
            if (ScriptParser.amIInitial(string.substring(n2, n3))) {
                n2 = n3;
                int n4 = string.indexOf("\n", n3);
                if (n4 == -1) {
                    string = string.substring(0, n3);
                    n3 = -1;
                    continue;
                }
                string = string.substring(0, n3) + systemLineSeparator + string.substring(n4 + 1);
                n3 = string.indexOf("--", n3);
                continue;
            }
            ++n3;
            n3 = string.indexOf("--", n3);
        }
        return string;
    }

    private String stripLine(String string) {
        String string2 = string;
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        string2 = string2.toLowerCase();
        return string2;
    }

    private String getTop(String string) {
        String string2;
        block10: {
            string2 = null;
            try {
                if (string == null) {
                    string2 = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                } else {
                    string2 = string;
                }
                if (string2 == null) {
                    return null;
                }
                while (string2.trim().equals("")) {
                    string2 = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                    if (string2 != null) continue;
                    return null;
                }
                if (string2 != null) {
                    string2 = string2.replaceAll("^\\s+", "");
                }
                this.m_readerLineStartCnt = this.m_readerLineCnt;
                String string3 = string2.trim().toLowerCase();
                if (!string3.startsWith("create") && !string3.startsWith("drop") && !string3.startsWith("alter")) break block10;
                String string4 = "";
                while (string2.indexOf(";") == -1 && string2.indexOf("/") == -1 && string2.toLowerCase().indexOf("begin") == -1 && string4 != null) {
                    String[] stringArray;
                    string4 = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                    if (string4 == null) continue;
                    if (this.sqlServerDDL && string4.trim().toUpperCase().startsWith("GO") && (stringArray = this.getTokens(string4)).length > 0 && stringArray[0].equalsIgnoreCase("GO")) {
                        string2 = string2 + "\nGO";
                        break;
                    }
                    if (this.db2orUDB && string4.trim().endsWith(this.db2UDBTerminationString)) {
                        string2 = string2 + systemLineSeparator + string4;
                        break;
                    }
                    string2 = string2 + systemLineSeparator + string4;
                }
            }
            catch (IOException iOException) {
                LOGGER.error(iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return string2;
    }

    public SQLCommand[] getSqlStatements() {
        return this.m_sqlArray.toArray(new SQLCommand[this.m_sqlArray.size()]);
    }

    private static boolean amIInitial(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        boolean[] blArray = new boolean[m_startAndEnd.length];
        for (n = 1; n < m_startAndEnd.length; ++n) {
            blArray[n] = true;
        }
        n = 1;
        while (true) {
            int n4;
            if (n2 == 0) {
                int n5;
                int n6 = 100000;
                n4 = 0;
                int n7 = 1;
                for (n7 = 1; n7 < m_startAndEnd.length; ++n7) {
                    if (!blArray[n7]) continue;
                    n5 = string.indexOf(m_startAndEnd[n7][0], n3);
                    if (n5 == -1) {
                        blArray[n7] = false;
                        continue;
                    }
                    if (n5 >= n6 || n7 == 5 && n5 + 2 == string.length()) continue;
                    n6 = n5;
                    n4 = n7;
                }
                n7 = 5;
                if (n != 0) {
                    n5 = string.indexOf("Q'", n3);
                    if (n5 == -1) {
                        n = 0;
                    } else if (n5 < n6 && (n7 != 5 || n5 + 2 != string.length())) {
                        n6 = n5;
                        n4 = n7;
                    }
                }
                if (n4 == 5) {
                    string2 = string.substring(n6 + 2, n6 + 3);
                    string2 = ScriptParser.getEndQuoteString(string2);
                }
                if (n4 == 5) {
                    n2 = 5;
                    n3 = n6 + 3;
                    continue;
                }
                if (n4 == 4) {
                    n2 = 4;
                    n3 = n6 + 1;
                    continue;
                }
                if (n4 == 0) {
                    return n2 == 0;
                }
                n2 = n4;
                n3 = n6 + m_startAndEnd[n4][0].length();
                continue;
            }
            String string3 = m_startAndEnd[n2][1];
            if (n2 == 5) {
                string3 = string2 + string3;
            }
            if ((n4 = string.indexOf(string3, n3)) == -1) {
                return n2 == 0;
            }
            n3 = n4 + string3.length();
            if (n2 == 4 || n2 == 5) {
                string2 = "";
            }
            n2 = 0;
        }
    }

    private int[] numberOfQuotes(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        if (string.indexOf(10) != -1) {
            int[] nArray = null;
            int n5 = 0;
            for (String string2 : string.split("\n")) {
                nArray = this.numberOfQuotes(string2, bl, bl2);
                n += nArray[0];
                if (bl && nArray[2] != -1) {
                    return new int[]{n, nArray[1], nArray[2] + n5};
                }
                n5 = n5 + string2.length() + "\n".length();
            }
            return new int[]{n, nArray[1], nArray[2]};
        }
        while (true) {
            int n6;
            int n7;
            int n8;
            if (this.m_state == 0) {
                int n9 = 100000;
                n8 = 0;
                n7 = 1;
                for (n7 = 1; n7 < m_startAndEnd.length; ++n7) {
                    n6 = string.indexOf(m_startAndEnd[n7][0], n2);
                    if (n6 == -1 || n6 >= n9 || n7 == 5 && n6 + 2 == string.length()) continue;
                    n9 = n6;
                    n8 = n7;
                }
                n7 = 5;
                n6 = string.indexOf("Q'", n2);
                if (n6 != -1 && n6 < n9 && (n7 != 5 || n6 + 2 != string.length())) {
                    n9 = n6;
                    n8 = n7;
                }
                if (bl && (n6 = string.indexOf(";", n2)) != -1 && n6 < n9) {
                    this.setFirstLine(string);
                    n4 = n6;
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                if (n8 == 5) {
                    this.m_quoteString = string.substring(n9 + 2, n9 + 3);
                    this.m_quoteString = ScriptParser.getEndQuoteString(this.m_quoteString);
                }
                if (n8 == 5) {
                    ++n;
                    this.m_state = 5;
                    n2 = n9 + 3;
                    continue;
                }
                if (n8 == 4) {
                    ++n;
                    this.m_state = 4;
                    n2 = n9 + 1;
                    continue;
                }
                if (n8 == 1 && this.m_firstLine && string.substring(n9).replaceAll("\\s+$", "").equals("--") && !string.replaceAll("\\s+$", "").replaceAll("^\\s+", "").equals("--")) {
                    n2 = n9 + 1;
                    continue;
                }
                if (n8 == 0) {
                    this.setFirstLine(string);
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                this.m_state = n8;
                n2 = n9 + m_startAndEnd[n8][0].length();
                continue;
            }
            String string3 = m_startAndEnd[this.m_state][1];
            if (this.m_state == 5) {
                string3 = this.m_quoteString + string3;
            }
            n8 = 0;
            n7 = string.indexOf(string3, n2);
            if (bl2 && this.m_firstLine && this.m_state == 1 && n7 == -1 && string.replaceAll("\\s+$", "").endsWith("-") && !string.replaceAll("^\\s+", "").startsWith("--")) {
                n8 = 1;
            }
            if (bl2 && this.m_firstLine && this.m_state == 1) {
                while (n7 != -1) {
                    int n10 = n6 = string.substring(n2, n7).replaceAll("\\s+$", "").endsWith("-") && !string.replaceAll("^\\s+", "").startsWith("--") ? 1 : 0;
                    if (n6 == 0) break;
                    if (n7 + 1 <= string.length()) {
                        n7 = string.indexOf(string3, n7 + 1);
                        continue;
                    }
                    n8 = 1;
                    n7 = -1;
                }
            }
            if (n7 == -1) {
                if (this.m_state == 1) {
                    if (n8 == 0) {
                        this.m_state = 0;
                    }
                    if (string.trim().endsWith(";")) {
                        n3 = 1;
                    }
                } else if (this.m_state != 0 && string.trim().endsWith(";")) {
                    n3 = 1;
                }
                this.setFirstLine(string);
                int[] nArray = new int[]{n, n3, n4};
                return nArray;
            }
            n2 = n7 + string3.length();
            if (this.m_state == 4 || this.m_state == 5) {
                ++n;
                this.m_quoteString = "";
            }
            this.m_state = 0;
        }
    }

    void setFirstLine(String string) {
        if (this.m_firstLine && (!string.replaceAll("\\s+$", "").endsWith("-") || string.replaceAll("^\\s+", "").startsWith("--"))) {
            this.m_firstLine = false;
        }
    }

    boolean isQuoteStringValid(String string) {
        boolean bl = true;
        if (string.equals("\t") || string.equals("\r") || string.equals("\n") || string.equals(" ")) {
            bl = false;
        }
        return bl;
    }

    static String getEndQuoteString(String string) {
        String string2 = string;
        if (string2.equals("[")) {
            string2 = "]";
        } else if (string2.equals("{")) {
            string2 = "}";
        } else if (string2.equals("<")) {
            string2 = ">";
        } else if (string2.equals("(")) {
            string2 = ")";
        }
        return string2;
    }
}

