/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOView
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "VIEW";
    private static final Logger LOGGER = new Logger(ODOView.class);
    PreparedStatement s_statement;
    PreparedStatement wh_statement;
    PreparedStatement col_statement;
    PreparedStatement tr_statement;
    PreparedStatement vstatement;

    public ODOView(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ODObject oDObject : list) {
            Object object;
            String string;
            String string2;
            String string3;
            String string4;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid,ORACLE_OBJECT_TYPE_REFERENCE,OVERRIDE_SELECT_TEXT_FLAG, a.REMARK ");
                    ((StringBuffer)charSequence).append("from CI_VIEW_DEFINITIONS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string4 = resultSet.getString(2);
                    string3 = resultSet.getString(3);
                    string2 = resultSet.getString(4);
                    string = resultSet.getString(5);
                    object = new ODObject(false, (String)charSequence, OBJECT_TYPE, string4);
                    ((ODObject)object).ivid = string3;
                    ((ODObject)object).setParentName(oDObject.getName());
                    ((ODObject)object).setParentID(oDObject.getIrid());
                    ((ODObject)object).objectReference = string2;
                    if ("Y".equals(string)) {
                        ((ODObject)object).overrideSelectText = true;
                    }
                    ((ODObject)object).containerType = oDObject.containerType;
                    arrayList.add(object);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid,ORACLE_OBJECT_TYPE_REFERENCE,OVERRIDE_SELECT_TEXT_FLAG, a.REMARK ");
                ((StringBuffer)charSequence).append("from CI_VIEW_DEFINITIONS a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM CI_VIEW_DEFINITIONS F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOView.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string4 = resultSet.getString(2);
                string3 = resultSet.getString(3);
                string2 = resultSet.getString(4);
                string = resultSet.getString(5);
                object = resultSet.getString(6);
                ODObject oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string4);
                oDObject2.ivid = string3;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.setDescription((String)object);
                oDObject2.objectReference = string2;
                if ("Y".equals(string)) {
                    oDObject2.overrideSelectText = true;
                }
                oDObject2.containerType = oDObject.containerType;
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.s_statement = null;
        this.wh_statement = null;
        this.col_statement = null;
        this.tr_statement = null;
        this.vstatement = null;
        for (ODObject oDObject : list) {
            String string;
            String string2;
            String string3;
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            String string4 = oDObject.getIrid();
            TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
            tableView.setName(oDObject.getName());
            this.setNotesAndComments(connection, tableView, string4, oDObject.ivid);
            tableView.setCommentInRDBMS(oDObject.getDescription());
            this.createDBSynonyms(connection, oDObject.getName(), oDObject.ivid);
            this.getExtractionHandler().addToImportedObjects(string4, tableView);
            StructuredType structuredType = null;
            if (oDObject.objectReference != null) {
                structuredType = (StructuredType)this.getExtractionHandler().getImportedObject(oDObject.objectReference);
            }
            if (structuredType != null) {
                tableView.setBasedOnStructuredType(structuredType);
                if (oDObject.overrideSelectText) {
                    string3 = "CREATE OR REPLACE VIEW " + oDObject.getName() + " AS";
                    string2 = this.getSelectStatement(connection, string4, oDObject.ivid);
                    string = this.getWhereStatement(connection, string4, true, oDObject.ivid);
                    tableView.setUserDefined(true);
                    if (string2.endsWith("\n")) {
                        tableView.setUserDefinedSQL(string3 + '\n' + string2 + string);
                    } else {
                        tableView.setUserDefinedSQL(string3 + '\n' + string2 + '\n' + string);
                    }
                }
            } else if (oDObject.overrideSelectText) {
                string3 = "CREATE OR REPLACE VIEW " + oDObject.getName() + " AS";
                string2 = this.getSelectStatement(connection, string4, oDObject.ivid);
                string = this.getWhereStatement(connection, string4, true, oDObject.ivid);
                tableView.setUserDefined(true);
                if (string2.endsWith("\n")) {
                    tableView.setUserDefinedSQL(string3 + '\n' + string2 + string);
                } else {
                    tableView.setUserDefinedSQL(string3 + '\n' + string2 + '\n' + string);
                }
            } else {
                this.initViewColumns(connection, tableView, string4, oDObject.ivid);
                tableView.setWhere(this.getWhereStatement(connection, string4, false, oDObject.ivid));
            }
            this.initViewTriggers(connection, tableView, string4, oDObject.ivid, oDObject.branch);
            importLogger.incrementImportedStatements();
        }
        if (this.s_statement != null) {
            this.s_statement.close();
        }
        if (this.wh_statement != null) {
            this.wh_statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.tr_statement != null) {
            this.tr_statement.close();
        }
        if (this.vstatement != null) {
            this.vstatement.close();
        }
    }

    private void initViewColumns(Connection connection, TableView tableView, String string, String string2) throws Exception {
        Object object;
        if (this.col_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("base_column_reference").append(',');
            ((StringBuffer)object).append("NAME").append(' ').append("alias_in_view").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_columns").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABLE_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid ").append('=').append(" ? ");
            ((StringBuffer)object).append(" order by  SEQUENCE_NUMBER");
            this.col_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.col_statement.setString(1, string);
            this.col_statement.setString(2, string2);
            object = this.col_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOView.initViewColumns(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("base_column_reference");
                String string4 = object.getString("alias_in_view");
                Column column = null;
                if (string3 != null) {
                    column = (Column)this.getExtractionHandler().getImportedObject(string3);
                }
                if (column == null) continue;
                ColumnView columnView = new ColumnView(tableView.getDesignPart());
                columnView.setName(column.getName());
                columnView.setDesign(tableView.getDesign());
                columnView.setReferencedColumn(column);
                columnView.setDataType(column.getDataType().toString());
                columnView.setContainer(tableView);
                columnView.setTable((Table)column.getContainer());
                tableView.add(columnView);
                tableView.addToContainers(column.getContainer(), column.getContainer().getName());
                if (string4 == null) continue;
                columnView.setAlias(string4);
            }
            object.close();
        }
    }

    private String getSelectStatement(Connection connection, String string, String string2) throws Exception {
        Object object;
        String string3 = "";
        if (this.s_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("PAC_REF").append('=').append(" ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("txt_type").append('=').append("'LGEXPR'").append(' ');
            ((StringBuffer)object).append(" and parent_ivid ").append('=').append(" ? ");
            ((StringBuffer)object).append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.s_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.s_statement.setString(1, string);
            this.s_statement.setString(2, string2);
            object = this.s_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOView.getSelectStatement(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string4 = object.getString("txt_text");
                if ("".equalsIgnoreCase(string3)) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + "\n" + string4;
            }
            object.close();
        }
        if (!"".equalsIgnoreCase(string3) && !string3.trim().toUpperCase().startsWith("SELECT")) {
            string3 = "SELECT " + string3.trim();
        }
        return string3;
    }

    private String getWhereStatement(Connection connection, String string, boolean bl, String string2) throws Exception {
        CharSequence charSequence;
        Object object;
        CharSequence charSequence2 = "";
        if (this.wh_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("PAC_REF").append('=').append(" ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("txt_type").append('=').append("'CDWHCL'").append(' ');
            ((StringBuffer)object).append(" and parent_ivid ").append('=').append(" ? ");
            ((StringBuffer)object).append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.wh_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("txt_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("rm_text_lines").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("PAC_REF").append('=').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("txt_type").append('=').append("'CDWHCL'").append(' ');
            ((StringBuffer)charSequence).append(" and parent_ivid ").append('=').append(string2);
            ((StringBuffer)charSequence).append(' ').append("ORDER BY").append(' ').append("TXT_SEQ");
            this.wh_statement.setString(1, string);
            this.wh_statement.setString(2, string2);
            object = this.wh_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOView.getWhereStatement(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                charSequence = object.getString("txt_text");
                if ("".equalsIgnoreCase((String)charSequence2)) {
                    charSequence2 = charSequence;
                    continue;
                }
                charSequence2 = (String)charSequence2 + "\n" + (String)charSequence;
            }
            object.close();
        }
        if (!"".equalsIgnoreCase((String)charSequence2)) {
            if (bl) {
                if (!((String)charSequence2).trim().toUpperCase().startsWith("WHERE")) {
                    charSequence2 = "WHERE " + ((String)charSequence2).trim();
                }
            } else if (((String)charSequence2).trim().toUpperCase().startsWith("WHERE")) {
                charSequence2 = ((String)charSequence2).trim().substring("WHERE".length()).trim();
            }
        }
        return charSequence2;
    }

    private void initViewTriggers(Connection connection, TableView tableView, String string, String string2, ODExtractionHandler.Branch branch) throws Exception {
        Object object;
        if (this.tr_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("select a.ID, a.COMPLETE_FLAG,a.DATABASE_TRIGGER_FOR, ");
            ((StringBuffer)object).append(" a.ELEMENT_TYPE_NAME, a.ENABLED_FLAG, a.EXECUTE_TIME, ");
            ((StringBuffer)object).append(" a.IRID, a.IVID, a.NAME, a.NEW_ALIAS,");
            ((StringBuffer)object).append(" a.OLD_ALIAS, a.PARENT_IVID, a.PLSQL_MODULE_REFERENCE as module_id,");
            ((StringBuffer)object).append(" a.TRIGGER_LEVEL, a.TRIGGER_ON_DELETE, a.TRIGGER_ON_INSERT, ");
            ((StringBuffer)object).append(" a.TRIGGER_ON_UPDATE ");
            ((StringBuffer)object).append(" from ci_database_triggers a ");
            ((StringBuffer)object).append("where a.PARENT_IVID = ? ");
            this.tr_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.tr_statement.setString(1, string2);
            object = this.tr_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("ODOView.initTableTriggers():", exception);
        }
        if (object != null) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
            TableViewProxy tableViewProxy = (TableViewProxy)storageDesignOracle.getTableViewProxySet().getProxy(tableView.getObjectID());
            while (object.next()) {
                Object object2;
                String string3 = "NEW";
                String string4 = "OLD";
                String string5 = object.getString(1);
                String string6 = object.getString(9);
                string3 = object.getString(10);
                string4 = object.getString(11);
                String string7 = object.getString(13);
                String string8 = object.getString(14);
                String string9 = object.getString(15);
                String string10 = object.getString(16);
                String string11 = object.getString(17);
                String string12 = null;
                if (string7 != null) {
                    string12 = this.getFromTextLines(connection, "CDIWHN", string5, string2);
                }
                String string13 = null;
                if (branch == null) {
                    string13 = this.getFromTextLines(connection, "CDIPLS", string7);
                } else {
                    if (this.vstatement == null) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("select ivid from i$sdd_object_versions v ");
                        ((StringBuffer)object2).append("  where ");
                        ((StringBuffer)object2).append("  v.irid = ? ");
                        ((StringBuffer)object2).append("  and branch_id = ? ");
                        ((StringBuffer)object2).append("  and sequence_in_branch  is not null ");
                        ((StringBuffer)object2).append("  and wastebasket='N' ");
                        ((StringBuffer)object2).append("  and sequence_in_branch = ");
                        ((StringBuffer)object2).append("   ( ");
                        ((StringBuffer)object2).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                        ((StringBuffer)object2).append("     where ");
                        ((StringBuffer)object2).append("     v2.irid = ? ");
                        ((StringBuffer)object2).append("     and branch_id = ? ");
                        ((StringBuffer)object2).append("     and sequence_in_branch  is not null ");
                        ((StringBuffer)object2).append("     and wastebasket='N' ");
                        ((StringBuffer)object2).append("   ) ");
                        this.vstatement = connection.prepareStatement(((StringBuffer)object2).toString());
                    }
                    object2 = null;
                    try {
                        this.vstatement.setString(1, string7);
                        this.vstatement.setString(2, branch.getId());
                        this.vstatement.setString(3, string7);
                        this.vstatement.setString(4, branch.getId());
                        object2 = this.vstatement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.error("ODExtractionHandler.getApplicationSystems(): - get branches for app", sQLException);
                    }
                    if (object2 != null) {
                        if (object2.next()) {
                            String string14 = object2.getString(1);
                            string13 = this.getFromTextLines(connection, "CDIPLS", string7, string14);
                        }
                        object2.close();
                    }
                }
                object2 = storageDesignOracle.getTriggerSet().createTrigger();
                ((TriggerOracle)object2).setOwner(((TableViewProxyOracle)tableViewProxy).getUser());
                ((StorageObject)object2).setName(string6);
                ((TriggerOracle)object2).setView((TableViewProxyOracle)tableViewProxy);
                if (string8 != null && string8.indexOf("ROW") > -1) {
                    ((TriggerOracle)object2).setScope(TriggerOracle.SCOPE_TYPES[0]);
                }
                ((Trigger)object2).setTriggerTime("INSTEAD OF");
                if (string10.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[0]);
                }
                if (string11.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[1]);
                }
                if (string9.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[2]);
                }
                if (string3 != null && !"NEW".equalsIgnoreCase(string3)) {
                    ((TriggerOracle)object2).setRef_NEW_AS(string3);
                }
                if (string4 != null && !"OLD".equalsIgnoreCase(string4)) {
                    ((TriggerOracle)object2).setRef_OLD_AS(string4);
                }
                if (string12 != null && !"".equalsIgnoreCase(string12)) {
                    ((TriggerOracle)object2).setCondition(string12);
                }
                if (string13 != null) {
                    ((Trigger)object2).setBody(string13);
                }
                this.setNotesAndComments(connection, (StorageObject)object2, string5, string2);
            }
            object.close();
        }
    }
}

