/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOTable
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "TABLE";
    private static final Logger LOGGER = new Logger(ODOTable.class);
    PreparedStatement col_statement;
    PreparedStatement indcol_statement;
    PreparedStatement val_statement;
    PreparedStatement ind_statement;
    PreparedStatement pk_statement;
    PreparedStatement pkcol_statement;
    PreparedStatement tlc_statement;
    PreparedStatement cnd_statement;
    PreparedStatement tr_statement;
    PreparedStatement tr_col_statement;
    PreparedStatement vstatement;

    public ODOTable(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            String string3;
            Object object;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                if (statement2 == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)object).append("from CI_TABLE_DEFINITIONS a,sdd_folder_members b, i$sdd_wa_context cc ");
                    ((StringBuffer)object).append("where ");
                    ((StringBuffer)object).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)object).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)object).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)object).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)object).toString());
                }
                object = null;
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    object = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
                }
                if (object == null) continue;
                while (object.next()) {
                    string3 = object.getString(1);
                    string2 = object.getString(2);
                    string = object.getString(3);
                    oDObject2 = new ODObject(false, string3, OBJECT_TYPE, string2);
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    oDObject2.containerType = oDObject.containerType;
                    arrayList.add(oDObject2);
                }
                object.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("select  a.NAME,a.ID,a.ivid    ");
                ((StringBuffer)object).append("from CI_TABLE_DEFINITIONS a,sdd_folder_members b ");
                ((StringBuffer)object).append("where ");
                ((StringBuffer)object).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)object).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)object).append("AND EXISTS \n");
                ((StringBuffer)object).append("(SELECT 1 \n");
                ((StringBuffer)object).append("FROM CI_TABLE_DEFINITIONS F, \n");
                ((StringBuffer)object).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)object).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)object).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)object).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)object).append(")");
                ((StringBuffer)object).append(" and a.ivid = ");
                ((StringBuffer)object).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)object).append("  where ");
                ((StringBuffer)object).append("  a.id = v.irid and ");
                ((StringBuffer)object).append("  branch_id = ? ");
                ((StringBuffer)object).append("  and sequence_in_branch  is not null");
                ((StringBuffer)object).append("  and wastebasket='N' ");
                ((StringBuffer)object).append("  and sequence_in_branch = ");
                ((StringBuffer)object).append("   ( ");
                ((StringBuffer)object).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)object).append("     where ");
                ((StringBuffer)object).append("     v2.irid = a.id");
                ((StringBuffer)object).append("     and branch_id = ? ");
                ((StringBuffer)object).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)object).append("     and wastebasket='N' ");
                ((StringBuffer)object).append("   ) ");
                ((StringBuffer)object).append("  )");
                ((StringBuffer)object).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
            }
            object = null;
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
            }
            if (object == null) continue;
            while (object.next()) {
                string3 = object.getString(1);
                string2 = object.getString(2);
                string = object.getString(3);
                oDObject2 = new ODObject(false, string3, OBJECT_TYPE, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.branch = oDObject.branch;
                oDObject2.containerType = oDObject.containerType;
                arrayList.add(oDObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Tables begin");
        Statement statement = null;
        this.col_statement = null;
        this.indcol_statement = null;
        this.ind_statement = null;
        this.val_statement = null;
        this.pk_statement = null;
        this.pkcol_statement = null;
        this.tlc_statement = null;
        this.cnd_statement = null;
        this.tr_statement = null;
        this.tr_col_statement = null;
        this.vstatement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.getIrid();
            if (statement == null) {
                object = "SELECT a.NAME,a.ID,CLUSTER_REFERENCE,INDEX_ONLY_FLAG index_organized,ORACLE_OBJECT_TYPE_REFERENCE,INITIAL_NUMBER_OF_ROWS, MAXIMUM_NUMBER_OF_ROWS,COLUMN_PREFIX,a.DATAWAREHOUSE_TYPE,c.ENTITY_REFERENCE, a.REMARK from CI_TABLE_DEFINITIONS a,CI_TABLES_ENTITIES c where a.IVID = ?  and a.ID = c.table_REFERENCE(+) ";
                statement = connection.prepareStatement((String)object);
            }
            object = null;
            try {
                statement.setString(1, oDObject.ivid);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOTable.generate():", sQLException);
            }
            if (object != null) {
                if (object.next()) {
                    ModelIDObject modelIDObject;
                    String string2 = object.getString("NAME");
                    String string3 = object.getString("CLUSTER_REFERENCE");
                    String string4 = object.getString("ORACLE_OBJECT_TYPE_REFERENCE");
                    int n = object.getInt("INITIAL_NUMBER_OF_ROWS");
                    int n2 = object.getInt("MAXIMUM_NUMBER_OF_ROWS");
                    String string5 = object.getString("ENTITY_REFERENCE");
                    String string6 = object.getString("REMARK");
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setName(string2);
                    this.getExtractionHandler().addToImportedObjects(string, table);
                    table.setMinVolumes(String.valueOf(n));
                    table.setMaxVolumes(String.valueOf(n2));
                    TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
                    if (string4 != null) {
                        modelIDObject = (StructuredType)this.getExtractionHandler().getImportedObject(string4);
                        if (modelIDObject != null) {
                            table.setBasedOnStructuredType((StructuredType)modelIDObject);
                        }
                    } else {
                        this.initColumns(connection, table, string, oDObject.ivid, tableProxyOracle);
                    }
                    this.initPK_UK(connection, table, string, oDObject.ivid);
                    this.initIndexes(connection, table, string, oDObject.ivid);
                    this.initTableLevelConstraints(connection, table, string, oDObject.ivid);
                    this.initTableTriggers(connection, table, string, oDObject.ivid, oDObject.branch);
                    if (tableProxyOracle != null && string3 != null && (modelIDObject = (ClusterOracle)this.getExtractionHandler().getImportedObject(string3)) != null) {
                        tableProxyOracle.setCluster((ClusterOracle)modelIDObject);
                    }
                    this.setNotesAndComments(connection, table, string, oDObject.ivid);
                    table.setCommentInRDBMS(string6);
                    this.createDBSynonyms(connection, table.getName(), oDObject.ivid);
                    if (string5 != null && (modelIDObject = (Entity)this.getExtractionHandler().getImportedObject(string5)) != null) {
                        this.getDesign().getExtendedMap().createMapping((DesignObject)modelIDObject, table);
                        table.setGeneratorID(modelIDObject.getObjectID());
                        table.setTypeID(((ContainerWithKeyObject)modelIDObject).getTypeID());
                    }
                }
                object.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.indcol_statement != null) {
            this.indcol_statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
        if (this.ind_statement != null) {
            this.ind_statement.close();
        }
        if (this.pk_statement != null) {
            this.pk_statement.close();
        }
        if (this.pkcol_statement != null) {
            this.pkcol_statement.close();
        }
        if (this.tlc_statement != null) {
            this.tlc_statement.close();
        }
        if (this.cnd_statement != null) {
            this.cnd_statement.close();
        }
        if (this.tr_statement != null) {
            this.tr_statement.close();
        }
        if (this.tr_col_statement != null) {
            this.tr_col_statement.close();
        }
        if (this.vstatement != null) {
            this.vstatement.close();
        }
        TimeLog.log("Tables end");
    }

    private void initColumns(Connection connection, Table table, String string, String string2, TableProxyOracle tableProxyOracle) throws Exception {
        Object object;
        if (this.col_statement == null) {
            object = "SELECT c.name,c.id,NULL_INDICATOR, c.AVERAGE_LENGTH,CLUSTER_COLUMN_REFERENCE,c.DATATYPE, DECIMAL_PLACES,DEFAULT_IMPLEMENTATION_ITEM, c.DEFAULT_VALUE,DESCRIPTOR_COLUMN,c.DOMAIN_REFERENCE,EXPRESSION_TEXT,FIELD_INITIAL_VALUE, FIELD_LEVEL,FIELD_NULL_VALUE, FINAL_VOLUME,INITIAL_VOLUME, JUSTIFICATION,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE, REDEFINES, RELATION_SELECTION_REFERENCE,c.REMARK, SCOPE_TABLE_REFERENCE, c.SEQUENCE_NUMBER, SEQUENCE_REFERENCE,c.SOFT_LOV, SOURCE_ATTRIBUTE_REFERENCE,c.SOURCE_ENTITY_DERIVED_FROM, SOURCE_REL_ENTITY, SOURCE_REL_ENTITY_ATTRIBUTE,SOURCE_RELATIONSHIP_END,STORE_REF_WITH_ROWID_FLAG, c.REMARK, c.DEFAULT_DISPLAY_TYPE,c.DISPLAY_FLAG,c.DISPLAY_HEIGHT,c.DISPLAY_LENGTH,c.FORMAT_MODIFIER,c.HELP_TEXT,c.PROMPT,c.SERVER_DERIVED_FLAG from ci_columns c where c.PARENT_IVID = ?  order by  c.SEQUENCE_NUMBER";
            this.col_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.col_statement.setString(1, string2);
            object = this.col_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initColumns():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                Object object6 = object.getString("DATATYPE");
                String string5 = object.getString("NULL_INDICATOR");
                String string6 = object.getString("CLUSTER_COLUMN_REFERENCE");
                String string7 = object.getString("DECIMAL_PLACES");
                String string8 = object.getString("DEFAULT_VALUE");
                String string9 = object.getString("domain_reference");
                String string10 = object.getString("MAXIMUM_LENGTH");
                String string11 = object.getString("OBJECT_TYPE_INCLUSION");
                String string12 = object.getString("ORACLE_TYPE_REFERENCE");
                String string13 = object.getString("SOURCE_ATTRIBUTE_REFERENCE");
                String string14 = object.getString("REMARK");
                String string15 = object.getString("SEQUENCE_REFERENCE");
                String string16 = object.getString("DEFAULT_DISPLAY_TYPE");
                String string17 = object.getString("DISPLAY_FLAG");
                String string18 = object.getString("DISPLAY_HEIGHT");
                String string19 = object.getString("DISPLAY_LENGTH");
                String string20 = object.getString("FORMAT_MODIFIER");
                String string21 = object.getString("HELP_TEXT");
                String string22 = object.getString("PROMPT");
                String string23 = object.getString("SERVER_DERIVED_FLAG");
                Column column = table.createColumn();
                column.setDefaultValue(string8);
                column.setName(string3);
                this.getExtractionHandler().addToImportedObjects(string4, column);
                if (string17 != null && "N".equalsIgnoreCase(string17)) {
                    column.setDefaultDisplayedOnForms(false);
                }
                if (string22 != null) {
                    column.setDefaultLabel(string22);
                }
                if (string20 != null) {
                    column.setDefaultFormatMask(string20);
                }
                if (string21 != null) {
                    column.setDefaultHelpText(string21);
                }
                if (string15 != null && (object5 = this.getExtractionHandler().getImportedObject(string15)) != null && object5 instanceof SequenceOracle) {
                    object4 = (SequenceOracle)object5;
                    column.setAutoIncrementColumn(true);
                    try {
                        column.setAutoIncrementStartWith(((SequenceOracle)object4).getStartWith());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setAutoIncrementIncrementBy(new Integer(((SequenceOracle)object4).getIncrementBy()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    column.setAutoIncrementSequenceName(((StorageObject)object4).getName());
                    if ("Y".equals(string23)) {
                        column.setAutoIncrementGenerateTrigger(true);
                    } else {
                        column.setAutoIncrementGenerateTrigger(false);
                    }
                }
                this.setDisplaAs(column, string16);
                object5 = null;
                if (string18 != null) {
                    try {
                        object5 = new Integer(string18);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    column.setDefaultFormHeight((Integer)object5);
                }
                if (string19 != null) {
                    try {
                        object5 = new Integer(string19);
                    }
                    catch (Exception exception) {
                        object5 = null;
                    }
                    column.setDefaultFormDisplayWidth((Integer)object5);
                }
                if (tableProxyOracle != null && string6 != null && (object4 = (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID())) != null) {
                    tableProxyOracle.setClusterColumns(((RelationalObjectProxy)object4).getObjectID());
                }
                if ("NOT NULL".equalsIgnoreCase(string5)) {
                    column.setNullsAllowed(false);
                } else {
                    column.setNullsAllowed(true);
                }
                if (string9 != null) {
                    object4 = this.getExtractionHandler().getImportedObject(string9);
                    if (object4 == null) {
                        object4 = ODODomain.getDomain(this.getDesign().getDomainSet(), string9);
                    }
                    if (object4 == null) {
                        object3 = this.getDesign().getDomainSet().createDomain(string9);
                        object2 = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("unknown");
                        ((Domain)object3).setLogicalDatatype((LogicalDatatype)object2);
                        object4 = object3;
                    }
                    if (object4 != null && object4 instanceof Domain) {
                        column.setUse((short)0);
                        column.setDomain((Domain)object4);
                    }
                } else if (string12 != null) {
                    object4 = (DesignObject)this.getExtractionHandler().getImportedObject(string12);
                    if (object4 != null) {
                        if (object4 instanceof StructuredType) {
                            column.setUse((short)3);
                            column.setStructuredType((StructuredType)object4);
                        } else if (object4 instanceof CollectionType) {
                            column.setUse((short)4);
                            column.setCollectionType((CollectionType)object4);
                        }
                        if ("REF".equalsIgnoreCase(string11)) {
                            column.setReference(true);
                        }
                    }
                } else {
                    object4 = StandardDatatypeNames.getUsedDatatypeName((String)object6);
                    if ("UNKNOWN".equalsIgnoreCase((String)object4) && (object3 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object6)) != null) {
                        object4 = object3;
                        object6 = object3;
                    }
                    if ((object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object4)) == null && (object2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object4)) != null) {
                        object4 = object2;
                        object6 = object2;
                        object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), ((String)object4).toUpperCase());
                    }
                    if (object3 != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype((LogicalDatatype)object3);
                        if (((String)object6).toUpperCase().indexOf("TIMESTAMP") > -1) {
                            if (string7 != null) {
                                column.setDataTypeParameter("precision", string7);
                            }
                        } else if (((String)object6).toUpperCase().indexOf("CHAR") <= -1) {
                            if (string10 != null) {
                                column.setDataTypeParameter("precision", String.valueOf(string10));
                            }
                            if (string7 != null) {
                                column.setDataTypeParameter("scale", String.valueOf(string7));
                            }
                        } else if (string10 != null) {
                            column.setDataTypeParameter("size", String.valueOf(string10));
                        }
                    } else {
                        LOGGER.warn("ODOTable.initColumns() - Unable to find Logical DataType for: " + (String)object6);
                    }
                }
                this.setValues(connection, column, string4, string2);
                this.setNotesAndComments(connection, column, string4, string2);
                column.setCommentInRDBMS(string14);
                if (string13 == null || (object4 = (Attribute)this.getExtractionHandler().getImportedObject(string13)) == null) continue;
                this.getDesign().getExtendedMap().createMapping((DesignObject)object4, column);
                column.setGeneratorID(((ModelIDObject)object4).getObjectID());
            }
            object.close();
        }
    }

    private void setDisplaAs(Column column, String string) {
        if (string != null) {
            if ("TEXT".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Text");
            } else if ("DFLEX".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Text Area");
            } else if ("CHECK BOX".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Checkbox");
            } else if ("COMBO-BOX".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Combo Box");
            } else if ("T-LIST".equalsIgnoreCase(string) || "POP-LIST".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Select List");
            } else if ("RADIO ACROSS".equalsIgnoreCase(string) || "RADIO DOWN".equalsIgnoreCase(string)) {
                column.setDefaultDisplayAs("Radio Group");
            } else {
                column.setDefaultDisplayAs("Other");
            }
        }
    }

    private void setValues(Connection connection, Column column, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (this.val_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("low_value").append(',');
            ((StringBuffer)object).append("HIGH_VALUE").append(",meaning ");
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_attribute_values").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("COLUMN_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("radio_sequence");
            string3 = ((StringBuffer)object).toString();
            this.val_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.val_statement.setString(1, string);
            this.val_statement.setString(2, string2);
            object = this.val_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.setValues():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                column.setUseDomainConstraints(false);
                string3 = object.getString("low_value");
                String string4 = object.getString("HIGH_VALUE");
                String string5 = object.getString(3);
                if (string4 != null) {
                    object2 = new AVT(string3, string4, string5);
                    column.addAVT((AVT)object2);
                    continue;
                }
                if (column.getValueList() == null) {
                    object2 = new ConstraintEnumeration();
                    column.setValueList((ConstraintEnumeration)object2);
                } else {
                    object2 = column.getValueList();
                }
                ((ConstraintEnumeration)object2).add(string3, string5);
            }
            object.close();
        }
    }

    private void initPK_UK(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        if (this.pk_statement == null) {
            object = "SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_UNIQUE_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  union SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_PRIMARY_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  order by CONSTRAINT_TYPE";
            this.pk_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.pk_statement.setString(1, string2);
            this.pk_statement.setString(2, string);
            this.pk_statement.setString(3, string2);
            this.pk_statement.setString(4, string);
            object = this.pk_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initPK_UK():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                TableProxyOracle tableProxyOracle;
                Table table2;
                ModelIDObject modelIDObject;
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                String string5 = object.getString("CONSTRAINT_TYPE");
                String string6 = object.getString("DEFER_STATUS");
                String string7 = object.getString("ENABLED_FLAG");
                String string8 = object.getString("EXCEPTION_TABLE");
                String string9 = object.getString("mapped_uid");
                Index index = table.createIndex();
                index.setName(string3);
                String string10 = object.getString("COMPLETE_FLAG");
                if (string10 != null && "Y".equalsIgnoreCase(string10)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initPK_UKColumns(connection, index, string4, string2);
                this.getExtractionHandler().addToImportedObjects(string4, index);
                if ("PRIMARY".equalsIgnoreCase(string5)) {
                    index.makePK();
                    modelIDObject = (PKProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().getProxy(index.getObjectID());
                    if (modelIDObject != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(string6)) {
                            ((PKProxyOracle)modelIDObject).setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(string6)) {
                            ((PKProxyOracle)modelIDObject).setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(string6)) {
                            ((PKProxyOracle)modelIDObject).setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(string7)) {
                            ((PKProxyOracle)modelIDObject).setEnable("YES");
                        } else {
                            ((PKProxyOracle)modelIDObject).setEnable("NO");
                        }
                        if (string8 != null && (table2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string8)) != null) {
                            tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table2.getObjectID());
                            ((PKProxyOracle)modelIDObject).setExceptionsTable(tableProxyOracle);
                        }
                    }
                } else {
                    index.setIndexState("Unique Constraint");
                    modelIDObject = (UniqueOracle)((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().getProxy(index.getObjectID());
                    if (modelIDObject != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(string6)) {
                            ((UniqueOracle)modelIDObject).setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(string6)) {
                            ((UniqueOracle)modelIDObject).setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(string6)) {
                            ((UniqueOracle)modelIDObject).setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(string7)) {
                            ((UniqueOracle)modelIDObject).setEnable("YES");
                        } else {
                            ((UniqueOracle)modelIDObject).setEnable("NO");
                        }
                        if (string8 != null && (table2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string8)) != null) {
                            tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table2.getObjectID());
                            ((UniqueOracle)modelIDObject).setExceptionsTable(tableProxyOracle);
                        }
                    }
                }
                if (string9 != null && (modelIDObject = (CandidateKey)this.getExtractionHandler().getImportedObject(string9)) != null) {
                    this.getDesign().getExtendedMap().createMapping((DesignObject)modelIDObject, index);
                    index.setGeneratorID(modelIDObject.getObjectID());
                }
                this.setNotesAndComments(connection, index, string4, string2);
            }
            object.close();
        }
    }

    private void initPK_UKColumns(Connection connection, Index index, String string, String string2) throws Exception {
        Object object;
        if (this.pkcol_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("COLUMN_REFERENCE").append(',');
            ((StringBuffer)object).append("SEQUENCE_NUMBER").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_key_components").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("CONSTRAINT_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid ").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.pkcol_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.pkcol_statement.setString(1, string);
            this.pkcol_statement.setString(2, string2);
            object = this.pkcol_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initPK_UKColumns():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("COLUMN_REFERENCE");
                Column column = (Column)this.getExtractionHandler().getImportedObject(string3);
                if (column == null) continue;
                index.add(column);
            }
            object.close();
        }
    }

    private void initIndexes(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        if (this.ind_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("NAME").append(',');
            ((StringBuffer)object).append("CLUSTER_REFERENCE").append(',');
            ((StringBuffer)object).append("COMPUTE_STATISTICS_FLAG").append(',');
            ((StringBuffer)object).append("ID").append(',');
            ((StringBuffer)object).append("INDEX_TYPE").append(',');
            ((StringBuffer)object).append("RELATION_INDEX_TYPE").append(' ').append(',');
            ((StringBuffer)object).append("ivid").append(',');
            ((StringBuffer)object).append("COMPLETE_FLAG").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_indexes").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABLE_DEFINITION_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            this.ind_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.ind_statement.setString(1, string);
            this.ind_statement.setString(2, string2);
            object = this.ind_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initIndexes():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                String string5 = object.getString("COMPUTE_STATISTICS_FLAG");
                String string6 = object.getString("RELATION_INDEX_TYPE");
                Index index = table.createIndex();
                index.setName(string3);
                this.getExtractionHandler().addToImportedObjects(string4, index);
                String string7 = object.getString("COMPLETE_FLAG");
                if (string7 != null && "Y".equalsIgnoreCase(string7)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initIndexColumns(connection, index, string4, string2);
                if ("UNIQUE".equalsIgnoreCase(string6)) {
                    index.setIndexState("Unique Plain Index");
                }
                this.setNotesAndComments(connection, index, string4, string2);
                IndexProxyOracle indexProxyOracle = (IndexProxyOracle)this.getStorageDesign().getIndexProxySet().getProxy(index.getObjectID());
                if (indexProxyOracle == null) continue;
                if ("Y".equalsIgnoreCase(string5)) {
                    indexProxyOracle.setComputeStatistics("YES");
                } else {
                    indexProxyOracle.setComputeStatistics("NO");
                }
                if (string7 != null && "Y".equalsIgnoreCase(string7)) {
                    indexProxyOracle.setMarkedGenerate(true);
                    continue;
                }
                indexProxyOracle.setMarkedGenerate(false);
            }
            object.close();
        }
    }

    private void initIndexColumns(Connection connection, Index index, String string, String string2) throws Exception {
        String string3;
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        if (this.indcol_statement == null) {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append("SELECT").append(' ');
            ((StringBuffer)object3).append("COLUMN_REFERENCE").append(',');
            ((StringBuffer)object3).append("INDEX_ENTRY_TYPE").append(',');
            ((StringBuffer)object3).append("INDEX_FUNCTION").append(',');
            ((StringBuffer)object3).append("SEQUENCE_NUMBER").append(' ');
            ((StringBuffer)object3).append("FROM").append(' ');
            ((StringBuffer)object3).append("ci_index_entries").append(' ');
            ((StringBuffer)object3).append("WHERE").append(' ');
            ((StringBuffer)object3).append("RELATION_INDEX_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object3).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object3).append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.indcol_statement = connection.prepareStatement(((StringBuffer)object3).toString());
        }
        object3 = null;
        try {
            this.indcol_statement.setString(1, string);
            this.indcol_statement.setString(2, string2);
            object3 = this.indcol_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initIndexColumns():", sQLException);
        }
        if (object3 != null) {
            while (object3.next()) {
                object2 = object3.getString("COLUMN_REFERENCE");
                object = object3.getString("INDEX_ENTRY_TYPE");
                string3 = object3.getString("INDEX_FUNCTION");
                if ("FUNCTIONBASED".equalsIgnoreCase((String)object) && string3 != null) {
                    bl = true;
                    arrayList.add("FUNCTIONBASED@" + string3);
                    continue;
                }
                if (object2 == null) continue;
                arrayList.add(object2);
            }
            object3.close();
        }
        object2 = arrayList.iterator();
        object = null;
        while (object2.hasNext()) {
            Object object4;
            string3 = (String)object2.next();
            if (bl) {
                object4 = "";
                if (string3.startsWith("FUNCTIONBASED")) {
                    object4 = string3.substring(string3.indexOf(64) + 1);
                } else {
                    Column column = (Column)this.getExtractionHandler().getImportedObject(string3);
                    if (column != null) {
                        object4 = column.getName();
                    }
                }
                if (object == null) {
                    object = object4;
                    continue;
                }
                object = (String)object + ", " + (String)object4;
                continue;
            }
            object4 = (Column)this.getExtractionHandler().getImportedObject(string3);
            if (object4 == null) continue;
            index.add((ContainedObject)object4);
        }
        if (object != null) {
            index.setIndexExpression((String)object);
        }
    }

    private void initTableLevelConstraints(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        if (this.tlc_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("NAME").append(',');
            ((StringBuffer)object).append("ID").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_constraints").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TABLE_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("CONSTRAINT_TYPE").append('=').append("'CHECK'").append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("NAME");
            this.tlc_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.tlc_statement.setString(1, string);
            this.tlc_statement.setString(2, string2);
            object = this.tlc_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.initTableLevelConstraints():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                String string5 = this.getConstraintCondition(connection, string4, string2);
                TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(string3, string5);
                table.addCheckConstraint(tableLevelConstraint);
            }
            object.close();
        }
    }

    private String getConstraintCondition(Connection connection, String string, String string2) throws Exception {
        Object object;
        String string3 = "";
        if (this.cnd_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TXT_REF").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("txt_type").append('=').append("'CDWHCL'").append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("TXT_SEQ");
            this.cnd_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.cnd_statement.setString(1, string);
            this.cnd_statement.setString(2, string2);
            object = this.cnd_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOTable.getConstraintCondition(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string4 = object.getString("txt_text");
                if ("".equalsIgnoreCase(string3)) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + "\n" + string4;
            }
            object.close();
        }
        return string3;
    }

    private void initTableTriggers(Connection connection, Table table, String string, String string2, ODExtractionHandler.Branch branch) throws Exception {
        Object object;
        if (this.tr_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("select a.ID, a.COMPLETE_FLAG,a.DATABASE_TRIGGER_FOR, ");
            ((StringBuffer)object).append(" a.ELEMENT_TYPE_NAME, a.ENABLED_FLAG, a.EXECUTE_TIME, ");
            ((StringBuffer)object).append(" a.IRID, a.IVID, a.NAME, a.NEW_ALIAS,");
            ((StringBuffer)object).append(" a.OLD_ALIAS, a.PARENT_IVID, a.PLSQL_MODULE_REFERENCE as module_id,");
            ((StringBuffer)object).append(" a.TRIGGER_LEVEL, a.TRIGGER_ON_DELETE, a.TRIGGER_ON_INSERT, ");
            ((StringBuffer)object).append(" a.TRIGGER_ON_UPDATE ");
            ((StringBuffer)object).append(" from ci_database_triggers a ");
            ((StringBuffer)object).append("where a.PARENT_IVID = ? ");
            this.tr_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.tr_statement.setString(1, string2);
            object = this.tr_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("ODOTable.initTableTriggers():", exception);
        }
        if (object != null) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
            TableProxyOracle tableProxyOracle = (TableProxyOracle)storageDesignOracle.getTableProxySet().getProxy(table.getObjectID());
            while (object.next()) {
                Object object2;
                String string3 = "NEW";
                String string4 = "OLD";
                String string5 = object.getString(1);
                String string6 = object.getString(6);
                String string7 = object.getString(9);
                string3 = object.getString(10);
                string4 = object.getString(11);
                String string8 = object.getString(13);
                String string9 = object.getString(14);
                String string10 = object.getString(15);
                String string11 = object.getString(16);
                String string12 = object.getString(17);
                String string13 = null;
                if (string8 != null) {
                    string13 = this.getFromTextLines(connection, "CDIWHN", string5, string2);
                }
                String string14 = null;
                if (branch == null) {
                    string14 = this.getFromTextLines(connection, "CDIPLS", string8);
                } else {
                    if (this.vstatement == null) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("select ivid from i$sdd_object_versions v ");
                        ((StringBuffer)object2).append("  where ");
                        ((StringBuffer)object2).append("  v.irid = ? ");
                        ((StringBuffer)object2).append("  and branch_id = ? ");
                        ((StringBuffer)object2).append("  and sequence_in_branch  is not null ");
                        ((StringBuffer)object2).append("  and wastebasket='N' ");
                        ((StringBuffer)object2).append("  and sequence_in_branch = ");
                        ((StringBuffer)object2).append("   ( ");
                        ((StringBuffer)object2).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                        ((StringBuffer)object2).append("     where ");
                        ((StringBuffer)object2).append("     v2.irid = ? ");
                        ((StringBuffer)object2).append("     and branch_id = ? ");
                        ((StringBuffer)object2).append("     and sequence_in_branch  is not null ");
                        ((StringBuffer)object2).append("     and wastebasket='N' ");
                        ((StringBuffer)object2).append("   ) ");
                        this.vstatement = connection.prepareStatement(((StringBuffer)object2).toString());
                    }
                    object2 = null;
                    try {
                        this.vstatement.setString(1, string8);
                        this.vstatement.setString(2, branch.getId());
                        this.vstatement.setString(3, string8);
                        this.vstatement.setString(4, branch.getId());
                        object2 = this.vstatement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.error("ODExtractionHandler.getApplicationSystems(): - get branches for app", sQLException);
                    }
                    if (object2 != null) {
                        if (object2.next()) {
                            String string15 = object2.getString(1);
                            string14 = this.getFromTextLines(connection, "CDIPLS", string8, string15);
                        }
                        object2.close();
                    }
                }
                object2 = storageDesignOracle.getTriggerSet().createTrigger();
                ((TriggerOracle)object2).setOwner(tableProxyOracle.getUser());
                ((StorageObject)object2).setName(string7);
                ((TriggerOracle)object2).setTable(tableProxyOracle);
                if (string9 != null && string9.indexOf("ROW") > -1) {
                    ((TriggerOracle)object2).setScope(TriggerOracle.SCOPE_TYPES[0]);
                }
                if (string6.indexOf("BEFORE") > -1) {
                    ((Trigger)object2).setTriggerTime("BEFORE");
                } else if (string6.indexOf("AFTER") > -1) {
                    ((Trigger)object2).setTriggerTime("AFTER");
                } else {
                    ((Trigger)object2).setTriggerTime("BEFORE");
                }
                if (string11.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[0]);
                }
                if (string12.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[1]);
                }
                if (string10.equalsIgnoreCase("Y")) {
                    ((Trigger)object2).setActions(Trigger.ACTION_TYPES[2]);
                }
                if (string3 != null && !"NEW".equalsIgnoreCase(string3)) {
                    ((TriggerOracle)object2).setRef_NEW_AS(string3);
                }
                if (string4 != null && !"OLD".equalsIgnoreCase(string4)) {
                    ((TriggerOracle)object2).setRef_OLD_AS(string4);
                }
                if (string13 != null && !"".equalsIgnoreCase(string13)) {
                    ((TriggerOracle)object2).setCondition(string13);
                }
                if (string14 != null) {
                    ((Trigger)object2).setBody(string14);
                }
                this.setNotesAndComments(connection, (StorageObject)object2, string5, string2);
                this.initTrigUpdateColumns(connection, (TriggerOracle)object2, string5, string2);
            }
            object.close();
        }
    }

    private void initTrigUpdateColumns(Connection connection, TriggerOracle triggerOracle, String string, String string2) throws SQLException {
        Object object;
        if (this.tr_col_statement == null) {
            object = "select column_reference from ci_trigger_column_usages where database_trigger_reference = ? and parent_ivid = ?";
            this.tr_col_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.tr_col_statement.setString(1, string);
            this.tr_col_statement.setString(2, string2);
            object = this.tr_col_statement.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("ODOTable.initTrigUpdateColumns():", exception);
        }
        if (object != null) {
            while (object.next()) {
                Column column;
                String string3 = object.getString(1);
                if (string3 == null || (column = (Column)this.getExtractionHandler().getImportedObject(string3)) == null) continue;
                triggerOracle.setColumns(column.getObjectID());
            }
            object.close();
        }
    }
}

