/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOForeignKey
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "FOREIGN KEY";
    private static final Logger LOGGER = new Logger(ODOForeignKey.class);
    PreparedStatement fk_statement;
    private Map arcMap = new TreeMap();

    public ODOForeignKey(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.fk_statement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!"TABLE".equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.getIrid();
            if (statement == null) {
                object = "SELECT a.NAME,FOREIGN_TABLE_REFERENCE,a.DEFER_STATUS, a.ENABLED_FLAG, a.ERROR_MESSAGE, a.EXCEPTION_TABLE, FK_CASCADE_DELETE, FK_TRANSFERABLE, FOR_JOINING_TO,  a.ID,RELATIONSHIP_END_REFERENCE,UNIQUE_KEY_REFERENCE,ARC_NUMBER,ARC_MANDATORY, MANDATORY_FLAG, COMPLETE_FLAG, PRIMARY_KEY_REFERENCE from CI_FOREIGN_KEY_CONSTRAINTS a where a.TABLE_REFERENCE = ?  and a.PARENT_IVID = ? ";
                statement = connection.prepareStatement((String)object);
            }
            object = null;
            try {
                statement.setString(1, string);
                statement.setString(2, oDObject.ivid);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOForeignKey.generate():", sQLException);
            }
            if (object == null) continue;
            while (object.next()) {
                String string2 = object.getString("NAME");
                String string3 = object.getString("ID");
                String string4 = object.getString("FOREIGN_TABLE_REFERENCE");
                String string5 = object.getString("DEFER_STATUS");
                String string6 = object.getString("ENABLED_FLAG");
                String string7 = object.getString("EXCEPTION_TABLE");
                String string8 = object.getString("FK_CASCADE_DELETE");
                String string9 = object.getString("FK_TRANSFERABLE");
                String string10 = object.getString("RELATIONSHIP_END_REFERENCE");
                String string11 = object.getString("UNIQUE_KEY_REFERENCE");
                String string12 = object.getString("ARC_NUMBER");
                String string13 = object.getString("ARC_MANDATORY");
                String string14 = object.getString("MANDATORY_FLAG");
                String string15 = object.getString("COMPLETE_FLAG");
                String string16 = object.getString("PRIMARY_KEY_REFERENCE");
                Table table = (Table)this.getExtractionHandler().getImportedObject(string);
                Table table2 = (Table)this.getExtractionHandler().getImportedObject(string4);
                if (table == null || table2 == null) continue;
                KeyObject keyObject = null;
                if (string11 != null) {
                    keyObject = (KeyObject)this.getExtractionHandler().getImportedObject(string11);
                } else if (string16 != null) {
                    keyObject = (KeyObject)this.getExtractionHandler().getImportedObject(string16);
                }
                if (keyObject == null) {
                    keyObject = table2.getPK();
                }
                if (keyObject != null) {
                    Relation relation;
                    Object object2;
                    FKIndexAssociation fKIndexAssociation = table.addFK(keyObject);
                    this.getExtractionHandler().addToImportedObjects(string3, fKIndexAssociation);
                    if (string2 != null) {
                        fKIndexAssociation.setName(string2);
                        fKIndexAssociation.getLocalFKIndex().setName(string2);
                    }
                    this.initFKColumns(connection, fKIndexAssociation, string3, oDObject.ivid);
                    this.setNotesAndComments(connection, fKIndexAssociation, string3, oDObject.ivid);
                    if ("C".equalsIgnoreCase(string8)) {
                        fKIndexAssociation.setDeleteRule("CASCADE");
                    } else if ("N".equalsIgnoreCase(string8)) {
                        fKIndexAssociation.setDeleteRule("SET NULL");
                    } else {
                        fKIndexAssociation.setDeleteRule("RESTRICT");
                    }
                    if (string12 != null) {
                        object2 = (ArcHolder)this.arcMap.get(table.getObjectID() + string12);
                        if (object2 == null) {
                            object2 = new ArcHolder();
                            this.arcMap.put(table.getObjectID() + string12, object2);
                        }
                        boolean bl = false;
                        if (string13 != null && string13.equalsIgnoreCase("Y")) {
                            bl = true;
                        }
                        ((ArcHolder)object2).mandatory = bl || ((ArcHolder)object2).mandatory;
                        ((ArcHolder)object2).fkeys.add(fKIndexAssociation);
                    }
                    if (string9 != null && "Y".equalsIgnoreCase(string9)) {
                        fKIndexAssociation.setTransferable(true);
                    } else {
                        fKIndexAssociation.setTransferable(false);
                    }
                    if (string14 != null && "Y".equalsIgnoreCase(string14)) {
                        fKIndexAssociation.setMandatory(true);
                    } else {
                        fKIndexAssociation.setMandatory(false);
                    }
                    if (string15 != null && "Y".equalsIgnoreCase(string15)) {
                        fKIndexAssociation.setMarkedGenerate(true);
                    } else {
                        fKIndexAssociation.setMarkedGenerate(false);
                    }
                    object2 = (FKProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID());
                    if (object2 != null) {
                        Table table3;
                        ((ModelIDObject)object2).setComment(fKIndexAssociation.getComment());
                        if ("INIT DEFERRED".equalsIgnoreCase(string5)) {
                            ((FKProxyOracle)object2).setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(string5)) {
                            ((FKProxyOracle)object2).setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(string5)) {
                            ((FKProxyOracle)object2).setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(string6)) {
                            ((FKProxyOracle)object2).setEnable("YES");
                        } else {
                            ((FKProxyOracle)object2).setEnable("NO");
                        }
                        if (string7 != null && (table3 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string7)) != null) {
                            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table3.getObjectID());
                            ((FKProxyOracle)object2).setExceptionsTable(tableProxyOracle);
                        }
                    }
                    if (string10 == null || (relation = this.getExtractionHandler().getRelationByEndID(string10)) == null) continue;
                    this.getDesign().getExtendedMap().createMapping(relation, fKIndexAssociation);
                    fKIndexAssociation.setGeneratorID(relation.getObjectID());
                    continue;
                }
                LOGGER.warn("ODOForeignKey.generate() - Unable to get Index from Table: " + table2.getName());
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.fk_statement != null) {
            this.fk_statement.close();
        }
        this.createArcs();
    }

    private void initFKColumns(Connection connection, FKIndexAssociation fKIndexAssociation, String string, String string2) throws Exception {
        Object object;
        if (this.fk_statement == null) {
            object = "SELECT COLUMN_REFERENCE,FOREIGN_COLUMN_REFERENCE,a.SEQUENCE_NUMBER from ci_key_components a where CONSTRAINT_REFERENCE = ?  and parent_ivid = ? order by SEQUENCE_NUMBER";
            this.fk_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.fk_statement.setString(1, string);
            this.fk_statement.setString(2, string2);
            object = this.fk_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOForeignKey.initFKColumns():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("COLUMN_REFERENCE");
                String string4 = object.getString("FOREIGN_COLUMN_REFERENCE");
                Column column = (Column)this.getExtractionHandler().getImportedObject(string3);
                Column column2 = (Column)this.getExtractionHandler().getImportedObject(string4);
                if (column != null && column2 != null) {
                    if (column.getContainerWithKeyObject() != fKIndexAssociation.getTable()) continue;
                    column.addFKAssociation(column2, fKIndexAssociation);
                    fKIndexAssociation.getLocalFKIndex().add(column);
                    continue;
                }
                LOGGER.warn("ODOForeignKey.initFKColumns() - Unable to find Column!");
            }
            object.close();
        }
    }

    private void createArcs() {
        for (String string : this.arcMap.keySet()) {
            ArcHolder arcHolder = (ArcHolder)this.arcMap.get(string);
            List list = arcHolder.fkeys;
            if (list.size() <= 1) continue;
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)list.get(0);
            Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            list.add(0, table);
            FKArc fKArc = ((RelationalDesign)table.getDesignPart()).createArc(list.toArray());
            fKArc.setMandatory(arcHolder.mandatory);
        }
    }

    private class ArcHolder {
        boolean mandatory = false;
        List fkeys = new ArrayList();

        private ArcHolder() {
        }
    }
}

