/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOEntity
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "ENTITY";
    private static final Logger LOGGER = new Logger(ODOEntity.class);
    PreparedStatement attr_statement;
    PreparedStatement key_statement;
    PreparedStatement val_statement;
    PreparedStatement keyat_statement;
    PreparedStatement syn_statement;

    public ODOEntity(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                try {
                    if (statement2 == null) {
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                        ((StringBuffer)charSequence).append("from ci_entities a,sdd_folder_members b, i$sdd_wa_context cc ");
                        ((StringBuffer)charSequence).append("where ");
                        ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                        ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                        ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                        ((StringBuffer)charSequence).append(" order by name ");
                        statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOEntity.extract(): " + sQLException.getMessage());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOEntity.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                    oDObject2.ivid = string;
                    oDObject2.parent_ivid = oDObject.ivid;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    oDObject2.containerType = oDObject.containerType;
                    arrayList.add(oDObject2);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            try {
                if (statement == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from ci_entities a,sdd_folder_members b ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("AND EXISTS \n");
                    ((StringBuffer)charSequence).append("(SELECT 1 \n");
                    ((StringBuffer)charSequence).append("FROM ci_entities F, \n");
                    ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                    ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                    ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                    ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                    ((StringBuffer)charSequence).append(")");
                    ((StringBuffer)charSequence).append(" and a.ivid = ");
                    ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                    ((StringBuffer)charSequence).append("  where ");
                    ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                    ((StringBuffer)charSequence).append("  branch_id = ? ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                    ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                    ((StringBuffer)charSequence).append("   ( ");
                    ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    ((StringBuffer)charSequence).append("     where ");
                    ((StringBuffer)charSequence).append("     v2.irid = a.id");
                    ((StringBuffer)charSequence).append("     and branch_id = ? ");
                    ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                    ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("   ) ");
                    ((StringBuffer)charSequence).append("  )");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOEntity.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                oDObject2.ivid = string;
                oDObject2.parent_ivid = oDObject.ivid;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.containerType = oDObject.containerType;
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Object object;
        TimeLog.log("Entities begin");
        this.attr_statement = null;
        this.key_statement = null;
        this.val_statement = null;
        this.keyat_statement = null;
        this.syn_statement = null;
        ArrayList<Temp> arrayList = new ArrayList<Temp>();
        Iterator iterator = list.iterator();
        this.getExtractionHandler().getRelationsToKeys().clear();
        Statement statement = null;
        while (iterator.hasNext()) {
            String string;
            Object object2;
            ODObject object3 = (ODObject)iterator.next();
            if (!OBJECT_TYPE.equalsIgnoreCase(object3.getType())) continue;
            object = object3.getIrid();
            String string2 = object3.ivid;
            if (statement == null) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("SELECT NAME,SUPERTYPE_REFERENCE,DATAWAREHOUSE_TYPE,ANNUAL_GROWTH_RATE,INITIAL_VOLUME,VOLUME avg_volume,MAXIMUM_VOLUME,SHORT_NAME,PLURAL ");
                ((StringBuffer)object2).append("FROM ci_entities ");
                ((StringBuffer)object2).append("WHERE IVID = ?");
                string = ((StringBuffer)object2).toString();
                statement = connection.prepareStatement(string);
            }
            object2 = null;
            try {
                statement.setString(1, string2);
                object2 = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOEntity.generate():", sQLException);
            }
            if (object2 != null) {
                if (object2.next()) {
                    string = object2.getString("DATAWAREHOUSE_TYPE");
                    int n = object2.getInt("ANNUAL_GROWTH_RATE");
                    String string3 = object2.getString("INITIAL_VOLUME");
                    String string4 = object2.getString("avg_volume");
                    String string5 = object2.getString("MAXIMUM_VOLUME");
                    String string6 = object2.getString("SUPERTYPE_REFERENCE");
                    String string7 = object2.getString(8);
                    String string8 = object2.getString(9);
                    Entity entity = this.getDesign().getLogicalDesign().createEntity();
                    entity.setName(object3.getName());
                    this.getExtractionHandler().addToImportedObjects((String)object, entity);
                    if (string3 != null) {
                        entity.setMinVolumes(string3);
                    }
                    if (string4 != null) {
                        entity.setExpectedVolumes(string4);
                    }
                    if (string5 != null) {
                        entity.setMaxVolumes(string5);
                    }
                    entity.setGrowthPercent(String.valueOf(n));
                    if (entity.getDesign().getDLSettings().getClassificationTypeByID(entity.getTypeID()) != null) {
                        entity.getDesign().getDLSettings().getClassificationTypeByID(entity.getTypeID()).setTypeName(string);
                    }
                    if (string7 != null) {
                        entity.setShortName(string7);
                    }
                    if (string8 != null) {
                        entity.setPreferredAbbreviation(string8);
                    }
                    this.initAttributes(connection, entity, (String)object, string2);
                    this.initKeys(connection, entity, (String)object, string2);
                    this.setNotesAndComments(connection, entity, (String)object, string2);
                    this.createSynonyms(connection, entity, (String)object, object3.parent_ivid);
                    if (string6 != null) {
                        Temp temp = new Temp();
                        temp.entity = entity;
                        temp.superEntityID = string6;
                        arrayList.add(temp);
                    }
                }
                object2.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.key_statement != null) {
            this.key_statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
        if (this.keyat_statement != null) {
            this.keyat_statement.close();
        }
        if (this.syn_statement != null) {
            this.syn_statement.close();
        }
        for (Temp temp : arrayList) {
            object = this.getExtractionHandler().getImportedObject(temp.superEntityID);
            if (object == null || !(object instanceof Entity)) continue;
            temp.entity.setHierarchicalParent((Entity)object);
        }
        TimeLog.log("Entities end");
    }

    private void initAttributes(Connection connection, Entity entity, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (this.attr_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("NAME").append(',');
            ((StringBuffer)object).append("ID").append(',');
            ((StringBuffer)object).append("FORMAT").append(',');
            ((StringBuffer)object).append("MAXIMUM_LENGTH").append(',');
            ((StringBuffer)object).append("OPTIONAL_FLAG").append(',');
            ((StringBuffer)object).append("domain_reference").append(',');
            ((StringBuffer)object).append("PRECISION").append(',');
            ((StringBuffer)object).append("NOTES").append(',').append("DEFAULT_VALUE").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_attributes").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            string3 = ((StringBuffer)object).toString();
            this.attr_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.attr_statement.setString(1, string2);
            object = this.attr_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOEntity.initAttributes():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                Object object3;
                Object object4;
                string3 = object.getString("NAME");
                String string4 = object.getString("FORMAT");
                String string5 = object.getString("MAXIMUM_LENGTH");
                String string6 = object.getString("PRECISION");
                String string7 = object.getString("OPTIONAL_FLAG");
                String string8 = object.getString("ID");
                String string9 = object.getString("domain_reference");
                String string10 = object.getString("NOTES");
                String string11 = object.getString("DEFAULT_VALUE");
                Attribute attribute = entity.createAttribute();
                attribute.setName(string3);
                if (string11 != null && !"".equals(string11)) {
                    attribute.setDefaultValue(string11);
                }
                this.getExtractionHandler().addToImportedObjects(string8, attribute);
                if (string9 != null) {
                    object4 = this.getExtractionHandler().getImportedObject(string9);
                    if (object4 == null) {
                        object4 = ODODomain.getDomain(this.getDesign().getDomainSet(), string9);
                    }
                    if (object4 == null) {
                        object3 = this.getDesign().getDomainSet().createDomain(string9);
                        object2 = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("unknown");
                        ((Domain)object3).setLogicalDatatype((LogicalDatatype)object2);
                        object4 = object3;
                    }
                    if (object4 != null && object4 instanceof Domain) {
                        attribute.setUse((short)0);
                        attribute.setDomain((Domain)object4);
                    }
                } else {
                    object4 = StandardDatatypeNames.getUsedDatatypeName(string4);
                    if ("UNKNOWN".equalsIgnoreCase((String)object4) && (object3 = MappingDatatypeNameLogicalDataType.getDesignerMappedName(string4)) != null) {
                        object4 = object3;
                    }
                    if ((object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object4)) == null && (object2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName((String)object4)) != null) {
                        object4 = object2;
                        object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), ((String)object4).toUpperCase());
                    }
                    if (object3 != null) {
                        attribute.setUse((short)1);
                        attribute.setLogicalDatatype((LogicalDatatype)object3);
                        if (string4.toUpperCase().indexOf("CHAR") <= -1) {
                            if (string4.toUpperCase().indexOf("TIMESTAMP") > -1) {
                                if (string6 != null) {
                                    attribute.setDataTypeParameter("precision", string6);
                                }
                            } else {
                                if (string5 != null) {
                                    attribute.setDataTypeParameter("precision", string5);
                                }
                                if (string6 != null) {
                                    attribute.setDataTypeParameter("scale", string6);
                                }
                            }
                        } else if (string5 != null) {
                            attribute.setDataTypeParameter("size", string5);
                        }
                    } else {
                        LOGGER.warn("ODOEntity.initAttributes() - Unable to find Logical DataType for: " + string4);
                    }
                }
                if ("Y".equalsIgnoreCase(string7)) {
                    attribute.setNullsAllowed(true);
                } else {
                    attribute.setNullsAllowed(false);
                }
                this.setValues(connection, attribute, string8, string2);
                this.setNotesAndComments(connection, attribute, string8, string2);
                attribute.setCommentInRDBMS(string10);
            }
            object.close();
        }
    }

    private void setValues(Connection connection, Attribute attribute, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (this.val_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("low_value").append(',');
            ((StringBuffer)object).append("HIGH_VALUE").append(",meaning ");
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_attribute_values").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("ATTRIBUTE_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("radio_sequence");
            string3 = ((StringBuffer)object).toString();
            this.val_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.val_statement.setString(1, string);
            this.val_statement.setString(2, string2);
            object = this.val_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOEntity.setValues():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                Object object2;
                attribute.setUseDomainConstraints(false);
                string3 = object.getString("low_value");
                String string4 = object.getString("HIGH_VALUE");
                String string5 = object.getString(3);
                if (string4 != null) {
                    object2 = new AVT(string3, string4, string5);
                    attribute.addAVT((AVT)object2);
                    continue;
                }
                if (attribute.getValueList() == null) {
                    object2 = new ConstraintEnumeration();
                    attribute.setValueList((ConstraintEnumeration)object2);
                } else {
                    object2 = attribute.getValueList();
                }
                ((ConstraintEnumeration)object2).add(string3, string5);
            }
            object.close();
        }
    }

    private void initKeys(Connection connection, Entity entity, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (this.key_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT NAME uid_name,PRIMARY_UID_FLAG,ID  ");
            ((StringBuffer)object).append("FROM CI_UNIQUE_IDENTIFIERS ");
            ((StringBuffer)object).append("WHERE parent_ivid = ?");
            string3 = ((StringBuffer)object).toString();
            this.key_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.key_statement.setString(1, string2);
            object = this.key_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOEntity.initKeys():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                string3 = object.getString("uid_name");
                String string4 = object.getString("PRIMARY_UID_FLAG");
                String string5 = object.getString("ID");
                CandidateKey candidateKey = entity.createCandidateKey();
                candidateKey.setName(string3);
                this.initKeyAttributes(connection, candidateKey, string5, string2);
                this.getExtractionHandler().addToImportedObjects(string5, candidateKey);
                if ("Y".equalsIgnoreCase(string4)) {
                    candidateKey.makePK();
                }
                this.setNotesAndComments(connection, candidateKey, string5, string2);
            }
            object.close();
        }
    }

    private void initKeyAttributes(Connection connection, CandidateKey candidateKey, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (this.keyat_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("ATTRIBUTE_REFERENCE").append(',').append("RELATIONSHIP_END_REFERENCE").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("CI_UNIQUE_IDENTIFIER_ENTRIES").append(' ');
            ((StringBuffer)object).append("WHERE ATTRIBUTE_OR_RELATION in ('A','R') ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("UNIQUE_IDENTIFIER_REFERENCE").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid ").append('=').append(" ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("SEQUENCE_WITHIN_UID");
            string3 = ((StringBuffer)object).toString();
            this.keyat_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            this.keyat_statement.setString(1, string);
            this.keyat_statement.setString(2, string2);
            object = this.keyat_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOEntity.initKeyAttributes():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                string3 = object.getString("ATTRIBUTE_REFERENCE");
                String string4 = object.getString("RELATIONSHIP_END_REFERENCE");
                if (string4 != null) {
                    this.getExtractionHandler().getRelationsToKeys().put(string4, candidateKey);
                    continue;
                }
                Object object2 = this.getExtractionHandler().getImportedObject(string3);
                if (object2 != null && object2 instanceof Attribute) {
                    candidateKey.add((ContainedObject)object2);
                    continue;
                }
                System.out.println("Unable to find Attribute for Key: " + candidateKey.getLongName());
            }
            object.close();
        }
    }

    private void createSynonyms(Connection connection, Entity entity, String string, String string2) throws SQLException {
        Object object;
        if (this.syn_statement == null) {
            object = "select a.name from ci_synonyms a, sdd_folder_members b where a.ENTITY_REFERENCE = ?  and a.ID = b.member_object and b.parent_ivid = ?  order by name";
            this.syn_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.syn_statement.setString(1, string);
            this.syn_statement.setString(2, string2);
            object = this.syn_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOEntity.createSynonyms():", sQLException);
        }
        String string3 = null;
        boolean bl = true;
        if (object != null) {
            while (object.next()) {
                String string4 = object.getString("NAME");
                if (bl) {
                    string3 = string4;
                    bl = false;
                    continue;
                }
                string3 = string3 + ", " + string4;
            }
            object.close();
        }
        if (string3 != null) {
            entity.setSynonym(string3);
        }
    }

    class Temp {
        Entity entity;
        String superEntityID;

        Temp() {
        }
    }
}

