/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODLogicalDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODLogicalDiagram.class);
    PreparedStatement ent_statement;

    public ODLogicalDiagram(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.ent_statement = null;
        for (ODObject oDObject : this.getExtractionHandler().getSelectedAppSystems()) {
            CharSequence charSequence;
            Object object;
            ODExtractionHandler.Branch branch = oDObject.branch;
            if (branch == null) {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'ERD' order by name";
                    statement = connection.prepareStatement((String)object);
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
            } else {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'ERD' ";
                    charSequence = new StringBuffer((String)object);
                    statement = connection.prepareStatement(charSequence.toString());
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
            }
            object = null;
            try {
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODLogicalDiagram.extract(): " + sQLException.getMessage());
            }
            if (object == null) continue;
            while (object.next()) {
                charSequence = object.getString("NAME");
                String string = object.getString("ID");
                String string2 = object.getString("ivid");
                boolean bl = false;
                DesignPartView designPartView = this.getDesign().getLogicalDesign().getSubViewByName((String)charSequence);
                if (designPartView == null) {
                    designPartView = this.getDesign().getLogicalDesign().createDesignPartSubView();
                    bl = true;
                }
                designPartView.setName((String)charSequence);
                designPartView.setMustBeVisible(false);
                if (!this.addEntitiesToDiagram(connection, designPartView, string, string2) && bl) {
                    this.getDesign().getLogicalDesign().deleteSubview(designPartView);
                    continue;
                }
                this.setNotesAndComments(connection, designPartView.getPlaceHolder(), string, oDObject.ivid);
                ((DPVLogicalSubView)designPartView).rearrangeDiagram();
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.ent_statement != null) {
            this.ent_statement.close();
        }
    }

    private boolean addEntitiesToDiagram(Connection connection, DesignPartView designPartView, String string, String string2) throws Exception {
        Object object;
        boolean bl = false;
        if (this.ent_statement == null) {
            object = "SELECT CIELEMENT_REFERENCE id from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and ELEMENT_TYPE_FOR ='ENT' and d.PARENT_IVID = ? ";
            this.ent_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.ent_statement.setString(1, string);
            this.ent_statement.setString(2, string2);
            object = this.ent_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODLogicalDiagram.addEntitiesToDiagram(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("ID");
                Entity entity = (Entity)this.getExtractionHandler().getImportedObject(string3);
                if (entity == null) continue;
                bl = true;
                ContainerView containerView = (ContainerView)entity.getFirstViewForDPV(designPartView);
                if (containerView == null) {
                    containerView = entity.getTopView().createViewSynonim(designPartView);
                }
                ((TVEntity)containerView).addTVRelations();
                containerView.addTVTypeSubstitutions();
            }
            object.close();
        }
        return bl;
    }
}

