/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODConstants;
import oracle.dbtools.crest.imports.oracledesigner.ODDataTypeDiagram;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODOType;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODLogicalDiagram;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODOEntity;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODORelation;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOCluster;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOSequence;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOSnapshot;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOForeignKey;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOTable;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOView;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODRelationalDiagram;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODExtractionHandler
implements ODConstants {
    public static final String WORKAREA_OBJECT_TYPE = "WORKAREA";
    public static final String APP_SYSTEM_OBJECT_TYPE = "APP_SYSTEM";
    private static ODExtractionHandler odExtractionHandler;
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    private List mohObjectsv8i = null;
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private ApplicationView view;
    private Map importedObjects = new TreeMap();
    private List appSystems;
    private static final Logger LOGGER;
    private Map relationsToKeys = new TreeMap();

    protected ODExtractionHandler(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public static ODExtractionHandler getInstance(ApplicationView applicationView) {
        if (odExtractionHandler == null) {
            odExtractionHandler = new ODExtractionHandler(applicationView);
        }
        return odExtractionHandler;
    }

    public static void clearInstance() {
        odExtractionHandler = null;
    }

    public List getOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: {
                return this.getOHObjectsv8i();
            }
            case 9: {
                return this.getOHObjectsv9i();
            }
            case 10: {
                return this.getOHObjectsv10g();
            }
            case 11: {
                return this.getOHObjectsv10g();
            }
        }
        return this.getOHObjectsv8i();
    }

    public List getOHObjectsv8i() {
        if (this.mohObjectsv8i == null) {
            this.mohObjectsv8i = new ArrayList();
            this.mohObjectsv8i.add(new ODODomain(this, this.view));
            this.mohObjectsv8i.add(new ODOType(this, this.view));
            this.mohObjectsv8i.add(new ODOCluster(this, this.view));
            this.mohObjectsv8i.add(new ODOEntity(this, this.view));
            this.mohObjectsv8i.add(new ODORelation(this, this.view));
            this.mohObjectsv8i.add(new ODOSequence(this, this.view));
            this.mohObjectsv8i.add(new ODOTable(this, this.view));
            this.mohObjectsv8i.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv8i.add(new ODOView(this, this.view));
            this.mohObjectsv8i.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv8i.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv8i.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv8i.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv8i;
    }

    public List getOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new ODODomain(this, this.view));
            this.mohObjectsv9i.add(new ODOType(this, this.view));
            this.mohObjectsv9i.add(new ODOCluster(this, this.view));
            this.mohObjectsv9i.add(new ODOEntity(this, this.view));
            this.mohObjectsv9i.add(new ODORelation(this, this.view));
            this.mohObjectsv9i.add(new ODOSequence(this, this.view));
            this.mohObjectsv9i.add(new ODOTable(this, this.view));
            this.mohObjectsv9i.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv9i.add(new ODOView(this, this.view));
            this.mohObjectsv9i.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv9i.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv9i.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv9i.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv9i;
    }

    public List getOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new ODODomain(this, this.view));
            this.mohObjectsv10g.add(new ODOType(this, this.view));
            this.mohObjectsv10g.add(new ODOCluster(this, this.view));
            this.mohObjectsv10g.add(new ODOSequence(this, this.view));
            this.mohObjectsv10g.add(new ODOEntity(this, this.view));
            this.mohObjectsv10g.add(new ODORelation(this, this.view));
            this.mohObjectsv10g.add(new ODOTable(this, this.view));
            this.mohObjectsv10g.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv10g.add(new ODOView(this, this.view));
            this.mohObjectsv10g.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv10g.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv10g.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv10g.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv10g;
    }

    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignOraclev9i.RDBMS_TYPE);
    }

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public List getWorkAreas(Connection connection) throws Exception {
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        if (connection != null) {
            CharSequence charSequence;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("NAME").append(',');
                ((StringBuffer)charSequence).append("OWNER").append(',');
                ((StringBuffer)charSequence).append("IRID").append(',');
                ((StringBuffer)charSequence).append("DESCRIPTION").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("i$sdd_workareas");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODExtractionHandler.getWorkAreas():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString("NAME");
                    String string = resultSet.getString("IRID");
                    String string2 = resultSet.getString("DESCRIPTION");
                    ODObject oDObject = new ODObject(false, (String)charSequence, WORKAREA_OBJECT_TYPE, string, string2);
                    arrayList.add(oDObject);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    public List getApplicationSystems(Connection connection, List list) throws Exception {
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        if (list.size() > 0 && connection != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("select branch_id, name from I$SDD_BRANCHES order by name ");
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODExtractionHandler.getApplicationSystems() - branches extract:", sQLException);
            }
            Object object = null;
            Object object2 = null;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n = 0;
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    Object object3 = new Branch(string2, string);
                    hashMap.put(string, object3);
                    arrayList2.add(object3);
                    if (++n == 1) {
                        object2 = object3;
                    }
                    if (!"MAIN".equalsIgnoreCase(string2)) continue;
                    object = object3;
                }
                resultSet.close();
            }
            if (object == null && object2 != null) {
                object = object2;
            }
            statement.close();
            boolean bl = false;
            for (Object object3 : list) {
                CharSequence charSequence;
                if (!((ODObject)object3).isSelected()) continue;
                String string = ((ODObject)object3).getIrid();
                Statement statement2 = connection.createStatement();
                resultSet = null;
                try {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT distinct A.Name, \n");
                    ((StringBuffer)charSequence).append("  A.Ivid, \n");
                    ((StringBuffer)charSequence).append("  A.Irid, \n");
                    ((StringBuffer)charSequence).append("  A.Container_Subtype , \n");
                    ((StringBuffer)charSequence).append("  NULL AS Branch_Id, \n");
                    ((StringBuffer)charSequence).append("  c.Folder_Reference, \n");
                    ((StringBuffer)charSequence).append("  'N' as state \n");
                    ((StringBuffer)charSequence).append("FROM I$sdd_Folders A, \n");
                    ((StringBuffer)charSequence).append("  I$sdd_Wa_Context B , \n");
                    ((StringBuffer)charSequence).append("  I$sdd_Folder_Members c, sdd_object_versions V \n");
                    ((StringBuffer)charSequence).append("WHERE A.Container_Subtype IN ('APP','FOL') \n");
                    ((StringBuffer)charSequence).append("AND b.workarea_irid        = " + string + " \n");
                    ((StringBuffer)charSequence).append("AND B.Wastebasket          = 'N' \n");
                    ((StringBuffer)charSequence).append("And A.Irid                 = V.Irid \n");
                    ((StringBuffer)charSequence).append("AND V.state                = 'N' \n");
                    ((StringBuffer)charSequence).append("AND A.Ivid                 = B.Object_Ivid \n");
                    ((StringBuffer)charSequence).append("AND A.Irid                 = C.Member_Object(+) \n");
                    ((StringBuffer)charSequence).append("union all ");
                    ((StringBuffer)charSequence).append("SELECT distinct Ss.Name, \n");
                    ((StringBuffer)charSequence).append("  Ss.Ivid, \n");
                    ((StringBuffer)charSequence).append("  Ss.Irid, \n");
                    ((StringBuffer)charSequence).append("  Ss.Container_Subtype, \n");
                    ((StringBuffer)charSequence).append("  Ss.Branch_Id, \n");
                    ((StringBuffer)charSequence).append("  B.Folder_Reference, \n");
                    ((StringBuffer)charSequence).append("  'I' as state \n");
                    ((StringBuffer)charSequence).append("FROM \n");
                    ((StringBuffer)charSequence).append("  ( SELECT DISTINCT A.Name, \n");
                    ((StringBuffer)charSequence).append("    A.Irid, \n");
                    ((StringBuffer)charSequence).append("    A.Ivid, \n");
                    ((StringBuffer)charSequence).append("    V0.Branch_Id, \n");
                    ((StringBuffer)charSequence).append("    Container_Subtype \n");
                    ((StringBuffer)charSequence).append("  FROM I$sdd_Folders A, \n");
                    ((StringBuffer)charSequence).append("    I$sdd_Object_Versions V0 \n");
                    ((StringBuffer)charSequence).append("  WHERE A.Container_Subtype IN ('APP','FOL') \n");
                    ((StringBuffer)charSequence).append("  AND A.Irid                 = V0.Irid \n");
                    ((StringBuffer)charSequence).append("  AND Branch_Id             IS NOT NULL \n");
                    ((StringBuffer)charSequence).append("  AND A.Ivid                 = \n");
                    ((StringBuffer)charSequence).append("    (SELECT Ivid \n");
                    ((StringBuffer)charSequence).append("    FROM I$sdd_Object_Versions V \n");
                    ((StringBuffer)charSequence).append("    WHERE A.Irid            = V.Irid \n");
                    ((StringBuffer)charSequence).append("    AND V.Branch_Id         = V0.Branch_Id \n");
                    ((StringBuffer)charSequence).append("    AND Sequence_In_Branch IS NOT NULL \n");
                    ((StringBuffer)charSequence).append("    AND Wastebasket         ='N' \n");
                    ((StringBuffer)charSequence).append("    AND Sequence_In_Branch  = \n");
                    ((StringBuffer)charSequence).append("      (SELECT MAX(Sequence_In_Branch) \n");
                    ((StringBuffer)charSequence).append("      FROM I$sdd_Object_Versions V2 \n");
                    ((StringBuffer)charSequence).append("      WHERE A.Irid            = V2.Irid \n");
                    ((StringBuffer)charSequence).append("      AND V2.Branch_Id        = V0.Branch_Id \n");
                    ((StringBuffer)charSequence).append("      AND Sequence_In_Branch IS NOT NULL \n");
                    ((StringBuffer)charSequence).append("      AND Wastebasket         ='N' \n");
                    ((StringBuffer)charSequence).append("      ) \n");
                    ((StringBuffer)charSequence).append("    ) \n");
                    ((StringBuffer)charSequence).append("  )Ss, \n");
                    ((StringBuffer)charSequence).append("  I$sdd_Folder_Members B \n");
                    ((StringBuffer)charSequence).append("WHERE EXISTS \n");
                    ((StringBuffer)charSequence).append("  (SELECT 1 \n");
                    ((StringBuffer)charSequence).append("  FROM I$sdd_Folders F, \n");
                    ((StringBuffer)charSequence).append("    I$sdd_Wa_Context C \n");
                    ((StringBuffer)charSequence).append("  WHERE Ss.Irid       = F.Irid \n");
                    ((StringBuffer)charSequence).append("  AND F.Ivid          = C.Object_Ivid \n");
                    ((StringBuffer)charSequence).append("  AND C.Workarea_Irid = " + string + " \n");
                    ((StringBuffer)charSequence).append("  ) \n");
                    ((StringBuffer)charSequence).append("AND ss.Irid = B.MEMBER_OBJECT(+) \n");
                    ((StringBuffer)charSequence).append("ORDER BY Name");
                    resultSet = statement2.executeQuery(((StringBuffer)charSequence).toString());
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODExtractionHandler.getApplicationSystems():", sQLException);
                }
                if (resultSet != null) {
                    while (resultSet.next()) {
                        int n2;
                        charSequence = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        String string4 = resultSet.getString(3);
                        String string5 = resultSet.getString(4);
                        String string6 = resultSet.getString(5);
                        String string7 = resultSet.getString(6);
                        String string8 = resultSet.getString(7);
                        bl = !"N".equals(string8);
                        ODObject oDObject = new ODObject(false, (String)charSequence, APP_SYSTEM_OBJECT_TYPE, string4);
                        oDObject.setParentName(((ODObject)object3).getName());
                        oDObject.ivid = string3;
                        oDObject.wa_irid = string;
                        oDObject.containerType = string5;
                        oDObject.parentAPP = string7;
                        oDObject.branchID = string6;
                        if (string6 != null) {
                            Branch branch = (Branch)hashMap.get(string6);
                            oDObject.branch = branch;
                            oDObject.sourceBranch = branch;
                            oDObject.branchID = string6;
                        }
                        arrayList.add(oDObject);
                        if (!bl) continue;
                        for (Branch branch : arrayList2) {
                            Branch branch2 = new Branch(branch.getName(), branch.getId());
                            branch2.ivid = string3;
                            oDObject.branches.add(branch2);
                        }
                        if (oDObject.branch != null || (n2 = oDObject.branches.indexOf(object)) <= -1) continue;
                        oDObject.branch = (Branch)oDObject.branches.get(n2);
                    }
                    resultSet.close();
                }
                statement2.close();
            }
        }
        return arrayList;
    }

    public List getODObjects(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        List list2 = this.getOHObjects();
        this.appSystems = list;
        if (list2.size() > 0 && connection != null) {
            for (AbstractObjectHandler abstractObjectHandler : list2) {
                List list3 = abstractObjectHandler.extract(connection, list);
                arrayList.addAll(list3);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDesign(Connection connection, List list, ImportLogger importLogger, ProgressDialog progressDialog) throws Exception {
        this.clearImportedObjects();
        List list2 = this.getOHObjects();
        boolean bl = false;
        AbstractObjectHandler.clearStatements();
        if (list.size() > 0 && list2.size() > 0 && connection != null) {
            TimeLog.log("Begin");
            try {
                int n = 0;
                double d = 10.0;
                int n2 = list2.size();
                for (AbstractObjectHandler abstractObjectHandler : list2) {
                    try {
                        abstractObjectHandler.generate(connection, list, importLogger);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error during import from Designer Repository \n", exception);
                        bl = true;
                    }
                    ++n;
                    progressDialog.setProgress((int)(d += 75.0 / (double)n2));
                }
            }
            catch (Exception exception) {
                LOGGER.error("TCP/IP connection is closed! \n", exception);
                bl = true;
            }
            finally {
                AbstractObjectHandler.closeStatements();
                connection.close();
                TimeLog.log("End");
                if (bl) {
                    MessageDialogs.showErrorMessage(Messages.getString("ODExtractionHandler.ErrorsInImport"));
                }
            }
            this.synchronizeTableAbbreviations();
        }
    }

    public void addToImportedObjects(String string, ModelIDObject modelIDObject) {
        this.importedObjects.put(string, modelIDObject);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String string) {
        return this.importedObjects.get(string);
    }

    public Relation getRelationByEndID(String string) {
        Object[] objectArray = this.importedObjects.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            int n = string2.indexOf(64);
            if (n > -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (!string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                return (Relation)this.importedObjects.get(objectArray[i]);
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            System.out.println("ODExtractionHandler.getRelationByEndID: NEW ID TEST");
            return (Relation)this.importedObjects.get(objectArray[i]);
        }
        return null;
    }

    public String getImportedObjectID(DesignObject designObject) {
        Object[] objectArray = this.importedObjects.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object v = this.importedObjects.get(objectArray[i]);
            if (v != designObject) continue;
            return (String)objectArray[i];
        }
        return null;
    }

    public List getSelectedAppSystems() {
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        if (this.appSystems != null) {
            for (ODObject oDObject : this.appSystems) {
                if (!oDObject.isSelected()) continue;
                arrayList.add(oDObject);
            }
        }
        return arrayList;
    }

    public List getBranches(Connection connection) throws Exception {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("select branch_id, name from I$SDD_BRANCHES order by name ");
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODExtractionHandler.getApplicationSystems():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Branch branch = new Branch(string2, string);
                arrayList.add(branch);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    public Map getRelationsToKeys() {
        return this.relationsToKeys;
    }

    private void synchronizeTableAbbreviations() {
        Iterator iterator = this.view.getCurrentDesign().getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            String string = entity.getShortName();
            if (string == null) continue;
            for (Table table : entity.getAllMappedtables()) {
                table.setAbbreviation(string);
            }
        }
    }

    static {
        LOGGER = new Logger(ODExtractionHandler.class);
    }

    public class Branch {
        private String name;
        private String id;
        public String ivid;

        public Branch(String string, String string2) {
            this.name = string;
            this.id = string2;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof Branch) {
                return this.id.equals(((Branch)object).getId());
            }
            return false;
        }
    }
}

