/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ODExtractionController {
    private ProgressDialog monitor;
    private String oldDesignPath;
    private String designName;
    private boolean inExistingDesign;
    private static final Logger LOGGER = new Logger(ODExtractionController.class);
    private ApplicationView view;
    private Design design;
    ImportLogger importLog;

    public ODExtractionController(ApplicationView applicationView) {
        this.view = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public ODExtractionHandler getExtractionHandler() {
        return ODExtractionHandler.getInstance(this.view);
    }

    public List getWorkAreas(Connection connection) throws Exception {
        return this.getExtractionHandler().getWorkAreas(connection);
    }

    public List getApplicationSystems(Connection connection, List list) throws Exception {
        return this.getExtractionHandler().getApplicationSystems(connection, list);
    }

    public List getODObjects(Connection connection, List list) throws Exception {
        return this.getExtractionHandler().getODObjects(connection, list);
    }

    public String getDBProductVersion() {
        return this.getExtractionHandler().getDBProductVersion();
    }

    public String getDBProductName() {
        return this.getExtractionHandler().getDBProductName();
    }

    public void generateDesign(Connection connection, Properties properties, List list, boolean bl) throws Exception {
        LongNameObject longNameObject;
        this.inExistingDesign = bl;
        this.oldDesignPath = this.view.getCurrentDesign().getDesignPath();
        String string = ConnectionInfo.getConnectionName(properties);
        this.designName = !bl ? string : this.view.getDesignName();
        this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.view.designExists(this.designName)) {
            this.view.deleteDesign(this.designName);
        }
        if (this.view != null && !bl) {
            this.view.setDesignName(this.designName);
        }
        if (!bl) {
            this.design.setFileName(this.designName);
        }
        if (bl) {
            longNameObject = this.design.addRelationalDesign(string);
            this.design.setRelationalDesign((RelationalDesign)longNameObject);
        }
        if ((longNameObject = this.getExtractionHandler().getRDBMSSite()) != null) {
            this.design.setSelectedRDBMSSite((RDBMSSite)longNameObject);
        }
        new Thread(new Runner(connection, list)).start();
    }

    public void showRelationalSubViews() {
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.isLoaded()) continue;
            relationalDesign.setMainViewVisible(true);
            Iterator iterator2 = relationalDesign.getDesignSubviews().iterator();
            while (iterator2.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                designPartViewPlaceHolder.setVisible(true);
            }
        }
    }

    public List getBranches(Connection connection) {
        try {
            return this.getExtractionHandler().getBranches(connection);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList();
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void createAppSystemsSubViews(List list) {
        if (this.getExtractionHandler().getSelectedAppSystems().size() > 1) {
            try {
                String string = "APPSYS_";
                String string2 = "FOLDER_";
                for (ODObject oDObject : list) {
                    ContainerView containerView;
                    ContainerObject containerObject;
                    DesignPartView designPartView;
                    String string3;
                    String string4;
                    if ("ENTITY".equalsIgnoreCase(oDObject.getType())) {
                        string4 = oDObject.containerType.equalsIgnoreCase("APP") ? string : string2;
                        string3 = oDObject.getParentName();
                        designPartView = this.design.getLogicalDesign().getSubViewByName(string4 + string3);
                        if (designPartView == null) {
                            designPartView = this.design.getLogicalDesign().createDesignPartSubView();
                            designPartView.setName(string4 + string3);
                            designPartView.setMustBeVisible(false);
                        }
                        if ((containerObject = (Entity)this.getExtractionHandler().getImportedObject(oDObject.getIrid())) == null) continue;
                        containerView = containerObject.getTopView().createViewSynonim(designPartView);
                        ((TVEntity)containerView).addTVRelations();
                        containerView.addTVTypeSubstitutions();
                        continue;
                    }
                    if (!"TABLE".equalsIgnoreCase(oDObject.getType()) && !"VIEW".equalsIgnoreCase(oDObject.getType())) continue;
                    string4 = oDObject.containerType.equalsIgnoreCase("APP") ? string : string2;
                    string3 = oDObject.getParentName();
                    designPartView = this.design.getRelationalDesign().getSubViewByName(string4 + string3);
                    if (designPartView == null) {
                        designPartView = this.design.getRelationalDesign().createDesignPartSubView();
                        designPartView.setName(string4 + string3);
                        designPartView.setMustBeVisible(false);
                    }
                    if ("TABLE".equalsIgnoreCase(oDObject.getType())) {
                        containerObject = (Table)this.getExtractionHandler().getImportedObject(oDObject.getIrid());
                        if (containerObject == null) continue;
                        containerView = containerObject.getTopView().createViewSynonim(designPartView);
                        ((TVTable)containerView).addTVFKRelations();
                        containerView.addTVTypeSubstitutions();
                        continue;
                    }
                    containerObject = (TableView)this.getExtractionHandler().getImportedObject(oDObject.getIrid());
                    if (containerObject == null) continue;
                    containerView = containerObject.getTopView().createViewSynonim(designPartView);
                    containerView.addTVTypeSubstitutions();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error creating AppSystems SubViews:", exception);
            }
        }
    }

    private void rearrangeSubViews() {
        ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
        Object object;
        Iterator iterator = this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            object = (DesignPartViewPlaceHolder)iterator.next();
            iD_ObjectPropertyTranslator = ((DesignPartViewPlaceHolder)object).getDesignPartView();
            ((DPVLogical)iD_ObjectPropertyTranslator).rearrangeEntities();
        }
        object = this.design.getRelationalDesigns().iterator();
        while (object.hasNext()) {
            iD_ObjectPropertyTranslator = (RelationalDesign)object.next();
            Iterator iterator2 = ((DesignPart)iD_ObjectPropertyTranslator).getDesignSubviews().iterator();
            while (iterator2.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                ((DPVRelational)designPartView).rearrangeNewDiagram();
            }
        }
    }

    private class Runner
    implements Runnable {
        private Connection connection;
        private List selectedObjects;
        private int selectedObjectsCount;

        public Runner(Connection connection, List list) {
            this.connection = connection;
            this.selectedObjects = list;
            this.selectedObjectsCount = list.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ODExtractionController.this.design.closeAllDiagrams();
                ODExtractionController.this.importLog = new ImportLogger();
                try {
                    ODExtractionController.this.monitor = new ProgressDialog(ODExtractionController.this.view, "", 0, 100);
                    try {
                        ODExtractionController.this.view.setImporting(true);
                        ODExtractionController.this.design.setPropagatePKChahges(false);
                        ApplicationView.canLogging = false;
                        try {
                            ODExtractionController.this.monitor.setProgress(5);
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.GenerateDesign"));
                            ODExtractionController.this.monitor.setProgress(10);
                            ODExtractionController.this.getExtractionHandler().generateDesign(this.connection, this.selectedObjects, ODExtractionController.this.importLog, ODExtractionController.this.monitor);
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeTypes"));
                            ODExtractionController.this.monitor.setProgress(80);
                            try {
                                ODExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Types", exception);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeEntities"));
                            ODExtractionController.this.monitor.setProgress(85);
                            try {
                                ODExtractionController.this.design.getLogicalDesign().rearrangeEntities();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Entities", exception);
                            }
                            try {
                                ODExtractionController.this.design.getLogicalDesign().rearrangeViews();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Views", exception);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeTables"));
                            ODExtractionController.this.monitor.setProgress(90);
                            try {
                                ((DPVRelational)ODExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Tables", exception);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeViews"));
                            ODExtractionController.this.monitor.setProgress(93);
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.CreateAppSystemsSubViews"));
                            ODExtractionController.this.monitor.setProgress(97);
                            ODExtractionController.this.createAppSystemsSubViews(this.selectedObjects);
                            ODExtractionController.this.rearrangeSubViews();
                            ODExtractionController.this.design.getRelationalDesign().showFKArcs();
                            ODExtractionController.this.design.setDirty(true);
                            ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                            ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setDirty(true);
                            ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                            ODExtractionController.this.monitor.setProgress(100);
                            if (ODExtractionController.this.inExistingDesign) {
                                ODExtractionController.this.view.getCurrentDesign().setDesignPath(ODExtractionController.this.oldDesignPath);
                            } else {
                                ODExtractionController.this.view.getCurrentDesign().setDesignPath("");
                            }
                            ODExtractionController.this.view.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            if (ODExtractionController.this.design != null) {
                                ODExtractionController.this.design.setPropagatePKChahges(true);
                            }
                            ApplicationView.canLogging = true;
                            ODExtractionController.this.view.setImporting(false);
                        }
                        if (ODExtractionController.this.design != null) {
                            Iterator iterator = ODExtractionController.this.design.getLogicalDesign().getArcSet().iterator();
                            while (iterator.hasNext()) {
                                Arc arc = (Arc)iterator.next();
                                Entity entity = arc.getEntity();
                                Iterator iterator2 = ODExtractionController.this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
                                while (iterator2.hasNext()) {
                                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                                    DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                                    TVEntity tVEntity = (TVEntity)entity.getFirstViewForDPV(designPartView);
                                    if (tVEntity == null) continue;
                                    tVEntity.addArcs();
                                }
                            }
                        }
                    }
                    finally {
                        ODExtractionController.this.view.getCurrentDesign().setDesignPath(ODExtractionController.this.oldDesignPath);
                        ODExtractionController.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object object;
                            ODExtractionController.this.design.getRelationalDesign().sortCollections();
                            ODExtractionController.this.design.getLogicalDesign().sortCollections();
                            ODExtractionController.this.design.getDataTypesDesign().sortCollections();
                            if (ODExtractionController.this.design.getLogicalDesign().getEntitySet().size() > 0) {
                                // empty if block
                            }
                            Iterator iterator = ODExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (iterator.hasNext()) {
                                object = (DesignPartViewPlaceHolder)iterator.next();
                                if (!((DesignPartViewPlaceHolder)object).getDesignPartView().mustBeVisible()) continue;
                                ((DesignPartViewPlaceHolder)object).setVisible(true);
                                ((DesignPartViewPlaceHolder)object).getDesignPartView().straightenLines();
                            }
                            if (ODExtractionController.this.design.getRelationalDesign().getTableSet().size() > 0) {
                                // empty if block
                            }
                            if (ODExtractionController.this.view.getSettings().showImportLog()) {
                                object = new LogReport(ODExtractionController.this.view);
                                ((LogReport)object).setLog(ODExtractionController.this.importLog.generateDDLReport(ODExtractionController.this.view, Runner.this.selectedObjectsCount));
                                ((LogReport)object).showDialog(new Dimension(750, 550));
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                ODExtractionController.this.design.destroyAll(false);
                ODExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + ODExtractionController.this.view.getDesignName(), exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ODExtractionController.UnableToGenerateDesign"), Messages.getString("ODExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }
}

