/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODDataTypeDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODDataTypeDiagram.class);
    PreparedStatement st_statement;

    public ODDataTypeDiagram(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.st_statement = null;
        for (ODObject oDObject : this.getExtractionHandler().getSelectedAppSystems()) {
            CharSequence charSequence;
            Object object;
            ODExtractionHandler.Branch branch = oDObject.branch;
            if (branch == null) {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b, i$sdd_object_versions v where d.ID = b.member_object and b.folder_reference = ?  and DIAGRAM_TYPE = 'DSD' and b.parent_ivid = ?  and d.ivid = v.ivid and v.wastebasket = 'N' and v.state in ('I','N') and not exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) and exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('OOT') and rownum<2 ) order by name";
                    statement = connection.prepareStatement((String)object);
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
            } else {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ?  and DIAGRAM_TYPE = 'DSD' and not exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) and exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('OOT') and rownum<2 ) ";
                    charSequence = new StringBuffer((String)object);
                    ((StringBuffer)charSequence).append("  and d.ivid = ");
                    ((StringBuffer)charSequence).append("(select ivid from i$sdd_object_versions v ");
                    ((StringBuffer)charSequence).append("  where ");
                    ((StringBuffer)charSequence).append("  v.irid = d.irid");
                    ((StringBuffer)charSequence).append("  and branch_id = ? ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null ");
                    ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                    ((StringBuffer)charSequence).append("   ( ");
                    ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    ((StringBuffer)charSequence).append("     where ");
                    ((StringBuffer)charSequence).append("     v2.irid = d.irid");
                    ((StringBuffer)charSequence).append("     and branch_id = ? ");
                    ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                    ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                    ((StringBuffer)charSequence).append("   ) )");
                    statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                if (branch != null) {
                    statement.setString(3, branch.getId());
                    statement.setString(4, branch.getId());
                }
            }
            object = null;
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODDataTypeDiagram.extract(): " + sQLException.getMessage());
            }
            if (object == null) continue;
            while (object.next()) {
                charSequence = object.getString("NAME");
                String string = object.getString("ID");
                String string2 = object.getString("ivid");
                DesignPartView designPartView = this.getDesign().getDataTypesDesign().createDesignPartSubView();
                designPartView.setName((String)charSequence);
                designPartView.setMustBeVisible(false);
                if (!this.addStructuredTypesToDiagram(connection, designPartView, string, string2)) {
                    this.getDesign().getDataTypesDesign().deleteSubview(designPartView);
                    continue;
                }
                this.setNotesAndComments(connection, designPartView.getPlaceHolder(), string, oDObject.ivid);
                ((DPVDataTypesSubView)designPartView).rearrangeDiagram();
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.st_statement != null) {
            this.st_statement.close();
        }
    }

    private boolean addStructuredTypesToDiagram(Connection connection, DesignPartView designPartView, String string, String string2) throws Exception {
        Object object;
        boolean bl = false;
        if (this.st_statement == null) {
            object = "SELECT CIELEMENT_REFERENCE ID from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and d.parent_ivid = ?  and ELEMENT_TYPE_FOR = 'OOT'";
            this.st_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.st_statement.setString(1, string);
            this.st_statement.setString(2, string2);
            object = this.st_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODDataTypeDiagram.addStructuredTypesToDiagram(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("ID");
                StructuredType structuredType = (StructuredType)this.getExtractionHandler().getImportedObject(string3);
                if (structuredType == null) continue;
                bl = true;
                ContainerView containerView = structuredType.getTopView().createViewSynonim(designPartView);
                ((TVStructuredType)containerView).addTVRelations();
                ((TVStructuredType)containerView).addTVInheritances();
            }
            object.close();
        }
        return bl;
    }
}

