/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.ODConstants;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractObjectHandler
implements ODConstants {
    private static final Logger LOGGER = new Logger(AbstractObjectHandler.class);
    protected ODExtractionHandler odExtractionHandler;
    protected ApplicationView view;
    private Design design;
    static PreparedStatement do_statement;
    static PreparedStatement sto_statement;
    static PreparedStatement dbsyn_statement;
    static PreparedStatement txt_statement;
    static PreparedStatement txtnv_statement;

    public AbstractObjectHandler(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        this.odExtractionHandler = oDExtractionHandler;
        this.view = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public abstract String getType();

    public abstract void generate(Connection var1, List var2, ImportLogger var3) throws Exception;

    public List extract(Connection connection, List list) throws Exception {
        return new ArrayList();
    }

    public Design getDesign() {
        return this.design;
    }

    public StorageDesign getStorageDesign() {
        return this.getDesign().getRelationalDesign().getStorageDesign();
    }

    public ApplicationView getView() {
        return this.view;
    }

    public String getSQLDataType(short s) {
        switch (s) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case -8: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "IMAGE";
            }
            case -1: {
                return "LONG alphabetic";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public String getColumn(ResultSet resultSet, String string) {
        String string2 = null;
        if (resultSet != null) {
            try {
                string2 = resultSet.getString(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return string2;
    }

    public boolean getColumn(ResultSet resultSet, String string, boolean bl) {
        boolean bl2 = bl;
        if (resultSet != null) {
            try {
                bl2 = resultSet.getBoolean(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return bl2;
    }

    public int getColumn(ResultSet resultSet, String string, int n) {
        int n2 = n;
        if (resultSet != null) {
            try {
                n2 = resultSet.getInt(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return n2;
    }

    protected void dumpResultSet(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    System.out.println(resultSetMetaData.getColumnName(i) + " : " + resultSetMetaData.getColumnTypeName(i) + " = " + resultSet.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dumpBuffer(StringBuffer stringBuffer) {
        System.out.println(stringBuffer.toString());
    }

    public ODExtractionHandler getExtractionHandler() {
        return this.odExtractionHandler;
    }

    protected void setNotesAndComments(Connection connection, StorageObject storageObject, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("txt_type").append(',');
            ((StringBuffer)charSequence).append("txt_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("rm_text_lines").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TXT_REF").append('=').append(string).append(' ');
            ((StringBuffer)charSequence).append(" order by txt_type, txt_seq");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string2;
                charSequence = resultSet.getString("txt_type");
                String string3 = resultSet.getString("txt_text");
                if ("CDINOT".equalsIgnoreCase((String)charSequence)) {
                    string2 = storageObject.getNotes();
                    if (string2 == null || "".equalsIgnoreCase(string2)) {
                        storageObject.setNotes(string3);
                        continue;
                    }
                    storageObject.setNotes(string2 + "\n" + string3);
                    continue;
                }
                if (!"CDIDSC".equalsIgnoreCase((String)charSequence)) continue;
                string2 = storageObject.getComment();
                if (string2 == null || "".equalsIgnoreCase(string2)) {
                    storageObject.setComment(string3);
                    continue;
                }
                storageObject.setComment(string2 + "\n" + string3);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void setNotesAndComments(Connection connection, StorageObject storageObject, String string, String string2) throws Exception {
        Object object;
        if (sto_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_type").append(',');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TXT_REF").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append(" and txt_type in ('CDIDSC','CDINOT')");
            ((StringBuffer)object).append(" order by txt_type, txt_seq");
            sto_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            sto_statement.setString(1, string);
            sto_statement.setString(2, string2);
            object = sto_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3;
                String string4 = object.getString("txt_type");
                String string5 = object.getString("txt_text");
                if ("CDINOT".equalsIgnoreCase(string4)) {
                    string3 = storageObject.getNotes();
                    if (string3 == null || "".equalsIgnoreCase(string3)) {
                        storageObject.setNotes(string5);
                        continue;
                    }
                    storageObject.setNotes(string3 + "\n" + string5);
                    continue;
                }
                if (!"CDIDSC".equalsIgnoreCase(string4)) continue;
                string3 = storageObject.getComment();
                if (string3 == null || "".equalsIgnoreCase(string3)) {
                    storageObject.setComment(string5);
                    continue;
                }
                storageObject.setComment(string3 + "\n" + string5);
            }
            object.close();
        }
    }

    protected void setNotesAndComments(Connection connection, DesignObject designObject, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("txt_type").append(',');
            ((StringBuffer)charSequence).append("txt_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("rm_text_lines").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TXT_REF").append('=').append(string).append(' ');
            ((StringBuffer)charSequence).append(" order by txt_type, txt_seq");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string2;
                charSequence = resultSet.getString("txt_type");
                String string3 = resultSet.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase((String)charSequence)) {
                    string2 = designObject.getComment();
                    if (string2 == null || "".equalsIgnoreCase(string2)) {
                        designObject.setComment(string3);
                        continue;
                    }
                    designObject.setComment(string2 + "\n" + string3);
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase((String)charSequence)) continue;
                string2 = designObject.getNotes();
                if (string2 == null || "".equalsIgnoreCase(string2)) {
                    designObject.setNotes(string3);
                    continue;
                }
                designObject.setNotes(string2 + "\n" + string3);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void setNotesAndComments(Connection connection, DesignObject designObject, String string, String string2) throws Exception {
        String string3;
        Object object;
        if (do_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_type").append(',');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("TXT_REF").append('=').append(" ? ");
            ((StringBuffer)object).append(" and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)object).append(" and txt_type in ('CDIDSC','CDINOT')");
            ((StringBuffer)object).append(" order by txt_type, txt_seq");
            string3 = ((StringBuffer)object).toString();
            do_statement = connection.prepareStatement(string3);
        }
        object = null;
        try {
            do_statement.setString(1, string);
            do_statement.setString(2, string2);
            object = do_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string4;
                string3 = object.getString("txt_type");
                String string5 = object.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase(string3)) {
                    string4 = designObject.getComment();
                    if (string4 == null || "".equalsIgnoreCase(string4)) {
                        designObject.setComment(string5);
                        continue;
                    }
                    designObject.setComment(string4 + "\n" + string5);
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase(string3)) continue;
                string4 = designObject.getNotes();
                if (string4 == null || "".equalsIgnoreCase(string4)) {
                    designObject.setNotes(string5);
                    continue;
                }
                designObject.setNotes(string4 + "\n" + string5);
            }
            object.close();
        }
    }

    protected String getFromTextLines(Connection connection, String string, String string2) throws Exception {
        CharSequence charSequence;
        if (txtnv_statement == null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("txt_type").append(',');
            ((StringBuffer)charSequence).append("txt_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("rm_text_lines").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TXT_REF").append('=').append(" ? ");
            ((StringBuffer)charSequence).append(" and txt_type = ? ");
            ((StringBuffer)charSequence).append(" order by txt_type, txt_seq");
            txtnv_statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
        }
        charSequence = "";
        ResultSet resultSet = null;
        try {
            txtnv_statement.setString(1, string2);
            txtnv_statement.setString(2, string);
            resultSet = txtnv_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string3 = resultSet.getString("txt_text");
                charSequence = (String)charSequence + string3;
            }
            resultSet.close();
        }
        return charSequence;
    }

    protected String getFromTextLines(Connection connection, String string, String string2, String string3) throws Exception {
        CharSequence charSequence;
        if (txt_statement == null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("txt_type").append(',');
            ((StringBuffer)charSequence).append("txt_text").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("rm_text_lines").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TXT_REF").append('=').append(" ? ");
            ((StringBuffer)charSequence).append("and parent_ivid").append('=').append(" ? ");
            ((StringBuffer)charSequence).append(" and txt_type = ? ");
            ((StringBuffer)charSequence).append(" order by txt_type, txt_seq");
            txt_statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
        }
        charSequence = "";
        ResultSet resultSet = null;
        try {
            txt_statement.setString(1, string2);
            txt_statement.setString(2, string3);
            txt_statement.setString(3, string);
            resultSet = txt_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                String string4 = resultSet.getString("txt_text");
                charSequence = (String)charSequence + string4;
            }
            resultSet.close();
        }
        return charSequence;
    }

    public void createDBSynonyms(Connection connection, String string, String string2) throws Exception {
        Object object;
        if (dbsyn_statement == null) {
            object = "select name,id,ivid,scope from ci_database_synonyms where parent_ivid = ?";
            dbsyn_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            dbsyn_statement.setString(1, string2);
            object = dbsyn_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("AbstractObjectHandler.createSynonyms():", sQLException);
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                String string5 = object.getString(4);
                if (string3 == null || "".equals(string3)) continue;
                SynonymOracle synonymOracle = ((StorageDesignOracle)this.getStorageDesign()).getSynonymSet().createSynonym();
                synonymOracle.setName(string3);
                synonymOracle.setObject(string);
                if ("PUBLIC".equalsIgnoreCase(string5)) {
                    synonymOracle.setPublic("YES");
                }
                this.setNotesAndComments(connection, synonymOracle, string4, string2);
            }
            object.close();
        }
    }

    public static void clearStatements() {
        do_statement = null;
        sto_statement = null;
        dbsyn_statement = null;
        txt_statement = null;
        txtnv_statement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStatements() {
        if (do_statement != null) {
            try {
                do_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                do_statement = null;
            }
        }
        if (sto_statement != null) {
            try {
                sto_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                sto_statement = null;
            }
        }
        if (dbsyn_statement != null) {
            try {
                dbsyn_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                dbsyn_statement = null;
            }
        }
        if (txt_statement != null) {
            try {
                txt_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                txt_statement = null;
            }
        }
        if (txtnv_statement != null) {
            try {
                txtnv_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                txtnv_statement = null;
            }
        }
    }
}

