/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.UserGroupUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceUDBv81
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceUDBv81.class);

    public MOHTablespaceUDBv81(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT  tbspace,tbspacetype managed_by,datatype, ");
                ((StringBuffer)object).append("extentsize,prefetchsize,ts.pagesize,  ");
                ((StringBuffer)object).append("ts.dbpgname,transferrate, ");
                ((StringBuffer)object).append("drop_recovery,remarks,overhead,bpname  ");
                ((StringBuffer)object).append("from syscat.TABLESPACES ts,syscat.BUFFERPOOLS bp ");
                ((StringBuffer)object).append("WHERE tbspace = '").append(string).append("'");
                ((StringBuffer)object).append(" and ts.bufferpoolid = bp.bufferpoolid");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTablespaceUDBv81.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
                        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                        object = (TableSpaceUDBv81)storageDesignUDB.getTableSpaceSet().getByName(string);
                        if (object == null) {
                            BufferPoolUDB bufferPoolUDB;
                            String string2 = resultSet.getString(1);
                            String string3 = resultSet.getString(2);
                            String string4 = resultSet.getString(3);
                            int n = resultSet.getInt(4);
                            int n2 = resultSet.getInt(5);
                            int n3 = resultSet.getInt(6);
                            String string5 = resultSet.getString(7);
                            float f = resultSet.getFloat(8);
                            String string6 = resultSet.getString(9);
                            String string7 = resultSet.getString(10);
                            float f2 = resultSet.getFloat(11);
                            String string8 = resultSet.getString(12);
                            object = storageDesignUDB.getTableSpaceSet().createTableSpace();
                            ((StorageObject)object).setName(string2);
                            this.stampModelObject((ModelObject)object, dBObject);
                            ((TableSpaceUDB)object).setDataType(string4);
                            if ("D".equalsIgnoreCase(string3)) {
                                ((TableSpaceUDB)object).setManagedBy("DATABASE");
                            }
                            if ((bufferPoolUDB = (BufferPoolUDB)storageDesignUDB.getBufferPoolSet().getByName(string8)) != null) {
                                ((TableSpaceUDB)object).setBufferPool(bufferPoolUDB);
                            }
                            ((TableSpaceUDB)object).setDataType(this.getDataTypeTB(string4));
                            ((TableSpaceUDB)object).setExtentSize(String.valueOf(n));
                            ((TableSpaceUDB)object).setPrefetchSize(String.valueOf(n2));
                            ((TableSpaceUDB)object).setPageSize(n3);
                            ((TableSpaceUDB)object).setOverhead(f2);
                            ((TableSpaceUDB)object).setTransferRate(f);
                            DBPartitionGroupUDBv81 dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)storageDesignUDB.getNodeGroupSet().getByName(string5);
                            if (dBPartitionGroupUDBv81 == null) {
                                dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)storageDesignUDB.getNodeGroupSet().createNodeGroup();
                                dBPartitionGroupUDBv81.setName(string5);
                                this.stampModelObject((ModelObject)dBPartitionGroupUDBv81, dBObject.getSchema(), string5);
                            }
                            ((TableSpaceUDB)object).setNodeGroup(dBPartitionGroupUDBv81);
                            if ("Y".equalsIgnoreCase(string6)) {
                                ((TableSpaceUDB)object).setDroppedTableRecovery(true);
                            }
                            this.initTbprivileges(connection, (TableSpaceUDB)object);
                            ((ModelIDObject)object).setCommentInRDBMS(string7);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initTbprivileges(Connection connection, TableSpaceUDB tableSpaceUDB) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  grantee,granteetype,useauth ");
            ((StringBuffer)charSequence).append("from syscat.tbspaceauth ");
            ((StringBuffer)charSequence).append("WHERE tbspace = '").append(tableSpaceUDB.getName()).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceUDBv81.initTbprivileges():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageObject storageObject;
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)storageDesign;
                if ("U".equalsIgnoreCase(string)) {
                    storageObject = (OwnerUDBv81)storageDesignUDBv81.getOwnerSet().getByName((String)charSequence);
                    if (storageObject != null) {
                        tableSpaceUDB.setUsers(storageObject.getName());
                    }
                } else if ("G".equalsIgnoreCase(string) && (storageObject = (UserGroupUDBv81)storageDesignUDBv81.getUserGroupSet().getByName((String)charSequence)) != null) {
                    tableSpaceUDB.setGroups(storageObject.getName());
                }
                if (!"Y".equalsIgnoreCase(string2)) continue;
                tableSpaceUDB.setGrantOption("YES");
            }
            resultSet.close();
        }
        statement.close();
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            charSequence.append("SELECT tbspace from syscat.TABLESPACES");
            resultSet = statement.executeQuery(charSequence.toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceUDBv81.extract(): ", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    private String getDataTypeTB(String string) {
        if (string.equalsIgnoreCase("L")) {
            return "LARGE";
        }
        if (string.equalsIgnoreCase("T")) {
            return "SYSTEM TEMPORARY";
        }
        if (string.equalsIgnoreCase("U")) {
            return "USER TEMPORARY";
        }
        return "REGULAR";
    }
}

