/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSummerTableUDBv81
extends MOHTableUDBv81 {
    public static final String OBJECT_TYPE = "SUMMARY TABLE";
    private static final Logger LOGGER = new Logger(MOHSummerTableUDBv81.class);

    public MOHSummerTableUDBv81(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT TABNAME from SYSCAT.TABLES t").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'S' and TABSCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHSummerTableUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT TABNAME, ");
                ((StringBuffer)object).append("TABSCHEMA, TABNAME, t.DEFINER, TYPE table_type, ");
                ((StringBuffer)object).append("ROWTYPESCHEMA, ROWTYPENAME, TABLEID, KEYINDEXID PK_ID, ");
                ((StringBuffer)object).append("TBSPACE, INDEX_TBSPACE, LONG_TBSPACE, PARTITION_MODE, ");
                ((StringBuffer)object).append("DATACAPTURE, LOG_ATTRIBUTE, REMARKS, ");
                ((StringBuffer)object).append("refresh,compression,clustered,v.text  ");
                ((StringBuffer)object).append("from syscat.tables t,syscat.VIEWS v  ");
                ((StringBuffer)object).append("WHERE TYPE = 'S' and TABSCHEMA = '");
                ((StringBuffer)object).append(dBObject.getSchema()).append("'");
                ((StringBuffer)object).append(" AND TABNAME = '").append(dBObject.getName()).append("'");
                ((StringBuffer)object).append(" AND  v.viewname = t.tabname ");
                ((StringBuffer)object).append(" AND v.viewschema = t.tabschema");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHSummerTableUDB.generate(): ");
            }
            object = null;
            TableProxyUDBv81 tableProxyUDBv81 = null;
            StorageDesign storageDesign = null;
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getDesign().getRelationalDesign().createTable();
                    ((ContainerObject)object).setSchema(dBObject.getSchema());
                    ((Table)object).setName(dBObject.getName());
                    this.stampModelObject((ModelObject)object, dBObject);
                    String string = resultSet.getString("TBSPACE");
                    String string2 = resultSet.getString("TABSCHEMA");
                    String string3 = resultSet.getString("INDEX_TBSPACE");
                    String string4 = resultSet.getString("LONG_TBSPACE");
                    String string5 = resultSet.getString("TEXT");
                    String string6 = resultSet.getString("REFRESH");
                    TableSpaceUDBv81 tableSpaceUDBv81 = null;
                    TableSpaceUDBv81 tableSpaceUDBv812 = null;
                    TableSpaceUDBv81 tableSpaceUDBv813 = null;
                    SchemaUDBv81 schemaUDBv81 = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv81) {
                        tableProxyUDBv81 = (TableProxyUDBv81)((StorageDesignUDBv81)storageDesign).getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        if (tableProxyUDBv81 != null) {
                            tableProxyUDBv81.setName(dBObject.getName());
                            tableSpaceUDBv81 = this.getTableSpace(storageDesign, string);
                            if (tableSpaceUDBv81 != null) {
                                tableProxyUDBv81.setTableSpace(tableSpaceUDBv81);
                            }
                            if ((tableSpaceUDBv812 = this.getTableSpace(storageDesign, string3)) != null) {
                                tableProxyUDBv81.setIndexInTableSpace(tableSpaceUDBv812);
                            }
                            if ((tableSpaceUDBv813 = this.getTableSpace(storageDesign, string4)) != null) {
                                tableProxyUDBv81.setLongInTableSpace(tableSpaceUDBv813);
                            }
                            tableProxyUDBv81.setSummaryQuery("YES");
                            tableProxyUDBv81.setSummaryQueryDefinition(string5);
                            if ("I".equalsIgnoreCase(string6)) {
                                tableProxyUDBv81.setSummaryRefreshOptions(TableProxyUDB.getSummaryRefreshOptionsChoices()[1]);
                            }
                            if ((schemaUDBv81 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(string2.trim())) != null) {
                                tableProxyUDBv81.setSchema(schemaUDBv81);
                                tableProxyUDBv81.setOwner(schemaUDBv81.getOwner());
                            }
                            this.initTriggers(connection, tableProxyUDBv81);
                            this.setProperties(tableProxyUDBv81, (StorageDesignUDBv81)storageDesign, resultSet);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + ((ModelIDObject)object).getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(connection, tableProxyUDBv81, dBObject);
                    this.initColumnConstraints(connection, (Table)object, string2);
                    this.initTableConstraints(connection, (Table)object, string2);
                    this.initUniqueConstraints(connection, (Table)object, string2);
                    this.initIndexes(connection, (Table)object, string2);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }
}

