/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserGroupUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "USERGROUP";
    private static final Logger LOGGER = new Logger(MOHUserGroupUDB.class);

    public MOHUserGroupUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select grantee group,alterinauth, ");
                ((StringBuffer)charSequence).append("createinauth,dropinauth ");
                ((StringBuffer)charSequence).append("from syscat.schemaauth ");
                ((StringBuffer)charSequence).append("where schemaname = '");
                ((StringBuffer)charSequence).append(string2).append("'");
                ((StringBuffer)charSequence).append(" and granteetype = 'G'");
                ((StringBuffer)charSequence).append(" and grantee = '").append(string).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHUserGroupUDB.generate():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    StorageDesignUDB storageDesignUDB;
                    charSequence = resultSet.getString(1);
                    UserGroupUDB userGroupUDB = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB) || (userGroupUDB = (UserGroupUDB)(storageDesignUDB = (StorageDesignUDB)storageDesign).getUserGroupSet().getByName((String)charSequence)) != null) continue;
                    userGroupUDB = storageDesignUDB.getUserGroupSet().createUserGroup();
                    userGroupUDB.setName((String)charSequence);
                    this.stampModelObject(userGroupUDB, dBObject);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            String string = dBObject.getName();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select grantee group,alterinauth, ");
                ((StringBuffer)charSequence).append("createinauth,dropinauth ");
                ((StringBuffer)charSequence).append("from syscat.schemaauth ");
                ((StringBuffer)charSequence).append("where schemaname = '");
                ((StringBuffer)charSequence).append(string).append("'");
                ((StringBuffer)charSequence).append(" and granteetype = 'G'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHUserGroupUDB.extract():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), ((String)charSequence).trim(), OBJECT_TYPE, string);
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }
}

