/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeIncompleteUDB
extends AbstractMOHandler {
    private Map selectedTypes = new TreeMap();
    private static List types;
    public static final String OBJECT_TYPE = "TYPE";
    private static final Logger LOGGER;

    public MOHTypeIncompleteUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        DBObject dBObject;
        DBObject dBObject2;
        int n;
        this.selectedTypes = new TreeMap();
        types = new ArrayList();
        TreeMap treeMap = new TreeMap();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (n = 0; n < list.size(); ++n) {
            dBObject2 = (DBObject)list.get(n);
            if (OBJECT_TYPE.equalsIgnoreCase(dBObject2.getType())) {
                types.add(dBObject2);
                this.selectedTypes.put(dBObject2.toString(), dBObject2);
            }
            if ("TYPED TABLE".equalsIgnoreCase(dBObject2.getType())) {
                this.addAdditionalType(treeMap, dBObject2);
            }
            if (!"VIEW".equalsIgnoreCase(dBObject2.getType())) continue;
            arrayList.add(dBObject2);
        }
        this.generateAdditionalTableTypes(connection, treeMap);
        this.generateAdditionalColumnTypes(connection, treeMap);
        for (n = 0; n < arrayList.size(); ++n) {
            dBObject2 = (DBObject)arrayList.get(n);
            dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dBObject2.getTypeName(), OBJECT_TYPE, dBObject2.getTypeOwner());
            dBObject.setSuperTypeOwner(dBObject2.getSuperTypeOwner());
            dBObject.setSuperTypeName(dBObject2.getSuperTypeName());
            if (dBObject.toString() == null || this.selectedTypes.containsKey(dBObject.toString())) continue;
            types.add(dBObject);
            this.selectedTypes.put(dBObject.toString(), dBObject);
        }
        for (n = 0; n < types.size(); ++n) {
            dBObject2 = (DBObject)types.get(n);
            this.addSuperTypes(connection, dBObject2);
            this.getAdditionalAttributeTypes(connection, dBObject2);
            this.generateAdditionalParameterAndResultTypes(connection, dBObject2);
        }
        for (int i = 0; i < types.size(); ++i) {
            dBObject = (DBObject)types.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType()) || !this.createStructuredType(dBObject) || !list.contains(dBObject)) continue;
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private boolean createStructuredType(DBObject dBObject) {
        String string = dBObject.getName();
        String string2 = dBObject.getSchema();
        StructuredType structuredType = this.getDesign().getDataTypesDesign().createStructuredType();
        structuredType.setName(string);
        this.stampModelObject(structuredType, dBObject);
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)storageDesignUDB.getStructuredTypeProxySet().getProxy(structuredType.getObjectID());
        if (structuredTypeProxyUDB != null) {
            structuredTypeProxyUDB.setName(string);
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string2);
            if (schemaUDB != null) {
                structuredTypeProxyUDB.setSchema(schemaUDB);
            }
        }
        return true;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select a.typename, a.metatype,b.super_schema,b.super_name,b.root_schema,b.root_name ");
                ((StringBuffer)charSequence).append("FROM syscat.DATATYPES a left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("on a.typename = b.sub_name ");
                ((StringBuffer)charSequence).append("and a.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("WHERE a.metatype in ('T','R') and a.TYPESCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("' ");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    DBObject dBObject2;
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2);
                    if (string.equalsIgnoreCase("R")) {
                        dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName(), "Structured type");
                        String string2 = resultSet.getString(3);
                        String string3 = resultSet.getString(4);
                        dBObject2.setSuperTypeOwner(string2);
                        dBObject2.setSuperTypeName(string3);
                    } else {
                        dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "DATATYPE", dBObject.getName(), "Distinct type");
                    }
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    private void addSuperTypes(Connection connection, DBObject dBObject) throws SQLException {
        DBObject dBObject2;
        String string = dBObject.getSuperTypeOwner();
        String string2 = dBObject.getSuperTypeName();
        if (string2 != null && !string2.equals("") && !this.selectedTypes.containsKey((dBObject2 = new DBObject(false, string2, OBJECT_TYPE, string)).toString())) {
            CharSequence charSequence;
            types.add(dBObject2);
            this.selectedTypes.put(dBObject2.toString(), dBObject2);
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select a.typename, a.metatype,b.super_schema,b.super_name,b.root_schema,b.root_name ");
                ((StringBuffer)charSequence).append("FROM syscat.DATATYPES a left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("on a.typename = b.sub_name ");
                ((StringBuffer)charSequence).append("and a.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("WHERE a.metatype = 'R' and a.TYPESCHEMA = '");
                ((StringBuffer)charSequence).append(string).append("' ");
                ((StringBuffer)charSequence).append("and a.typename = '");
                ((StringBuffer)charSequence).append(string2).append("' ");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTypeIncompleteUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                if (resultSet.next() && ((String)(charSequence = resultSet.getString(2))).equalsIgnoreCase("R")) {
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    dBObject2.setSuperTypeOwner(string3);
                    dBObject2.setSuperTypeName(string4);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void addAdditionalType(Map map, DBObject dBObject) {
        if (!map.containsKey(dBObject.getSchema())) {
            map.put(dBObject.getSchema(), '\'' + dBObject.getName() + '\'');
        } else {
            String string = (String)map.get(dBObject.getSchema());
            string = string + ',' + '\'' + dBObject.getName() + '\'';
            map.put(dBObject.getSchema(), string);
        }
    }

    private void generateAdditionalTableTypes(Connection connection, Map map) throws SQLException {
        for (String string : map.keySet()) {
            CharSequence charSequence;
            String string2 = (String)map.get(string);
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select distinct a.rowtypeschema, a.rowtypename, b.super_schema, b.super_name ");
                ((StringBuffer)charSequence).append(" from syscat.tables a left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("  on a.rowtypename = b.sub_name ");
                ((StringBuffer)charSequence).append("  and a.rowtypeschema = b.sub_schema  ");
                ((StringBuffer)charSequence).append(" where tabschema = ").append('\'').append(string).append('\'').append(' ').append("AND");
                ((StringBuffer)charSequence).append(" a.tabname in ").append('(').append(string2).append(')');
                ((StringBuffer)charSequence).append(' ').append("AND");
                ((StringBuffer)charSequence).append(" rowtypename is not null");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (Exception exception) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalTableTypes():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    DBObject dBObject;
                    charSequence = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string3, OBJECT_TYPE, (String)charSequence);
                    dBObject2.setSuperTypeOwner(string4);
                    dBObject2.setSuperTypeName(string5);
                    if (!this.selectedTypes.containsKey(dBObject2.toString())) {
                        types.add(dBObject2);
                        this.selectedTypes.put(dBObject2.toString(), dBObject2);
                    }
                    if (string5 == null || string5.equals("") || this.selectedTypes.containsKey((dBObject = new DBObject(false, string5, OBJECT_TYPE, string4)).toString())) continue;
                    types.add(dBObject);
                    this.selectedTypes.put(dBObject.toString(), dBObject);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void generateAdditionalColumnTypes(Connection connection, Map map) throws SQLException {
        for (String string : map.keySet()) {
            CharSequence charSequence;
            String string2 = (String)map.get(string);
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select distinct ");
                ((StringBuffer)charSequence).append("a.typeschema, a.typename,b.super_schema,b.super_name ");
                ((StringBuffer)charSequence).append(" from syscat.columns a, syscat.DATATYPES c left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
                ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("where a.TABSCHEMA = ").append('\'').append(string).append('\'').append(' ').append("AND");
                ((StringBuffer)charSequence).append(" a.tabname in ").append('(').append(string2).append(')');
                ((StringBuffer)charSequence).append(' ').append("AND");
                ((StringBuffer)charSequence).append(" a.typename <>'REFERENCE' ");
                ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
                ((StringBuffer)charSequence).append("  and a.typename = c.typename and a.typeschema = c.typeschema ");
                ((StringBuffer)charSequence).append("union ");
                ((StringBuffer)charSequence).append("select distinct ");
                ((StringBuffer)charSequence).append("a.target_typeschema, a.target_typename,b.super_schema,b.super_name ");
                ((StringBuffer)charSequence).append(" from syscat.columns a, syscat.DATATYPES c left join syscat.hierarchies b ");
                ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
                ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
                ((StringBuffer)charSequence).append("where a.TABSCHEMA = ").append('\'').append(string).append('\'').append(' ').append("AND");
                ((StringBuffer)charSequence).append(" a.tabname in ").append('(').append(string2).append(')');
                ((StringBuffer)charSequence).append(' ').append("AND");
                ((StringBuffer)charSequence).append("  a.typename = 'REFERENCE' ");
                ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
                ((StringBuffer)charSequence).append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (Exception exception) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalColumnTypes():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(2);
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, string3);
                    dBObject.setSuperTypeOwner(string4);
                    dBObject.setSuperTypeName(string5);
                    if (this.selectedTypes.containsKey(dBObject.toString())) continue;
                    types.add(dBObject);
                    this.selectedTypes.put(dBObject.toString(), dBObject);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private void getAdditionalAttributeTypes(Connection connection, DBObject dBObject) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select distinct a.attr_typeschema as attr_typeschema, ");
            ((StringBuffer)charSequence).append("  a.attr_typename as attr_typename,b.super_schema,b.super_name ");
            ((StringBuffer)charSequence).append(" from syscat.attributes a, syscat.DATATYPES c left join syscat.hierarchies b ");
            ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
            ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
            ((StringBuffer)charSequence).append(" where a.TYPESCHEMA = ").append('\'').append(dBObject.getSchema()).append('\'').append(' ').append("AND");
            ((StringBuffer)charSequence).append(" a.TYPENAME = ").append('\'').append(dBObject.getName()).append('\'');
            ((StringBuffer)charSequence).append("  and a.attr_typename <> 'REFERENCE' ");
            ((StringBuffer)charSequence).append("  and a.attr_typename = c.typename and a.attr_typeschema = c.typeschema ");
            ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
            ((StringBuffer)charSequence).append("union ");
            ((StringBuffer)charSequence).append("select distinct a.target_typeschema as attr_typeschema, ");
            ((StringBuffer)charSequence).append("  a.target_typename as attr_typename,b.super_schema,b.super_name ");
            ((StringBuffer)charSequence).append(" from syscat.attributes a, syscat.DATATYPES c left join syscat.hierarchies b ");
            ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
            ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
            ((StringBuffer)charSequence).append(" where a.TYPESCHEMA = ").append('\'').append(dBObject.getSchema()).append('\'').append(' ').append("AND");
            ((StringBuffer)charSequence).append(" a.TYPENAME = ").append('\'').append(dBObject.getName()).append('\'');
            ((StringBuffer)charSequence).append("  and a.attr_typename = 'REFERENCE' ");
            ((StringBuffer)charSequence).append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
            ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getAttributeType():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                DBObject dBObject2;
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                DBObject dBObject3 = new DBObject(false, string, OBJECT_TYPE, (String)charSequence);
                dBObject3.setSuperTypeOwner(string2);
                dBObject3.setSuperTypeName(string3);
                if (!this.selectedTypes.containsKey(dBObject3.toString())) {
                    types.add(dBObject3);
                    this.selectedTypes.put(dBObject3.toString(), dBObject3);
                }
                if (string3 == null || string3.equals("") || this.selectedTypes.containsKey((dBObject2 = new DBObject(false, string3, OBJECT_TYPE, string2)).toString())) continue;
                types.add(dBObject2);
                this.selectedTypes.put(dBObject2.toString(), dBObject2);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void generateAdditionalParameterAndResultTypes(Connection connection, DBObject dBObject) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("with functions (funcname, funcschema,subject_typeschema, subject_typename) ");
            ((StringBuffer)charSequence).append("as ( ");
            ((StringBuffer)charSequence).append("select distinct funcname, funcschema,subject_typeschema, subject_typename ");
            ((StringBuffer)charSequence).append("from syscat.functions  ");
            ((StringBuffer)charSequence).append("where effect not in ('MU','OB','CN') and method = 'Y' ");
            ((StringBuffer)charSequence).append("and subject_typeschema =").append('\'').append(dBObject.getSchema()).append('\'').append(' ').append("AND");
            ((StringBuffer)charSequence).append(" subject_typename = ").append('\'').append(dBObject.getName()).append('\'').append(" ) ");
            ((StringBuffer)charSequence).append("select distinct a.typeschema as typeschema, a.typename as typename,b.super_schema,b.super_name ");
            ((StringBuffer)charSequence).append(" from functions f, ");
            ((StringBuffer)charSequence).append("  syscat.funcparms a, syscat.DATATYPES c left join syscat.hierarchies b ");
            ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
            ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
            ((StringBuffer)charSequence).append(" where ");
            ((StringBuffer)charSequence).append("  a.typename = c.typename and a.typeschema = c.typeschema ");
            ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
            ((StringBuffer)charSequence).append("  and a.typename <> 'REFERENCE' ");
            ((StringBuffer)charSequence).append("  and f.funcname = a.funcname and f.funcschema = a.funcschema ");
            ((StringBuffer)charSequence).append("union ");
            ((StringBuffer)charSequence).append("select distinct a.target_typeschema as typeschema, a.target_typename as typename,b.super_schema,b.super_name ");
            ((StringBuffer)charSequence).append(" from functions f,syscat.funcparms a, syscat.DATATYPES c left join syscat.hierarchies b ");
            ((StringBuffer)charSequence).append("  on  c.typename = b.sub_name ");
            ((StringBuffer)charSequence).append("  and c.typeschema = b.sub_schema ");
            ((StringBuffer)charSequence).append(" where ");
            ((StringBuffer)charSequence).append("  a.typename = 'REFERENCE' ");
            ((StringBuffer)charSequence).append("  and a.target_typename = c.typename and a.target_typeschema = c.typeschema ");
            ((StringBuffer)charSequence).append("  and c.metatype = 'R' ");
            ((StringBuffer)charSequence).append("  and f.funcname = a.funcname and f.funcschema = a.funcschema ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHTypeIncompleteOraclev9i.getParameterType():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                DBObject dBObject2;
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                DBObject dBObject3 = new DBObject(false, string, OBJECT_TYPE, (String)charSequence);
                dBObject3.setSuperTypeOwner(string2);
                dBObject3.setSuperTypeName(string3);
                if (!this.selectedTypes.containsKey(dBObject3.toString())) {
                    types.add(dBObject3);
                    this.selectedTypes.put(dBObject3.toString(), dBObject3);
                }
                if (string3 == null || string3.equals("") || this.selectedTypes.containsKey((dBObject2 = new DBObject(false, string3, OBJECT_TYPE, string2)).toString())) continue;
                types.add(dBObject2);
                this.selectedTypes.put(dBObject2.toString(), dBObject2);
            }
            resultSet.close();
        }
        statement.close();
    }

    static {
        LOGGER = new Logger(MOHTypeIncompleteUDB.class);
    }
}

