/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceUDB.class);

    public MOHTablespaceUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT  tbspace,tbspacetype managed_by,datatype, ");
                ((StringBuffer)object).append("extentsize,prefetchsize,ts.pagesize,  ");
                ((StringBuffer)object).append("ts.dbpgname,transferrate, ");
                ((StringBuffer)object).append("drop_recovery,remarks comment,overhead,bp.bpname  ");
                ((StringBuffer)object).append("from syscat.TABLESPACES ts,syscat.BUFFERPOOL bp ");
                ((StringBuffer)object).append("WHERE tbspace = '").append(string).append("'");
                ((StringBuffer)object).append(" and ts.bufferpoolid = bp.bufferpoolid");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTablespaceUDB.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv71) {
                        StorageDesignUDBv71 storageDesignUDBv71 = (StorageDesignUDBv71)storageDesign;
                        object = (TableSpaceUDBv71)storageDesignUDBv71.getTableSpaceSet().getByName(string);
                        if (object == null) {
                            BufferPoolUDBv71 bufferPoolUDBv71;
                            String string2 = resultSet.getString(1);
                            String string3 = resultSet.getString(2);
                            String string4 = resultSet.getString(3);
                            int n = resultSet.getInt(4);
                            int n2 = resultSet.getInt(5);
                            int n3 = resultSet.getInt(6);
                            String string5 = resultSet.getString(7);
                            float f = resultSet.getFloat(8);
                            String string6 = resultSet.getString(9);
                            String string7 = resultSet.getString(10);
                            float f2 = resultSet.getFloat(11);
                            String string8 = resultSet.getString(12);
                            object = (TableSpaceUDBv71)storageDesignUDBv71.getTableSpaceSet().createTableSpace();
                            ((StorageObject)object).setName(string2);
                            ((TableSpaceUDB)object).setDataType(string4);
                            this.stampModelObject((ModelObject)object, dBObject);
                            if ("D".equalsIgnoreCase(string3)) {
                                ((TableSpaceUDB)object).setManagedBy("DATABASE");
                            }
                            if ((bufferPoolUDBv71 = (BufferPoolUDBv71)storageDesignUDBv71.getBufferPoolSet().getByName(string8)) != null) {
                                ((TableSpaceUDB)object).setBufferPool(bufferPoolUDBv71);
                            }
                            ((TableSpaceUDB)object).setDataType(this.getDataTypeTB(string4));
                            ((TableSpaceUDB)object).setExtentSize(String.valueOf(n));
                            ((TableSpaceUDB)object).setPrefetchSize(String.valueOf(n2));
                            ((TableSpaceUDB)object).setPageSize(n3);
                            ((TableSpaceUDB)object).setOverhead(f2);
                            ((TableSpaceUDB)object).setTransferRate(f);
                            NodeGroupUDBv71 nodeGroupUDBv71 = (NodeGroupUDBv71)storageDesignUDBv71.getNodeGroupSet().getByName(string5);
                            if (nodeGroupUDBv71 == null) {
                                nodeGroupUDBv71 = (NodeGroupUDBv71)storageDesignUDBv71.getNodeGroupSet().createNodeGroup();
                                nodeGroupUDBv71.setName(string5);
                                this.stampModelObject((ModelObject)nodeGroupUDBv71, dBObject.getSchema(), string5);
                            }
                            ((TableSpaceUDB)object).setNodeGroup(nodeGroupUDBv71);
                            if ("Y".equalsIgnoreCase(string6)) {
                                ((TableSpaceUDB)object).setDroppedTableRecovery(true);
                            }
                            this.initTbprivileges(connection, (TableSpaceUDBv71)object);
                            ((ModelIDObject)object).setCommentInRDBMS(string7);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            charSequence.append("SELECT tbspace from syscat.TABLESPACES");
            resultSet = statement.executeQuery(charSequence.toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceUDB.extract(): ", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    private String getDataTypeTB(String string) {
        if (string.equalsIgnoreCase("T")) {
            return "SYSTEM TEMPORARY";
        }
        if (string.equalsIgnoreCase("U")) {
            return "USER TEMPORARY";
        }
        return "REGULAR";
    }

    private void initTbprivileges(Connection connection, TableSpaceUDBv71 tableSpaceUDBv71) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  grantee,granteetype,useauth ");
            ((StringBuffer)charSequence).append("from syscat.tbspaceauth ");
            ((StringBuffer)charSequence).append("WHERE tbspace = '").append(tableSpaceUDBv71.getName()).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceUDB.initTbprivileges():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageObject storageObject;
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storageDesignUDBv71 = (StorageDesignUDBv71)storageDesign;
                if ("U".equalsIgnoreCase(string)) {
                    storageObject = (OwnerUDBv81)storageDesignUDBv71.getOwnerSet().getByName((String)charSequence);
                    if (storageObject != null) {
                        tableSpaceUDBv71.setUsers(storageObject.getName());
                    }
                } else if ("G".equalsIgnoreCase(string) && (storageObject = (NodeGroupUDBv71)storageDesignUDBv71.getNodeGroupSet().getByName((String)charSequence)) != null) {
                    tableSpaceUDBv71.setGroups(storageObject.getName());
                }
                if (!"Y".equalsIgnoreCase(string2)) continue;
                tableSpaceUDBv71.setGrantOption("YES");
            }
            resultSet.close();
        }
        statement.close();
    }
}

