/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ColumnProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.IndexProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TriggerUDBv71;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableUDB
extends MOHTable {
    private static final Logger LOGGER = new Logger(MOHTableUDB.class);
    String CWD_TS_TAB_META = "<cwd_ts_tab ";
    String CWD_TS_COLUMN_META = "<cwd_ts_column ";

    public MOHTableUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!"TABLE".equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("TABSCHEMA").append(',');
                ((StringBuffer)object).append("TABNAME").append(',');
                ((StringBuffer)object).append("DEFINER").append(',');
                ((StringBuffer)object).append("TYPE").append(',');
                ((StringBuffer)object).append("ROWTYPESCHEMA").append(',');
                ((StringBuffer)object).append("ROWTYPENAME").append(',');
                ((StringBuffer)object).append("TABLEID").append(',');
                ((StringBuffer)object).append("KEYINDEXID").append(',');
                ((StringBuffer)object).append("TBSPACE").append(',');
                ((StringBuffer)object).append("INDEX_TBSPACE").append(',');
                ((StringBuffer)object).append("LONG_TBSPACE").append(',');
                ((StringBuffer)object).append("PARTITION_MODE").append(',');
                ((StringBuffer)object).append("DATACAPTURE").append(',');
                ((StringBuffer)object).append("LOG_ATTRIBUTE").append(',');
                ((StringBuffer)object).append("REMARKS").append(',');
                ((StringBuffer)object).append("REFRESH").append(',');
                ((StringBuffer)object).append("COMPRESSION").append(',');
                ((StringBuffer)object).append("CLUSTERED").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("SYSCAT").append('.').append("TABLES").append(' ').append("t ");
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("TABSCHEMA").append('=').append('\'');
                ((StringBuffer)object).append(dBObject.getSchema()).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TABNAME").append('=').append('\'');
                ((StringBuffer)object).append(dBObject.getName()).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("TYPE").append('=').append('\'');
                ((StringBuffer)object).append("T").append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("NOT").append(' ').append("EXISTS");
                ((StringBuffer)object).append('(').append("SELECT").append(' ').append("1").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("SYSCAT").append('.').append("VIEWS").append(' ').append("v ");
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("v").append('.').append("VIEWNAME").append('=');
                ((StringBuffer)object).append("t").append('.').append("TABNAME").append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("v").append('.').append("VIEWSCHEMA").append('=');
                ((StringBuffer)object).append("t").append('.').append("TABSCHEMA").append(')');
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableUDB.generate():", sQLException);
            }
            object = null;
            TableProxyUDBv71 tableProxyUDBv71 = null;
            StorageDesign storageDesign = null;
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getDesign().getRelationalDesign().createTable();
                    ((ContainerObject)object).setSchema(dBObject.getSchema());
                    ((Table)object).setName(dBObject.getName());
                    this.stampModelObject((ModelObject)object, dBObject);
                    String string = resultSet.getString("TBSPACE");
                    String string2 = resultSet.getString("TABSCHEMA");
                    String string3 = resultSet.getString("INDEX_TBSPACE");
                    String string4 = resultSet.getString("LONG_TBSPACE");
                    TableSpaceUDBv71 tableSpaceUDBv71 = null;
                    TableSpaceUDBv71 tableSpaceUDBv712 = null;
                    TableSpaceUDBv71 tableSpaceUDBv713 = null;
                    SchemaUDBv71 schemaUDBv71 = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv71) {
                        tableProxyUDBv71 = (TableProxyUDBv71)((StorageDesignUDBv71)storageDesign).getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        if (tableProxyUDBv71 != null) {
                            tableProxyUDBv71.setName(dBObject.getName());
                            tableSpaceUDBv71 = this.getTableSpace(storageDesign, string);
                            if (tableSpaceUDBv71 != null) {
                                tableProxyUDBv71.setTableSpace(tableSpaceUDBv71);
                            }
                            if ((tableSpaceUDBv712 = this.getTableSpace(storageDesign, string3)) != null) {
                                tableProxyUDBv71.setIndexInTableSpace(tableSpaceUDBv712);
                            }
                            if ((tableSpaceUDBv713 = this.getTableSpace(storageDesign, string4)) != null) {
                                tableProxyUDBv71.setLongInTableSpace(tableSpaceUDBv713);
                            }
                            if ((schemaUDBv71 = (SchemaUDBv71)((StorageDesignUDBv71)storageDesign).getSchemaSet().getByName(string2.trim())) != null) {
                                tableProxyUDBv71.setSchema(schemaUDBv71);
                                tableProxyUDBv71.setOwner(schemaUDBv71.getOwner());
                            }
                            this.initTriggers(connection, tableProxyUDBv71);
                            this.setProperties(tableProxyUDBv71, (StorageDesignUDBv71)storageDesign, resultSet);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + ((ModelIDObject)object).getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(connection, tableProxyUDBv71, dBObject);
                    this.initColumnConstraints(connection, (Table)object, string2);
                    this.initTableConstraints(connection, (Table)object, string2);
                    this.initUniqueConstraints(connection, (Table)object, string2);
                    this.initIndexes(connection, (Table)object, string2);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    protected TableSpaceUDBv71 getTableSpace(StorageDesign storageDesign, String string) {
        if (string != null && string.equalsIgnoreCase("")) {
            TableSpaceUDBv71 tableSpaceUDBv71 = (TableSpaceUDBv71)((StorageDesignUDBv71)storageDesign).getTableSpaceSet().getByName(string);
            return tableSpaceUDBv71;
        }
        return null;
    }

    protected void setProperties(TableProxyUDBv71 tableProxyUDBv71, StorageDesignUDBv71 storageDesignUDBv71, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("PARTITION_MODE");
        String string2 = resultSet.getString("REMARKS");
        String string3 = resultSet.getString("LOG_ATTRIBUTE");
        String string4 = resultSet.getString("DATACAPTURE");
        if ("H".equalsIgnoreCase(string)) {
            tableProxyUDBv71.setPartKeyHashing(true);
        }
        if ("1".equalsIgnoreCase(string3)) {
            tableProxyUDBv71.setInitialLogging(false);
        }
        if (!"N".equalsIgnoreCase(string4)) {
            tableProxyUDBv71.setDataCapture(TableProxyUDB.getAvailableDataCaptureValues()[1]);
        }
        if (string2 != null && !"".equalsIgnoreCase(string2)) {
            tableProxyUDBv71.setCommentInRDBMS(string2);
            tableProxyUDBv71.setCommentInRDBMSChanged(true);
        }
    }

    protected void initColumns(Connection connection, TableProxyUDBv71 tableProxyUDBv71, DBObject dBObject) throws Exception {
        Comparable<StringBuffer> comparable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("SELECT").append(' ');
            ((StringBuffer)comparable).append("TABSCHEMA").append(',');
            ((StringBuffer)comparable).append("TABNAME").append(',');
            ((StringBuffer)comparable).append("COLNAME").append(',');
            ((StringBuffer)comparable).append("COLNO").append(',');
            ((StringBuffer)comparable).append("TYPESCHEMA").append(',');
            ((StringBuffer)comparable).append("TYPENAME").append(',');
            ((StringBuffer)comparable).append("LENGTH").append(',');
            ((StringBuffer)comparable).append("scale").append(',');
            ((StringBuffer)comparable).append("DEFAULT").append(',');
            ((StringBuffer)comparable).append("NULLS").append(',');
            ((StringBuffer)comparable).append("LOGGED").append(',');
            ((StringBuffer)comparable).append("COMPACT").append(',');
            ((StringBuffer)comparable).append("CODEPAGE").append(',');
            ((StringBuffer)comparable).append("TARGET_TYPESCHEMA").append(',');
            ((StringBuffer)comparable).append("SCOPE_TABSCHEMA").append(',');
            ((StringBuffer)comparable).append("SCOPE_TABNAME").append(',');
            ((StringBuffer)comparable).append("IDENTITY").append(',');
            ((StringBuffer)comparable).append("GENERATED").append(',');
            ((StringBuffer)comparable).append("TEXT").append(',');
            ((StringBuffer)comparable).append("REMARKS").append(',');
            ((StringBuffer)comparable).append("SPECIAL_PROPS").append(',');
            ((StringBuffer)comparable).append("DL_FEATURES").append(',');
            ((StringBuffer)comparable).append("PARTKEYSEQ").append(',');
            ((StringBuffer)comparable).append("COMPRESS").append(' ');
            ((StringBuffer)comparable).append("FROM").append(' ');
            ((StringBuffer)comparable).append("SYSCAT").append('.').append("COLUMNS").append(' ');
            ((StringBuffer)comparable).append("WHERE").append(' ');
            ((StringBuffer)comparable).append("TABSCHEMA").append('=');
            ((StringBuffer)comparable).append('\'').append(dBObject.getSchema()).append('\'');
            ((StringBuffer)comparable).append("AND").append(' ');
            ((StringBuffer)comparable).append("TABNAME").append('=');
            ((StringBuffer)comparable).append('\'').append(dBObject.getName()).append('\'');
            ((StringBuffer)comparable).append("ORDER BY").append(' ').append("COLNO");
            resultSet = statement.executeQuery(((StringBuffer)comparable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initColumns():", sQLException);
        }
        comparable = this.getStorageDesign().getRDBMSType();
        if (resultSet != null) {
            while (resultSet.next()) {
                Object object;
                ModelIDObject modelIDObject;
                Object object2;
                String string = resultSet.getString("COLNAME");
                String string2 = resultSet.getString("TYPENAME");
                int n = resultSet.getInt("LENGTH");
                int n2 = resultSet.getInt("scale");
                Integer n3 = (Integer)resultSet.getObject("PARTKEYSEQ");
                String string3 = resultSet.getString("NULLS");
                String string4 = resultSet.getString("DEFAULT");
                String string5 = resultSet.getString("LOGGED");
                String string6 = resultSet.getString("COMPACT");
                String string7 = resultSet.getString("IDENTITY");
                String string8 = resultSet.getString("GENERATED");
                String string9 = resultSet.getString("REMARKS");
                String string10 = resultSet.getString("DL_FEATURES");
                Table table = (Table)tableProxyUDBv71.getObject();
                Column column = (Column)table.getElementByName(string);
                if (column == null) {
                    column = table.createColumn(string);
                    this.stampModelObject((ModelObject)column, table.getName(), string);
                    object2 = StandardDatatypeNames.getUsedDatatypeName(string2);
                    modelIDObject = null;
                    object = StandardDatatypeNames.getNativeDBType(comparable, string2);
                    if (object != null) {
                        modelIDObject = ((NativeDBType)object).getLogicalDatatype();
                    }
                    if (modelIDObject == null) {
                        modelIDObject = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object2);
                    }
                    if (modelIDObject == null) {
                        modelIDObject = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string2, this.getDbmeHandler().getRDBMSSite().getType().getName());
                    }
                    if (modelIDObject != null && !"UNKNOWN".equalsIgnoreCase((String)object2)) {
                        column.setUse((short)1);
                        column.setLogicalDatatype((LogicalDatatype)modelIDObject);
                        column.setDataTypeParameter("size", String.valueOf(n));
                        column.setDataTypeParameter("scale", String.valueOf(n2));
                    } else {
                        StructuredType structuredType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2);
                        if (structuredType != null) {
                            column.setUse((short)3);
                            column.setStructuredType(structuredType);
                        } else {
                            DistinctType distinctType = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string2);
                            if (distinctType != null) {
                                column.setUse((short)2);
                                column.setDistinctType(distinctType);
                            }
                        }
                    }
                    if ("Y".equalsIgnoreCase(string3)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                    if (string4 != null) {
                        column.setDefaultValue(string4);
                    }
                    if (n3 != null && n3 > 0) {
                        tableProxyUDBv71.setPartitioningKey(column.getName());
                    }
                }
                if ((object2 = this.getStorageDesign()) == null || !(object2 instanceof StorageDesignUDBv71) || (object = (ColumnProxyUDBv71)(modelIDObject = (StorageDesignUDBv71)object2).getColumnProxySet().getProxy(column.getObjectID())) == null) continue;
                if ("Y".equalsIgnoreCase(string5)) {
                    ((ColumnProxyUDB)object).setLogging("LOGGED");
                }
                if ("Y".equalsIgnoreCase(string6)) {
                    ((ColumnProxyUDB)object).setCompact(ColumnProxyUDB.getCompactChoices()[0]);
                }
                if ("Y".equalsIgnoreCase(string7)) {
                    ((ColumnProxyUDB)object).setUseIdentity(true);
                    this.initIdentityColumn(connection, table, (ColumnProxyUDBv71)object);
                    if ("D".equalsIgnoreCase(string8)) {
                        ((ColumnProxyUDB)object).setGenerate(ColumnProxyUDB.getGenerateValues()[1]);
                    }
                }
                if (string10 != null && string10.equals("")) {
                    this.initDatalinkOptions((ColumnProxyUDBv71)object, string10);
                }
                ((ModelIDObject)object).setCommentInRDBMS(string9);
                ((RelationalObjectProxy)object).setCommentInRDBMSChanged(true);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIdentityColumn(Connection connection, Table table, ColumnProxyUDBv71 columnProxyUDBv71) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("s").append('.').append("INCREMENT").append(',');
            stringBuffer.append("s").append('.').append("START").append(',');
            stringBuffer.append("s").append('.').append("MAXVALUE").append(',');
            stringBuffer.append("s").append('.').append("MINVALUE").append(',');
            stringBuffer.append("s").append('.').append("CYCLE").append(',');
            stringBuffer.append("s").append('.').append("CACHE").append(',');
            stringBuffer.append("s").append('.').append("ORDER").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("sysibm.SYSSEQUENCES s").append(',');
            stringBuffer.append("sysibm.SYSDEPENDENCIES d").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("d").append('.').append("dschema");
            stringBuffer.append('=').append('\'').append(table.getSchema()).append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("d").append('.').append("dname");
            stringBuffer.append('=').append('\'').append(table.getName()).append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqtype ");
            stringBuffer.append('=').append('\'').append("I").append('\'');
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqschema");
            stringBuffer.append('=').append("d.bschema");
            stringBuffer.append(' ').append("AND").append(' ');
            stringBuffer.append("s").append('.').append("seqname");
            stringBuffer.append('=').append("d.bname");
            resultSet = statement.executeQuery(stringBuffer.toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableUDB.initIdentityColumn():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                columnProxyUDBv71.setIncrementBy(n);
                columnProxyUDBv71.setStartWith(string);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initColumnConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select a.constname,a.definition, b.enforced, b.enablequeryopt,d.colname ");
            ((StringBuffer)charSequence).append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            ((StringBuffer)charSequence).append("from syscat.CHECKS c where c.tabschema = '");
            ((StringBuffer)charSequence).append(string.trim()).append("' and ");
            ((StringBuffer)charSequence).append("c.tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and c.type = 'C' and 1 = (select count(*) ");
            ((StringBuffer)charSequence).append("from syscat.COLCHECKS ch where c.constname = ch.constname and ");
            ((StringBuffer)charSequence).append("c.tabschema = ch.tabschema and c.tabname = ch.tabname))a, syscat.TABCONST b, syscat.colchecks d ");
            ((StringBuffer)charSequence).append("where a.tabname = b.tabname and a.tabschema = b.tabschema and a.constname = b.constname and ");
            ((StringBuffer)charSequence).append("a.tabname = d.tabname and a.tabschema = d.tabschema and a.constname = d.constname ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initColumnConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(5);
                CheckConstraint checkConstraint = new CheckConstraint();
                checkConstraint.setDesign(table.getDesign());
                checkConstraint.setName((String)charSequence);
                checkConstraint.add(StorageDesignUDBv71.RDBMS_TYPE, string2);
                Column column = (Column)table.getElementByName(string3);
                if (column == null) continue;
                column.setUseDomainConstraints(false);
                column.setCheck(checkConstraint);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initTableConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select a.constname,a.definition, b.enforced, b.enablequeryopt ");
            ((StringBuffer)charSequence).append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            ((StringBuffer)charSequence).append("from syscat.CHECKS c where ");
            ((StringBuffer)charSequence).append("c.tabschema =  '");
            ((StringBuffer)charSequence).append(string.trim()).append("' and ");
            ((StringBuffer)charSequence).append("c.tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append(" c.type = 'C' and ");
            ((StringBuffer)charSequence).append("1<( ");
            ((StringBuffer)charSequence).append("select count(*) ");
            ((StringBuffer)charSequence).append("from syscat.COLCHECKS ch  ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("c.constname = ch.constname and ");
            ((StringBuffer)charSequence).append("c.tabschema = ch.tabschema and ");
            ((StringBuffer)charSequence).append("c.tabname = ch.tabname)) a, syscat.TABCONST b ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("a.tabname = b.tabname and ");
            ((StringBuffer)charSequence).append("a.tabschema = b.tabschema and ");
            ((StringBuffer)charSequence).append("a.constname = b.constname ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initTableConstraints:", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                TableLevelConstraint tableLevelConstraint = table.createCheckConstraint((String)charSequence, string2);
                table.addCheckConstraint(tableLevelConstraint);
                this.stampModelObject((ModelObject)tableLevelConstraint, string.trim(), (String)charSequence);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initUniqueConstraints(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  constname,type, enforced, ");
            ((StringBuffer)charSequence).append("enablequeryopt, remarks comment ");
            ((StringBuffer)charSequence).append("FROM  syscat.TABCONST ");
            ((StringBuffer)charSequence).append("WHERE tabschema  = '");
            ((StringBuffer)charSequence).append(string.trim()).append("'");
            ((StringBuffer)charSequence).append(" AND tabname  = '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND type in ('P','U')");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initUniqueConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Index index = table.createIndex();
                index.setContainerObject(table);
                index.setName((String)charSequence);
                this.stampModelObject((ModelObject)index, string.trim(), (String)charSequence);
                this.initKeyColumns(connection, index, (String)charSequence, table);
                if ("U".equalsIgnoreCase(string2)) {
                    index.setIndexState("Unique Constraint");
                    continue;
                }
                if ("P".equalsIgnoreCase(string2) && !table.isBST()) {
                    index.setIndexState("Primary Constraint");
                    continue;
                }
                if (!"P".equalsIgnoreCase(string2) || !table.isBST()) continue;
                if (index.getElementsCollection().size() > 0) {
                    table.getOidPKColumns().addAll(index.getElementsCollection());
                    table.setOidIsPK(true);
                }
                index.remove();
                index = (Index)table.getPK();
                index.setName((String)charSequence);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initKeyColumns(Connection connection, Index index, String string, Table table) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT COLNAME, COLSEQ ");
            ((StringBuffer)charSequence).append("from syscat.keycoluse ");
            ((StringBuffer)charSequence).append("WHERE tabschema  = '");
            ((StringBuffer)charSequence).append(table.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" AND tabname = '");
            ((StringBuffer)charSequence).append(table.getName()).append("' and ");
            ((StringBuffer)charSequence).append("constname = '").append(index.getName());
            ((StringBuffer)charSequence).append("' order by colseq");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initKeyColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                Column column = (Column)table.getElementByName((String)charSequence);
                if (column == null) continue;
                index.add(column);
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initIndexes(Connection connection, Table table, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  indname,indschema,colnames, uniquerule, ");
            ((StringBuffer)charSequence).append("colcount,unique_colcount,indextype clust_reg, ");
            ((StringBuffer)charSequence).append("pctfree,minpctused,reverse_scans,remarks comment ");
            ((StringBuffer)charSequence).append("from syscat.indexes  ");
            ((StringBuffer)charSequence).append("WHERE  tabname  =  '");
            ((StringBuffer)charSequence).append(table.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND tabschema  = '");
            ((StringBuffer)charSequence).append(string.trim()).append("'");
            ((StringBuffer)charSequence).append(" AND entrytype <>'H' ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initIndexes():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                StorageDesignUDBv71 storageDesignUDBv71;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(7);
                int n = resultSet.getInt(8);
                int n2 = resultSet.getInt(9);
                String string5 = resultSet.getString(10);
                String string6 = resultSet.getString(11);
                Index index = table.createIndex();
                index.setName((String)charSequence);
                index.setCommentInRDBMS(string6);
                this.stampModelObject((ModelObject)index, string.trim(), (String)charSequence);
                if ("U".equalsIgnoreCase(string3)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string3) && !table.isBST()) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(string3) && table.isBST()) {
                    if (index.getElementsCollection().size() > 0) {
                        table.getOidPKColumns().addAll(index.getElementsCollection());
                        table.setOidIsPK(true);
                    }
                    index.remove();
                    index = (Index)table.getPK();
                    index.setName((String)charSequence);
                }
                IndexProxyUDBv71 indexProxyUDBv71 = null;
                SchemaUDBv71 schemaUDBv71 = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71) || (indexProxyUDBv71 = (IndexProxyUDBv71)(storageDesignUDBv71 = (StorageDesignUDBv71)storageDesign).getIndexProxySet().getByName((String)charSequence)) == null) continue;
                schemaUDBv71 = (SchemaUDBv71)storageDesignUDBv71.getSchemaSet().getByName(string2);
                if (schemaUDBv71 != null) {
                    indexProxyUDBv71.setSchema(schemaUDBv71);
                    indexProxyUDBv71.setOwner(schemaUDBv71.getOwner());
                }
                indexProxyUDBv71.setPercentageFree(n);
                indexProxyUDBv71.setMinimumPercentageUsed(n2);
                if ("CLUS".equalsIgnoreCase(string4)) {
                    indexProxyUDBv71.setCluster(true);
                }
                if ("Y".equalsIgnoreCase(string5)) {
                    indexProxyUDBv71.setReverseScanSupport(true);
                }
                this.initIndexPrivileges(connection, indexProxyUDBv71);
                this.initIndexColumns(connection, indexProxyUDBv71, (String)charSequence, table);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIndexPrivileges(Connection connection, IndexProxyUDBv71 indexProxyUDBv71) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT grantee,granteetype,controlauth ");
            ((StringBuffer)charSequence).append("from syscat.indexauth ");
            ((StringBuffer)charSequence).append("WHERE INDNAME = '");
            ((StringBuffer)charSequence).append(indexProxyUDBv71.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND INDSCHEMA = '");
            ((StringBuffer)charSequence).append(indexProxyUDBv71.getSchema()).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                if (!"Y".equalsIgnoreCase(string2)) continue;
                if ("U".equalsIgnoreCase(string)) {
                    indexProxyUDBv71.setUsers(((String)charSequence).trim());
                    continue;
                }
                indexProxyUDBv71.setGroups(((String)charSequence).trim());
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initIndexColumns(Connection connection, IndexProxyUDBv71 indexProxyUDBv71, String string, Table table) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT colname, colseq, colorder ");
            ((StringBuffer)charSequence).append("from syscat.INDEXCOLUSE ");
            ((StringBuffer)charSequence).append("WHERE INDNAME = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND INDSCHEMA = '");
            ((StringBuffer)charSequence).append(table.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY COLSEQ ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                Column column = (Column)table.getElementByName((String)charSequence);
                Index index = indexProxyUDBv71.getIndex();
                if (column == null) continue;
                index.add(column);
                if ("A".equals(string2)) {
                    index.setColumnSortOrder(column, "ASC");
                } else {
                    index.setColumnSortOrder(column, "DESC");
                }
                indexProxyUDBv71.setColumnList(column.getName());
            }
            resultSet.close();
        }
        statement.close();
    }

    protected void initTriggers(Connection connection, TableProxyUDBv71 tableProxyUDBv71) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT TRIGSCHEMA,TRIGNAME,TRIGTIME, ");
            ((StringBuffer)charSequence).append("TRIGEVENT,GRANULARITY,TEXT definition,REMARKS comment ");
            ((StringBuffer)charSequence).append("from syscat.triggers ");
            ((StringBuffer)charSequence).append("WHERE tabname = '");
            ((StringBuffer)charSequence).append(tableProxyUDBv71.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND tabschema = '");
            ((StringBuffer)charSequence).append(tableProxyUDBv71.getSchema()).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY TRIGEVENT,TRIGTIME,create_time ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                SchemaUDBv71 schemaUDBv71 = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storageDesignUDBv71 = (StorageDesignUDBv71)storageDesign;
                TriggerUDBv71 triggerUDBv71 = (TriggerUDBv71)storageDesignUDBv71.getTriggerSet().createTrigger();
                triggerUDBv71.setName(string);
                triggerUDBv71.setTable(tableProxyUDBv71);
                this.stampModelObject((ModelObject)triggerUDBv71, (String)charSequence, string);
                schemaUDBv71 = (SchemaUDBv71)storageDesignUDBv71.getSchemaSet().getByName((String)charSequence);
                if (schemaUDBv71 != null) {
                    triggerUDBv71.setOwner(schemaUDBv71.getOwner());
                }
                if ("U".equalsIgnoreCase(string3)) {
                    triggerUDBv71.setActions(Trigger.ACTION_TYPES[1]);
                } else if ("D".equalsIgnoreCase(string3)) {
                    triggerUDBv71.setActions(Trigger.ACTION_TYPES[2]);
                }
                if ("A".equalsIgnoreCase(string2)) {
                    triggerUDBv71.setTriggerTime(TriggerUDB.TRIGGER_TIMES[1]);
                } else if ("B".equalsIgnoreCase(string2)) {
                    triggerUDBv71.setTriggerTime(TriggerUDB.TRIGGER_TIMES[0]);
                }
                if ("S".equalsIgnoreCase(string4)) {
                    triggerUDBv71.setScope(TriggerUDB.SCOPE_TYPES[1]);
                }
                triggerUDBv71.setBody(string5);
                triggerUDBv71.setCommentInRDBMS(string6);
                this.initTriggerColumnTypeSubstitution(connection, (Table)tableProxyUDBv71.getObject(), triggerUDBv71, string5);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initDatalinkOptions(ColumnProxyUDBv71 columnProxyUDBv71, String string) {
        String string2 = String.valueOf(string.charAt(2));
        String string3 = String.valueOf(string.charAt(4));
        String string4 = String.valueOf(string.charAt(5));
        String string5 = String.valueOf(string.charAt(6));
        String string6 = String.valueOf(string.charAt(7));
        if ("F".equalsIgnoreCase(string2)) {
            columnProxyUDBv71.setLinkControl(ColumnProxyUDB.getLinkControlChoices()[1]);
        }
        if ("D".equalsIgnoreCase(string3)) {
            columnProxyUDBv71.setReadPermission(ColumnProxyUDB.getReadPermissionChoices()[1]);
        }
        if ("B".equalsIgnoreCase(string4)) {
            columnProxyUDBv71.setWritePermission(ColumnProxyUDB.getWritePermissionChoices()[1]);
        }
        if ("N".equalsIgnoreCase(string5)) {
            columnProxyUDBv71.setRecovery(ColumnProxyUDB.getRecoveryChoices()[1]);
        }
        if ("D".equalsIgnoreCase(string6)) {
            columnProxyUDBv71.setOnUnlink(ColumnProxyUDB.getOnUnlinkChoices()[1]);
        }
    }

    private void initTriggerColumnTypeSubstitution(Connection connection, Table table, Trigger trigger, String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = string;
        int n = this.CWD_TS_COLUMN_META.length();
        int n2 = string2.indexOf(this.CWD_TS_COLUMN_META);
        try {
            while (n2 > -1) {
                string2 = string2.substring(n2 + n);
                String string3 = Token.getFirstToken(Token.getStringAfter(string2, "column="));
                Object object2 = Token.getFirstToken(Token.getStringAfter(string2, "type="));
                object = new Temp();
                ((Temp)object).tableName = Token.removeQuotes(string3);
                ((Temp)object).typeName = Token.removeQuotes((String)object2);
                arrayList.add(object);
                n2 = string2.indexOf(this.CWD_TS_COLUMN_META);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("MOHTableUDB.initTriggerColumnTypeSubstitution():", runtimeException);
        }
        for (Object object2 : arrayList) {
            StructuredType structuredType;
            object = (Column)table.getElementByName(((Temp)object2).tableName);
            if (object == null || (structuredType = this.getStructuredType(((Temp)object2).typeName, table.getDesign(), trigger.getStorageDesign())) == null) continue;
            List list = ((ContainedObjectWithDomain)object).getPermittedSubTypes();
            if (!list.contains(structuredType)) {
                list.add(structuredType);
            }
            ((ContainedObjectWithDomain)object).setAllowSubtypeSubstitution(true);
            ((ContainedObjectWithDomain)object).setRestrictedTypeSubstitution(true);
        }
    }

    private StructuredType getStructuredType(String string, Design design, StorageDesign storageDesign) {
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            StructuredTypeProxy structuredTypeProxy = ((StructuredTypeProxySetUDB)storageDesign.getStructuredTypeProxySet()).getBySchemaAndName(string3, string2);
            if (structuredTypeProxy != null) {
                return structuredTypeProxy.getStructuredType();
            }
            return null;
        }
        return (StructuredType)design.getDataTypesDesign().getStructuredTypeSet().getByName(string);
    }

    class Temp {
        String tableName;
        String typeName;
        String parenTypeName;
        StructuredType st;
        StructuredType stPar;

        Temp() {
        }
    }
}

