/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSchemaPrivilegesUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SCHEMA_OBJECT";
    private static final Logger LOGGER = new Logger(MOHSchemaPrivilegesUDB.class);

    public MOHSchemaPrivilegesUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        Iterator iterator = storageDesignUDB.getSchemaSet().iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            SchemaUDB schemaUDB = (SchemaUDB)iterator.next();
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select ");
                ((StringBuffer)charSequence).append("grantee user,granteetype,alterinauth,createinauth,dropinauth ");
                ((StringBuffer)charSequence).append("from syscat.schemaauth ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append("schemaname = '").append(schemaUDB.getName()).append("'");
                ((StringBuffer)charSequence).append(" and granteetype in ('U','G')");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (Exception exception) {
                System.out.println("MOHSchemaPrivilegesUDB.generate(): " + exception.getMessage());
                LOGGER.error("MOHSchemaObjectsUDB.generate():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    String string4 = resultSet.getString(5);
                    PrivilegesUDB privilegesUDB = null;
                    StorageObject storageObject = this.getUserOrGroup(storageDesignUDB, (String)charSequence, string);
                    if (storageObject == null || (privilegesUDB = this.getPrivileges(storageDesignUDB, schemaUDB, storageObject)) == null) continue;
                    if ("U".equalsIgnoreCase(string)) {
                        privilegesUDB.setUser((OwnerUDB)storageObject);
                    } else {
                        privilegesUDB.setGroup((UserGroupUDB)storageObject);
                    }
                    this.initPrivileges(privilegesUDB, (String)PrivilegesUDB.getPrivilegesValues().get(0), string2);
                    this.initPrivileges(privilegesUDB, (String)PrivilegesUDB.getPrivilegesValues().get(1), string3);
                    this.initPrivileges(privilegesUDB, (String)PrivilegesUDB.getPrivilegesValues().get(2), string4);
                }
                resultSet.close();
            }
            statement.close();
        }
    }

    private StorageObject getUserOrGroup(StorageDesignUDB storageDesignUDB, String string, String string2) {
        if ("U".equalsIgnoreCase(string2) && storageDesignUDB.getOwnerSet().getByName(string) != null) {
            return (StorageObject)storageDesignUDB.getOwnerSet().getByName(string);
        }
        if ("G".equalsIgnoreCase(string2) && storageDesignUDB.getUserGroupSet().getByName(string) != null) {
            return (StorageObject)storageDesignUDB.getUserGroupSet().getByName(string);
        }
        return null;
    }

    private PrivilegesUDB getPrivileges(StorageDesignUDB storageDesignUDB, SchemaUDB schemaUDB, Object object) {
        PrivilegesUDB privilegesUDB;
        Iterator iterator = storageDesignUDB.getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            privilegesUDB = (PrivilegesUDB)iterator.next();
            if (privilegesUDB.getSchema() != schemaUDB || privilegesUDB.getUser() != object && privilegesUDB.getGroup() != object) continue;
            return privilegesUDB;
        }
        privilegesUDB = storageDesignUDB.getPrivilegesSet().createPriv();
        privilegesUDB.setSchema(schemaUDB);
        return privilegesUDB;
    }

    private void initPrivileges(PrivilegesUDB privilegesUDB, String string, String string2) {
        if ("Y".equalsIgnoreCase(string2)) {
            privilegesUDB.setSystemPrivileges(string);
        }
        if ("G".equalsIgnoreCase(string2)) {
            privilegesUDB.setSystemPrivileges(string);
            privilegesUDB.setGrantOption("YES");
        }
    }
}

