/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureUDB.class);

    public MOHProcedureUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StoredProcedureUDB storedProcedureUDB = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT PROCNAME,SPECIFICNAME,DEFINER, ");
                ((StringBuffer)object).append("TEXT_BODY_OFFSET,TEXT definition,REMARKS comment ");
                ((StringBuffer)object).append("from syscat.PROCEDURES ");
                ((StringBuffer)object).append("WHERE  procschema = '");
                ((StringBuffer)object).append(string2).append("'");
                ((StringBuffer)object).append(" AND PROCNAME ='");
                ((StringBuffer)object).append(string).append("'");
                ((StringBuffer)object).append(" and SPECIFICNAME = '").append(dBObject.getSpecificName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHProcedureUDB.generate():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    StorageDesignUDB storageDesignUDB;
                    object = this.getStorageDesign();
                    if (object == null || !(object instanceof StorageDesignUDB) || (storedProcedureUDB = (StoredProcedureUDB)(storageDesignUDB = (StorageDesignUDB)object).getStoredProcedureSet().getByName(string)) != null && (storedProcedureUDB.getSchema() == null || !storedProcedureUDB.getSchema().getName().equalsIgnoreCase(string2) || storedProcedureUDB.getSpecificName().equalsIgnoreCase(dBObject.getSpecificName()))) continue;
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6);
                    storedProcedureUDB = storageDesignUDB.getStoredProcedureSet().createStoredProcedure();
                    storedProcedureUDB.setName(string);
                    storedProcedureUDB.setBody(string4);
                    storedProcedureUDB.setSpecificName(string3);
                    this.stampModelObject(storedProcedureUDB, dBObject);
                    SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string2);
                    if (schemaUDB != null) {
                        storedProcedureUDB.setSchema(schemaUDB);
                        storedProcedureUDB.setOwner(schemaUDB.getOwner());
                    }
                    storedProcedureUDB.setCommentInRDBMS(string5);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT PROCNAME,SPECIFICNAME, ");
                ((StringBuffer)charSequence).append("TEXT_BODY_OFFSET,TEXT definition,REMARKS comment ");
                ((StringBuffer)charSequence).append("from syscat.PROCEDURES ");
                ((StringBuffer)charSequence).append("WHERE  procschema = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHProcedureUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(2);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName(), string);
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }
}

