/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPrivilegesUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PRIVILIGES";
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);

    public MOHPrivilegesUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.initObject(connection, this.getDesign().getRelationalDesign().getTableSet());
        this.initObject(connection, this.getDesign().getRelationalDesign().getTableViewSet());
    }

    private void initObject(Connection connection, DesignObjectSet designObjectSet) throws SQLException {
        Iterator iterator = designObjectSet.iterator();
        DesignObject designObject = null;
        RelationalObjectProxy relationalObjectProxy = null;
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
        while (iterator.hasNext()) {
            designObject = (DesignObject)iterator.next();
            if (designObject instanceof Table) {
                relationalObjectProxy = storageDesignUDB.getTableProxySet().getProxy(designObject.getObjectID());
                if (((TableProxyUDB)relationalObjectProxy).getSchema() == null) continue;
                this.setPermission(connection, relationalObjectProxy, ((TableProxyUDB)relationalObjectProxy).getSchema().getName());
                this.initColumns(connection, relationalObjectProxy, ((TableProxyUDB)relationalObjectProxy).getSchema().getName());
                continue;
            }
            relationalObjectProxy = storageDesignUDB.getTableViewProxySet().getProxy(designObject.getObjectID());
            if (((TableViewProxyUDB)relationalObjectProxy).getSchema() == null) continue;
            this.setPermission(connection, relationalObjectProxy, ((TableViewProxyUDB)relationalObjectProxy).getSchema().getName());
            this.initColumns(connection, relationalObjectProxy, ((TableViewProxyUDB)relationalObjectProxy).getSchema().getName());
        }
    }

    private void setPermission(Connection connection, RelationalObjectProxy relationalObjectProxy, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        PermissionsUDB permissionsUDB = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT GRANTEE,GRANTEETYPE,CONTROLAUTH,ALTERAUTH, ");
            ((StringBuffer)charSequence).append("DELETEAUTH,INDEXAUTH,INSERTAUTH,SELECTAUTH, ");
            ((StringBuffer)charSequence).append("REFAUTH,UPDATEAUTH ");
            ((StringBuffer)charSequence).append("from syscat.TABAUTH  ");
            ((StringBuffer)charSequence).append("WHERE  TABNAME   =  '");
            ((StringBuffer)charSequence).append(relationalObjectProxy.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND TABSCHEMA   = '");
            ((StringBuffer)charSequence).append(string).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPrivilegesUDB.setPermission():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                String string6 = resultSet.getString(6);
                String string7 = resultSet.getString(7);
                String string8 = resultSet.getString(8);
                String string9 = resultSet.getString(9);
                String string10 = resultSet.getString(10);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                StorageObject storageObject = this.getUserOrGroup(storageDesignUDB, (String)charSequence, string2);
                if (storageObject != null) {
                    permissionsUDB = this.getPermissionForUser(relationalObjectProxy, storageObject);
                }
                if (permissionsUDB == null) {
                    permissionsUDB = storageDesignUDB.getPermissionsSet().createPermissions();
                    this.initUserOrGroup(storageDesignUDB, permissionsUDB, storageObject, string2);
                }
                this.initPrivileges(permissionsUDB, "CONTROL", string3);
                this.initPrivileges(permissionsUDB, "ALTER", string4);
                this.initPrivileges(permissionsUDB, "DELETE", string5);
                this.initPrivileges(permissionsUDB, "INDEX", string6);
                this.initPrivileges(permissionsUDB, "INSERT", string7);
                this.initPrivileges(permissionsUDB, "SELECT", string8);
                this.initPrivileges(permissionsUDB, "REFERENCES", string9);
                this.initPrivileges(permissionsUDB, "UPDATE", string10);
                if (relationalObjectProxy instanceof TableProxyUDB) {
                    permissionsUDB.setTable((TableProxyUDB)relationalObjectProxy);
                    continue;
                }
                permissionsUDB.setView((TableViewProxyUDB)relationalObjectProxy);
            }
            resultSet.close();
        }
        statement.close();
    }

    private void initColumns(Connection connection, RelationalObjectProxy relationalObjectProxy, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        PermissionsUDB permissionsUDB = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT grantee,granteetype,tabschema,tabname, ");
            ((StringBuffer)charSequence).append("colname,privtype,grantable ");
            ((StringBuffer)charSequence).append("from syscat.colauth  ");
            ((StringBuffer)charSequence).append("WHERE  TABNAME   =  '");
            ((StringBuffer)charSequence).append(relationalObjectProxy.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND TABSCHEMA   = '");
            ((StringBuffer)charSequence).append(string).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPrivilegesUDB.initColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(5);
                String string4 = resultSet.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                StorageObject storageObject = this.getUserOrGroup(storageDesignUDB, (String)charSequence, string2);
                if (storageObject != null) {
                    permissionsUDB = this.getPermissionForUser(relationalObjectProxy, storageObject);
                }
                if (permissionsUDB == null) {
                    permissionsUDB = storageDesignUDB.getPermissionsSet().createPermissions();
                    this.initUserOrGroup(storageDesignUDB, permissionsUDB, storageObject, string2);
                }
                if ("U".equalsIgnoreCase(string4)) {
                    permissionsUDB.setColumnList(string3 + "," + "UPDATE");
                    continue;
                }
                if (!"R".equalsIgnoreCase(string4)) continue;
                permissionsUDB.setColumnList(string3 + "," + "REFERENCES");
            }
            resultSet.close();
        }
        statement.close();
    }

    private StorageObject getUserOrGroup(StorageDesignUDB storageDesignUDB, String string, String string2) {
        if ("U".equalsIgnoreCase(string2) && storageDesignUDB.getOwnerSet().getByName(string) != null) {
            return (StorageObject)storageDesignUDB.getOwnerSet().getByName(string);
        }
        if ("G".equalsIgnoreCase(string2) && storageDesignUDB.getUserGroupSet().getByName(string) != null) {
            return (StorageObject)storageDesignUDB.getUserGroupSet().getByName(string);
        }
        return null;
    }

    private void initPrivileges(PermissionsUDB permissionsUDB, String string, String string2) {
        if ("Y".equalsIgnoreCase(string2)) {
            permissionsUDB.setPrivileges(string);
        } else if ("G".equalsIgnoreCase(string2)) {
            permissionsUDB.setPrivilegesWithGrantOption(string);
        }
    }

    private void initUserOrGroup(StorageDesignUDB storageDesignUDB, PermissionsUDB permissionsUDB, StorageObject storageObject, String string) {
        if ("U".equalsIgnoreCase(string) && storageObject instanceof OwnerUDB) {
            permissionsUDB.setUser((OwnerUDB)storageObject);
        } else if ("G".equalsIgnoreCase(string) && storageObject instanceof UserGroupUDB) {
            permissionsUDB.setGroup((UserGroupUDB)storageObject);
        }
    }

    private PermissionsUDB getPermissionForUser(RelationalObjectProxy relationalObjectProxy, StorageObject storageObject) {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
            Iterator iterator = storageDesignUDB.getPermissionsSet().iterator();
            PermissionsUDB permissionsUDB = null;
            while (iterator.hasNext()) {
                permissionsUDB = (PermissionsUDB)iterator.next();
                if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != relationalObjectProxy && permissionsUDB.getView() != relationalObjectProxy) continue;
                return permissionsUDB;
            }
        }
        return null;
    }
}

