/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionGroupUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PARTITION GROUP";
    private static final Logger LOGGER = new Logger(MOHPartitionGroupUDB.class);

    public MOHPartitionGroupUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            charSequence.append("select  dbpgname,remarks ");
            charSequence.append("from syscat.DBPARTITIONGROUPS");
            resultSet = statement.executeQuery(charSequence.toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionGroupUDB.generate():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storageDesignUDBv71 = (StorageDesignUDBv71)storageDesign;
                NodeGroupUDBv71 nodeGroupUDBv71 = (NodeGroupUDBv71)storageDesignUDBv71.getNodeGroupSet().getByName((String)charSequence);
                if (nodeGroupUDBv71 == null) {
                    nodeGroupUDBv71 = (NodeGroupUDBv71)storageDesignUDBv71.getNodeGroupSet().createNodeGroup();
                    nodeGroupUDBv71.setName((String)charSequence);
                    this.stampModelObject((ModelObject)nodeGroupUDBv71, "", (String)charSequence);
                }
                nodeGroupUDBv71.setCommentInRDBMS(string);
            }
            resultSet.close();
        }
        statement.close();
    }
}

