/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHOwnerUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OWNER";
    private static List schemas = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHOwnerUDB.class);

    public MOHOwnerUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    public static List getSchemas() {
        return schemas;
    }

    public static void setSchemas(List list) {
        schemas = list;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            StorageDesignUDB storageDesignUDB;
            OwnerUDB ownerUDB;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignUDB && (ownerUDB = (OwnerUDB)(storageDesignUDB = (StorageDesignUDB)storageDesign).getOwnerSet().getByName(string.trim())) == null) {
                ownerUDB = (OwnerUDB)storageDesignUDB.getOwnerSet().createElement(null);
                ownerUDB.setName(string.trim());
                this.stampModelObject(ownerUDB, dBObject);
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        this.initSchema(connection, schemas);
    }

    private void initSchema(Connection connection, List list) throws SQLException {
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!dBObject.isSelected()) continue;
            this.createSchema(connection, dBObject.getName());
        }
    }

    private void createSchema(Connection connection, String string) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  schemaname,definer,remarks  ");
            ((StringBuffer)charSequence).append("from syscat.schemata ");
            ((StringBuffer)charSequence).append("WHERE schemaname = '");
            ((StringBuffer)charSequence).append(string).append("'");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHOwnerUDB.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                SchemaUDB schemaUDB = storageDesignUDB.getSchemaSet().createSchema();
                schemaUDB.setName(string);
                this.stampModelObject((ModelObject)schemaUDB, "", string);
                OwnerUDB ownerUDB = (OwnerUDB)storageDesignUDB.getOwnerSet().getByName((String)charSequence);
                schemaUDB.setOwner(ownerUDB);
                schemaUDB.setCommentInRDBMS(string2);
            }
            resultSet.close();
        }
        statement.close();
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        schemas = list;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT  distinct grantee group  ");
            ((StringBuffer)charSequence).append("from syscat.schemaauth ");
            ((StringBuffer)charSequence).append("WHERE granteetype = 'U' ");
            ((StringBuffer)charSequence).append("union ");
            ((StringBuffer)charSequence).append("SELECT  distinct grantee group  ");
            ((StringBuffer)charSequence).append("from syscat.tabauth ");
            ((StringBuffer)charSequence).append("WHERE granteetype = 'U' ");
            ((StringBuffer)charSequence).append("union ");
            ((StringBuffer)charSequence).append("SELECT  distinct case owner when 'SYSIBM' then definer   ");
            ((StringBuffer)charSequence).append("else owner  end as owner ");
            ((StringBuffer)charSequence).append("from SYSCAT.schemata ");
            ((StringBuffer)charSequence).append("WHERE schemaname not like 'SYS%' ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHOwnerUDB.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }
}

