/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBufferpoolUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BUFFERPOOL";
    private static final Logger LOGGER = new Logger(MOHBufferpoolUDB.class);

    public MOHBufferpoolUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select ");
                ((StringBuffer)charSequence).append("bpname,bufferpoolid,ngname,npages,pagesize, ");
                ((StringBuffer)charSequence).append("estore,numblockpages,blocksize ");
                ((StringBuffer)charSequence).append("FROM syscat.BUFFERPOOLS  ");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (Exception exception) {
                LOGGER.error("MOHBufferpoolUDB.generate():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    int n2 = resultSet.getInt(5);
                    String string2 = resultSet.getString(6);
                    String string3 = resultSet.getString(2);
                    BufferPoolUDB bufferPoolUDB = null;
                    StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign();
                    if (storageDesignUDB == null) continue;
                    bufferPoolUDB = (BufferPoolUDB)storageDesignUDB.getBufferPoolSet().getByName((String)charSequence);
                    if (bufferPoolUDB == null) {
                        bufferPoolUDB = storageDesignUDB.getBufferPoolSet().createBufferPool();
                        bufferPoolUDB.setName((String)charSequence);
                        this.stampModelObject(bufferPoolUDB, dBObject);
                    }
                    bufferPoolUDB.setSize(n);
                    if (string != null) {
                        bufferPoolUDB.setScope(string);
                    }
                    if (n2 != 0) {
                        bufferPoolUDB.setPageSize(n2 / 1024);
                    }
                    if ("Y".equalsIgnoreCase(string2)) {
                        bufferPoolUDB.setExtendedStorage(true);
                    }
                    String string4 = this.getDiffSizePartitions(connection, string3);
                    bufferPoolUDB.setNodesWithDiffSize(string4);
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private String getDiffSizePartitions(Connection connection, String string) throws Exception {
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select ");
            ((StringBuffer)charSequence).append(" dbpartitionnum,npages ");
            ((StringBuffer)charSequence).append("FROM syscat.BUFFERPOOLDBPARTITIONS ");
            ((StringBuffer)charSequence).append("where BUFFERPOOLID = ").append(string);
            ((StringBuffer)charSequence).append(" order by DBPARTITIONNUM");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHBufferpoolUDB.generate():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((String)charSequence).append(" size ").append(string2);
            }
            resultSet.close();
        }
        statement.close();
        return stringBuffer.toString();
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            charSequence.append("select distinct bpname ");
            charSequence.append("FROM syscat.BUFFERPOOLS  ");
            resultSet = statement.executeQuery(charSequence.toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHBufferpoolUDB.generate():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }
}

