/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAliasUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ALIAS";
    private static final Logger LOGGER = new Logger(MOHAliasUDB.class);

    public MOHAliasUDB(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT  t.TABNAME aliasname,t.BASE_TABSCHEMA objectschema, ");
                ((StringBuffer)charSequence).append(" t.BASE_TABNAME objectname,a.TYPE objecttype ");
                ((StringBuffer)charSequence).append("FROM syscat.TABLES t,syscat.TABLES a ");
                ((StringBuffer)charSequence).append("WHERE t.type = 'A' and t.tabschema = '");
                ((StringBuffer)charSequence).append(string2).append("'");
                ((StringBuffer)charSequence).append(" AND t.tabname = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                ((StringBuffer)charSequence).append(" AND T.BASE_TABSCHEMA =a.TABSCHEMA");
                ((StringBuffer)charSequence).append(" AND T.BASE_TABNAME = a.TABNAME");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAliasUDB.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    charSequence = resultSet.getString(3);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
                        TableProxyUDB tableProxyUDB;
                        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)storageDesign;
                        AliasUDB aliasUDB = storageDesignUDB.getAliasSet().createAlias();
                        aliasUDB.setName(string);
                        this.stampModelObject(aliasUDB, dBObject);
                        SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string2);
                        if (schemaUDB != null) {
                            aliasUDB.setSchema(schemaUDB);
                        }
                        if ((tableProxyUDB = ((TableProxySetUDB)storageDesignUDB.getTableProxySet()).getByName((String)charSequence)) != null) {
                            aliasUDB.setReferencedObject(tableProxyUDB);
                        } else {
                            TableViewProxyUDB tableViewProxyUDB = ((TableViewProxySetUDB)storageDesignUDB.getTableViewProxySet()).getByName((String)charSequence);
                            if (tableViewProxyUDB != null) {
                                aliasUDB.setReferencedObject(tableViewProxyUDB);
                            } else {
                                AliasUDB aliasUDB2 = (AliasUDB)storageDesignUDB.getAliasSet().getByName((String)charSequence);
                                if (aliasUDB2 != null) {
                                    aliasUDB.setReferencedObject(aliasUDB2);
                                } else if (schemaUDB != null) {
                                    aliasUDB.setReferencedObject(schemaUDB);
                                }
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            statement.close();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT TABNAME from SYSCAT.TABLES").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'A' and TABSCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAliasUDB.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }
}

