/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.MOHAliasUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHBufferpoolUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHForeignKeyUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHOwnerUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHPartitionGroupUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHPrivilegesUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHProcedureUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHSchemaPrivilegesUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHSummerTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTableUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTablespaceUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeIncompleteUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHTypeUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHUserGroupUDB;
import oracle.dbtools.crest.imports.metadata.udb.MOHViewUDB;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHForeignKeyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHHierarchyUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHPartitionGroupUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHSequencesUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHStagingTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHSummerTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTablespaceUDBv81;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTypedTableUDBv81;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class DBMExtractionHandlerUDB
extends AbstractDBMExtractionHandler {
    private static DBMExtractionHandlerUDB dbmExtractionHandler;
    private List mohObjectsv71 = null;
    private List mohObjectsv81 = null;
    private ApplicationView view;
    private static final Logger LOGGER;

    private DBMExtractionHandlerUDB(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView applicationView) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerUDB(applicationView);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv71();
            }
            case 8: {
                return this.getMOHObjectsv81();
            }
            case 9: {
                return this.getMOHObjectsv81();
            }
        }
        return this.getMOHObjectsv81();
    }

    public List getMOHObjectsv71() {
        if (this.mohObjectsv71 == null) {
            this.mohObjectsv71 = new ArrayList();
            this.mohObjectsv71.add(new MOHUserGroupUDB(this, this.view));
            this.mohObjectsv71.add(new MOHOwnerUDB(this, this.view));
            this.mohObjectsv71.add(new MOHSchemaPrivilegesUDB(this, this.view));
            this.mohObjectsv71.add(new MOHTypeIncompleteUDB(this, this.view));
            this.mohObjectsv71.add(new MOHDatatypeUDB(this, this.view));
            this.mohObjectsv71.add(new MOHTypeUDB(this, this.view));
            this.mohObjectsv71.add(new MOHBufferpoolUDB(this, this.view));
            this.mohObjectsv71.add(new MOHPartitionGroupUDB(this, this.view));
            this.mohObjectsv71.add(new MOHTablespaceUDB(this, this.view));
            this.mohObjectsv71.add(new MOHTableUDB(this, this.view));
            this.mohObjectsv71.add(new MOHSummerTableUDB(this, this.view));
            this.mohObjectsv71.add(new MOHForeignKeyUDB(this, this.view));
            this.mohObjectsv71.add(new MOHViewUDB(this, this.view));
            this.mohObjectsv71.add(new MOHAliasUDB(this, this.view));
            this.mohObjectsv71.add(new MOHProcedureUDB(this, this.view));
            this.mohObjectsv71.add(new MOHPrivilegesUDB(this, this.view));
        }
        return this.mohObjectsv71;
    }

    public List getMOHObjectsv81() {
        if (this.mohObjectsv81 == null) {
            this.mohObjectsv81 = new ArrayList();
            this.mohObjectsv81.add(new MOHUserGroupUDB(this, this.view));
            this.mohObjectsv81.add(new MOHOwnerUDB(this, this.view));
            this.mohObjectsv81.add(new MOHSchemaPrivilegesUDB(this, this.view));
            this.mohObjectsv81.add(new MOHTypeIncompleteUDB(this, this.view));
            this.mohObjectsv81.add(new MOHDatatypeUDB(this, this.view));
            this.mohObjectsv81.add(new MOHTypeUDB(this, this.view));
            this.mohObjectsv81.add(new MOHBufferpoolUDB(this, this.view));
            this.mohObjectsv81.add(new MOHPartitionGroupUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHTablespaceUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHTableUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHSummerTableUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHStagingTableUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHTypedTableUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHForeignKeyUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHViewUDB(this, this.view));
            this.mohObjectsv81.add(new MOHAliasUDB(this, this.view));
            this.mohObjectsv81.add(new MOHProcedureUDB(this, this.view));
            this.mohObjectsv81.add(new MOHPrivilegesUDB(this, this.view));
            this.mohObjectsv81.add(new MOHSequencesUDBv81(this, this.view));
            this.mohObjectsv81.add(new MOHHierarchyUDBv81(this, this.view));
        }
        return this.mohObjectsv81;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv71.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
            case 9: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignUDBv81.RDBMS_TYPE);
    }

    @Override
    public List getSchemas(Connection connection) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (connection != null) {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                int n;
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = -1;
                try {
                    this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.dbMajorVersion == -1 && (n = this.dbProductVersion.indexOf(46)) > 0) {
                    String string = this.dbProductVersion.substring(0, n);
                    try {
                        this.dbMajorVersion = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        this.dbMajorVersion = 8;
                    }
                }
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
            return this.getUDBSchemas(connection);
        }
        return arrayList;
    }

    public List getUDBSchemas(Connection connection) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select schemaname,case owner  ");
            ((StringBuffer)charSequence).append("when 'SYSIBM' then definer ");
            ((StringBuffer)charSequence).append("else owner end as owner ");
            ((StringBuffer)charSequence).append("FROM SYSCAT.schemata ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("DBMExtractionHandlerUDB.getSchemas(): ", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1).trim();
                DBObject dBObject = new DBObject(false, (String)charSequence);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        return arrayList;
    }

    static {
        LOGGER = new Logger(DBMExtractionHandlerUDB.class);
    }
}

