/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHXMLSchemaCollection
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "XMLSchemaCollection";
    private static final Logger LOGGER = new Logger(MOHPartitionColumnSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;

    public MOHXMLSchemaCollection(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            Iterator iterator = this.storage.getDataBaseSet().iterator();
            while (iterator.hasNext()) {
                this.database = (DataBaseSqlServerv2k5)iterator.next();
                if (this.database.isNullInstance()) continue;
                this.initXMLSchemaCollection(connection, importLogger);
            }
        }
    }

    private void initXMLSchemaCollection(Connection connection, ImportLogger importLogger) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("xsc.name AS [Name],xsc.xml_collection_id AS [ID], ");
            ((StringBuffer)charSequence).append("sch.name AS [Schema],XML_SCHEMA_NAMESPACE(sch.Name, xsc.name) AS [Definition] ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.xml_schema_collections AS xsc ");
            ((StringBuffer)charSequence).append("INNER JOIN sys.schemas AS sch ON xsc.schema_id = sch.schema_id ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("(xsc.schema_id   <>4) ");
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("sch.name,xsc.name ");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)this.database.getSchemas().getByName(string2);
                XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)this.storage.getXmlSchemaCollectionSet().createType();
                if (xMLSchemaCollectionSqlServerv2k5 == null) continue;
                xMLSchemaCollectionSqlServerv2k5.setName((String)charSequence);
                xMLSchemaCollectionSqlServerv2k5.setDatabase(this.database);
                if (schemaSqlServerv2k5 != null) {
                    xMLSchemaCollectionSqlServerv2k5.setSchema(schemaSqlServerv2k5);
                    this.stampModelObject((ModelObject)xMLSchemaCollectionSqlServerv2k5, schemaSqlServerv2k5, (String)charSequence);
                }
                xMLSchemaCollectionSqlServerv2k5.setSchemaDefinition(string3);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }
}

