/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewSqlServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "VIEW";
    private static final Logger LOGGER = new Logger(MOHViewSqlServerv2k5.class);

    public MOHViewSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getId();
        String string2 = dBUserSqlServer.getDb();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("VIEWNAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("u").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("USERNAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysusers u").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("V").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("u").append('.').append("UID").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSQLServer.extractByUser():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, string3);
                dBObjectSqlServer.setDb(string2);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("SELECT").append(' ');
                ((StringBuffer)serializable).append("u").append('.').append("NAME").append(' ');
                ((StringBuffer)serializable).append("USERNAME").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("s").append('.').append("TEXT").append(' ');
                ((StringBuffer)serializable).append("DEFINITION").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append("o").append('.').append("ID").append(' ');
                ((StringBuffer)serializable).append("VIEWID").append(' ');
                ((StringBuffer)serializable).append("FROM").append(' ');
                ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysobjects o").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append(string2).append('.').append("dbo.sysusers u").append(' ');
                ((StringBuffer)serializable).append(',').append(' ');
                ((StringBuffer)serializable).append(string2).append('.').append("dbo.syscomments s").append(' ');
                ((StringBuffer)serializable).append("WHERE").append(' ');
                ((StringBuffer)serializable).append("XTYPE").append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append('\'').append("V").append('\'').append(' ');
                ((StringBuffer)serializable).append("AND").append(' ');
                ((StringBuffer)serializable).append("o").append('.').append("UID").append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append("u").append('.').append("UID").append(' ');
                ((StringBuffer)serializable).append("AND").append(' ');
                ((StringBuffer)serializable).append("o").append('.').append("ID").append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append("s").append('.').append("ID").append(' ');
                ((StringBuffer)serializable).append("AND").append(' ');
                ((StringBuffer)serializable).append("o").append('.').append("NAME").append(' ');
                ((StringBuffer)serializable).append('=').append(' ');
                ((StringBuffer)serializable).append('\'').append(string).append('\'').append(' ');
                resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewSqlServerv2k5.generate():", sQLException);
            }
            serializable = new ArrayList();
            if (resultSet != null) {
                while (resultSet.next()) {
                    object4 = resultSet.getString(1);
                    object3 = resultSet.getString(2);
                    object2 = resultSet.getString(3);
                    boolean bl = false;
                    for (int j = 0; j < serializable.size(); ++j) {
                        object = (Properties)serializable.get(j);
                        if (!((Properties)object).getProperty("username").equals(object4) || !((Properties)object).getProperty("view_id").equals(object2)) continue;
                        ((Properties)object).setProperty("body", ((Properties)object).getProperty("body") + (String)object3);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Properties properties = new Properties();
                    properties.setProperty("username", (String)object4);
                    properties.setProperty("body", (String)object3);
                    properties.setProperty("view_id", (String)object2);
                    serializable.add(properties);
                }
            }
            if (statement != null) {
                statement.close();
            }
            object4 = serializable.iterator();
            while (object4.hasNext()) {
                object3 = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                ((DesignObject)object3).setName(string);
                this.stampModelObject((ModelObject)object3, dBObjectSqlServer);
                ((AbstractView)object3).setSyntaxProvider("MSSQL");
                object2 = (Properties)object4.next();
                String string3 = ((Properties)object2).getProperty("username");
                String string4 = ((Properties)object2).getProperty("body");
                object = ((Properties)object2).getProperty("view_id");
                ((AbstractView)object3).setUserDefinedSQL(string4);
                ((AbstractView)object3).setUserDefined(true);
                ((TableView)object3).getColumns(string4.replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignSqlServer)) continue;
                StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                DataBaseSqlServer dataBaseSqlServer = null;
                if (!"".equalsIgnoreCase(string2)) {
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                } else {
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getNullInstance();
                }
                TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)storageDesignSqlServer.getTableViewProxySet().getProxy(((ModelIDObject)object3).getObjectID());
                tableViewProxySqlServer.setDataBase(dataBaseSqlServer);
                this.setUser(tableViewProxySqlServer, storageDesignSqlServer, string3, string2, connection);
                this.setSchema(tableViewProxySqlServer, string3);
                this.initIndexesOnView(tableViewProxySqlServer, storageDesignSqlServer, (String)object, string2, connection);
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setSchema(TableViewProxySqlServer tableViewProxySqlServer, String string) {
        SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)tableViewProxySqlServer.getDataBase().getSchemas().getByName(string);
        tableViewProxySqlServer.setSchema(schemaSqlServerv2k5);
    }

    private void initIndexesOnView(TableViewProxySqlServer tableViewProxySqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("i.name").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("clustered_ind = ");
            stringBuffer.append("case when (i.status & 16)=16 ");
            stringBuffer.append("then 'YES' ");
            stringBuffer.append("else 'NO' ");
            stringBuffer.append("end, f.groupname filegroup, ");
            stringBuffer.append("i.origfillfactor fill_factor, i.indid, ");
            stringBuffer.append("unique_ind = case when (i.status & 2)<>0 then 'YES' else 'NO' end, ");
            stringBuffer.append("stats_no_recompute = case when (i.status & 16777216)<>0 then 'YES'  else 'NO' end, ");
            stringBuffer.append("ignore_dup_keys = case when (i.status & 1)<>0 then 'YES'  else 'NO' end, ");
            stringBuffer.append("is_pad_index = (select INDEXPROPERTY(i.id, i.name,'IsPadIndex')) ");
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysindexes i").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysfilegroups f").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("i").append('.').append(' ');
            stringBuffer.append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("f").append('.').append("GROUPID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("i").append('.').append("GROUPID").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    String string6 = resultSet.getString(5);
                    String string7 = resultSet.getString(6);
                    String string8 = resultSet.getString(7);
                    String string9 = resultSet.getString(8);
                    int n2 = resultSet.getInt(9);
                    tableViewProxySqlServer.setSchemaBinding("YES");
                    IndexOnViewSqlServer indexOnViewSqlServer = storageDesignSqlServer.getIndexOnViewSet().createIndexOnView();
                    indexOnViewSqlServer.setName(string3);
                    indexOnViewSqlServer.setView(tableViewProxySqlServer);
                    indexOnViewSqlServer.setClustered(string4);
                    this.stampModelObject((ModelObject)indexOnViewSqlServer, tableViewProxySqlServer, string3);
                    indexOnViewSqlServer.setFillFactor(n);
                    indexOnViewSqlServer.setUnique(string7);
                    if (string8.equalsIgnoreCase("NO")) {
                        indexOnViewSqlServer.setRecomputeStatistics("NO");
                    } else {
                        indexOnViewSqlServer.setRecomputeStatistics("AUTO");
                    }
                    indexOnViewSqlServer.setIgnoreDupKey(string9);
                    if (n2 == 0) {
                        indexOnViewSqlServer.setPadIndex("NO");
                    } else {
                        indexOnViewSqlServer.setPadIndex("YES");
                    }
                    FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)storageDesignSqlServer.getFileGroupSet().getByName(string5);
                    if (fileGroupSqlServer == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string5);
                        fileGroupSqlServer.setDataBase(tableViewProxySqlServer.getDataBase());
                        this.stampModelObject((ModelObject)fileGroupSqlServer, tableViewProxySqlServer, string5);
                    }
                    indexOnViewSqlServer.setFilegroup(fileGroupSqlServer);
                    this.initColumns(indexOnViewSqlServer, string, string6, string2, connection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHViewSqlServerv2k5.initIndexesOnView():", sQLException);
        }
    }

    private void initColumns(IndexOnViewSqlServer indexOnViewSqlServer, String string, String string2, String string3, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("USE").append(' ');
            stringBuffer.append(string3).append(' ');
            stringBuffer.append(";").append(' ');
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("col_name(id,colid) columnname").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("sort_desc = indexkey_property(id, indid, keyno, 'isdescending') ");
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(string3).append('.').append("dbo.sysindexkeys").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("id").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("indid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string2).append(' ');
            stringBuffer.append("ORDER BY").append(' ');
            stringBuffer.append("keyno");
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    indexOnViewSqlServer.setCols(string4);
                    if (n == 0) {
                        indexOnViewSqlServer.setCols("ASC");
                        continue;
                    }
                    indexOnViewSqlServer.setCols("DESC");
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHViewSqlServerv2k5.initIndexesOnView():", sQLException);
        }
    }

    private void setUser(TableViewProxySqlServer tableViewProxySqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        String string3;
        UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string);
        if (userSqlServer == null) {
            userSqlServer = storageDesignSqlServer.getUserSet().createUser();
            userSqlServer.setName(string);
            userSqlServer.setDatabase(tableViewProxySqlServer.getDataBase());
            this.stampModelObject((ModelObject)userSqlServer, string2, string);
        }
        if ((string3 = this.getLogin(string, string2, connection)) != null) {
            LoginSqlServer loginSqlServer = (LoginSqlServer)storageDesignSqlServer.getLoginSet().getByName(string3);
            if (loginSqlServer == null) {
                loginSqlServer = storageDesignSqlServer.getLoginSet().createLogin();
                loginSqlServer.setName(string3);
                this.stampModelObject((ModelObject)loginSqlServer, tableViewProxySqlServer, string3);
            }
            userSqlServer.setLogin(loginSqlServer);
            loginSqlServer.setUsers(string);
        }
        tableViewProxySqlServer.setUser(userSqlServer);
    }

    private String getLogin(String string, String string2, Connection connection) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("l.loginname").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("master.dbo.syslogins l").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("l").append('.').append("sid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("u").append('.').append("sid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ').append('\'');
            stringBuffer.append(string).append('\'').append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHViewSqlServerv2k5.getLogin():", sQLException);
        }
        return string3;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

