/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSQLServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SIZE = "size";
    protected static final String PRECISION = "precision";
    private static final Logger LOGGER = new Logger(MOHTableSQLServerv2k5.class);

    public MOHTableSQLServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(MOHTableSQLServerv2k5.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private static List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getId();
        String string2 = dBUserSqlServer.getDb();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append("TABLENAME").append(',').append(' ');
            ((StringBuffer)charSequence).append("ID").append(',').append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append("USERID").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("U").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSQLServerv2k5.extractByUser():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, "");
                dBObjectSqlServer.setDb(string2);
                dBObjectSqlServer.setSchema(dBUserSqlServer.getName());
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    protected ResultSet getTables(DatabaseMetaData databaseMetaData, DBObject dBObject, boolean bl) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        if (bl) {
            return databaseMetaData.getTables(dBObject.getName(), null, "%", new String[]{OBJECT_TYPE});
        }
        return databaseMetaData.getTables(dBObjectSqlServer.getDb(), null, dBObject.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getColumns(dBObjectSqlServer.getDb(), null, dBObject.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getPrimaryKeys(dBObjectSqlServer.getDb(), null, dBObject.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)dBObject;
        return databaseMetaData.getIndexInfo(dBObjectSqlServer.getDb(), null, dBObject.getName(), false, false);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Start Tables");
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append("TABLENAME").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("u").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append("schemaname").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("ID").append(' ');
                ((StringBuffer)charSequence).append("TABLEID").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append(string2).append('.').append("sys.schemas u").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("XTYPE").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append('\'').append("U").append('\'').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append("u").append('.').append("schema_id").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append('\'').append(string).append('\'').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("u").append('.').append("NAME").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append('\'').append(dBObjectSqlServer.getSchema()).append('\'');
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTableSqlServer.extract():", sQLException);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    if (!((String)charSequence).equals(string)) continue;
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dBObjectSqlServer.getSchema());
                    table.setName((String)charSequence);
                    this.stampModelObject((ModelObject)table, dBObjectSqlServer.getSchema(), (String)charSequence);
                    TreeMap treeMap = new TreeMap();
                    this.initColumns(connection, table, string4, string2, treeMap);
                    this.initIndexes(connection, table, string4, string2);
                    this.initConstraints(connection, table, string4, string2, treeMap);
                    this.initUniqueKeys(connection, table, string4, string2);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)storageDesignSqlServer.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxySqlServer != null) {
                            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                            if (dataBaseSqlServer == null) {
                                dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                                dataBaseSqlServer.setName(string2);
                                this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                            }
                            tableProxySqlServer.setDatabase(dataBaseSqlServer);
                            this.setSchema(tableProxySqlServer, string3, dataBaseSqlServer);
                            this.setFilegroups(tableProxySqlServer, string4, storageDesignSqlServer, dataBaseSqlServer, connection);
                            this.setFileGroupsOrPartitionSchema(tableProxySqlServer, string4, storageDesignSqlServer, (DataBaseSqlServerv2k5)dataBaseSqlServer, connection);
                            this.initTriggers(connection, tableProxySqlServer, string4, string2);
                            continue;
                        }
                        LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        continue;
                    }
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
        TimeLog.log("End Tables");
    }

    private void setSchema(TableProxySqlServer tableProxySqlServer, String string, DataBaseSqlServer dataBaseSqlServer) {
        SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)dataBaseSqlServer.getSchemas().getByName(string);
        if (schemaSqlServerv2k5 != null) {
            tableProxySqlServer.setSchema(schemaSqlServerv2k5);
        }
    }

    private void setFileGroupsOrPartitionSchema(TableProxySqlServer tableProxySqlServer, String string, StorageDesignSqlServer storageDesignSqlServer, DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("USE").append(' ');
            stringBuffer.append(dataBaseSqlServerv2k5).append(' ');
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("tbl").append('.').append("NAME").append(' ');
            stringBuffer.append("AS").append(' ').append("[").append("NAME").append("]").append(',');
            stringBuffer.append("tbl").append('.').append("object_id").append(' ');
            stringBuffer.append("AS").append(' ').append("[").append("ID").append("]").append(',');
            stringBuffer.append("SCHEMA_NAME").append('(').append("tbl").append('.').append("schema_id").append(')');
            stringBuffer.append(' ').append("AS").append(' ').append("[").append("SCHEMA").append("]").append(',');
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasAfterTrigger') AS bit) AS [HasAfterTrigger], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasInsertTrigger') AS bit) AS [HasInsertTrigger], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasDeleteTrigger') AS bit) AS [HasDeleteTrigger], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasInsteadOfTrigger') AS bit) AS [HasInsteadOfTrigger], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'HasUpdateTrigger') AS bit) AS [HasUpdateTrigger], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'IsIndexed') AS bit) AS [HasIndex], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id, N'IsIndexable') AS bit) AS [IsIndexable], ");
            stringBuffer.append("CAST(CASE idx.index_id WHEN 1 THEN 1 ELSE 0 END AS bit) AS [HasClusteredIndex], ");
            stringBuffer.append("ISNULL(dstext.name,N'') AS [TextFileGroup],dstext.data_space_id AS [TextFileGroup_ID], ");
            stringBuffer.append("tbl.is_replicated AS [Replicated], ");
            stringBuffer.append("ISNULL( ( select sum (spart.rows) from sys.partitions spart where ");
            stringBuffer.append("spart.object_id = tbl.object_id and spart.index_id < 2), 0) AS [RowCount], ");
            stringBuffer.append("tbl.uses_ansi_nulls AS [AnsiNullsStatus], ");
            stringBuffer.append("CAST(OBJECTPROPERTY(tbl.object_id,N'IsQuotedIdentOn') AS bit) AS [QuotedIdentifierStatus], ");
            stringBuffer.append("CAST(0 AS bit) AS [FakeSystemTable], ");
            stringBuffer.append("CASE WHEN 'FG'=dsidx.type THEN dsidx.name ELSE N'' END AS [FileGroup], ");
            stringBuffer.append("CASE WHEN 'PS'=dsidx.type THEN dsidx.name ELSE N'' END AS [PartitionScheme], ");
            stringBuffer.append("CAST(CASE WHEN 'PS'=dsidx.type THEN 1 ELSE 0 END AS bit) AS [IsPartitioned], ");
            stringBuffer.append("dsidx.data_space_id AS [FG_PS_dataspace_id], ");
            stringBuffer.append("dstext.type as text_dataspace_type ");
            stringBuffer.append("FROM").append(' ').append("sys.tables").append(' ').append("AS").append(' ').append("tbl ");
            stringBuffer.append("INNER JOIN sys.indexes AS idx ON idx.object_id = tbl.object_id and idx.index_id < 2 ");
            stringBuffer.append("LEFT OUTER JOIN sys.data_spaces AS dstext  ON tbl.lob_data_space_id = dstext.data_space_id ");
            stringBuffer.append("LEFT OUTER JOIN sys.data_spaces AS dsidx ON dsidx.data_space_id = idx.data_space_id ");
            stringBuffer.append("WHERE").append(' ').append("tbl.object_id ").append('=').append(' ').append(string);
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    FileGroupSqlServer fileGroupSqlServer;
                    String string2 = resultSet.getString(12);
                    String string3 = resultSet.getString(19);
                    String string4 = resultSet.getString(20);
                    String string5 = resultSet.getString(23);
                    if (!string3.equals("")) {
                        fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServerv2k5.getFilegroups().getByName(string3);
                        if (fileGroupSqlServer == null) {
                            fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            fileGroupSqlServer.setName(string3);
                            fileGroupSqlServer.setDataBase(dataBaseSqlServerv2k5);
                            this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServerv2k5, string3);
                        }
                        tableProxySqlServer.setFilegroup(fileGroupSqlServer);
                    }
                    if (!string2.equals("") && string5.equalsIgnoreCase("FG")) {
                        fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServerv2k5.getFilegroups().getByName(string2);
                        if (fileGroupSqlServer == null) {
                            fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            fileGroupSqlServer.setName(string2);
                            fileGroupSqlServer.setDataBase(dataBaseSqlServerv2k5);
                            this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServerv2k5, string3);
                        }
                        tableProxySqlServer.setTextImageFG(fileGroupSqlServer);
                    }
                    if (string4.equals("")) continue;
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.setFileGroupsOrPartitionSchema():", sQLException);
        }
    }

    private void setFilegroups(TableProxySqlServer tableProxySqlServer, String string, StorageDesignSqlServer storageDesignSqlServer, DataBaseSqlServer dataBaseSqlServer, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("s").append('.').append("GROUPNAME").append(' ');
            stringBuffer.append("filegroup").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("i").append('.').append("indid").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysfilegroups s").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(dataBaseSqlServer.getName()).append('.').append("dbo.sysindexes i").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("i").append('.').append("ID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("(i.indid =0 or i.indid = 255)").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("i").append('.').append("GROUPID").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("s").append('.').append("GROUPID").append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null) {
                while (resultSet.next()) {
                    FileGroupSqlServer fileGroupSqlServer;
                    String string2 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    if (n == 0) {
                        fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string2);
                        if (fileGroupSqlServer == null) {
                            fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            fileGroupSqlServer.setName(string2);
                            fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                            this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServer, string2);
                        }
                        tableProxySqlServer.setFilegroup(fileGroupSqlServer);
                        continue;
                    }
                    if (n != 255) continue;
                    fileGroupSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string2);
                    if (fileGroupSqlServer == null) {
                        fileGroupSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                        fileGroupSqlServer.setName(string2);
                        fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                        this.stampModelObject((ModelObject)fileGroupSqlServer, dataBaseSqlServer, string2);
                    }
                    tableProxySqlServer.setTextImageFG(fileGroupSqlServer);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initFilegroups():", sQLException);
        }
    }

    private void initColumns(Connection connection, Table table, String string, String string2, Map map) throws Exception {
        Comparable<StringBuffer> comparable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("SELECT").append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("NAME").append(' ');
            ((StringBuffer)comparable).append("colname").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("t").append('.');
            ((StringBuffer)comparable).append("NAME").append(' ');
            ((StringBuffer)comparable).append("typename").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("colid").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("length").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("prec").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("scale").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("isnullable").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("iscomputed").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("computed_expr = com.text").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("c").append('.');
            ((StringBuffer)comparable).append("collation").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("identitycolumn = ");
            ((StringBuffer)comparable).append("case c.colstat & 1 ");
            ((StringBuffer)comparable).append("when 1 then 'YES' ");
            ((StringBuffer)comparable).append("else 'NO' ");
            ((StringBuffer)comparable).append("end").append(' ');
            ((StringBuffer)comparable).append(',').append(' ');
            ((StringBuffer)comparable).append("ROWGUIDCOLL = ColumnProperty(c.id, c.name, 'IsRowGuidCol')").append(' ');
            ((StringBuffer)comparable).append("FROM").append(' ');
            ((StringBuffer)comparable).append(string2).append('.').append("dbo.systypes t").append(',');
            ((StringBuffer)comparable).append('(').append(' ').append(string2).append('.');
            ((StringBuffer)comparable).append("dbo.syscolumns c Left Outer Join ");
            ((StringBuffer)comparable).append(string2).append('.');
            ((StringBuffer)comparable).append("dbo.syscomments com ");
            ((StringBuffer)comparable).append("On com.id = c.id and com.number = c.colid)").append(' ');
            ((StringBuffer)comparable).append("WHERE").append(' ');
            ((StringBuffer)comparable).append("c.id ").append('=').append(string);
            ((StringBuffer)comparable).append("AND").append(' ');
            ((StringBuffer)comparable).append("c.xusertype ").append('=').append("t.xusertype").append(' ');
            ((StringBuffer)comparable).append("ORDER BY").append(' ');
            ((StringBuffer)comparable).append("c.colid");
            resultSet = statement.executeQuery(((StringBuffer)comparable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initColumns():", sQLException);
        }
        comparable = this.getStorageDesign().getRDBMSType();
        if (resultSet != null) {
            while (resultSet.next()) {
                ModelIDObject modelIDObject;
                Object object;
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                int n = resultSet.getInt(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                String string6 = resultSet.getString(9);
                String string7 = resultSet.getString(10);
                String string8 = resultSet.getString(11);
                int n6 = resultSet.getInt(12);
                boolean bl = false;
                if (string4.equalsIgnoreCase("varchar") && n == -1) {
                    bl = true;
                }
                String string9 = "-11";
                Column column = table.createColumn(string3);
                this.stampModelObject((ModelObject)column, table.getName(), string3);
                if (string9 != null) {
                    map.put(string9, column);
                }
                String string10 = StandardDatatypeNames.getUsedDatatypeName(string4);
                Object object2 = null;
                if (bl && (object = this.getDesign().getLogicalDatatypeSet().getLogTypeForVarcharMax(string4, this.getDbmeHandler().getRDBMSSite().getType().getName())) != null) {
                    object2 = object;
                }
                object = null;
                if (object2 == null && (object = StandardDatatypeNames.getNativeDBType(comparable, string4)) != null) {
                    object2 = ((NativeDBType)object).getLogicalDatatype();
                }
                if (object2 == null) {
                    object2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string10);
                }
                if (object2 == null) {
                    object2 = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string4, this.getDbmeHandler().getRDBMSSite().getType().getName());
                }
                if (object2 != null && !"UNKNOWN".equalsIgnoreCase(string10)) {
                    column.setUse((short)1);
                    column.setLogicalDatatype((LogicalDatatype)object2);
                    if (bl) {
                        column.setDataTypeParameter(SIZE, "max");
                    } else {
                        column.setDataTypeParameter(SIZE, String.valueOf(n));
                    }
                    column.setDataTypeParameter(PRECISION, String.valueOf(n2));
                    column.setDataTypeParameter("SCALE", String.valueOf(n3));
                } else {
                    modelIDObject = (DistinctType)this.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(string4);
                    if (modelIDObject != null) {
                        column.setUse((short)2);
                        column.setDistinctType((DistinctType)modelIDObject);
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype((LogicalDatatype)object2);
                        column.setDataTypeParameter(SIZE, String.valueOf(n));
                        column.setDataTypeParameter(PRECISION, String.valueOf(n2));
                        column.setDataTypeParameter("SCALE", String.valueOf(n3));
                        System.out.println("Unable to find logical datatype for: " + string4);
                    }
                }
                column.setNullsAllowed(n4 == 1);
                if (n5 != 0) {
                    column.setComputed(true);
                    column.setFormulaDesc(string6);
                }
                if ((modelIDObject = this.getStorageDesign()) != null && modelIDObject instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)modelIDObject;
                    ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)storageDesignSqlServer.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxySqlServerv2k5 != null) {
                        if (n6 == 0) {
                            columnProxySqlServerv2k5.setRowGuidCol("NO");
                        } else {
                            columnProxySqlServerv2k5.setRowGuidCol("YES");
                        }
                        columnProxySqlServerv2k5.setAsIdentity("YES".equalsIgnoreCase(string8));
                        columnProxySqlServerv2k5.setCollation(string7);
                        if (!(columnProxySqlServerv2k5.getDataType() instanceof MDXMLTypeSqlServer)) continue;
                        this.initXMLSchemaCollection(connection, string2, string, string5, columnProxySqlServerv2k5, storageDesignSqlServer);
                        continue;
                    }
                    LOGGER.error("Unable to find ColumnProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initXMLSchemaCollection(Connection connection, String string, String string2, String string3, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5, StorageDesignSqlServer storageDesignSqlServer) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("x.name xml_collection,s.name as [schema],x.schema_id, is_xml_document ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("SYS").append('.').append("columns c").append(' ');
            ((StringBuffer)charSequence).append("Left Join sys.xml_schema_collections as x on c.xml_collection_id = x.xml_collection_id  ");
            ((StringBuffer)charSequence).append("Left Join sys.schemas as s on x.schema_id = s.schema_id ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("c.object_id ").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.column_id").append(' ').append('=').append(' ').append(string3).append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initXMLSchemaCollection():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = string4 + "." + (String)charSequence;
                XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = this.getXmlCollectionByNameAndSchema(string6, storageDesignSqlServer);
                if (xMLSchemaCollectionSqlServerv2k5 == null) continue;
                columnProxySqlServerv2k5.setXmlSchemaCollection(xMLSchemaCollectionSqlServerv2k5);
                if (!"1".equals(string5)) continue;
                columnProxySqlServerv2k5.setCollectionType("DOCUMENT");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private XMLSchemaCollectionSqlServerv2k5 getXmlCollectionByNameAndSchema(String string, StorageDesignSqlServer storageDesignSqlServer) {
        Iterator iterator = ((StorageDesignSqlServerv2k5)storageDesignSqlServer).getXmlSchemaCollectionSet().iterator();
        while (iterator.hasNext()) {
            XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)iterator.next();
            if (!xMLSchemaCollectionSqlServerv2k5.getLongName().equals(string)) continue;
            return xMLSchemaCollectionSqlServerv2k5;
        }
        return null;
    }

    private void initIndexes(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        Object object2;
        Object object3;
        Serializable serializable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("USE").append(' ');
            ((StringBuffer)serializable).append(string2).append(' ');
            ((StringBuffer)serializable).append("SELECT").append(' ');
            ((StringBuffer)serializable).append("i.name, i.index_id, i.type,i.type_desc,i.is_primary_key, ");
            ((StringBuffer)serializable).append("i.is_unique_constraint,i.is_unique, ");
            ((StringBuffer)serializable).append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, ");
            ((StringBuffer)serializable).append("i.allow_page_locks,i.data_space_id,ds.name ds_name,ds.type ds_type, ");
            ((StringBuffer)serializable).append("s.no_recompute AS [NoAutomaticRecomputation] ");
            ((StringBuffer)serializable).append("FROM").append(' ');
            ((StringBuffer)serializable).append("sys.indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            ((StringBuffer)serializable).append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND  ");
            ((StringBuffer)serializable).append("s.object_id = i.object_id ");
            ((StringBuffer)serializable).append("WHERE").append(' ');
            ((StringBuffer)serializable).append("i.object_id = ").append(string).append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("i.is_primary_key = 0 ");
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("i.is_unique_constraint = 0 ");
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("i.type<>3 and i.name is not null ");
            ((StringBuffer)serializable).append("union select i.name, i.index_id, ");
            ((StringBuffer)serializable).append("i.type,i.type_desc,i.is_primary_key,i.is_unique_constraint,i.is_unique, ");
            ((StringBuffer)serializable).append("i.ignore_dup_key,i.fill_factor,i.is_padded,i.allow_row_locks, i.allow_page_locks, ");
            ((StringBuffer)serializable).append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation]  ");
            ((StringBuffer)serializable).append("from sys.xml_indexes i INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ");
            ((StringBuffer)serializable).append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND ");
            ((StringBuffer)serializable).append("s.object_id = i.object_id ");
            ((StringBuffer)serializable).append("where  i.object_id = ").append(string).append(' ');
            ((StringBuffer)serializable).append("and i.is_primary_key = 0 ");
            ((StringBuffer)serializable).append("and i.is_unique_constraint = 0 ");
            ((StringBuffer)serializable).append("and i.using_xml_index_id is null ");
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initIndexes():", sQLException);
        }
        serializable = new ArrayList();
        if (resultSet != null) {
            while (resultSet.next()) {
                object3 = resultSet.getString(1);
                object2 = resultSet.getString(2);
                string10 = resultSet.getString(4);
                string9 = resultSet.getString(7);
                string8 = resultSet.getString(8);
                int n = resultSet.getInt(9);
                string7 = resultSet.getString(10);
                String string11 = resultSet.getString(11);
                string6 = resultSet.getString(12);
                string5 = resultSet.getString(14);
                string4 = resultSet.getString(15);
                string3 = resultSet.getString(16);
                if (object3 != null) {
                    object = new Properties();
                    ((Properties)object).setProperty("name", (String)object3);
                    ((Properties)object).setProperty("indId", (String)object2);
                    ((Properties)object).setProperty("clustered", string10);
                    ((Properties)object).setProperty("unique", string9);
                    ((Properties)object).setProperty("ignoreDupKeys", string8);
                    ((Properties)object).setProperty("fillFactor", String.valueOf(n));
                    ((Properties)object).setProperty("isPadIndex", string7);
                    ((Properties)object).setProperty("allow_row_locks", string11);
                    ((Properties)object).setProperty("allow_page_locks", string6);
                    ((Properties)object).setProperty("ds_name", string5);
                    ((Properties)object).setProperty("ds_type", string4);
                    ((Properties)object).setProperty("statsNoRecompute", string3 != null ? string3 : "");
                    serializable.add(object);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
        }
        if (statement != null) {
            statement.close();
        }
        object3 = serializable.iterator();
        while (object3.hasNext()) {
            object2 = (Properties)object3.next();
            string10 = ((Properties)object2).getProperty("name");
            string9 = ((Properties)object2).getProperty("indId");
            string8 = ((Properties)object2).getProperty("clustered");
            String string12 = ((Properties)object2).getProperty("unique");
            string7 = ((Properties)object2).getProperty("ignoreDupKeys");
            int n = Integer.parseInt(((Properties)object2).getProperty("fillFactor"));
            string6 = ((Properties)object2).getProperty("isPadIndex");
            string5 = ((Properties)object2).getProperty("allow_row_locks");
            string4 = ((Properties)object2).getProperty("allow_page_locks");
            string3 = ((Properties)object2).getProperty("ds_name");
            object = ((Properties)object2).getProperty("ds_type");
            String string13 = ((Properties)object2).getProperty("statsNoRecompute");
            Index index = table.createIndex();
            index.setName(string10);
            this.stampModelObject((ModelObject)index, table.getSchema(), string10);
            if ("1".equalsIgnoreCase(string12)) {
                index.setIndexState("Unique Plain Index");
            }
            this.initKeyColumns(index, table, string, string9, string2, connection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesign storageDesign2 = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storageDesign2 = (StorageDesignSqlServer)storageDesign;
            }
            if (storageDesign2 != null) {
                IndexProxySqlServerv2k5 indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)storageDesign2.getIndexProxySet().getProxy(index.getObjectID());
                if (indexProxySqlServerv2k5 != null) {
                    AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
                    if ("CLUSTERED".equalsIgnoreCase(string8)) {
                        indexProxySqlServerv2k5.setClustered(true);
                    } else {
                        indexProxySqlServerv2k5.setClustered(false);
                    }
                    indexProxySqlServerv2k5.setFillFactor(n);
                    if ("1".equalsIgnoreCase(string13)) {
                        indexProxySqlServerv2k5.setRecomputeStatistics("ON");
                    } else {
                        indexProxySqlServerv2k5.setRecomputeStatistics("OFF");
                    }
                    indexProxySqlServerv2k5.setIgnoreDupKey(string7);
                    if ("1".equalsIgnoreCase(string6)) {
                        indexProxySqlServerv2k5.setPadIndex("YES");
                    } else {
                        indexProxySqlServerv2k5.setPadIndex("NO");
                    }
                    DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)((StorageDesignSqlServer)storageDesign2).getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = ((StorageDesignSqlServer)storageDesign2).getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    if (((String)object).equalsIgnoreCase("FG")) {
                        abstractStorageObjectSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string3);
                        if (abstractStorageObjectSqlServer == null) {
                            abstractStorageObjectSqlServer = ((StorageDesignSqlServer)storageDesign2).getFileGroupSet().createFileGroup();
                            abstractStorageObjectSqlServer.setName(string3);
                            ((FileGroupSqlServer)abstractStorageObjectSqlServer).setDataBase(dataBaseSqlServer);
                            this.stampModelObject((ModelObject)abstractStorageObjectSqlServer, indexProxySqlServerv2k5, string3);
                        }
                        indexProxySqlServerv2k5.setFilegroup((FileGroupSqlServer)abstractStorageObjectSqlServer);
                    }
                    if (((String)object).equalsIgnoreCase("PS") && (abstractStorageObjectSqlServer = this.getPartitionSchemaByName(string3, dataBaseSqlServer)) != null) {
                        indexProxySqlServerv2k5.setPartitionScheme((PartitionSchemeSqlServer)abstractStorageObjectSqlServer);
                    }
                    if (indexProxySqlServerv2k5.isPrimaryXmlIndex()) {
                        this.initSecondaryXMLIndex(connection, string2, string, string9, indexProxySqlServerv2k5);
                    }
                    if ("0".equals(string4)) {
                        indexProxySqlServerv2k5.setAllowPageLocks("OFF");
                    }
                    if ("0".equals(string5)) {
                        indexProxySqlServerv2k5.setAllowRowLocks("OFF");
                    }
                    this.initIncludeColumns(connection, string2, string, string9, table, indexProxySqlServerv2k5);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
        }
    }

    private void initIncludeColumns(Connection connection, String string, String string2, String string3, Table table, IndexProxySqlServerv2k5 indexProxySqlServerv2k5) throws SQLException {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("c.name column_name, ic.column_id ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("SYS").append('.').append("index_columns ic").append(' ');
            ((StringBuffer)charSequence).append(',').append("SYS").append('.').append("columns c ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("ic.object_id").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("is_included_column = 1");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.object_id = ic.object_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.column_id = ic.column_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("index_id =  ").append(string3);
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initSecondaryXMLIndex():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                Column column = (Column)table.getElementByName(((String)charSequence).trim());
                if (column == null) continue;
                indexProxySqlServerv2k5.setIncludeColumns(column.getObjectID());
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initSecondaryXMLIndex(Connection connection, String string, String string2, String string3, IndexProxySqlServerv2k5 indexProxySqlServerv2k5) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("i.name, i.secondary_type_desc ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("SYS").append('.').append("xml_indexes i").append(' ');
            ((StringBuffer)charSequence).append(',').append("SYS").append('.').append("data_spaces ds ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("i.object_id").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("i.data_space_id = ds.data_space_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("i.is_primary_key = 0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("i.is_unique_constraint = 0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("i.using_xml_index_id is not null  ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("i.using_xml_index_id = ").append(string3);
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initSecondaryXMLIndex():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = null;
                if (storageDesign == null || !(storageDesign instanceof StorageDesignSqlServerv2k5)) continue;
                storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)storageDesign;
                SecondaryXmlIndexSqlServerv2k5 secondaryXmlIndexSqlServerv2k5 = (SecondaryXmlIndexSqlServerv2k5)storageDesignSqlServerv2k5.getSecondaryXmlIndexSetv2k5().createXmlIndex();
                secondaryXmlIndexSqlServerv2k5.setName((String)charSequence);
                secondaryXmlIndexSqlServerv2k5.setPrimaryXmlIndex(indexProxySqlServerv2k5);
                secondaryXmlIndexSqlServerv2k5.setIndexType(string4.trim().toUpperCase());
                this.stampModelObject((ModelObject)secondaryXmlIndexSqlServerv2k5, indexProxySqlServerv2k5, (String)charSequence);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private PartitionSchemeSqlServerv2k5 getPartitionSchemaByName(String string, DataBaseSqlServer dataBaseSqlServer) {
        Iterator iterator = ((DataBaseSqlServerv2k5)dataBaseSqlServer).getPartitionFunction().iterator();
        while (iterator.hasNext()) {
            PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)iterator.next();
            PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5 = (PartitionSchemeSqlServerv2k5)partitionFunctionSqlServerv2k5.getPartitionScheme().getByName(string);
            if (partitionSchemeSqlServerv2k5 == null) continue;
            return partitionSchemeSqlServerv2k5;
        }
        return null;
    }

    private void initConstraints(Connection connection, Table table, String string, String string2, Map map) throws Exception {
        String string3;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            string3 = "select name, object_id,parent_object_id,type,definition,is_system_named from sys.check_constraints  where parent_object_id = " + string + " union" + " select name, object_id,parent_object_id,type,definition,is_system_named from sys.default_constraints " + " where parent_object_id = " + string;
            resultSet = statement.executeQuery(string3);
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initConstraints():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                ModelObject modelObject;
                string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4).trim();
                String string7 = resultSet.getString(5);
                String string8 = resultSet.getString(6);
                Column column = (Column)map.get(string4);
                string7 = Token.getValBetweenBrackets(string7);
                if (column != null) {
                    if ("C".equalsIgnoreCase(string6)) {
                        modelObject = new CheckConstraint();
                        modelObject.setName(string3);
                        ((CheckConstraint)modelObject).add(StorageDesignSqlServerv2k.RDBMS_TYPE, string7);
                        if (column == null) continue;
                        column.setUseDomainConstraints(false);
                        column.setCheck((CheckConstraint)modelObject);
                        continue;
                    }
                    if (!"D".equalsIgnoreCase(string6) || column == null) continue;
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(string7);
                    continue;
                }
                modelObject = table.createCheckConstraint(string3, string7);
                table.addCheckConstraint((TableLevelConstraint)modelObject);
                this.stampModelObject(modelObject, table.getSchema(), string3);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUniqueKeys(Connection connection, Table table, String string, String string2) throws Exception {
        Object object;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        Object object2;
        Object object3;
        Serializable serializable;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("USE").append(' ');
            ((StringBuffer)serializable).append(string2).append(' ');
            ((StringBuffer)serializable).append("SELECT").append(' ');
            ((StringBuffer)serializable).append("i").append('.');
            ((StringBuffer)serializable).append("NAME").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("index_id ");
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i").append('.');
            ((StringBuffer)serializable).append("TYPE").append(' ');
            ((StringBuffer)serializable).append(',').append(' ');
            ((StringBuffer)serializable).append("i.type_desc,is_primary_key,is_unique_constraint,is_unique, ");
            ((StringBuffer)serializable).append("ignore_dup_key,fill_factor,is_padded,allow_row_locks,allow_page_locks, ");
            ((StringBuffer)serializable).append("i.data_space_id,ds.name ds_name,ds.type ds_type,s.no_recompute AS [NoAutomaticRecomputation] ");
            ((StringBuffer)serializable).append("FROM").append(' ');
            ((StringBuffer)serializable).append("SYS").append('.').append("indexes i").append(' ');
            ((StringBuffer)serializable).append("INNER Join sys.data_spaces as ds ON i.data_space_id = ds.data_space_id ").append(' ');
            ((StringBuffer)serializable).append("LEFT OUTER JOIN sys.stats AS s ON s.stats_id = i.index_id AND s.object_id = i.object_id ");
            ((StringBuffer)serializable).append("WHERE").append(' ');
            ((StringBuffer)serializable).append("i.object_id").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)serializable).append("AND").append(' ');
            ((StringBuffer)serializable).append("(is_primary_key = 1 or is_unique_constraint = 1)");
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initUniqueKeys():", sQLException);
        }
        serializable = new ArrayList();
        if (resultSet != null) {
            while (resultSet.next()) {
                object3 = resultSet.getString(1);
                object2 = resultSet.getString(2);
                string9 = resultSet.getString(4);
                string8 = resultSet.getString(5);
                int n = resultSet.getInt(9);
                string7 = resultSet.getString(10);
                String string10 = resultSet.getString(11);
                string6 = resultSet.getString(12);
                string5 = resultSet.getString(14);
                string4 = resultSet.getString(15);
                string3 = resultSet.getString(16);
                object = new Properties();
                ((Properties)object).setProperty("name", (String)object3);
                ((Properties)object).setProperty("indId", (String)object2);
                ((Properties)object).setProperty("clustered", string9);
                ((Properties)object).setProperty("xtype", string8);
                ((Properties)object).setProperty("fillFactor", String.valueOf(n));
                ((Properties)object).setProperty("is_padded", string7);
                ((Properties)object).setProperty("allow_row_locks", string10);
                ((Properties)object).setProperty("allow_page_locks", string6);
                ((Properties)object).setProperty("ds_name", string5);
                ((Properties)object).setProperty("ds_type", string4);
                ((Properties)object).setProperty("StatRecompute", string3 != null ? string3 : "");
                serializable.add(object);
            }
        }
        object3 = serializable.iterator();
        while (object3.hasNext()) {
            AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
            DataBaseSqlServer dataBaseSqlServer;
            IndexProxy indexProxy;
            object2 = (Properties)object3.next();
            string9 = ((Properties)object2).getProperty("name");
            string8 = ((Properties)object2).getProperty("indId");
            String string11 = ((Properties)object2).getProperty("clustered");
            string7 = ((Properties)object2).getProperty("xtype");
            int n = Integer.parseInt(((Properties)object2).getProperty("fillFactor"));
            string6 = ((Properties)object2).getProperty("is_padded");
            string5 = ((Properties)object2).getProperty("allow_row_locks");
            string4 = ((Properties)object2).getProperty("allow_page_locks");
            string3 = ((Properties)object2).getProperty("ds_name");
            object = ((Properties)object2).getProperty("ds_type");
            String string12 = ((Properties)object2).getProperty("StatRecompute");
            Index index = table.createIndex();
            index.setName(string9);
            this.stampModelObject((ModelObject)index, table.getSchema(), string9);
            this.initKeyColumns(index, table, string, string8, string2, connection);
            StorageDesign storageDesign = this.getStorageDesign();
            StorageDesignSqlServer storageDesignSqlServer = null;
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
            }
            if ("1".equalsIgnoreCase(string7)) {
                index.setIndexState("Primary Constraint");
                if (storageDesignSqlServer != null) {
                    indexProxy = (PKProxySqlServerv2k5)storageDesignSqlServer.getPKProxySet().getProxy(index.getObjectID());
                    if (indexProxy != null) {
                        if ("CLUSTERED".equalsIgnoreCase(string11)) {
                            indexProxy.setClustered(true);
                        } else {
                            indexProxy.setClustered(false);
                        }
                        ((PKProxySqlServerv2k5)indexProxy).setFillFactor(n);
                        dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                        if (dataBaseSqlServer == null) {
                            dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                            dataBaseSqlServer.setName(string2);
                            this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                        }
                        if (((String)object).equalsIgnoreCase("FG")) {
                            abstractStorageObjectSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string3);
                            if (abstractStorageObjectSqlServer == null) {
                                abstractStorageObjectSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                                abstractStorageObjectSqlServer.setName(string3);
                                ((FileGroupSqlServer)abstractStorageObjectSqlServer).setDataBase(dataBaseSqlServer);
                                this.stampModelObject((ModelObject)abstractStorageObjectSqlServer, indexProxy, string3);
                            }
                            ((PKProxySqlServer)indexProxy).setFilegroup((FileGroupSqlServer)abstractStorageObjectSqlServer);
                        }
                        if (((String)object).equalsIgnoreCase("PS") && (abstractStorageObjectSqlServer = this.getPartitionSchemaByName(string3, dataBaseSqlServer)) != null) {
                            ((PKProxySqlServerv2k5)indexProxy).setPartitionScheme((PartitionSchemeSqlServer)abstractStorageObjectSqlServer);
                        }
                        if ("0".equals(string4)) {
                            ((PKProxySqlServerv2k5)indexProxy).setAllowPageLocks("OFF");
                        }
                        if ("0".equals(string5)) {
                            ((PKProxySqlServerv2k5)indexProxy).setAllowRowLocks("OFF");
                        }
                        if ("1".equals(string6)) {
                            ((PKProxySqlServerv2k5)indexProxy).setPadIndex("YES");
                        }
                        if (!"0".equals(string12)) continue;
                        ((PKProxySqlServerv2k5)indexProxy).setRecomputeStatistics("NO");
                        continue;
                    }
                    LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
                continue;
            }
            index.setIndexState("Unique Constraint");
            if (storageDesignSqlServer != null) {
                indexProxy = (UniqueProxySqlServerv2k5)storageDesignSqlServer.getUniqueProxySet().getProxy(index.getObjectID());
                if (indexProxy != null) {
                    if ("YES".equalsIgnoreCase(string11)) {
                        indexProxy.setClustered(true);
                    } else {
                        indexProxy.setClustered(false);
                    }
                    ((UniqueProxySqlServerv2k5)indexProxy).setFillFactor(n);
                    dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                    if (dataBaseSqlServer == null) {
                        dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                        dataBaseSqlServer.setName(string2);
                        this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                    }
                    if (((String)object).equalsIgnoreCase("FG")) {
                        abstractStorageObjectSqlServer = (FileGroupSqlServer)dataBaseSqlServer.getFilegroups().getByName(string3);
                        if (abstractStorageObjectSqlServer == null) {
                            abstractStorageObjectSqlServer = storageDesignSqlServer.getFileGroupSet().createFileGroup();
                            abstractStorageObjectSqlServer.setName(string3);
                            ((FileGroupSqlServer)abstractStorageObjectSqlServer).setDataBase(dataBaseSqlServer);
                            this.stampModelObject((ModelObject)abstractStorageObjectSqlServer, indexProxy, string3);
                        }
                        ((UniqueProxySqlServer)indexProxy).setFilegroup((FileGroupSqlServer)abstractStorageObjectSqlServer);
                    }
                    if (((String)object).equalsIgnoreCase("PS") && (abstractStorageObjectSqlServer = this.getPartitionSchemaByName(string3, dataBaseSqlServer)) != null) {
                        ((UniqueProxySqlServerv2k5)indexProxy).setPartitionScheme((PartitionSchemeSqlServer)abstractStorageObjectSqlServer);
                    }
                    if ("0".equals(string4)) {
                        ((UniqueProxySqlServerv2k5)indexProxy).setAllowPageLocks("OFF");
                    }
                    if ("0".equals(string5)) {
                        ((UniqueProxySqlServerv2k5)indexProxy).setAllowRowLocks("OFF");
                    }
                    if ("1".equals(string6)) {
                        ((UniqueProxySqlServerv2k5)indexProxy).setPadIndex("YES");
                    }
                    if (!"0".equals(string12)) continue;
                    ((UniqueProxySqlServerv2k5)indexProxy).setRecomputeStatistics("NO");
                    continue;
                }
                LOGGER.error("Unable to find IndexProxy for table ID: " + table.getObjectID());
                continue;
            }
            LOGGER.error("Unable to find Storage Design!");
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initKeyColumns(Index index, Table table, String string, String string2, String string3, Connection connection) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string3).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("c.name column_name, ic.column_id ,ic.is_descending_key,ic.key_ordinal ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("SYS").append('.').append("index_columns ic").append(' ');
            ((StringBuffer)charSequence).append(',').append("SYS").append('.').append("columns c ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("ic.object_id").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("index_id").append(' ').append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("is_included_column = 0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.object_id = ic.object_id  ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("c.column_id = ic.column_id  ");
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("ic.key_ordinal").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initKeyColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                int n = resultSet.getInt(3);
                Column column = (Column)table.getElementByName((String)charSequence);
                if (column == null) continue;
                index.add(column);
                if (n == 0) {
                    index.setColumnSortOrder(column, "ASC");
                    continue;
                }
                index.setColumnSortOrder(column, "DESC");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initTriggers(Connection connection, TableProxySqlServer tableProxySqlServer, String string, String string2) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ');
            ((StringBuffer)charSequence).append(string2).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("trigger_name").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o").append('.');
            ((StringBuffer)charSequence).append("ID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("trigger_owner").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("user_name(uid)").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isupdate = ObjectProperty( o.id, 'ExecIsUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isdelete = ObjectProperty( o.id, 'ExecIsDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isinsert = ObjectProperty( o.id, 'ExecIsInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isafter = ObjectProperty( o.id, 'ExecIsAfterTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isinsteadof = ObjectProperty( o.id, 'ExecIsInsteadOfTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstupdate = ObjectProperty( o.id, 'ExecIsFirstUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstdelete = ObjectProperty( o.id, 'ExecIsFirstDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isfirstinsert = ObjectProperty( o.id, 'ExecIsFirstInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastupdate = ObjectProperty( o.id, 'ExecIsLastUpdateTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastdelete = ObjectProperty( o.id, 'ExecIsLastDeleteTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("isLastinsert = ObjectProperty( o.id, 'ExecIsLastInsertTrigger')").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("s.encrypted").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("s.text trigger_definition").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append(string2).append('.').append("dbo.syscomments s").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("parent_obj").append(' ').append('=').append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("type = 'TR'").append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o.id = s.id").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTableSqlServer.initTriggers():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(3);
                int n = resultSet.getInt(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                int n6 = resultSet.getInt(9);
                int n7 = resultSet.getInt(10);
                int n8 = resultSet.getInt(11);
                int n9 = resultSet.getInt(12);
                int n10 = resultSet.getInt(13);
                int n11 = resultSet.getInt(14);
                int n12 = resultSet.getInt(15);
                String string4 = resultSet.getString(16);
                StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)tableProxySqlServer.getStorageDesign();
                TriggerSqlServer triggerSqlServer = storageDesignSqlServer.getTriggerSet().createTrigger();
                triggerSqlServer.setName((String)charSequence);
                triggerSqlServer.setTable(tableProxySqlServer);
                this.stampModelObject((ModelObject)triggerSqlServer, tableProxySqlServer, (String)charSequence);
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageDesignSqlServer.getSchemaSet().getByName(string3);
                if (schemaSqlServerv2k5 != null) {
                    triggerSqlServer.setSchema(schemaSqlServerv2k5);
                }
                if (n == 1) {
                    triggerSqlServer.setActions("UPDATE");
                }
                if (n2 == 1) {
                    triggerSqlServer.setActions("DELETE");
                }
                if (n3 == 1) {
                    triggerSqlServer.setActions("INSERT");
                }
                if (n4 == 1) {
                    triggerSqlServer.setTriggerTime("AFTER");
                } else if (n5 == 1) {
                    triggerSqlServer.setTriggerTime("INSTEAD OF");
                }
                if (n7 == 1 || n8 == 1 || n6 == 1) {
                    triggerSqlServer.setExecutionOrder("FIRST");
                } else if (n10 == 1 || n11 == 1 || n9 == 1) {
                    triggerSqlServer.setExecutionOrder("LAST");
                }
                if (n12 == 1) {
                    triggerSqlServer.setEncription("YES");
                } else {
                    triggerSqlServer.setEncription("NO");
                }
                triggerSqlServer.setBody(string4);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }
}

