/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionColumnSqlServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "Partition";
    private static final Logger LOGGER = new Logger(MOHPartitionColumnSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;

    public MOHPartitionColumnSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            Iterator iterator = this.storage.getDataBaseSet().iterator();
            while (iterator.hasNext()) {
                this.database = (DataBaseSqlServerv2k5)iterator.next();
                if (this.database.isNullInstance()) continue;
                this.initPartitionColumnsForTables(connection, importLogger);
                this.initPartitionColumnsForIndexes(connection, importLogger);
            }
        }
    }

    private void initPartitionColumnsForTables(Connection connection, ImportLogger importLogger) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("tab.name table_name, sch.name [schema], ");
            ((StringBuffer)charSequence).append("cols.name [column], cols.column_id,partition_ordinal ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.index_columns icols, sys.columns cols, ");
            ((StringBuffer)charSequence).append("sys.tables tab, sys.schemas sch ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("partition_ordinal>0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.index_id < 2 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.object_id = cols.object_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.column_id = cols.column_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("tab.object_id = icols.object_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("tab.schema_id = sch.schema_id ");
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("table_name,partition_ordinal");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                TableProxySqlServerv2k5 tableProxySqlServerv2k5 = this.getTableByNameAndSchemaName((String)charSequence, string2);
                if (tableProxySqlServerv2k5 == null) continue;
                ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)tableProxySqlServerv2k5.getColumnProxyByName(string3);
                tableProxySqlServerv2k5.setPartitioningColumn(columnProxySqlServerv2k5);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initPartitionColumnsForIndexes(Connection connection, ImportLogger importLogger) throws Exception {
        CharSequence charSequence;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = this.database.getName();
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("USE").append(' ').append(string).append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("tab.name table_name, sch.name [schema], ");
            ((StringBuffer)charSequence).append("ind.name index_name, cols.name [column], ");
            ((StringBuffer)charSequence).append("cols.column_id,partition_ordinal, is_primary_key ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append("sys.index_columns icols, sys.columns cols, ");
            ((StringBuffer)charSequence).append("sys.tables tab, sys.schemas sch, sys.indexes ind ");
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("partition_ordinal>0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.index_id > 0 ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.object_id = cols.object_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("icols.column_id = cols.column_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("tab.object_id = icols.object_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("tab.schema_id = sch.schema_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("ind.index_id = icols.index_id ");
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("ind.object_id = icols.object_id ");
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("table_name,partition_ordinal");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                IndexProxy indexProxy;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(7);
                TableProxySqlServerv2k5 tableProxySqlServerv2k5 = this.getTableByNameAndSchemaName((String)charSequence, string2);
                if (tableProxySqlServerv2k5 == null) continue;
                IndexProxySqlServerv2k5 indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)tableProxySqlServerv2k5.getIndexes().getByName(string3);
                ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)tableProxySqlServerv2k5.getColumnProxyByName(string4);
                if (indexProxySqlServerv2k5 != null) {
                    indexProxySqlServerv2k5.setPartitioningColumn(columnProxySqlServerv2k5);
                    continue;
                }
                if ("1".equals(string5)) {
                    indexProxy = (PKProxySqlServerv2k5)tableProxySqlServerv2k5.getPkeys().getByName(string3);
                    if (indexProxy == null) continue;
                    ((PKProxySqlServerv2k5)indexProxy).setPartitioningColumn(columnProxySqlServerv2k5);
                    continue;
                }
                indexProxy = (UniqueProxySqlServerv2k5)tableProxySqlServerv2k5.getUkeys().getByName(string3);
                if (indexProxy == null) continue;
                ((UniqueProxySqlServerv2k5)indexProxy).setPartitioningColumn(columnProxySqlServerv2k5);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    public TableProxySqlServerv2k5 getTableByNameAndSchemaName(String string, String string2) {
        TableProxySqlServerv2k5 tableProxySqlServerv2k5 = null;
        Iterator iterator = this.database.getTables().iterator();
        while (iterator.hasNext()) {
            StorageObjectPlaceHolder storageObjectPlaceHolder = (StorageObjectPlaceHolder)iterator.next();
            tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)storageObjectPlaceHolder.getObject();
            if (!tableProxySqlServerv2k5.getName().equals(string) || tableProxySqlServerv2k5.getSchema() == null || !tableProxySqlServerv2k5.getSchema().getName().equals(string2)) continue;
            return tableProxySqlServerv2k5;
        }
        return null;
    }
}

