/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.DistinctTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeSqlServerv2k5.class);

    public MOHDatatypeSqlServerv2k5(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            String string3 = dBObjectSqlServer.getId();
            String string4 = dBObjectSqlServer.getUsertypeId();
            String string5 = dBObjectSqlServer.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("USE").append(' ');
                ((StringBuffer)charSequence).append(string2).append(' ');
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("st").append('.');
                ((StringBuffer)charSequence).append("NAME").append(' ');
                ((StringBuffer)charSequence).append(" AS [Name]").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("st.user_type_id AS [ID]").append(' ');
                ((StringBuffer)charSequence).append(',').append(' ');
                ((StringBuffer)charSequence).append("CAST(CASE WHEN baset.name IN (N'nchar', N'nvarchar') ");
                ((StringBuffer)charSequence).append("AND st.max_length <> -1 THEN st.max_length/2 ");
                ((StringBuffer)charSequence).append("ELSE st.max_length END AS int) AS [Length], ");
                ((StringBuffer)charSequence).append("CAST(st.precision AS int) AS [NumericPrecision], ");
                ((StringBuffer)charSequence).append("CAST(st.scale AS int) AS [NumericScale], ");
                ((StringBuffer)charSequence).append("st.max_length AS [MaxLength],");
                ((StringBuffer)charSequence).append("st.is_nullable AS [Nullable], ");
                ((StringBuffer)charSequence).append("(case when st.default_object_id = 0 then N'' else def.name end) AS [Default],");
                ((StringBuffer)charSequence).append("(case when st.default_object_id = 0 then N'' else  ");
                ((StringBuffer)charSequence).append("schema_name(def.schema_id) end) AS [DefaultSchema], ");
                ((StringBuffer)charSequence).append("(case when st.rule_object_id = 0 then N'' else rul.name end) AS [Rule], ");
                ((StringBuffer)charSequence).append("(case when st.rule_object_id = 0 then N'' else ");
                ((StringBuffer)charSequence).append("schema_name(rul.schema_id) end) AS [RuleSchema], ");
                ((StringBuffer)charSequence).append("st.collation_name AS [Collation], ");
                ((StringBuffer)charSequence).append("baset.name AS [SystemType] ");
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("sys.types AS st ");
                ((StringBuffer)charSequence).append("LEFT OUTER JOIN sys.types AS baset ON baset.user_type_id = ");
                ((StringBuffer)charSequence).append("st.system_type_id and baset.user_type_id = baset.system_type_id ");
                ((StringBuffer)charSequence).append("LEFT OUTER JOIN sys.objects AS def ON def.object_id = ");
                ((StringBuffer)charSequence).append("st.default_object_id ");
                ((StringBuffer)charSequence).append("LEFT OUTER JOIN sys.objects AS rul ON rul.object_id = st.rule_object_id ");
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("st.schema_id = ").append(string3).append(' ');
                ((StringBuffer)charSequence).append(" and st.user_type_id = ").append(string4).append(' ');
                ((StringBuffer)charSequence).append("and (st.schema_id!=4 and st.system_type_id!=240 and st.user_type_id != st.system_type_id)");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatatypeSqlServerv2k5.generate():", sQLException);
            }
            if (resultSet != null && resultSet.next()) {
                charSequence = resultSet.getString(7);
                String string6 = resultSet.getString(8);
                String string7 = resultSet.getString(9);
                String string8 = resultSet.getString(10);
                String string9 = resultSet.getString(11);
                DistinctType distinctType = this.getDesign().getDataTypesDesign().createDistinctType();
                distinctType.setName(string);
                this.setProperties(distinctType, resultSet);
                this.stampModelObject(distinctType, dBObjectSqlServer);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServerv2k5) {
                    StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)storageDesign;
                    DistinctTypeProxySqlServerv2k5 distinctTypeProxySqlServerv2k5 = (DistinctTypeProxySqlServerv2k5)storageDesignSqlServerv2k5.getProxy(distinctType);
                    DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageDesignSqlServerv2k5.getDataBaseSet().getByName(string2);
                    if (distinctTypeProxySqlServerv2k5 != null) {
                        if (dataBaseSqlServerv2k5 == null) {
                            dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)storageDesignSqlServerv2k5.getDataBaseSet().createDataBase();
                            dataBaseSqlServerv2k5.setName(string2);
                            this.stampModelObject((ModelObject)dataBaseSqlServerv2k5, "", string2);
                        }
                        UsedUserDefinedDatav2k5 usedUserDefinedDatav2k5 = (UsedUserDefinedDatav2k5)storageDesignSqlServerv2k5.getUsedUserDefinedDataSet().createUsedUserDefinedData();
                        usedUserDefinedDatav2k5.setName(string);
                        usedUserDefinedDatav2k5.setDatabase(dataBaseSqlServerv2k5);
                        usedUserDefinedDatav2k5.setDistinctTypeProxy(distinctTypeProxySqlServerv2k5);
                        this.stampModelObject((ModelObject)usedUserDefinedDatav2k5, dBObjectSqlServer.getSchema(), string);
                        SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)dataBaseSqlServerv2k5.getSchemas().getByName(string5);
                        if (schemaSqlServerv2k5 != null) {
                            usedUserDefinedDatav2k5.setSchema(schemaSqlServerv2k5);
                        }
                        if ("1".equals(charSequence)) {
                            distinctTypeProxySqlServerv2k5.setNullType(DistinctTypeProxy.NULL_STATES[0]);
                        } else {
                            distinctTypeProxySqlServerv2k5.setNullType(DistinctTypeProxy.NULL_STATES[1]);
                        }
                        String string10 = "";
                        if (!string9.equals("")) {
                            string10 = string9 + ".";
                        }
                        string10 = string10 + string8;
                        String string11 = "";
                        if (!string7.equals("")) {
                            string11 = string7 + ".";
                        }
                        string11 = string11 + string6;
                        ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).addToDefaultMap(string11, usedUserDefinedDatav2k5.getObjectID());
                        ((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).addToRuleMap(string10, usedUserDefinedDatav2k5.getObjectID());
                    }
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setProperties(DistinctType distinctType, ResultSet resultSet) throws Exception {
        String string = resultSet.getString(13);
        String string2 = resultSet.getString(6);
        String string3 = string != null ? string.toUpperCase() : "";
        int n = 0;
        int n2 = 0;
        try {
            n = resultSet.getInt(4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = resultSet.getInt(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = StandardDatatypeNames.getUsedDatatypeName(string);
        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), string4);
        if (logicalDatatype == null) {
            logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string4, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDatatype != null) {
            distinctType.setLogicalDataType(logicalDatatype);
            if (string3.indexOf("NCHAR") > -1 || string3.indexOf("NVARCHAR") > -1) {
                try {
                    int n3 = Integer.parseInt(string2) / 2;
                    distinctType.setSize(String.valueOf(n3));
                }
                catch (RuntimeException runtimeException) {
                    distinctType.setSize(string2);
                }
                distinctType.setScale(n2 / 2);
            } else {
                distinctType.setSize(string2);
                distinctType.setScale(n2);
            }
            distinctType.setPrecision(n);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getDb();
        String string2 = dBUserSqlServer.getId();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("userdef_name").append(' ').append(',');
            ((StringBuffer)charSequence).append("usertype ");
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.systypes t").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append('(').append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.systypes").append(' ');
            ((StringBuffer)charSequence).append(')').append(' ');
            ((StringBuffer)charSequence).append("st").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append("<>").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XUSERTYPE").append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("st").append('.').append("XTYPE").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatatypeSqlServerv2k5.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBUserSqlServer.getName());
                dBObjectSqlServer.setDb(string);
                dBObjectSqlServer.setId(string2);
                dBObjectSqlServer.setUsertypeId(string3);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

