/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureSqlServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureSqlServer.class);

    public MOHProcedureSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            CharSequence charSequence;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            String string3 = dBObjectSqlServer.getSchema();
            String string4 = dBObjectSqlServer.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            if ("".equalsIgnoreCase(string4)) {
                string4 = this.getID(connection, string, string3, string2);
            }
            if (string4 == null) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("S").append('.').append("TEXT").append(' ');
                ((StringBuffer)charSequence).append("DEFINITION").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string2).append('.').append("dbo.syscomments s").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("s").append('.').append("ID").append(' ');
                ((StringBuffer)charSequence).append('=').append(' ');
                ((StringBuffer)charSequence).append(string4);
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHProcedureSqlServer.generate():", sQLException);
            }
            charSequence = null;
            if (resultSet != null && resultSet.next()) {
                charSequence = resultSet.getString("DEFINITION");
            }
            if (statement != null) {
                statement.close();
            }
            if (charSequence != null) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer dataBaseSqlServer = null;
                    if (!"".equalsIgnoreCase(string2)) {
                        dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string2);
                        if (dataBaseSqlServer == null) {
                            dataBaseSqlServer = storageDesignSqlServer.getDataBaseSet().createDataBase();
                            dataBaseSqlServer.setName(string2);
                            this.stampModelObject((ModelObject)dataBaseSqlServer, "", string2);
                        }
                    } else {
                        dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getNullInstance();
                    }
                    StoredProcedureSqlServer storedProcedureSqlServer = ((StorageDesignSqlServer)storageDesign).getStoredProcedureSet().createStoredProcedure();
                    storedProcedureSqlServer.setName(string);
                    this.stampModelObject(storedProcedureSqlServer, dBObjectSqlServer);
                    storedProcedureSqlServer.setDatabase(dataBaseSqlServer);
                    this.setUser(storedProcedureSqlServer, (StorageDesignSqlServer)storageDesign, string3, string2, connection);
                    this.setProperties(storedProcedureSqlServer, (String)charSequence);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setUser(StoredProcedureSqlServer storedProcedureSqlServer, StorageDesignSqlServer storageDesignSqlServer, String string, String string2, Connection connection) {
        String string3;
        UserSqlServer userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByName(string);
        if (userSqlServer == null) {
            userSqlServer = storageDesignSqlServer.getUserSet().createUser();
            userSqlServer.setName(string);
            userSqlServer.setDatabase(storedProcedureSqlServer.getDatabase());
            this.stampModelObject((ModelObject)userSqlServer, string2, string);
        }
        if ((string3 = this.getLogin(string, string2, connection)) != null) {
            LoginSqlServer loginSqlServer = (LoginSqlServer)storageDesignSqlServer.getLoginSet().getByName(string3);
            if (loginSqlServer == null) {
                loginSqlServer = storageDesignSqlServer.getLoginSet().createLogin();
                loginSqlServer.setName(string3);
                this.stampModelObject((ModelObject)loginSqlServer, storedProcedureSqlServer, string3);
            }
            userSqlServer.setLogin(loginSqlServer);
            loginSqlServer.setUsers(string);
        }
        storedProcedureSqlServer.setOwner(userSqlServer);
    }

    private String getLogin(String string, String string2, Connection connection) {
        String string3 = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("l.loginname").append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append("master.dbo.syslogins l").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append(string2).append('.').append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("l").append('.').append("sid").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append("u").append('.').append("sid").append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ').append('\'');
            stringBuffer.append(string).append('\'').append(' ');
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHProcedureSqlServer.generate():", sQLException);
        }
        return string3;
    }

    private void setProperties(StoredProcedureSqlServer storedProcedureSqlServer, String string) throws Exception {
        if (string != null) {
            String string2;
            if (string.startsWith("CREATE PROCEDURE") && (string2 = Token.getStringAfter(string, "CREATE PROCEDURE")).startsWith(storedProcedureSqlServer.getName())) {
                string = string2.substring(storedProcedureSqlServer.getName().length());
            }
            storedProcedureSqlServer.setBody(string.trim());
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private String getID(Connection connection, String string, String string2, String string3) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string4 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT").append(' ');
            stringBuffer.append("o").append('.').append("NAME").append(' ');
            stringBuffer.append("PROCNAME").append(' ');
            stringBuffer.append(',').append(' ');
            stringBuffer.append("o").append('.').append("ID").append(' ');
            stringBuffer.append("PROCID").append(' ');
            stringBuffer.append("FROM").append(' ');
            if (!"".equalsIgnoreCase(string3)) {
                stringBuffer.append(string3).append('.');
            }
            stringBuffer.append("dbo.sysobjects o").append(' ');
            stringBuffer.append(',').append(' ');
            if (!"".equalsIgnoreCase(string3)) {
                stringBuffer.append(string3).append('.');
            }
            stringBuffer.append("dbo.sysusers u").append(' ');
            stringBuffer.append("WHERE").append(' ');
            stringBuffer.append("XTYPE").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append('\'').append("P").append('\'').append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("u").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append('\'').append(string2).append('\'').append(' ');
            stringBuffer.append("AND").append(' ');
            stringBuffer.append("o").append('.').append("NAME").append(' ');
            stringBuffer.append('=').append(' ');
            stringBuffer.append('\'').append(string).append('\'');
            resultSet = statement.executeQuery(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHProcedureSqlServerv2k5.extract():", sQLException);
        }
        if (resultSet != null && resultSet.next()) {
            string4 = resultSet.getString(2);
        }
        if (statement != null) {
            statement.close();
        }
        return string4;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getDb();
        String string2 = dBUserSqlServer.getUid();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("PROCNAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("ID").append(' ');
            ((StringBuffer)charSequence).append("PROCID").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("u").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("USERNAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.sysobjects o").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.sysusers u").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append('\'').append("P").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ').append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("-- user id").append("\n");
            ((StringBuffer)charSequence).append("o").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("u").append('.').append("UID").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHProcedureSqlServer.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, "");
                dBObjectSqlServer.setSchema(string4);
                dBObjectSqlServer.setDb(string);
                dBObjectSqlServer.setId(string3);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

