/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeSqlServer.class);

    public MOHDatatypeSqlServer(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)list.get(i);
            String string = dBObjectSqlServer.getName();
            String string2 = dBObjectSqlServer.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObjectSqlServer.getType())) continue;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("st").append('.');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append("SYSTYPE").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("LENGTH").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("PREC").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("SCALE").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("ALLOWNULLS").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(string2).append('.').append("dbo.systypes t").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append('(').append(' ');
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append(',').append(' ');
                ((StringBuffer)object).append("XTYPE").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(string2).append('.').append("dbo.systypes").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ').append("XUSERTYPE").append(' ');
                ((StringBuffer)object).append('=').append(' ').append("XTYPE").append(' ');
                ((StringBuffer)object).append(')').append(' ');
                ((StringBuffer)object).append("st").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("t").append('.').append("NAME").append(' ');
                ((StringBuffer)object).append('=').append(' ').append('\'');
                ((StringBuffer)object).append(string).append('\'').append(' ');
                ((StringBuffer)object).append("AND").append(' ');
                ((StringBuffer)object).append("t").append('.').append("XTYPE").append(' ');
                ((StringBuffer)object).append('=').append(' ');
                ((StringBuffer)object).append("st").append('.').append("XTYPE").append(' ');
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatatypeSqlServer.generate():", sQLException);
            }
            if (resultSet != null && resultSet.next()) {
                object = this.getDesign().getDataTypesDesign().createDistinctType();
                ((DesignObject)object).setName(string);
                this.stampModelObject((ModelObject)object, dBObjectSqlServer);
                this.setProperties((DistinctType)object, resultSet);
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObjectSqlServer);
        }
    }

    private void setProperties(DistinctType distinctType, ResultSet resultSet) throws Exception {
        String string = resultSet.getString("SYSTYPE");
        String string2 = resultSet.getString("LENGTH");
        int n = 0;
        int n2 = 0;
        try {
            n = resultSet.getInt("PREC");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = resultSet.getInt("SCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = StandardDatatypeNames.getUsedDatatypeName(string);
        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), string3);
        if (logicalDatatype == null) {
            logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string3, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDatatype != null) {
            distinctType.setLogicalDataType(logicalDatatype);
            distinctType.setSize(string2);
            distinctType.setScale(n2);
            distinctType.setPrecision(n);
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DBObject dBObject : list) {
            DBUserSqlServer dBUserSqlServer;
            if (!dBObject.isSelected() || !(dBObject instanceof DBUserSqlServer) || this.containsDboForDb(list, dBUserSqlServer = (DBUserSqlServer)dBObject)) continue;
            arrayList.addAll(this.extractByUser(connection, dBUserSqlServer));
        }
        return arrayList;
    }

    private List extractByUser(Connection connection, DBUserSqlServer dBUserSqlServer) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObjectSqlServer> arrayList = new ArrayList<DBObjectSqlServer>();
        String string = dBUserSqlServer.getDb();
        String string2 = dBUserSqlServer.getUid();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ').append("DISTINCT").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("NAME").append(' ');
            ((StringBuffer)charSequence).append("userdef_name").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.systypes t").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append('(').append(' ');
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("NAME").append(' ');
            ((StringBuffer)charSequence).append(',').append(' ');
            ((StringBuffer)charSequence).append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(string).append('.').append("dbo.systypes").append(' ');
            ((StringBuffer)charSequence).append(')').append(' ');
            ((StringBuffer)charSequence).append("st").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("UID").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append(string2).append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append("<>").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XUSERTYPE").append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("t").append('.').append("XTYPE").append(' ');
            ((StringBuffer)charSequence).append('=').append(' ');
            ((StringBuffer)charSequence).append("st").append('.').append("XTYPE").append(' ');
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatatypeSqlServer.extract():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBUserSqlServer.getSchema());
                dBObjectSqlServer.setDb(string);
                arrayList.add(dBObjectSqlServer);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }
}

