/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHCommentsSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDatabaseSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDatatypeSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDefaultSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHForeignKeySQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHLoginSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHPermissionsSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHProcedureSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHRoleSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHRuleSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHTableSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHViewSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDatatypeSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDefaultSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHForeignKeySQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHLoginSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPermissionsSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHRoleSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHRuleSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHSchemaSqlServer2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHTableSQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHUserSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHViewSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHXMLSchemaCollection;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.logging.Logger;

public class DBMExtractionHandlerSQLServer
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static final Logger LOGGER = new Logger(DBMExtractionHandlerSQLServer.class);
    private static DBMExtractionHandlerSQLServer dbmExtractionHandler;
    private List mohObjects = null;
    private List mohObjectsv2k5 = null;
    private ApplicationView view;
    private List loginList = null;
    private static final String SQL_SERVER_V2K = "Microsoft SQL Server 2000";
    private static final String SQL_SERVER_V2K5 = "Microsoft SQL Server 2005";
    private static final String SQL_SERVER_V2K8 = "Microsoft SQL Server 2008";
    private Map defaultMap = new HashMap();
    private Map ruleMap = new HashMap();

    private DBMExtractionHandlerSQLServer(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView applicationView) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerSQLServer(applicationView);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 0: {
                return this.getMOHObjectsv2k();
            }
        }
        return this.getMOHObjectsv2k5();
    }

    private List getMOHObjectsv2k5() {
        if (this.mohObjectsv2k5 == null) {
            this.mohObjectsv2k5 = new ArrayList();
            this.mohObjectsv2k5.add(new MOHSchemaSqlServer2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDatatypeSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDatabaseSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHLoginSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHUserSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHXMLSchemaCollection(this, this.view));
            this.mohObjectsv2k5.add(new MOHPartitionFunctionSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHTableSQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHForeignKeySQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHPartitionColumnSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHViewSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDefaultSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHRoleSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHRuleSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHProcedureSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHPermissionsSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHCommentsSqlServer(this, this.view));
        }
        return this.mohObjectsv2k5;
    }

    public List getMOHObjectsv2k() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHDatatypeSqlServer(this, this.view));
            this.mohObjects.add(new MOHDatabaseSqlServer(this, this.view));
            this.mohObjects.add(new MOHLoginSqlServer(this, this.view));
            this.mohObjects.add(new MOHUserSqlServer(this, this.view));
            this.mohObjects.add(new MOHTableSQLServer(this, this.view));
            this.mohObjects.add(new MOHForeignKeySQLServer(this, this.view));
            this.mohObjects.add(new MOHViewSqlServer(this, this.view));
            this.mohObjects.add(new MOHDefaultSqlServer(this, this.view));
            this.mohObjects.add(new MOHRoleSqlServer(this, this.view));
            this.mohObjects.add(new MOHRuleSqlServer(this, this.view));
            this.mohObjects.add(new MOHProcedureSqlServer(this, this.view));
            this.mohObjects.add(new MOHPermissionsSqlServer(this, this.view));
            this.mohObjects.add(new MOHCommentsSqlServer(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public List getSchemas(Connection connection) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (connection != null) {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = this.getDatabaseMajorVersion(connection);
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
            ResultSet resultSet = databaseMetaData.getCatalogs();
            List list = null;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                arrayList2.add(string);
            }
            resultSet.close();
            for (String string : arrayList2) {
                if (this.dbMajorVersion == 0) {
                    list = this.getUsers(string, connection);
                } else if (this.dbMajorVersion == 1) {
                    list = this.getSchemas(string, connection);
                }
                if (list.isEmpty()) continue;
                DBObject dBObject = new DBObject(false, string, "DATABASE");
                arrayList.add(dBObject);
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSchemas(String string, Connection connection) throws Exception {
        Object object;
        ArrayList<DBUserSqlServer> arrayList = new ArrayList<DBUserSqlServer>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append("AS").append(' ');
                ((StringBuffer)object).append("schema_name").append(',');
                ((StringBuffer)object).append("schema_id").append(',');
                ((StringBuffer)object).append("principal_id").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(string).append(".sys.schemas").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("NAME").append(' ');
                ((StringBuffer)object).append("NOT").append(' ').append("IN").append(' ');
                ((StringBuffer)object).append('(').append("'db_owner'").append(',');
                ((StringBuffer)object).append("'db_accessadmin'").append(',');
                ((StringBuffer)object).append("'db_backupoperator'").append(',');
                ((StringBuffer)object).append("'db_datareader'").append(',');
                ((StringBuffer)object).append("'db_datawriter'").append(',');
                ((StringBuffer)object).append("'db_ddladmin'").append(',');
                ((StringBuffer)object).append("'db_denydatareader'").append(',');
                ((StringBuffer)object).append("'db_denydatawriter'").append(',');
                ((StringBuffer)object).append("'db_securityadmin'").append(',');
                ((StringBuffer)object).append("'INFORMATION_SCHEMA'").append(')');
                ((StringBuffer)object).append("ORDER BY").append(' ').append("NAME");
                resultSet = statement.executeQuery(((StringBuffer)object).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getSchemas(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    object = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    DBUserSqlServer dBUserSqlServer = new DBUserSqlServer(false, (String)object, "Schema");
                    dBUserSqlServer.setUid(string3);
                    dBUserSqlServer.setDb(string);
                    dBUserSqlServer.setId(string2);
                    arrayList.add(dBUserSqlServer);
                }
            }
            object = arrayList;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return object;
    }

    private int getDatabaseMajorVersion(Connection connection) throws Exception {
        int n = 0;
        n = 1;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT @@VERSION");
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    if (Token.hasString(string, SQL_SERVER_V2K)) {
                        n = 0;
                        continue;
                    }
                    if (Token.hasString(string, SQL_SERVER_V2K5)) {
                        n = 1;
                        continue;
                    }
                    if (!Token.hasString(string, SQL_SERVER_V2K8)) continue;
                    n = 1;
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("DBMExtractionHandlerSQLServer.getDatabaseMajorVersion(): " + sQLException.getMessage());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getUsers(String string, Connection connection) throws Exception {
        ArrayList<DBUserSqlServer> arrayList = new ArrayList<DBUserSqlServer>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            CharSequence charSequence;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("NAME").append(' ').append(',');
                ((StringBuffer)charSequence).append("UID").append(' ').append(',');
                ((StringBuffer)charSequence).append("sid").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(string).append(".dbo.sysusers").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getUsers(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = "0x" + resultSet.getString(3);
                    String string4 = this.getLogin(string3, connection);
                    String string5 = string4 + " / " + (String)charSequence;
                    if (string4 == null && !((String)charSequence).equalsIgnoreCase("guest")) {
                        string5 = "BUILTIN\\Admin / " + (String)charSequence;
                    }
                    DBUserSqlServer dBUserSqlServer = new DBUserSqlServer(false, string5, "Login / User");
                    dBUserSqlServer.setUid(string2);
                    dBUserSqlServer.setDb(string);
                    arrayList.add(dBUserSqlServer);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLogin(String string, Connection connection) throws Exception {
        StringBuffer stringBuffer;
        ResultSet resultSet = null;
        Statement statement = connection.createStatement();
        try {
            CharSequence charSequence;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("loginname").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("master.dbo.syslogins").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("sid").append('=').append(string);
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getLogin(): " + sQLException.getMessage());
            }
            charSequence = null;
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                }
            }
            stringBuffer = charSequence;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getLogins(Connection connection) throws Exception {
        if (this.loginList == null) {
            ResultSet resultSet;
            Statement statement;
            block6: {
                this.loginList = new ArrayList();
                statement = connection.createStatement();
                resultSet = null;
                try {
                    CharSequence charSequence;
                    try {
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append("SELECT").append(' ');
                        ((StringBuffer)charSequence).append("sid").append(' ');
                        ((StringBuffer)charSequence).append("FROM").append(' ');
                        ((StringBuffer)charSequence).append("master.dbo.syslogins");
                        resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
                    }
                    catch (SQLException sQLException) {
                        LOGGER.error("DBMExtractionHandlerSQLServer.getLogins(): " + sQLException.getMessage());
                    }
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        charSequence = resultSet.getString(1);
                        this.loginList.add("0x" + (String)charSequence);
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(resultSet, statement);
                    throw throwable;
                }
            }
            JDBCUtils.close(resultSet, statement);
        }
        return this.loginList;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 0: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
    }

    public Map getDefaultMap() {
        return this.defaultMap;
    }

    public Map getRuleMap() {
        return this.ruleMap;
    }

    public void addToDefaultMap(String string, String string2) {
        if (!string.equals("")) {
            List<String> list = new ArrayList<String>();
            if (this.defaultMap.containsKey(string)) {
                list = (List)this.defaultMap.get(string);
            }
            list.add(string2);
            this.defaultMap.put(string, list);
        }
    }

    public void addToRuleMap(String string, String string2) {
        if (!string.equals("")) {
            List<String> list = new ArrayList<String>();
            if (this.ruleMap.containsKey(string)) {
                list = (List)this.ruleMap.get(string);
            }
            list.add(string2);
            this.ruleMap.put(string, list);
        }
    }
}

