/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUndoTableSpaceOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "UNDO TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHUndoTableSpaceOraclev9i.class);
    protected boolean dbaUser;

    public MOHUndoTableSpaceOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("NOT").append(' ').append("IN").append(' ');
            ((StringBuffer)charSequence).append('(').append('\'');
            ((StringBuffer)charSequence).append("SYSTEM").append('\'').append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("CONTENTS").append('=').append('\'');
            ((StringBuffer)charSequence).append("UNDO").append('\'').append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            System.out.println("MOHUndoTableSpaceOraclev9i.extract(): " + exception.getMessage());
            LOGGER.error("MOHUndoTableSpaceOraclev9i.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign instanceof StorageDesignOraclev9i) {
                UndoTablespaceOracle undoTablespaceOracle = ((StorageDesignOraclev9i)storageDesign).getUndoTablespaceSet().createTablespace();
                undoTablespaceOracle.setName(dBObject.getName());
                this.stampModelObject(undoTablespaceOracle, dBObject);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }
}

