/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableOraclev9i
extends MOHTableOracle {
    private static final Logger LOGGER = new Logger(MOHTableOraclev9i.class);
    private PreparedStatement xmlTypeCols_st = null;

    public MOHTableOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    public MOHTableOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView, bl);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        Statement statement = null;
        Statement statement2 = null;
        for (DBObject dBObject : list) {
            Object object;
            String string;
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            String string2 = dBObject.getName();
            ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                if (statement == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT").append(' ');
                    ((StringBuffer)charSequence).append("TABLE_NAME").append(' ').append(',');
                    ((StringBuffer)charSequence).append("TABLE_TYPE").append(' ').append(',');
                    ((StringBuffer)charSequence).append("TABLE_TYPE_OWNER").append(',');
                    ((StringBuffer)charSequence).append("TYPECODE").append(' ').append(',');
                    ((StringBuffer)charSequence).append("SUPERTYPE_OWNER").append(' ').append(',');
                    ((StringBuffer)charSequence).append("SUPERTYPE_NAME").append(' ');
                    ((StringBuffer)charSequence).append("FROM").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ').append("a").append(',').append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_types" : "all_types").append(' ').append("b").append(' ');
                    ((StringBuffer)charSequence).append("WHERE").append(' ').append("IOT_NAME").append(' ').append("IS").append(' ').append("NULL").append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append('(');
                    ((StringBuffer)charSequence).append("IOT_TYPE").append(' ').append("IS").append(' ').append("NULL").append(' ');
                    ((StringBuffer)charSequence).append("OR").append(' ').append("IOT_TYPE").append(' ').append('=').append(' ').append("'IOT'");
                    ((StringBuffer)charSequence).append(')').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append("NESTED").append('=').append('\'').append("NO").append('\'').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
                    if (!this.getDbmeHandler().isSecondaryTables()) {
                        ((StringBuffer)charSequence).append("AND").append(' ');
                        ((StringBuffer)charSequence).append("SECONDARY").append('=').append('\'').append("N").append('\'').append(' ');
                    }
                    ((StringBuffer)charSequence).append("AND").append(' ').append("NOT").append(' ').append("EXISTS").append(' ').append('(');
                    ((StringBuffer)charSequence).append("SELECT").append(' ').append('1').append(' ');
                    ((StringBuffer)charSequence).append("FROM").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_queue_tables" : "all_queue_tables").append(' ').append("c").append(' ');
                    ((StringBuffer)charSequence).append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append("c.").append("QUEUE_TABLE").append(' ').append('=').append(' ').append("a.").append("TABLE_NAME").append(')').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append("a.").append("TABLE_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ').append("a.").append("TABLE_TYPE").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ').append("(+)").append(' ');
                    ((StringBuffer)charSequence).append("ORDER BY").append(' ').append("TABLE_NAME");
                    statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                statement.setString(1, string2);
                statement.setString(2, string2);
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHTableOraclev9i.extract(): " + exception.getMessage());
                LOGGER.error("MOHTableOraclev9i.extract():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString("TABLE_NAME");
                    string = resultSet.getString("TABLE_TYPE_OWNER");
                    String string3 = resultSet.getString("TABLE_TYPE");
                    object = resultSet.getString("TYPECODE");
                    String string4 = resultSet.getString("SUPERTYPE_OWNER");
                    String string5 = resultSet.getString("SUPERTYPE_NAME");
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "TABLE", string2);
                    dBObject2.setTypeName(string3);
                    dBObject2.setTypeOwner(string);
                    dBObject2.setTypeCode((String)object);
                    dBObject2.setSuperTypeOwner(string4);
                    dBObject2.setSuperTypeName(string5);
                    arrayList2.add(dBObject2);
                }
                resultSet.close();
            }
            try {
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT").append(' ');
                    ((StringBuffer)charSequence).append("TABLE_NAME").append(' ');
                    ((StringBuffer)charSequence).append("FROM").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ').append("a").append(' ');
                    ((StringBuffer)charSequence).append("WHERE").append(' ');
                    ((StringBuffer)charSequence).append("OWNER").append('=').append('?');
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                statement2.setString(1, string2);
                resultSet2 = statement2.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHTableOraclev9i.extract() external tables: " + exception.getMessage());
                LOGGER.error("MOHTableOraclev9i.extract() external tables:", exception);
            }
            if (resultSet2 != null) {
                charSequence = arrayList2.toArray();
                block6: while (resultSet2.next()) {
                    string = resultSet2.getString("TABLE_NAME");
                    for (int i = 0; i < ((CharSequence)charSequence).length; ++i) {
                        object = (DBObject)((Object)charSequence[i]);
                        if (!((DBObject)object).getName().equals(string)) continue;
                        arrayList2.remove(object);
                        continue block6;
                    }
                }
                resultSet2.close();
            }
            arrayList.addAll(arrayList2);
        }
        if (statement2 != null) {
            statement2.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    @Override
    protected void initColumns(Connection connection, List list) throws Exception {
        this.xmlTypeCols_st = null;
        boolean bl = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        TreeMap<String, TypeHolder> treeMap = new TreeMap<String, TypeHolder>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        stringBuffer.append("a.").append("COLUMN_NAME").append(',');
        stringBuffer.append("DATA_TYPE").append(',');
        stringBuffer.append("DATA_TYPE_MOD").append(',');
        stringBuffer.append("DATA_TYPE_OWNER").append(',');
        stringBuffer.append("DATA_LENGTH").append(',');
        stringBuffer.append("DATA_PRECISION").append(',');
        stringBuffer.append("DATA_SCALE").append(',');
        stringBuffer.append("CHAR_USED").append(',');
        stringBuffer.append("CHAR_LENGTH").append(',');
        stringBuffer.append("NULLABLE").append(',');
        if (bl) {
            stringBuffer.append("VIRTUAL_COLUMN").append(',');
        }
        stringBuffer.append("DEFAULT_LENGTH").append(',');
        stringBuffer.append("DATA_DEFAULT").append(',');
        stringBuffer.append("COMMENTS").append(' ');
        stringBuffer.append("FROM").append(' ');
        if (bl) {
            stringBuffer.append(this.dbaUser ? "dba_tab_cols" : "all_tab_cols").append(' ').append("a").append(',');
        } else {
            stringBuffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(',');
        }
        stringBuffer.append(this.dbaUser ? "dba_col_comments" : "all_col_comments").append(' ').append("b").append(' ');
        stringBuffer.append("WHERE").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("OWNER").append('=');
        stringBuffer.append("b.").append("OWNER").append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("TABLE_NAME").append('=');
        stringBuffer.append("b.").append("TABLE_NAME").append(' ');
        stringBuffer.append("AND").append(' ');
        stringBuffer.append("a.").append("COLUMN_NAME").append('=');
        stringBuffer.append("b.").append("COLUMN_NAME").append(' ');
        stringBuffer.append("ORDER BY").append(' ');
        stringBuffer.append("COLUMN_ID");
        String string = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (DBObject dBObject : list) {
            Table table = dBObject.getTable();
            if (table.isBST()) continue;
            ResultSet resultSet = null;
            try {
                preparedStatement.setString(1, dBObject.getSchema());
                preparedStatement.setString(2, dBObject.getName());
                resultSet = preparedStatement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHTableOraclev9i.initColumns():", exception);
            }
            RDBMSType rDBMSType = this.getStorageDesign().getRDBMSType();
            if (resultSet == null) continue;
            boolean bl2 = false;
            while (resultSet.next()) {
                String string2;
                String string3 = resultSet.getString("COLUMN_NAME");
                String string4 = resultSet.getString("DATA_TYPE");
                String string5 = resultSet.getString("DATA_TYPE_MOD");
                String string6 = resultSet.getString("DATA_TYPE_OWNER");
                String string7 = resultSet.getString("DATA_PRECISION");
                int n = resultSet.getInt("DATA_LENGTH");
                int n2 = 0;
                if (string7 != null) {
                    try {
                        n2 = Integer.valueOf(string7);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int n3 = resultSet.getInt("DATA_SCALE");
                String string8 = resultSet.getString("CHAR_USED");
                string8 = string8 == null ? "" : (string8.equalsIgnoreCase("C") ? " CHAR" : (string8.equalsIgnoreCase("B") ? " BYTE" : ""));
                int n4 = resultSet.getInt("CHAR_LENGTH");
                String string9 = resultSet.getString("NULLABLE");
                String string10 = bl ? resultSet.getString("VIRTUAL_COLUMN") : "";
                String string11 = resultSet.getString("DATA_DEFAULT");
                String string12 = resultSet.getString("COMMENTS");
                Column column = table.createColumn(string3);
                this.stampModelObject((ModelObject)column, table.getName(), string3);
                string4 = this.removeBrackets(string4).trim();
                TypeHolder typeHolder = (TypeHolder)treeMap.get(string4);
                if (typeHolder == null) {
                    Object object;
                    typeHolder = new TypeHolder();
                    treeMap.put(string4, typeHolder);
                    string2 = StandardDatatypeNames.getUsedDatatypeName(string4);
                    LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string2);
                    NativeDBType nativeDBType = null;
                    if (logicalDatatype == null) {
                        nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string2);
                        if (nativeDBType == null && string6 != null) {
                            nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string6 + "." + string2);
                        }
                        if (nativeDBType != null) {
                            logicalDatatype = nativeDBType.getLogicalDatatype();
                        }
                    }
                    if (logicalDatatype == null) {
                        logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string4, this.getDbmeHandler().getRDBMSSite().getType().getName());
                    }
                    boolean bl3 = false;
                    if (logicalDatatype == null || logicalDatatype != null && "UNKNOWN".equalsIgnoreCase(string2) || nativeDBType != null && !"".equals(nativeDBType.getTypeKind())) {
                        object = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string4);
                        if (object != null) {
                            column.setUse((short)3);
                            if (string5 != null && "REF".equalsIgnoreCase(string5)) {
                                column.setReference(true);
                            }
                            column.setStructuredType((StructuredType)object);
                            typeHolder.strDT = true;
                            typeHolder.strdt = object;
                            bl3 = true;
                        } else {
                            CollectionType collectionType = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string4);
                            if (collectionType != null) {
                                column.setUse((short)4);
                                column.setCollectionType(collectionType);
                                typeHolder.colDT = true;
                                typeHolder.coldt = collectionType;
                                bl3 = true;
                            }
                        }
                    }
                    if (!bl3) {
                        if (logicalDatatype != null && !"UNKNOWN".equalsIgnoreCase(string2)) {
                            object = string4.toUpperCase();
                            column.setUse((short)1);
                            column.setLogicalDatatype(logicalDatatype);
                            typeHolder.ldt = logicalDatatype;
                            typeHolder.logicalDT = true;
                            if (string4.equalsIgnoreCase("CHAR") || string4.equalsIgnoreCase("VARCHAR2") || string4.equalsIgnoreCase("VARCHAR")) {
                                this.setParameter(column, "size", Integer.toString(n4) + string8);
                            } else if (string4.equalsIgnoreCase("NCHAR") || string4.equalsIgnoreCase("NVARCHAR2") || string4.equalsIgnoreCase("NVARCHAR")) {
                                this.setParameter(column, "size", Integer.toString(n4));
                            } else if (((String)object).indexOf("TIMESTAMP".trim()) < 0) {
                                this.setParameter(column, "size", n);
                            }
                            if (((String)object).indexOf("TIMESTAMP".trim()) > -1) {
                                this.setParameter(column, "precision", n3);
                            } else if (string7 != null) {
                                this.setParameter(column, "precision", n2);
                                this.setParameter(column, "scale", n3);
                                column.setDataTypeSize(null);
                            }
                        } else {
                            logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("UNKNOWN");
                            column.setUse((short)1);
                            column.setLogicalDatatype(logicalDatatype);
                            typeHolder.ukndt = logicalDatatype;
                            typeHolder.unknownDT = true;
                        }
                    }
                } else if (typeHolder.logicalDT) {
                    string2 = string4.toUpperCase();
                    column.setUse((short)1);
                    column.setLogicalDatatype(typeHolder.ldt);
                    if (string4.equalsIgnoreCase("CHAR") || string4.equalsIgnoreCase("VARCHAR2") || string4.equalsIgnoreCase("VARCHAR")) {
                        this.setParameter(column, "size", Integer.toString(n4) + string8);
                    } else if (string4.equalsIgnoreCase("NCHAR") || string4.equalsIgnoreCase("NVARCHAR2") || string4.equalsIgnoreCase("NVARCHAR")) {
                        this.setParameter(column, "size", Integer.toString(n4));
                    } else if (string2.indexOf("TIMESTAMP".trim()) < 0) {
                        this.setParameter(column, "size", n);
                    }
                    if (string2.indexOf("TIMESTAMP".trim()) > -1) {
                        this.setParameter(column, "precision", n3);
                    } else if (string7 != null) {
                        this.setParameter(column, "precision", n2);
                        this.setParameter(column, "scale", n3);
                        column.setDataTypeSize(null);
                    }
                } else if (typeHolder.strDT) {
                    column.setUse((short)3);
                    column.setStructuredType(typeHolder.strdt);
                    if (string5 != null && "REF".equalsIgnoreCase(string5)) {
                        column.setReference(true);
                    }
                } else if (typeHolder.colDT) {
                    column.setUse((short)4);
                    column.setCollectionType(typeHolder.coldt);
                } else {
                    column.setUse((short)1);
                    column.setLogicalDatatype(typeHolder.ukndt);
                }
                column.setNullsAllowed("Y".equalsIgnoreCase(string9));
                column.setComputed("YES".equalsIgnoreCase(string10));
                if (string11 != null) {
                    string11 = string11.trim();
                    if (column.isComputed().booleanValue()) {
                        column.setFormulaDesc(string11);
                        column.setSourceType("Derived");
                    } else {
                        column.setDefaultValue(string11);
                    }
                }
                if (string12 != null) {
                    column.setCommentInRDBMS(string12);
                }
                if (string4.equalsIgnoreCase("BLOB") || string4.equalsIgnoreCase("CLOB") || string4.equalsIgnoreCase("NCLOB") || column.getUse() == 3) {
                    dBObject.hasLOBs = true;
                    continue;
                }
                if (!string4.equalsIgnoreCase("XMLTYPE")) continue;
                bl2 = true;
            }
            resultSet.close();
            if (!bl2) continue;
            this.initXMLTypeColumns(connection, dBObject);
        }
        if (this.xmlTypeCols_st != null) {
            this.xmlTypeCols_st.close();
            this.xmlTypeCols_st = null;
        }
        preparedStatement.close();
    }

    protected void initXMLTypeColumns(Connection connection, DBObject dBObject) throws Exception {
        Object object;
        Object object2;
        boolean bl = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        Table table = dBObject.getTable();
        if (this.xmlTypeCols_st == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ');
            ((StringBuffer)object2).append("COLUMN_NAME").append(',');
            ((StringBuffer)object2).append("XMLSCHEMA").append(',');
            ((StringBuffer)object2).append("ELEMENT_NAME").append(',');
            ((StringBuffer)object2).append("STORAGE_TYPE");
            if (bl) {
                ((StringBuffer)object2).append(',');
                ((StringBuffer)object2).append("ANYSCHEMA").append(',');
                ((StringBuffer)object2).append("NONSCHEMA");
            }
            ((StringBuffer)object2).append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_xml_tab_cols" : "all_xml_tab_cols").append(' ').append("a").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ');
            ((StringBuffer)object2).append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            object = ((StringBuffer)object2).toString();
            this.xmlTypeCols_st = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.xmlTypeCols_st.setString(1, dBObject.getSchema());
            this.xmlTypeCols_st.setString(2, table.getName());
            object2 = this.xmlTypeCols_st.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHTableOraclev9i.initXMLTypeColumns():", exception);
        }
        if (object2 != null) {
            object = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            while (object2.next()) {
                ColumnProxyOraclev9i columnProxyOraclev9i;
                String string = object2.getString("COLUMN_NAME");
                String string2 = object2.getString("XMLSCHEMA");
                String string3 = object2.getString("ELEMENT_NAME");
                String string4 = object2.getString("STORAGE_TYPE");
                String string5 = null;
                String string6 = null;
                if (bl) {
                    string5 = object2.getString("ANYSCHEMA");
                    string6 = object2.getString("NONSCHEMA");
                }
                if ((columnProxyOraclev9i = (ColumnProxyOraclev9i)((TableProxy)object).getColumnProxyByName(string)) == null) continue;
                if (string2 != null) {
                    columnProxyOraclev9i.setXmlSchemaUrl(string2);
                }
                if (string3 != null) {
                    columnProxyOraclev9i.setXmlSchemaElement(string3);
                }
                if (string4 != null) {
                    if (string4.equals("BINARY")) {
                        string4 = "BINARY XML";
                    } else if (string4.equals("OBJECT-RELATIONAL")) {
                        string4 = "OBJECT RELATIONAL";
                    }
                    columnProxyOraclev9i.setStoreAs(string4);
                }
                if (string5 != null) {
                    ((ColumnProxyOraclev11g)columnProxyOraclev9i).setAllowAnySchema(string5);
                }
                if (string6 == null) continue;
                ((ColumnProxyOraclev11g)columnProxyOraclev9i).setAllowNonSchema(string6);
            }
            object2.close();
        }
    }

    protected String removeBrackets(String string) {
        String string2;
        int n = string.length();
        int n2 = string.indexOf(40);
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            int n3 = string.indexOf(41);
            if (n3 > 0 && n3 < n - 1) {
                String string3 = string.substring(n3 + 1, n);
                string2 = string2.trim() + " " + this.removeBrackets(string3).trim();
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    protected void setParameter(Column column, String string, String string2) {
        column.setDataTypeParameter(string, string2);
    }

    class TypeHolder {
        boolean logicalDT = false;
        boolean strDT = false;
        boolean colDT = false;
        boolean unknownDT = false;
        LogicalDatatype ldt;
        LogicalDatatype ukndt;
        StructuredType strdt;
        CollectionType coldt;

        TypeHolder() {
        }
    }
}

