/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RoleOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHRoleOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ROLE";
    private static final Logger LOGGER = new Logger(MOHRoleOraclev9i.class);
    protected boolean dbaUser;
    PreparedStatement objectPrivilegesStmt = null;
    PreparedStatement systemPrivilegesStmt = null;
    PreparedStatement columnPrivilegesStmt = null;
    PreparedStatement directoryPrivilegesStmt = null;

    public MOHRoleOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.systemPrivilegesStmt = null;
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                    if (this.dbaUser) {
                        CharSequence charSequence;
                        ResultSet resultSet = null;
                        try {
                            if (statement == null) {
                                charSequence = new StringBuffer();
                                ((StringBuffer)charSequence).append("SELECT").append(' ');
                                ((StringBuffer)charSequence).append("a.").append(OBJECT_TYPE).append(',');
                                ((StringBuffer)charSequence).append("a.").append("PASSWORD_REQUIRED").append(' ');
                                ((StringBuffer)charSequence).append("AS").append(' ').append("identification").append(',');
                                ((StringBuffer)charSequence).append("b.").append("SCHEMA").append(',');
                                ((StringBuffer)charSequence).append("b.").append("PACKAGE").append(' ');
                                ((StringBuffer)charSequence).append("FROM").append(' ');
                                ((StringBuffer)charSequence).append("dba_roles").append(' ').append("a").append(',');
                                ((StringBuffer)charSequence).append("dba_application_roles").append(' ').append("b").append(' ');
                                ((StringBuffer)charSequence).append("WHERE").append(' ');
                                ((StringBuffer)charSequence).append("a.").append(OBJECT_TYPE).append('=').append('?').append(' ');
                                ((StringBuffer)charSequence).append("AND").append(' ');
                                ((StringBuffer)charSequence).append("a.").append(OBJECT_TYPE).append('=').append("b.").append(OBJECT_TYPE).append(' ').append("(+)");
                                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                            }
                            statement.setString(1, dBObject.getName());
                            resultSet = statement.executeQuery();
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getMessage().startsWith("ORA-00942")) {
                                System.out.println("MOHRoleOraclev9i.generate(): " + sQLException.getMessage());
                                LOGGER.error("MOHRoleOraclev9i.generate(): current connection user has no SELECT privilege on dba_roles dba_application_roles");
                            } else {
                                System.out.println("MOHRoleOraclev9i.generate(): " + sQLException.getMessage());
                                LOGGER.error("MOHRoleOraclev9i.generate():", sQLException);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("MOHRoleOraclev9i.generate(): " + exception.getMessage());
                            LOGGER.error("MOHRoleOraclev9i.generate():", exception);
                        }
                        if (resultSet != null) {
                            if (resultSet.next()) {
                                charSequence = resultSet.getString(OBJECT_TYPE);
                                String string = resultSet.getString("identification");
                                String string2 = resultSet.getString("SCHEMA");
                                String string3 = resultSet.getString("PACKAGE");
                                RoleOraclev9i roleOraclev9i = null;
                                if (storageDesign instanceof StorageDesignOraclev10g) {
                                    roleOraclev9i = (RoleOraclev10g)((StorageDesignOraclev10g)storageDesign).getRoleSet().createRole();
                                } else if (storageDesign instanceof StorageDesignOraclev9i) {
                                    roleOraclev9i = (RoleOraclev9i)((StorageDesignOraclev9i)storageDesign).getRoleSet().createRole();
                                }
                                if (roleOraclev9i != null) {
                                    roleOraclev9i.setName((String)charSequence);
                                    if (((StorageDesignOracle)storageDesign).isSeededRole((String)charSequence)) {
                                        roleOraclev9i.setIsNullInstance(true);
                                        roleOraclev9i.setStorableNullInstance(true);
                                    }
                                    if ("EXTERNAL".equalsIgnoreCase(string)) {
                                        roleOraclev9i.setIdentified("YES");
                                        roleOraclev9i.setAuthType(RoleOraclev9i.getAuthTypes()[1]);
                                    } else if ("GLOBAL".equalsIgnoreCase(string)) {
                                        roleOraclev9i.setIdentified("YES");
                                        roleOraclev9i.setAuthType(RoleOraclev9i.getAuthTypes()[2]);
                                    } else if ("YES".equalsIgnoreCase(string)) {
                                        roleOraclev9i.setIdentified("YES");
                                        if (string2 != null && !"".equalsIgnoreCase(string2) && string3 != null && !"".equalsIgnoreCase(string3)) {
                                            roleOraclev9i.setAuthType("USING PACKAGE");
                                            roleOraclev9i.setSchema(string2);
                                            roleOraclev9i.setPack(string3);
                                        } else {
                                            roleOraclev9i.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                                        }
                                    }
                                    this.setSystemPrivileges(roleOraclev9i, connection);
                                    this.stampModelObject(roleOraclev9i, dBObject);
                                }
                            }
                            resultSet.close();
                        }
                    }
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (this.systemPrivilegesStmt != null) {
            this.systemPrivilegesStmt.close();
            this.systemPrivilegesStmt = null;
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setSystemPrivileges(RoleOracle roleOracle, Connection connection) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        try {
            if (this.systemPrivilegesStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("PRIVILEGE").append(',');
                ((StringBuffer)charSequence).append("ADMIN_OPTION").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_sys_privs" : "user_sys_privs").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append('?');
                this.systemPrivilegesStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.systemPrivilegesStmt.setString(1, roleOracle.getName());
            resultSet = this.systemPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHRoleOraclev9i.setSystemPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_sys_privs" : "user_sys_privs"));
            } else {
                System.out.println("MOHRoleOraclev9i.setSystemPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHRoleOraclev9i.setSystemPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHRoleOraclev9i.setSystemPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("PRIVILEGE");
                String string = resultSet.getString("ADMIN_OPTION");
                if ("YES".equalsIgnoreCase(string)) {
                    roleOracle.setPrivilegesWithAdminOption((String)charSequence);
                    continue;
                }
                roleOracle.setPrivileges((String)charSequence);
            }
            resultSet.close();
        }
    }

    private void setObjectPrivileges(RoleOracle roleOracle, Connection connection) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        String string = roleOracle.getName();
        try {
            if (this.objectPrivilegesStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append(' ').append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append(',');
                ((StringBuffer)charSequence).append("TABLE_NAME").append(',');
                ((StringBuffer)charSequence).append("PRIVILEGE").append(',');
                ((StringBuffer)charSequence).append("GRANTABLE").append(',');
                ((StringBuffer)charSequence).append("HIERARCHY").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tab_privs" : "all_tab_privs").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("GRANTEE").append('=').append('?').append(' ');
                this.objectPrivilegesStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.objectPrivilegesStmt.setString(1, string);
            resultSet = this.objectPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHRoleOracle9i.setObjectPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOracle9i.setObjectPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
            } else {
                System.out.println("MOHRoleOracle9i.setObjectPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOracle9i.setObjectPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHRoleOracle9i.setObjectPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHRoleOracle9i.setObjectPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                ModelObject modelObject;
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString("TABLE_NAME");
                String string3 = resultSet.getString("PRIVILEGE");
                String string4 = resultSet.getString("GRANTABLE");
                String string5 = resultSet.getString("HIERARCHY");
                boolean bl = false;
                PermissionsOracle permissionsOracle = null;
                if (permissionsOracle == null) {
                    permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                }
                boolean bl2 = false;
                if (MOHRoleOraclev9i.isTableGrant(string3) && (modelObject = (TableProxyOracle)((TableProxySetOracle)this.getStorageDesign().getTableProxySet()).getByUserSchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setTable((TableProxyOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isViewGrant(string3) && (modelObject = (TableViewProxyOracle)((TableViewProxySetOracle)this.getStorageDesign().getTableViewProxySet()).getBySchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setView((TableViewProxyOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isSequenceGrant(string3) && (modelObject = (SequenceOracle)((StorageDesignOracle)this.getStorageDesign()).getSequenceSet().getByUserSchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setSequence((SequenceOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isStoredProcedureGrant(string3) && (modelObject = ((StorageDesignOracle)this.getStorageDesign()).getFunctionSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setFunctionOracle((FunctionOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isStoredProcedureGrant(string3) && (modelObject = ((StorageDesignOracle)this.getStorageDesign()).getPackageSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setPackage((PackageOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isStoredProcedureGrant(string3) && (modelObject = ((StorageDesignOracle)this.getStorageDesign()).getStoredProcedureSet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setProc((StoredProcedureOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isCollectionTypeGrant(string3) && (modelObject = (CollectionTypeProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getCollectionTypeProxySet().getByOwnerAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setCollectionTypeOracle((CollectionTypeProxyOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isStructuredTypeGrant(string3) && (modelObject = (StructuredTypeProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getStructuredTypeProxySet().getBySchemaAndName((String)charSequence, string2)) != null) {
                    bl2 = true;
                    permissionsOracle.setStructuredTypeOracle((StructuredTypeProxyOracle)modelObject);
                    bl = true;
                }
                if (!bl2 && MOHRoleOraclev9i.isExternalTableGrant(string3)) {
                    ExternalTableOracle externalTableOracle;
                    modelObject = null;
                    StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                    if (storageDesignOracle instanceof StorageDesignOraclev10g) {
                        modelObject = ((StorageDesignOraclev10g)storageDesignOracle).getExternalTableSet();
                    } else if (storageDesignOracle instanceof StorageDesignOraclev9i) {
                        modelObject = ((StorageDesignOraclev9i)storageDesignOracle).getExternalTableSet();
                    }
                    if (modelObject != null && (externalTableOracle = ((ExternalTableSetOracle)modelObject).getByOwnerAndName((String)charSequence, string2)) != null) {
                        bl2 = true;
                        permissionsOracle.setExternalTableOracle(externalTableOracle);
                        bl = true;
                    }
                }
                if (!bl2 && MOHRoleOraclev9i.isDirectoryGrant(string3) && (modelObject = (DirectoryOracle)((StorageDesignOracle)this.getStorageDesign()).getDirectorySet().getByName(string2)) != null) {
                    permissionsOracle.setDirectoryOracle((DirectoryOracle)modelObject);
                    bl = true;
                }
                if (bl) {
                    permissionsOracle.setPrivileges(string3);
                    permissionsOracle.setPrivilegesWithGrantOption(string4.equals("YES") ? string3 : "");
                    permissionsOracle.setPrivilegesWithHierarchyOption(string5.equals("YES") ? string3 : "");
                    permissionsOracle.setRole(roleOracle);
                    continue;
                }
                permissionsOracle.remove(true);
            }
            resultSet.close();
        }
    }

    private void setColumnPrivileges(RoleOracle roleOracle, Connection connection) throws Exception {
        ResultSet resultSet = null;
        String string = roleOracle.getName();
        try {
            if (this.columnPrivilegesStmt == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT").append(' ');
                stringBuffer.append(' ').append(this.dbaUser ? "OWNER" : "TABLE_SCHEMA").append(',');
                stringBuffer.append("TABLE_NAME").append(',');
                stringBuffer.append("COLUMN_NAME").append(',');
                stringBuffer.append("PRIVILEGE").append(',');
                stringBuffer.append("GRANTABLE").append(' ');
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append(this.dbaUser ? "dba_col_privs" : "all_col_privs").append(' ').append("a").append(' ');
                stringBuffer.append("WHERE").append(' ');
                stringBuffer.append("GRANTEE").append('=').append('?').append(' ');
                this.columnPrivilegesStmt = connection.prepareStatement(stringBuffer.toString());
            }
            this.columnPrivilegesStmt.setString(1, string);
            resultSet = this.columnPrivilegesStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().startsWith("ORA-00942")) {
                System.out.println("MOHRoleOracle9i.setColumnPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOracle9i.setColumnPrivileges(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_tab_privs" : "all_tab_privs"));
            } else {
                System.out.println("MOHRoleOracle9i.setColumnPrivileges(): " + sQLException.getMessage());
                LOGGER.error("MOHRoleOracle9i.setColumnPrivileges():", sQLException);
            }
        }
        catch (Exception exception) {
            System.out.println("MOHRoleOracle9i.setColumnPrivileges(): " + exception.getMessage());
            LOGGER.error("MOHRoleOracle9i.setColumnPrivileges():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                boolean bl = false;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString("TABLE_NAME");
                String string4 = resultSet.getString("COLUMN_NAME");
                String string5 = resultSet.getString("PRIVILEGE");
                String string6 = resultSet.getString("GRANTABLE");
                String string7 = "";
                String string8 = "";
                string7 = string7.concat(string4);
                string8 = string8.concat(string4);
                PermissionsOracle permissionsOracle = this.getPermissionPerObject(roleOracle, string3);
                if (permissionsOracle == null) {
                    permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
                }
                permissionsOracle.setRole(roleOracle);
                TableProxyOracle tableProxyOracle = (TableProxyOracle)((TableProxySetOracle)this.getStorageDesign().getTableProxySet()).getByUserSchemaAndName(string2, string3);
                if (tableProxyOracle != null) {
                    permissionsOracle.setColumnsTable(tableProxyOracle);
                }
                if (string6.equals("YES")) {
                    string8 = string8.concat(", ").concat(string5);
                } else {
                    string7 = string7.concat(", ").concat(string5);
                }
                if (string7.indexOf(",") > -1) {
                    permissionsOracle.setColumnList(string7);
                }
                if (string8.indexOf(",") > -1) {
                    permissionsOracle.setColumnListWithGrantOption(string8);
                }
                if (!bl) continue;
                permissionsOracle.setPrivileges(string5);
                permissionsOracle.setPrivilegesWithGrantOption(string6.equals("YES") ? string5 : "");
            }
        }
    }

    public static boolean isTableGrant(String string) {
        String[] stringArray = PermissionsOracle.getTablePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isViewGrant(String string) {
        String[] stringArray = PermissionsOracle.getViewPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSequenceGrant(String string) {
        String[] stringArray = PermissionsOracle.getSeqPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryGrant(String string) {
        String[] stringArray = PermissionsOracle.getDirectoryPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStoredProcedureGrant(String string) {
        String[] stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollectionTypeGrant(String string) {
        String[] stringArray = PermissionsOracle.getCollectionTypePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStructuredTypeGrant(String string) {
        String[] stringArray = PermissionsOracle.getStructuredTypePrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalTableGrant(String string) {
        String[] stringArray = PermissionsOracle.getExtTablesPrivilegesValues();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().trim();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (this.dbaUser) {
            CharSequence charSequence;
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("a.").append(OBJECT_TYPE).append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append("dba_roles").append(' ').append("a").append(',');
                ((StringBuffer)charSequence).append("dba_application_roles").append(' ').append("b").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("a.").append(OBJECT_TYPE).append('=').append("b.").append(OBJECT_TYPE).append(' ').append("(+)").append(' ');
                ((StringBuffer)charSequence).append("ORDER BY").append(' ');
                ((StringBuffer)charSequence).append(OBJECT_TYPE);
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHRoleOraclev9i.extract(): " + sQLException.getMessage());
                    LOGGER.error("MOHRoleOraclev9i.extract(): current connection user has no SELECT privilege on dba_roles dba_application_roles");
                } else {
                    System.out.println("MOHRoleOraclev9i.extract(): " + sQLException.getMessage());
                    LOGGER.error("MOHRoleOraclev9i.extract():", sQLException);
                }
            }
            catch (Exception exception) {
                System.out.println("MOHRoleOraclev9i.extract(): " + exception.getMessage());
                LOGGER.error("MOHRoleOraclev9i.extract():", exception);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(OBJECT_TYPE);
                    DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                    arrayList.add(dBObject);
                }
                resultSet.close();
            }
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void postGenerateProcessing(Connection connection) {
        block16: {
            try {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignOracle)) break block16;
                Statement statement = null;
                this.objectPrivilegesStmt = null;
                this.columnPrivilegesStmt = null;
                this.directoryPrivilegesStmt = null;
                for (DBObject dBObject : this.handledObjects) {
                    Object object;
                    if (dBObject == null) continue;
                    RoleSetOracle roleSetOracle = ((StorageDesignOracle)storageDesign).getRoleSet();
                    RoleOraclev9i roleOraclev9i = (RoleOraclev9i)roleSetOracle.getByName(dBObject.getName());
                    if (statement == null) {
                        try {
                            object = new StringBuffer();
                            ((StringBuffer)object).append("SELECT");
                            ((StringBuffer)object).append(' ').append(this.dbaUser ? "GRANTEE" : "USERNAME");
                            ((StringBuffer)object).append(',').append("GRANTED_ROLE");
                            ((StringBuffer)object).append(',').append("ADMIN_OPTION");
                            ((StringBuffer)object).append(' ').append("FROM").append(' ');
                            ((StringBuffer)object).append(this.dbaUser ? "dba_role_privs" : "user_role_privs").append(' ');
                            ((StringBuffer)object).append("WHERE").append(' ');
                            ((StringBuffer)object).append(this.dbaUser ? "GRANTEE" : "USERNAME").append('=').append(' ').append('?').append(' ');
                            statement = connection.prepareStatement(((StringBuffer)object).toString());
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getMessage().startsWith("ORA-00942")) {
                                System.out.println("MOHUserOraclev9i.review(): " + sQLException.getMessage());
                                LOGGER.error("MOHUserOraclev9i.review(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_role_privs" : "user_role_privs"));
                            } else {
                                System.out.println("MOHUserOraclev9i.review(): " + sQLException.getMessage());
                                LOGGER.error("MOHUserOraclev9i.review():", sQLException);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("MOHUserOraclev9i.review(): " + exception.getMessage());
                            LOGGER.error("MOHUserOraclev9i.review():", exception);
                        }
                    }
                    statement.setString(1, dBObject.getName());
                    object = statement.executeQuery();
                    if (object != null) {
                        while (object.next()) {
                            RoleOraclev9i roleOraclev9i2;
                            String string = object.getString("GRANTED_ROLE");
                            String string2 = object.getString("ADMIN_OPTION");
                            if (string == null || "".equalsIgnoreCase(string) || (roleOraclev9i2 = (RoleOraclev9i)((StorageDesignOracle)storageDesign).getRoleSet().getByName(string)) == null) continue;
                            if ("YES".equalsIgnoreCase(string2)) {
                                roleOraclev9i.setRolesWithAdminOption(roleOraclev9i2.getObjectID());
                                continue;
                            }
                            roleOraclev9i.setRoles(roleOraclev9i2.getObjectID());
                        }
                        object.close();
                    }
                    this.setObjectPrivileges(roleOraclev9i, connection);
                    this.setColumnPrivileges(roleOraclev9i, connection);
                }
                if (statement != null) {
                    statement.close();
                }
                if (this.objectPrivilegesStmt != null) {
                    this.objectPrivilegesStmt.close();
                    this.objectPrivilegesStmt = null;
                }
                if (this.columnPrivilegesStmt != null) {
                    this.columnPrivilegesStmt.close();
                    this.columnPrivilegesStmt = null;
                }
                if (this.directoryPrivilegesStmt != null) {
                    this.directoryPrivilegesStmt.close();
                    this.directoryPrivilegesStmt = null;
                }
            }
            catch (Exception exception) {
                LOGGER.error("MOHRoleOraclev9i.postGenerateProcessing():", exception);
            }
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject storageObject, String string) {
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getRole() != storageObject) continue;
            if (permissionsOracle.getTable() != null && permissionsOracle.getTable().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getView() != null && permissionsOracle.getView().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getProc() != null && permissionsOracle.getProc().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getFunctionOracle() != null && permissionsOracle.getFunctionOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getPackage() != null && permissionsOracle.getPackage().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getSequence() != null && permissionsOracle.getSequence().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getSnapshot() != null && permissionsOracle.getSnapshot().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getDirectoryOracle() != null && permissionsOracle.getDirectoryOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getStructuredTypeOracle() != null && permissionsOracle.getStructuredTypeOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getCollectionTypeOracle() != null && permissionsOracle.getCollectionTypeOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getExternalTableOracle() != null && permissionsOracle.getExternalTableOracle().getName().equals(string)) {
                return permissionsOracle;
            }
            if (permissionsOracle.getColumnsTable() == null) continue;
            String string2 = string;
            String string3 = string;
            if (string.indexOf(".") > -1) {
                string2 = string.substring(0, string.indexOf("."));
                string3 = string.substring(string.indexOf(".") + 1, string.length());
            }
            if (!permissionsOracle.getColumnsTable().getName().equals(string2) || !permissionsOracle.getColumns().contains(string3) && !permissionsOracle.getColumnsWithGrantOption().contains(string3)) continue;
            return permissionsOracle;
        }
        return null;
    }
}

