/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHExternalTableOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "EXTERNAL TABLE";
    private static final Logger LOGGER = new Logger(MOHExternalTableOraclev9i.class);
    protected boolean dbaUser;
    PreparedStatement columnsStmt = null;
    PreparedStatement parallelStmt = null;

    public MOHExternalTableOraclev9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("TABLE_NAME").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("OWNER").append('=').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ');
                ((StringBuffer)object).append("TABLE_NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHExternalTableOraclev9i.extract(): " + exception.getMessage());
                LOGGER.error("MOHExternalTableOraclev9i.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString("TABLE_NAME");
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, dBObject.getName());
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("SELECT").append(' ');
                    ((StringBuffer)object).append("b.").append("LOCATION").append(',');
                    ((StringBuffer)object).append("DEFAULT_DIRECTORY_NAME").append(',');
                    ((StringBuffer)object).append("REJECT_LIMIT").append(',');
                    ((StringBuffer)object).append("TYPE_NAME").append(',');
                    ((StringBuffer)object).append("ACCESS_PARAMETERS").append(' ');
                    ((StringBuffer)object).append("FROM").append(' ');
                    ((StringBuffer)object).append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ').append("a").append(',');
                    ((StringBuffer)object).append(this.dbaUser ? "dba_external_locations" : "all_external_locations").append(' ').append("b").append(' ');
                    ((StringBuffer)object).append("WHERE").append(' ');
                    ((StringBuffer)object).append("a.").append("OWNER").append('=').append('?').append(' ');
                    ((StringBuffer)object).append("AND").append(' ');
                    ((StringBuffer)object).append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                    ((StringBuffer)object).append("AND").append(' ');
                    ((StringBuffer)object).append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ');
                    ((StringBuffer)object).append("AND").append(' ');
                    ((StringBuffer)object).append("a.").append("TABLE_NAME").append('=').append("b.").append("TABLE_NAME");
                    statement = connection.prepareStatement(((StringBuffer)object).toString());
                }
                statement.setString(1, string);
                statement.setString(2, dBObject.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                LOGGER.error("MOHExternalTableOraclev9i.extract():", exception);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof StorageDesignOracle) {
                        String string2 = dBObject.getName();
                        String string3 = resultSet.getString("LOCATION");
                        String string4 = resultSet.getString("DEFAULT_DIRECTORY_NAME");
                        String string5 = resultSet.getString("REJECT_LIMIT");
                        String string6 = resultSet.getString("TYPE_NAME");
                        String string7 = resultSet.getString("ACCESS_PARAMETERS");
                        ExternalTableOracle externalTableOracle = null;
                        if (object instanceof StorageDesignOraclev9i) {
                            externalTableOracle = ((StorageDesignOraclev9i)object).getExternalTableSet().createExternalTable();
                        } else if (object instanceof StorageDesignOraclev10g) {
                            externalTableOracle = ((StorageDesignOraclev10g)object).getExternalTableSet().createExternalTable();
                        }
                        if (externalTableOracle != null) {
                            externalTableOracle.setName(string2);
                            UserOracle userOracle = (UserOracle)((StorageDesignOracle)object).getUserSet().getByName(string);
                            externalTableOracle.setOwner(userOracle);
                            externalTableOracle.setLocation(string3);
                            DirectoryOracle directoryOracle = (DirectoryOracle)((StorageDesignOracle)object).getDirectorySet().getByName(string4);
                            externalTableOracle.setDefaultDir(directoryOracle);
                            externalTableOracle.setRejectLimit(string5);
                            externalTableOracle.setAccessDriverType(string6);
                            if (string6 != null && string6.toUpperCase().startsWith("ORACLE_")) {
                                externalTableOracle.setAccessParametersType("Opaque Format Spec");
                                externalTableOracle.setOpaqueFormatSpec(string7);
                            } else {
                                externalTableOracle.setAccessParametersType("CLOB Subquery");
                                externalTableOracle.setClobSubquery(string7);
                            }
                            this.initParallel(connection, externalTableOracle, string);
                            this.initColumns(connection, externalTableOracle, string);
                            this.stampModelObject(externalTableOracle, dBObject);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (this.parallelStmt != null) {
            this.parallelStmt.close();
            this.parallelStmt = null;
        }
        if (this.columnsStmt != null) {
            this.columnsStmt.close();
            this.columnsStmt = null;
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumns(Connection connection, ExternalTableOracle externalTableOracle, String string) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        try {
            if (this.columnsStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("a.").append("COLUMN_NAME").append(',');
                ((StringBuffer)charSequence).append("DATA_TYPE").append(',');
                ((StringBuffer)charSequence).append("DATA_LENGTH").append(',');
                ((StringBuffer)charSequence).append("DATA_PRECISION").append(',');
                ((StringBuffer)charSequence).append("DATA_SCALE").append(',');
                ((StringBuffer)charSequence).append("CHAR_USED").append(',');
                ((StringBuffer)charSequence).append("CHAR_LENGTH").append(',');
                ((StringBuffer)charSequence).append("COMMENTS").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(',');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_col_comments" : "all_col_comments").append(' ').append("b").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("a.").append("OWNER").append('=').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("a.").append("OWNER").append('=');
                ((StringBuffer)charSequence).append("b.").append("OWNER").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("a.").append("TABLE_NAME").append('=');
                ((StringBuffer)charSequence).append("b.").append("TABLE_NAME").append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("a.").append("COLUMN_NAME").append('=');
                ((StringBuffer)charSequence).append("b.").append("COLUMN_NAME").append(' ');
                ((StringBuffer)charSequence).append("ORDER BY").append(' ');
                ((StringBuffer)charSequence).append("COLUMN_ID");
                this.columnsStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.columnsStmt.setString(1, string);
            this.columnsStmt.setString(2, externalTableOracle.getName());
            resultSet = this.columnsStmt.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHExternalTableOraclev9i.initColumns():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("COLUMN_NAME");
                String string2 = resultSet.getString("DATA_TYPE");
                int n = resultSet.getInt("DATA_LENGTH");
                int n2 = resultSet.getInt("DATA_PRECISION");
                int n3 = resultSet.getInt("DATA_SCALE");
                int n4 = resultSet.getInt("CHAR_LENGTH");
                String string3 = resultSet.getString("CHAR_USED");
                String string4 = resultSet.getString("COMMENTS");
                ExternalTableColumnOracle externalTableColumnOracle = null;
                if (externalTableOracle instanceof ExternalTableOraclev9i) {
                    externalTableColumnOracle = ((StorageDesignOraclev9i)externalTableOracle.getStorageDesign()).getExternalColumnSet().createExternalColumn();
                } else if (externalTableOracle instanceof ExternalTableOraclev10g) {
                    externalTableColumnOracle = ((StorageDesignOraclev10g)externalTableOracle.getStorageDesign()).getExternalColumnSet().createExternalColumn();
                }
                if (externalTableColumnOracle == null) continue;
                externalTableColumnOracle.setName((String)charSequence);
                externalTableColumnOracle.setExternalTable(externalTableOracle);
                string2 = this.removeBrackets(string2);
                externalTableColumnOracle.setDatatype(string2);
                if (string2.indexOf("CHAR") > -1) {
                    int n5 = n4;
                    String string5 = "";
                    if (string3 != null) {
                        if (string3.equalsIgnoreCase("C")) {
                            string5 = "CHAR";
                        } else if (string3.equalsIgnoreCase("B")) {
                            string5 = "BYTE";
                            n5 = n;
                        }
                    }
                    externalTableColumnOracle.setSize(n5);
                    externalTableColumnOracle.setUnits(string5);
                } else if (string2.equals("RAW") || string2.equals("UROWID")) {
                    externalTableColumnOracle.setSize(n);
                } else if (string2.startsWith("TIMESTAMP")) {
                    externalTableColumnOracle.setPrecision(n3);
                } else {
                    externalTableColumnOracle.setPrecision(n2);
                    externalTableColumnOracle.setScale(n3);
                }
                if (string4 != null) {
                    externalTableColumnOracle.setCommentInRDBMS(string4);
                }
                this.stampModelObject((ModelObject)externalTableColumnOracle, externalTableOracle.getName(), (String)charSequence);
            }
            resultSet.close();
        }
    }

    private void initParallel(Connection connection, ExternalTableOracle externalTableOracle, String string) throws Exception {
        CharSequence charSequence;
        ResultSet resultSet = null;
        try {
            if (this.parallelStmt == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("DEGREE").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("OWNER").append('=').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("TABLE_NAME").append('=').append('?');
                this.parallelStmt = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.parallelStmt.setString(1, string);
            this.parallelStmt.setString(2, externalTableOracle.getName());
            resultSet = this.parallelStmt.executeQuery();
        }
        catch (Exception exception) {
            LOGGER.error("MOHExternalTableOraclev9i.initParallel():", exception);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                charSequence = resultSet.getString("DEGREE");
                if ("1".equalsIgnoreCase(((String)charSequence).trim())) {
                    externalTableOracle.setParallel("NO");
                } else {
                    externalTableOracle.setParallel("YES");
                }
            }
            resultSet.close();
        }
    }

    protected String removeBrackets(String string) {
        String string2;
        int n = string.length();
        int n2 = string.indexOf(40);
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            int n3 = string.indexOf(41);
            if (n3 > 0 && n3 < n - 1) {
                String string3 = string.substring(n3 + 1, n);
                string2 = string2.trim() + ' ' + this.removeBrackets(string3).trim();
            }
        } else {
            string2 = string;
        }
        return string2;
    }
}

