/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBitmapIndexesv9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BITMAP JOIN";
    private static final Logger LOGGER = new Logger(MOHBitmapIndexesv9i.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement jcol_statement = null;

    public MOHBitmapIndexesv9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHBitmapIndexesv9i(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        this.col_statement = null;
        this.jcol_statement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOraclev9i tableProxyOraclev9i = null;
        while (iterator.hasNext()) {
            CharSequence charSequence;
            tableProxyOraclev9i = (TableProxyOraclev9i)iterator.next();
            try {
                if (statement == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT").append(' ');
                    ((StringBuffer)charSequence).append("OWNER").append(',');
                    ((StringBuffer)charSequence).append("INDEX_NAME").append(',');
                    ((StringBuffer)charSequence).append("INDEX_TYPE").append(',');
                    ((StringBuffer)charSequence).append("TABLE_OWNER").append(',');
                    ((StringBuffer)charSequence).append("TABLE_NAME").append(',');
                    ((StringBuffer)charSequence).append("TABLE_TYPE").append(',');
                    ((StringBuffer)charSequence).append("UNIQUENESS").append(',');
                    ((StringBuffer)charSequence).append("COMPRESSION").append(',');
                    ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(',');
                    ((StringBuffer)charSequence).append("INI_TRANS").append(',');
                    ((StringBuffer)charSequence).append("MAX_TRANS").append(',');
                    ((StringBuffer)charSequence).append("INITIAL_EXTENT").append(',');
                    ((StringBuffer)charSequence).append("NEXT_EXTENT").append(',');
                    ((StringBuffer)charSequence).append("MIN_EXTENTS").append(',');
                    ((StringBuffer)charSequence).append("MAX_EXTENTS").append(',');
                    ((StringBuffer)charSequence).append("PCT_INCREASE").append(',');
                    ((StringBuffer)charSequence).append("INCLUDE_COLUMN").append(',');
                    ((StringBuffer)charSequence).append("FREELISTS").append(',');
                    ((StringBuffer)charSequence).append("FREELIST_GROUPS").append(',');
                    ((StringBuffer)charSequence).append("PCT_FREE").append(',');
                    ((StringBuffer)charSequence).append("LOGGING").append(',');
                    ((StringBuffer)charSequence).append("DEGREE").append(',');
                    ((StringBuffer)charSequence).append("PARTITIONED").append(',');
                    ((StringBuffer)charSequence).append("TEMPORARY").append(',');
                    ((StringBuffer)charSequence).append("GENERATED").append(',');
                    ((StringBuffer)charSequence).append("SECONDARY").append(',');
                    ((StringBuffer)charSequence).append("BUFFER_POOL").append(' ');
                    ((StringBuffer)charSequence).append("FROM").append(' ');
                    ((StringBuffer)charSequence).append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
                    ((StringBuffer)charSequence).append("WHERE").append(' ');
                    ((StringBuffer)charSequence).append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ');
                    ((StringBuffer)charSequence).append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
                    ((StringBuffer)charSequence).append("AND").append(' ');
                    ((StringBuffer)charSequence).append("JOIN_INDEX").append('=').append('\'');
                    ((StringBuffer)charSequence).append("YES").append('\'');
                    statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                statement.setString(1, ((Table)tableProxyOraclev9i.getObject()).getSchema());
                statement.setString(2, tableProxyOraclev9i.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHBitmapIndexesv9i.generate(): " + exception.getMessage());
                LOGGER.error("MOHBitmapIndexesv9i.generate(): ", exception);
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString("INDEX_NAME");
                String string = resultSet.getString("TABLE_OWNER");
                String string2 = resultSet.getString("PARTITIONED");
                String string3 = resultSet.getString("TABLESPACE_NAME");
                String string4 = resultSet.getString("LOGGING");
                BitmapJoinIndexOraclev9i bitmapJoinIndexOraclev9i = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getBitmapJoinIndexSet().createBitmapJoinIndex();
                UserOraclev9i userOraclev9i = (UserOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getUserSet().getByName(string);
                bitmapJoinIndexOraclev9i.setName((String)charSequence);
                bitmapJoinIndexOraclev9i.setUser(userOraclev9i);
                bitmapJoinIndexOraclev9i.setTable(tableProxyOraclev9i);
                bitmapJoinIndexOraclev9i.setLocalPartitioning(string2);
                bitmapJoinIndexOraclev9i.setTablespace(string3);
                bitmapJoinIndexOraclev9i.setLogging(string4);
                this.stampModelObject((ModelObject)bitmapJoinIndexOraclev9i, string, (String)charSequence);
                this.initIndexColumns(connection, bitmapJoinIndexOraclev9i, string, importLogger);
                this.initJoinColumns(connection, bitmapJoinIndexOraclev9i, string, importLogger);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.jcol_statement != null) {
            this.jcol_statement.close();
        }
    }

    private void initJoinColumns(Connection connection, BitmapJoinIndexOracle bitmapJoinIndexOracle, String string, ImportLogger importLogger) {
        ResultSet resultSet = null;
        try {
            CharSequence charSequence;
            if (this.jcol_statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("INNER_TABLE_OWNER").append(',');
                ((StringBuffer)charSequence).append("INNER_TABLE_NAME").append(',');
                ((StringBuffer)charSequence).append("INNER_TABLE_COLUMN").append(',');
                ((StringBuffer)charSequence).append("OUTER_TABLE_OWNER").append(',');
                ((StringBuffer)charSequence).append("OUTER_TABLE_NAME").append(',');
                ((StringBuffer)charSequence).append("OUTER_TABLE_COLUMN").append(',');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_join_ind_columns" : "all_join_ind_columns").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("INDEX_NAME").append(' ').append('=').append(' ').append('?');
                this.jcol_statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.jcol_statement.setString(1, string);
            this.jcol_statement.setString(2, bitmapJoinIndexOracle.getName());
            resultSet = this.jcol_statement.executeQuery();
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString("INNER_TABLE_NAME");
                    String string2 = resultSet.getString("INNER_TABLE_COLUMN");
                    String string3 = resultSet.getString("OUTER_TABLE_NAME");
                    String string4 = resultSet.getString("OUTER_TABLE_COLUMN");
                    Table table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName((String)charSequence);
                    Table table2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string3);
                    if (table == null || table2 == null) continue;
                    Column column = (Column)table.getElementByName(string2);
                    Column column2 = (Column)table2.getElementByName(string4);
                    if (column == null || column2 == null) continue;
                    bitmapJoinIndexOracle.setJoinColumns(column2.getObjectID());
                    bitmapJoinIndexOracle.setJoinColumns(column.getObjectID());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(column2.getName());
                    Index index = this.getUniqueIndexForColumnNames(table2, arrayList);
                    bitmapJoinIndexOracle.setDimensionKeys(table2.getObjectID());
                    bitmapJoinIndexOracle.setDimensionKeys(index.getObjectID());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHBitmapIndexesv9i.initJoinColumns():", exception);
        }
    }

    private void initIndexColumns(Connection connection, BitmapJoinIndexOracle bitmapJoinIndexOracle, String string, ImportLogger importLogger) {
        ResultSet resultSet = null;
        try {
            CharSequence charSequence;
            if (this.col_statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT").append(' ');
                ((StringBuffer)charSequence).append("TABLE_OWNER").append(',');
                ((StringBuffer)charSequence).append("TABLE_NAME").append(',');
                ((StringBuffer)charSequence).append("COLUMN_NAME").append(',');
                ((StringBuffer)charSequence).append("COLUMN_POSITION").append(',');
                ((StringBuffer)charSequence).append("DESCEND").append(' ');
                ((StringBuffer)charSequence).append("FROM").append(' ');
                ((StringBuffer)charSequence).append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
                ((StringBuffer)charSequence).append("WHERE").append(' ');
                ((StringBuffer)charSequence).append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)charSequence).append("AND").append(' ');
                ((StringBuffer)charSequence).append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)charSequence).append("ORDER BY").append(' ');
                ((StringBuffer)charSequence).append("COLUMN_POSITION");
                this.col_statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            this.col_statement.setString(1, string);
            this.col_statement.setString(2, bitmapJoinIndexOracle.getName());
            resultSet = this.col_statement.executeQuery();
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString("COLUMN_NAME");
                    String string2 = resultSet.getString("TABLE_NAME");
                    Table table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string2);
                    if (table != null) {
                        Column column = (Column)table.getElementByName((String)charSequence);
                        String string3 = resultSet.getString("DESCEND");
                        if (column != null) {
                            bitmapJoinIndexOracle.setIndexColumns(column.getObjectID());
                            bitmapJoinIndexOracle.setIndexColumns(string3);
                            continue;
                        }
                        importLogger.addWarning("Column " + (String)charSequence + " was not imported");
                        continue;
                    }
                    importLogger.addWarning("Table " + string2 + " was not imported");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("MOHBitmapIndexesv9i.initIndexColumns():", exception);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (!columnArray[i].getName().equalsIgnoreCase((String)list.get(j))) continue;
                arrayList.remove(list.get(j));
            }
        }
        return arrayList.size() == 0;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }
}

