/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUndoTableSpaceOraclev10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "UNDO TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHUndoTableSpaceOraclev10g.class);
    protected boolean dbaUser;

    public MOHUndoTableSpaceOraclev10g(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("NOT").append(' ').append("IN").append(' ');
            ((StringBuffer)charSequence).append('(').append('\'');
            ((StringBuffer)charSequence).append("SYSTEM").append('\'').append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("CONTENTS").append('=').append('\'');
            ((StringBuffer)charSequence).append("UNDO").append('\'').append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            System.out.println("MOHUndoTableSpaceOraclev10g.extract(): " + exception.getMessage());
            LOGGER.error("MOHUndoTableSpaceOraclev10g.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = null;
            try {
                if (statement == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("SELECT").append(' ');
                    ((StringBuffer)object).append("BIGFILE").append(',');
                    ((StringBuffer)object).append("RETENTION").append(' ');
                    ((StringBuffer)object).append("FROM").append(' ');
                    ((StringBuffer)object).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                    ((StringBuffer)object).append("WHERE").append(' ');
                    ((StringBuffer)object).append("TABLESPACE_NAME").append('=').append('?').append(' ');
                    ((StringBuffer)object).append("AND").append(' ');
                    ((StringBuffer)object).append("CONTENTS").append('=').append('\'');
                    ((StringBuffer)object).append("UNDO").append('\'');
                    statement = connection.prepareStatement(((StringBuffer)object).toString());
                }
                statement.setString(1, dBObject.getName());
                resultSet = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHUndoTableSpaceOraclev10g.generate(): " + exception.getMessage());
                LOGGER.error("MOHUndoTableSpaceOraclev10g.generate():", exception);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object instanceof StorageDesignOraclev10g) {
                        UndoTablespaceOracle undoTablespaceOracle = ((StorageDesignOraclev10g)object).getUndoTablespaceSet().createTablespace();
                        undoTablespaceOracle.setName(dBObject.getName());
                        this.setProperties(undoTablespaceOracle, resultSet);
                        this.stampModelObject(undoTablespaceOracle, dBObject);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(UndoTablespaceOracle undoTablespaceOracle, ResultSet resultSet) throws Exception {
        String string = resultSet.getString("BIGFILE");
        if ("YES".equals(string)) {
            undoTablespaceOracle.setFileType("BIGFILE");
        } else if ("NO".equals(string)) {
            undoTablespaceOracle.setFileType("SMALLFILE");
        }
        String string2 = resultSet.getString("RETENTION");
        if ("GUARANTEE".equals(string2) || "NOGUARANTEE".equals(string2)) {
            undoTablespaceOracle.setRetention(string2);
        }
    }
}

