/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            ((StringBuffer)charSequence).append("WHERE").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME").append(' ');
            ((StringBuffer)charSequence).append("NOT").append(' ').append("IN").append(' ');
            ((StringBuffer)charSequence).append('(').append('\'');
            ((StringBuffer)charSequence).append("SYSTEM").append('\'').append(')').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("CONTENTS").append(' ').append("<>").append(' ');
            ((StringBuffer)charSequence).append('\'').append("UNDO").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("NOT").append(' ').append('(');
            ((StringBuffer)charSequence).append("CONTENTS").append('=').append('\'');
            ((StringBuffer)charSequence).append("TEMPORARY").append('\'').append(' ');
            ((StringBuffer)charSequence).append("AND").append(' ');
            ((StringBuffer)charSequence).append("EXTENT_MANAGEMENT").append('=').append('\'');
            ((StringBuffer)charSequence).append("LOCAL").append('\'').append(')').append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("TABLESPACE_NAME");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            System.out.println("MOHTableSpaceOracle.extract(): " + exception.getMessage());
            LOGGER.error("MOHTableSpaceOracle.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            if (statement == null) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("SELECT").append(' ');
                ((StringBuffer)object2).append("TABLESPACE_NAME").append(',');
                ((StringBuffer)object2).append("INITIAL_EXTENT").append(',');
                ((StringBuffer)object2).append("NEXT_EXTENT").append(',');
                ((StringBuffer)object2).append("MIN_EXTENTS").append(',');
                ((StringBuffer)object2).append("MAX_EXTENTS").append(',');
                ((StringBuffer)object2).append("PCT_INCREASE").append(',');
                ((StringBuffer)object2).append("MIN_EXTLEN").append(',');
                ((StringBuffer)object2).append("STATUS").append(',');
                ((StringBuffer)object2).append("CONTENTS").append(',');
                ((StringBuffer)object2).append("LOGGING").append(',');
                ((StringBuffer)object2).append("EXTENT_MANAGEMENT").append(',');
                ((StringBuffer)object2).append("ALLOCATION_TYPE");
                if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
                    ((StringBuffer)object2).append(',');
                    ((StringBuffer)object2).append("BIGFILE").append(',');
                    ((StringBuffer)object2).append("DEF_TAB_COMPRESSION");
                }
                ((StringBuffer)object2).append(' ');
                ((StringBuffer)object2).append("FROM").append(' ');
                ((StringBuffer)object2).append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                ((StringBuffer)object2).append("WHERE").append(' ');
                ((StringBuffer)object2).append("TABLESPACE_NAME").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object2).append("AND").append(' ');
                ((StringBuffer)object2).append("CONTENTS").append(' ').append("<>").append(' ');
                ((StringBuffer)object2).append('\'').append("UNDO").append('\'').append(' ');
                ((StringBuffer)object2).append("AND").append(' ');
                ((StringBuffer)object2).append("NOT").append(' ').append('(');
                ((StringBuffer)object2).append("CONTENTS").append('=').append('\'');
                ((StringBuffer)object2).append("TEMPORARY").append('\'').append(' ');
                ((StringBuffer)object2).append("AND").append(' ');
                ((StringBuffer)object2).append("EXTENT_MANAGEMENT").append('=').append('\'');
                ((StringBuffer)object2).append("LOCAL").append('\'').append(')').append(' ');
                ((StringBuffer)object2).append("ORDER BY").append(' ');
                ((StringBuffer)object2).append("TABLESPACE_NAME");
                object = ((StringBuffer)object2).toString();
                statement = connection.prepareStatement((String)object);
            }
            object2 = null;
            try {
                statement.setString(1, dBObject.getName());
                object2 = statement.executeQuery();
                if (object2 != null) {
                    if (object2.next()) {
                        object = this.getStorageDesign();
                        if (object instanceof StorageDesignOracle) {
                            TableSpaceOracle tableSpaceOracle = ((StorageDesignOracle)object).getTableSpaceSet().createTableSpace();
                            tableSpaceOracle.setName(dBObject.getName());
                            this.setProperties(tableSpaceOracle, (ResultSet)object2);
                            this.stampModelObject(tableSpaceOracle, dBObject);
                        } else {
                            LOGGER.error("Unable to find Storage Design!");
                        }
                    }
                    object2.close();
                }
            }
            catch (Exception exception) {
                System.out.println("MOHTableSpaceOracle.generate(): " + exception.getMessage());
                LOGGER.error("MOHTableSpaceOracle.generate():", exception);
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(TableSpaceOracle tableSpaceOracle, ResultSet resultSet) throws Exception {
        long l = resultSet.getLong("INITIAL_EXTENT");
        long l2 = resultSet.getLong("NEXT_EXTENT");
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        try {
            n = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception exception) {
            LOGGER.error("error in min_extent", exception);
        }
        try {
            n2 = resultSet.getInt("MAX_EXTENTS");
        }
        catch (Exception exception) {
            LOGGER.error("error in max_extent", exception);
        }
        int n3 = resultSet.getInt("PCT_INCREASE");
        int n4 = resultSet.getInt("MIN_EXTLEN");
        String string = resultSet.getString("STATUS");
        String string2 = resultSet.getString("CONTENTS");
        String string3 = resultSet.getString("LOGGING");
        String string4 = resultSet.getString("EXTENT_MANAGEMENT");
        String string5 = resultSet.getString("ALLOCATION_TYPE");
        tableSpaceOracle.setDSInitialExtent(l);
        tableSpaceOracle.setDSNextExtent(l2);
        tableSpaceOracle.setDSMinExtents(n);
        tableSpaceOracle.setDSMaxExtents(String.valueOf(n2));
        tableSpaceOracle.setDSPctIncrease(n3);
        tableSpaceOracle.setMinExtLen(n4);
        tableSpaceOracle.setStatus(string.trim());
        tableSpaceOracle.setContents(string2.trim());
        tableSpaceOracle.setLogging(string3.trim());
        tableSpaceOracle.setExtentManagement(string4.trim());
        if ("UNIFORM".equalsIgnoreCase(string5.trim())) {
            tableSpaceOracle.setEMLocalSubtype("UNIFORM");
            try {
                tableSpaceOracle.setEMUniformSize(resultSet.getInt("NEXT_EXTENT"));
            }
            catch (Exception exception) {
                LOGGER.error("error in next_extent", exception);
            }
        }
        if (tableSpaceOracle instanceof TableSpaceOraclev10g) {
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)tableSpaceOracle;
            String string6 = resultSet.getString("BIGFILE");
            if ("YES".equals(string6)) {
                tableSpaceOraclev10g.setFileType("BIGFILE");
            } else if ("NO".equals(string6)) {
                tableSpaceOraclev10g.setFileType("SMALLFILE");
            }
            String string7 = resultSet.getString("DEF_TAB_COMPRESSION");
            if ("ENABLED".equals(string7)) {
                tableSpaceOraclev10g.setDSCompression("COMPRESS");
            } else if ("DISABLED".equals(string7)) {
                tableSpaceOraclev10g.setDSCompression("NOCOMPRESS");
            }
        }
    }
}

