/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSynonymOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SYNONYM";
    private static final Logger LOGGER = new Logger(MOHSynonymOracle.class);
    protected boolean dbaUser;

    public MOHSynonymOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHSynonymOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        TreeMap<String, DBObject> treeMap = new TreeMap<String, DBObject>();
        ArrayList arrayList2 = new ArrayList(list);
        for (DBObject dBObject : arrayList2) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("SYNONYM_NAME").append(',').append(' ');
                ((StringBuffer)object).append("TABLE_OWNER").append(',').append(' ');
                ((StringBuffer)object).append("TABLE_NAME").append(',').append(' ');
                ((StringBuffer)object).append("DB_LINK").append(',').append(' ');
                ((StringBuffer)object).append("OWNER").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_synonyms" : "all_synonyms").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("OR").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ').append("SYNONYM_NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                statement.setString(2, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHSynonymOracle.extract(): " + exception.getMessage());
                LOGGER.error("MOHSynonymOracle.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString(1);
                String string2 = object.getString(2);
                String string3 = object.getString(3);
                String string4 = object.getString(4);
                String string5 = object.getString(5);
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, string5);
                String string6 = dBObject2.toString();
                Object v = treeMap.get(string6);
                if (v != null) continue;
                treeMap.put(string6, dBObject2);
                DescSyn descSyn = new DescSyn();
                descSyn.tablename = string3;
                descSyn.tableowner = string2;
                descSyn.dblink = string4;
                dBObject2.setDescrptiveObject(descSyn);
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        treeMap.clear();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        TimeLog.log("Synonyms begin");
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            if (storageDesignOracle != null) {
                SynonymOracle synonymOracle = storageDesignOracle.getSynonymSet().createSynonym();
                synonymOracle.setName(dBObject.getName());
                String string = dBObject.getSchema();
                this.stampModelObject(synonymOracle, dBObject);
                if ("PUBLIC".equalsIgnoreCase(string)) {
                    synonymOracle.setPublic("YES");
                } else {
                    this.setUser(synonymOracle, storageDesignOracle, string);
                }
                DescSyn descSyn = (DescSyn)dBObject.getDescrptiveObject();
                synonymOracle.setDBLink(descSyn.dblink);
                synonymOracle.setObject(descSyn.tablename);
                UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(descSyn.tableowner);
                if (userOracle == null) {
                    userOracle = (UserOracle)storageDesignOracle.getUserSet().createElement(null);
                    userOracle.setName(descSyn.tableowner);
                    this.stampModelObject((ModelObject)userOracle, "", descSyn.tableowner);
                }
                synonymOracle.setObjectUser(userOracle);
                this.stampModelObject(synonymOracle, dBObject);
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        TimeLog.log("Synonyms end");
    }

    private void setUser(SynonymOracle synonymOracle, StorageDesignOracle storageDesignOracle, String string) {
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string);
        if (userOracle == null) {
            userOracle = (UserOracle)storageDesignOracle.getUserSet().createElement(null);
            userOracle.setName(string);
            this.stampModelObject((ModelObject)userOracle, "", string);
        }
        synonymOracle.setUser(userOracle);
    }

    public static String getSynonymObjectName(DBObject dBObject) {
        DescSyn descSyn = (DescSyn)dBObject.getDescrptiveObject();
        if (descSyn != null) {
            return descSyn.tablename;
        }
        return "";
    }

    public static String getSynonymObjectOwner(DBObject dBObject) {
        DescSyn descSyn = (DescSyn)dBObject.getDescrptiveObject();
        if (descSyn != null) {
            return descSyn.tableowner;
        }
        return "";
    }

    static class DescSyn {
        String dblink;
        String tablename;
        String tableowner;

        DescSyn() {
        }
    }
}

