/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.PreparedStatement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageBodyOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPackageOracle
extends MOHPlSqlStorageObjectOracle<PackageOracle> {
    public static final String OBJECT_TYPE = "PACKAGE";
    private static final Logger LOGGER = new Logger(MOHPackageOracle.class);
    private MOHPackageBodyOracle mohPackageBodyOracle;

    public MOHPackageOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.mohPackageBodyOracle = new MOHPackageBodyOracle(abstractDBMExtractionHandler, applicationView);
    }

    public MOHPackageOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView, bl);
        this.mohPackageBodyOracle = new MOHPackageBodyOracle(abstractDBMExtractionHandler, applicationView, bl);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public PackageOracle generateObject(StorageDesignOracle storageDesignOracle, DBObject dBObject, String string) {
        PackageOracle packageOracle = (PackageOracle)storageDesignOracle.getPackageSet().createElement(null);
        packageOracle.setName(dBObject.getName());
        packageOracle.setSource("CREATE OR REPLACE " + string);
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(dBObject.getSchema());
        packageOracle.setOwner(userOracle);
        return packageOracle;
    }

    @Override
    protected PackageOracle generate(PreparedStatement preparedStatement, DBObject dBObject, ImportLogger importLogger) throws Exception {
        PackageOracle packageOracle = (PackageOracle)super.generate(preparedStatement, dBObject, importLogger);
        if (packageOracle != null) {
            packageOracle.setBody(this.mohPackageBodyOracle.generate(packageOracle, preparedStatement.getConnection(), dBObject, importLogger));
            this.stampModelObject(packageOracle, dBObject);
        }
        return packageOracle;
    }
}

