/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHObjectColumnsOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OBJECT_COLUMN";
    private static final Logger LOGGER = new Logger(MOHObjectColumnsOracle.class);
    protected boolean dbaUser;

    public MOHObjectColumnsOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHObjectColumnsOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Object Columns begin");
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOracle tableProxyOracle = null;
        int n = 0;
        while (iterator.hasNext()) {
            tableProxyOracle = (TableProxyOracle)iterator.next();
            arrayList.add(tableProxyOracle.getName());
            if (n == 990) {
                this.initSubstitutable(connection, arrayList);
                this.initCollectionSubstitutable(connection, arrayList);
                this.initScope(connection, arrayList);
                arrayList.clear();
                n = -1;
            }
            ++n;
        }
        if (n > 0) {
            this.initSubstitutable(connection, arrayList);
            this.initCollectionSubstitutable(connection, arrayList);
            this.initScope(connection, arrayList);
            arrayList.clear();
        }
        TimeLog.log("Object Columns end");
    }

    private void initCollectionSubstitutable(Connection connection, List list) throws Exception {
        Object object;
        int n = list.size();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n2;
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("PARENT_TABLE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("PARENT_TABLE_COLUMN").append(',').append(' ');
            ((StringBuffer)object).append("ELEMENT_SUBSTITUTABLE").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "DBA_NESTED_TABLES" : "ALL_NESTED_TABLES").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("PARENT_TABLE_NAME").append(' ').append("IN").append(' ');
            ((StringBuffer)object).append('(').append('?');
            for (n2 = 1; n2 < n; ++n2) {
                ((StringBuffer)object).append(',').append('?');
            }
            ((StringBuffer)object).append(')');
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            for (n2 = 0; n2 < n; ++n2) {
                statement.setString(n2 + 1, (String)list.get(n2));
            }
            resultSet = statement.executeQuery();
        }
        catch (Exception exception) {
            System.out.println("MOHObjectColumnsOracle.initCollectionSubstitutable(): " + exception.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initCollectionSubstitutable():", exception);
        }
        if (resultSet != null) {
            object = this.getDesign().getRelationalDesign().getTableSet();
            while (resultSet.next()) {
                Column column;
                Table table;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4).trim();
                if (!"N".equalsIgnoreCase(string4) || (table = ((TableSet)object).getBySchemaAndName(string, string2)) == null || (column = (Column)table.getElementByName(string3)) == null) continue;
                column.setAllowSubtypeSubstitution(false);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initSubstitutable(Connection connection, List list) throws Exception {
        Object object;
        int n = list.size();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n2;
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("TABLE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("COLUMN_NAME").append(',').append(' ');
            ((StringBuffer)object).append("SUBSTITUTABLE").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "DBA_OBJ_COLATTRS" : "ALL_OBJ_COLATTRS").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("TABLE_NAME").append(' ').append("IN").append(' ');
            ((StringBuffer)object).append('(').append('?');
            for (n2 = 1; n2 < n; ++n2) {
                ((StringBuffer)object).append(',').append('?');
            }
            ((StringBuffer)object).append(')');
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            for (n2 = 0; n2 < n; ++n2) {
                statement.setString(n2 + 1, (String)list.get(n2));
            }
            resultSet = statement.executeQuery();
        }
        catch (Exception exception) {
            System.out.println("MOHObjectColumnsOracle.initSubstitutable(): " + exception.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initSubstitutable():", exception);
        }
        if (resultSet != null) {
            object = this.getDesign().getRelationalDesign().getTableSet();
            while (resultSet.next()) {
                Column column;
                Table table;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4).trim();
                if (!"N".equalsIgnoreCase(string4) || (table = ((TableSet)object).getBySchemaAndName(string, string2)) == null || string3.equalsIgnoreCase("SYS_NC_ROWINFO$") || (column = (Column)table.getElementByName(string3)) == null) continue;
                column.setAllowSubtypeSubstitution(false);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initScope(Connection connection, List list) throws Exception {
        Object object;
        int n = list.size();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n2;
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            ((StringBuffer)object).append("TABLE_NAME").append(',').append(' ');
            ((StringBuffer)object).append("COLUMN_NAME").append(',').append(' ');
            ((StringBuffer)object).append("WITH_ROWID").append(',').append(' ');
            ((StringBuffer)object).append("SCOPE_TABLE_OWNER").append(',').append(' ');
            ((StringBuffer)object).append("SCOPE_TABLE_NAME").append(' ');
            ((StringBuffer)object).append("FROM").append(' ').append(this.dbaUser ? "dba_refs" : "all_refs").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ').append("TABLE_NAME").append(' ').append("IN").append(' ');
            ((StringBuffer)object).append('(').append('?');
            for (n2 = 1; n2 < n; ++n2) {
                ((StringBuffer)object).append(',').append('?');
            }
            ((StringBuffer)object).append(')');
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            for (n2 = 0; n2 < n; ++n2) {
                statement.setString(n2 + 1, (String)list.get(n2));
            }
            resultSet = statement.executeQuery();
        }
        catch (Exception exception) {
            System.out.println("MOHObjectColumnsOracle.initScope(): " + exception.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initScope():", exception);
        }
        if (resultSet != null) {
            object = this.getDesign().getRelationalDesign().getTableSet();
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
            while (resultSet.next()) {
                ColumnProxyOracle columnProxyOracle;
                Column column;
                Table table;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                String string6 = resultSet.getString(6);
                Table table2 = string6 == null ? null : ((TableSet)object).getBySchemaAndName(string5, string6);
                if (table2 == null && !string4.equals("YES") || (table = ((TableSet)object).getBySchemaAndName(string, string2)) == null || (column = (Column)table.getElementByName(string3)) == null) continue;
                if (table2 != null) {
                    column.setScopeId(table2.getObjectID());
                }
                if (!string4.equals("YES") || (columnProxyOracle = (ColumnProxyOracle)storageDesignOracle.getColumnProxySet().getProxy(column.getObjectID())) == null) continue;
                columnProxyOracle.setWithRowId("YES");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }
}

